/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePartProgress;

public class ByteArrayRequestEntity
implements RequestEntity {
    private byte[] content;
    private String contentType;
    private FilePartProgress progress;

    public ByteArrayRequestEntity(byte[] content) {
        this(content, null, null);
    }

    public ByteArrayRequestEntity(byte[] content, FilePartProgress pr) {
        this(content);
        this.progress = pr;
    }

    public ByteArrayRequestEntity(byte[] content, String contentType) {
        if (content == null) {
            throw new IllegalArgumentException("The content cannot be null");
        }
        this.content = content;
        this.contentType = contentType;
    }

    public ByteArrayRequestEntity(byte[] content, String contentType, FilePartProgress pr) {
        this(content, contentType);
        this.progress = pr;
    }

    public boolean isRepeatable() {
        return true;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (this.content != null) {
            byte[] tmp = new byte[16048];
            int total = 0;
            int i = 0;
            boolean stopped = false;
            if (this.progress != null) {
                this.progress.startUpload();
            }
            ByteArrayInputStream input = new ByteArrayInputStream(this.content);
            while ((i = input.read(tmp)) >= 0) {
                if (this.progress != null) {
                    stopped = this.progress.sendData(i);
                }
                if (stopped) break;
                out.write(tmp, 0, i);
                total += i;
            }
            if (this.progress != null) {
                this.progress.finishUpload();
            }
        } else {
            throw new IllegalStateException("Content must be set before entity is written");
        }
    }

    public long getContentLength() {
        return this.content.length;
    }

    public byte[] getContent() {
        return this.content;
    }

    public FilePartProgress getFilePartProgress() {
        return this.progress;
    }
}

