/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePartProgress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputStreamRequestEntity
implements RequestEntity {
    public static final int CONTENT_LENGTH_AUTO = -2;
    private static final Log LOG;
    private long contentLength;
    private InputStream content;
    private byte[] buffer = null;
    private String contentType;
    private FilePartProgress progress;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.httpclient.methods.InputStreamRequestEntity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public InputStreamRequestEntity(InputStream content) {
        this(content, (String)null);
    }

    public InputStreamRequestEntity(InputStream content, FilePartProgress pr) {
        this(content);
        this.progress = pr;
    }

    public InputStreamRequestEntity(InputStream content, String contentType) {
        this(content, -2L, contentType);
    }

    public InputStreamRequestEntity(InputStream content, long contentLength) {
        this(content, contentLength, (String)null);
    }

    public InputStreamRequestEntity(InputStream content, long contentLength, FilePartProgress pr) {
        this(content, contentLength, (String)null);
        this.progress = pr;
    }

    public InputStreamRequestEntity(InputStream content, long contentLength, String contentType) {
        if (content == null) {
            throw new IllegalArgumentException("The content cannot be null");
        }
        this.content = content;
        this.contentLength = contentLength;
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    private void bufferContent() {
        if (this.buffer != null) {
            return;
        }
        if (this.content != null) {
            try {
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                byte[] data = new byte[4096];
                int l = 0;
                while ((l = this.content.read(data)) >= 0) {
                    tmp.write(data, 0, l);
                }
                this.buffer = tmp.toByteArray();
                this.content = null;
                this.contentLength = this.buffer.length;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                this.buffer = null;
                this.content = null;
                this.contentLength = 0L;
            }
        }
    }

    public boolean isRepeatable() {
        return this.buffer != null;
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (this.content != null) {
            byte[] tmp = new byte[16048];
            int total = 0;
            int i = 0;
            boolean stopped = false;
            if (this.progress != null) {
                this.progress.startUpload();
            }
            while ((i = this.content.read(tmp)) >= 0) {
                if (this.progress != null) {
                    stopped = this.progress.sendData(i);
                }
                if (stopped) break;
                out.write(tmp, 0, i);
                total += i;
            }
            if (this.progress != null) {
                this.progress.finishUpload();
            }
        } else if (this.buffer != null) {
            out.write(this.buffer);
        } else {
            throw new IllegalStateException("Content must be set before entity is written");
        }
    }

    public long getContentLength() {
        if (this.contentLength == -2L && this.buffer == null) {
            this.bufferContent();
        }
        return this.contentLength;
    }

    public InputStream getContent() {
        return this.content;
    }

    public FilePartProgress getFilePartProgress() {
        return this.progress;
    }
}

