﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Viewer.aspx.cs" Inherits="HttpCommander.Viewer" %>

<%@ Import Namespace="HttpCommander" %>
<%@ Import Namespace="Newtonsoft.Json" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta content="NOINDEX, NOFOLLOW" name="ROBOTS" />
    <meta http-equiv="x-ua-compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=0" />
    <script src="../Scripts/error-handler<%=Utils.BuildModeJs%>.js"></script>
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon" />
    <script type="text/javascript">
        function htmlEnc(value) {
            return !value ? value : String(value).replace(/&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;").replace(/"/g, "&quot;");
        }

        function ProcessScriptError (e, withoutOpener, skipEncode) {
            try {
                if (typeof (e) == 'undefined') {
                    return;
                }
                if (typeof HttpCommanderLog != 'undefined') {
                    if (typeof HttpCommanderLog.SetLastError == 'function') {
                        HttpCommanderLog.SetLastError(e);
                    }
                    if (typeof window.onerror == 'function' && typeof e.message != 'undefined') {
                        window.onerror(e.message, window.location.href);
                    }
                }
                if (!(withoutOpener === true)) {
                    invokeEventFromOpener(skipEncode ? e.message : htmlEnc(e.message));
                }
                var debug = <%=JsonConvert.SerializeObject(Utils.DebugModeJs)%>;
                if (debug) {
                    if (!!window.console && !!window.console.log) {
                        window.console.log(e);
                    }
                    window.alert(e.message);
                }
            } catch (fe) {
                if (!!window.console && !!window.console.log) {
                    window.console.log(fe);
                }
                window.alert(fe.message);
            }
        }

        function invokeEventFromOpener(arg) {
            if (!!arg) {
                if (window.opener) {
                    try {
                        window.opener['handleViewerError'](arg);
                    } catch (e) {
                        if (!!window.console && !!window.console.log) {
                            window.console.log(e);
                        }
                        window.alert(e.message);
                    }
                } else {
                    if (!!window.console && !!window.console.log) {
                        window.console.log(arg);
                    }
                    window.alert(arg);
                }
            }
            window.close();
        }

        try {
            var locHash = window.location.hash;
            if (locHash == 'noback' || locHash == '#noback') {
                window.close();
            } else {
                window.location.hash = 'noback';
            }
        } catch (e) {
            ProcessScriptError(e, true);
        }
    </script>
    <% if (!string.IsNullOrWhiteSpace(ErrorMessage))
       { %>
    <script type="text/javascript">
        invokeEventFromOpener(<%=JsonConvert.SerializeObject(ErrorMessage)%>);
    </script>
    <% } %>
    <% if (AdobeImageUrl != null)
       { %>
    <style type="text/css">
        body { border: 0px; margin: 0px; padding: 0px; overflow: hidden; }
    </style>
    <% if (Request.IsSecureConnection)
       { %>
    <script type="text/javascript" src="https://dme0ih8comzn4.cloudfront.net/imaging/v3/editor.js"></script>
    <% }
       else
       { %>
    <script type="text/javascript" src="http://feather.aviary.com/imaging/v3/editor.js"></script>
    <% } %>
    <script type='text/javascript'>
        var srcUrl = <%=JsonConvert.SerializeObject(AdobeImageUrl)%>;
        var featherEditor = null;
        try {
            featherEditor = new Aviary.Feather({
                apiKey: <%=JsonConvert.SerializeObject(Utils.UserSettings.Office.AdobeClientId.Value)%>,
                displayImageSize: true,
                tools: 'all',
                noCloseButton: true,
                language: <%=JsonConvert.SerializeObject(Utils.CurrentTwoLetterLanguageName)%>,
                fileFormat: <%=JsonConvert.SerializeObject(AdobeSaveFormat)%>,
                appendTo: 'adobe_image_editor',
                onLoad: function() {
                    launchEditor('image_for_edit', srcUrl);
                },
                onSave: function(imageID, newURL) {
                    try {
                        var img = document.getElementById(imageID),
                            me = window,
                            saveUrl = srcUrl + '&adobesave=' + encodeURIComponent(newURL);
                        if (img) {
                            img.src = newURL;
                        }
                        if (me.opener) {
                            with (me.opener) {
                                Ext.Ajax.request({
                                    url: saveUrl,
                                    callback: function (opts, success, response) {
                                        var errorMessage = null;
                                        if (!!response && !Ext.isEmpty(response.responseText)) {
                                            try {
                                                var jsn = JSON.parse(response.responseText);
                                                if (!!jsn) {
                                                    errorMessage = jsn.message;
                                                }
                                                if (Ext.isEmpty(errorMessage) && !success) {
                                                    errorMessage = response.responseText || 'Unknown error';
                                                }
                                            } catch (e) {
                                                if (!success) {
                                                    errorMessage = response.responseText || 'Unknown error';
                                                }
                                            }
                                        }
                                        if (Ext.isEmpty(errorMessage)) {
                                            adobeImageSaved(<%=JsonConvert.SerializeObject(AdobeWaitId)%>);
                                        } else {
                                            me.invokeEventFromOpener.call(me, Ext.util.Format.htmlEncode(errorMessage));
                                        }
                                    }
                                });
                            }
                        }
                    } catch (e) {
                        ProcessScriptError(e);
                    }
                },
                onError: function(e) {
                    ProcessScriptError(e);
                }
            });

            function launchEditor(id, src) {
                try {
                    featherEditor.launch({
                        image: id,
                        url: src
                    });
                } catch (e) {
                    ProcessScriptError(e);
                }
                return false;
            }
        } catch (e) {
            if (!featherEditor) {
                var isIE = <%=JsonConvert.SerializeObject(IsIE)%>;
                ProcessScriptError(new Error(e.message + (isIE ? ('<br /><br />Please also check following sites in "Trusted sites" list:<br /><span style="font-weight:bold;">'
                    <% if (Request.IsSecureConnection)
                       { %>
                    + 'https://dme0ih8comzn4.cloudfront.net'
                    <% }
                       else
                       { %>
                    + 'http://feather.aviary.com'
                    <% } %>
                    + '<br />https://featherservices.aviary.com</span>') : '')), false, true);
            } else {
                ProcessScriptError(e);
            }
        }
        </script>
    <% } else if (AllowViewing && ViewerType == AvailableViewers.eBook) 
       { %>
    <link rel="stylesheet" href="../Scripts/epub/css/normalize.css" type="text/css" />
    <link rel="stylesheet" href="../Scripts/epub/css/main.css" type="text/css" />
    <link rel="stylesheet" href="../Scripts/epub/css/popup.css" type="text/css" />
    <script type="text/javascript" src="../Scripts/epub/js/libs/jquery.min.js"></script>
    <script type="text/javascript" src="../Scripts/epub/js/libs/zip.min.js"></script>
    <script type="text/javascript">
        "use strict";
        document.onreadystatechange = function () {
            if (document.readyState == "complete") {
                EPUBJS.filePath = "../Scripts/epub/js/libs/";
                EPUBJS.cssPath = <%=JsonConvert.SerializeObject(Utils.AppRootUrl)%> + "Scripts/epub/css/";
                window.reader = ePubReader(<%=JsonConvert.SerializeObject("Download.ashx?action=download&file=" + Uri.EscapeDataString(Request.QueryString["path"]))%>, {
                    contained:true,
                    restore: true,
                    storage: true
                });
            }
        };
    </script>
    <script type="text/javascript" src="../Scripts/epub/js/libs/localforage.min.js"></script>
    <script type="text/javascript" src="../Scripts/epub/js/libs/screenfull<%=Utils.ReleaseJsCssSuffix%>.js"></script>
    <script type="text/javascript" src="../Scripts/epub/js/epub<%=Utils.ReleaseJsCssSuffix%>.js"></script>
    <script type="text/javascript" src="../Scripts/epub/js/hooks<%=Utils.ReleaseJsCssSuffix%>.js"></script>
    <script type="text/javascript" src="../Scripts/epub/js/reader<%=Utils.ReleaseJsCssSuffix%>.js"></script>
    <script type="text/javascript" src="../Scripts/epub/js/hooks/extensions/highlight.js"></script>
    <% } else if (AllowViewing && ViewerType == AvailableViewers.Djvu)
       { %>
    <link href="../Scripts/djvu/Djvu_html5.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="../Scripts/djvu/djvu_html5/djvu_html5.nocache.js"></script>
    <% }
       else
       { %>
    <link rel="stylesheet" type="text/css" href="../Styles-min.css" />
    <% if (AllowViewing)
       { %>
    <% if (ONLYOFFICEApiUrl != null)
       { %>
    <script type="text/javascript">
        function includeJsFile(config) {
            var script, cfg = Ext.isObject(config) ? config : {},
                head = document.getElementsByTagName('head')[0],
                afterLoad = function () {
                    if (Ext.isFunction(cfg.callback)) {
                        cfg.callback.call();
                    }
                };
            script = document.createElement('script');
            script.type = 'text/javascript';
            script.async = true;
            if (Ext.isFunction(cfg.callback)) {
                script.onload = script.onerror = function () {
                    var self = this;
                    if (!self.executed) {
                        self.executed = true;
                        afterLoad();
                    }
                };
                script.onreadystatechange = function () {
                    var self = this;
                    if (self.readyState == 'complete' || self.readyState == 'loaded') {
                        setTimeout(function () { self.onload() }, 0);
                    }
                };
            }
            script.src = config.url || '';
            head.appendChild(script);
        }
    </script>
    <% } %>
    <script type="text/javascript">
        function getAndHtmlEncodeMessage (obj, defaultMsg) {
            var msg = null;
            if (obj) {
                msg = obj.message;
                if (Ext.isEmpty(msg))
                    msg = obj.msg;
                if (Ext.isEmpty(msg))
                    msg = obj.error;
                if (Ext.isEmpty(msg))
                    msg = obj.errors;
            }
            if (Ext.isEmpty(msg)) {
                msg = defaultMsg;
            }
            return String(msg);
        }

        function checkDirectHandlerResult (data, trans) {
            if (typeof data == 'undefined' || !data) {
                return getAndHtmlEncodeMessage(trans,
                    <%=JsonConvert.SerializeObject(Utils.LocalizationsManager.GetString("UploadFromUrlUnknownResponse"))%>);
            }
            if ((typeof data.success != 'undefined' && !data.success) ||
                (typeof data.status != 'undefined' && data.status != 'success')) {
                return getAndHtmlEncodeMessage(data,
                    <%=JsonConvert.SerializeObject(Utils.LocalizationsManager.GetString("UploadFromUrlUnknownResponse"))%>);
            }
            return null;
        }

        <% if (ViewerType == AvailableViewers.Pixlr)
           { %>
        function getPixlrUrl(url, fileName) {
            var referrer = <%=JsonConvert.SerializeObject(Utils.LocalizationsManager.GetString("CommonMainTitle"))%>;
            <% if (Utils.UserSettings.Office.UseGETMethodWhenSavingPixlrImages.Value)
               { %>
            var method = 'GET';
            <% }
               else
               { %>
            var method = 'POST';
            <% } %>
            var proto = 'http';
            <% if (Utils.IsSSLConnection())
               { %>
            proto += 's';
            <% } %>
            var editUrl = proto + '://pixlr.com/editor/?s=c'
                + '&referrer=' + encodeURIComponent(referrer)
                + '&title=' + encodeURIComponent(fileName)
                + '&method=' + encodeURIComponent(method)
                + '&target=' + encodeURIComponent(url + '&pixlr=save');
            <% if (!CreateInPixlr)
               { %>
            editUrl += '&image=' + encodeURIComponent(url + '&pixlr=edit');
            <% } %>
            return editUrl;
        }
        <% } %>

        function getLink() {
            var loadingText = document.getElementById('loading-text');
            if (loadingText) {
                loadingText.innerHTML = <%=JsonConvert.SerializeObject(ProgressMessage)%>;
            }
            var path = <%=JsonConvert.SerializeObject(ViewerType == AvailableViewers.Shortcut ? CurrentFolder : VirtualPath)%>;
            var svc = <%=JsonConvert.SerializeObject(ServiceName)%>;
            var fileName = <%=JsonConvert.SerializeObject(CurrentDocName)%>;
            var fileInfo = {
                path: path
            };
            if (!Ext.isEmpty(svc)) {
                fileInfo.service = svc;
            }
            <% if (CreateInPixlr)
               { %>
            fileInfo.createFileName = true;
            <% }
               else if (ViewerType == AvailableViewers.Shortcut)
               { %>
            fileInfo.name = fileName;
            <% } %>
            <% if (ViewerType == AvailableViewers.ONLYOFFICE)
               { %>
            fileInfo.onlyofficeEdit = <%=JsonConvert.SerializeObject(AllowModify)%>;
            <% } %>
            Ext.Ajax.timeout = 1800000; // half-hour (30 min)
            var directMethod = <%=JsonConvert.SerializeObject(DirectMethod)%>;
            HttpCommander.Common[directMethod](fileInfo, function (data, trans) {
                try {
                    var error = checkDirectHandlerResult(data, trans);
                    if (!Ext.isEmpty(error)) {
                        invokeEventFromOpener(error);
                        return;
                    }
                    var url = data.url;
                    if (Ext.isEmpty(url)) {
                        invokeEventFromOpener('no url');
                        return;
                    }
                <% if (ViewerType != AvailableViewers.ONLYOFFICE)
                   { %>
                <% if (ViewerType == AvailableViewers.Adobe)
                   { %>
                    var viewUrl = '?adobe=' + encodeURIComponent(url) + '&format=' + <%=JsonConvert.SerializeObject(AdobeSaveFormat)%>
                        + '&filename=' + encodeURIComponent(<%=JsonConvert.SerializeObject(CurrentDocName)%>)
                        + '&adbid=' + encodeURIComponent(<%=JsonConvert.SerializeObject(AdobeWaitId)%>);
                <% }
                   else if (ViewerType == AvailableViewers.Box || ViewerType == AvailableViewers.Shortcut)
                   { %>
                    var viewUrl = url;
                    if (!Ext.isEmpty(data.fileId)) {
                        try { window.opener.boxFileId = data.fileId; }
                        catch (be) { }
                    }
                <% }
                   else if (ViewerType == AvailableViewers.Zoho)
                   { %>
                    var viewUrl = url + '&zoho=post';
                <% }
                   else if (ViewerType == AvailableViewers.Pixlr)
                   { %>
                    var viewUrl = getPixlrUrl(url, fileName);
                <% }
                   else
                   { %>
                    var viewUrl = <%=JsonConvert.SerializeObject(ViewerUrl)%>;
                    <% if (ViewerType == AvailableViewers.Google)
                       { %>
                    var url_parts = url.split('?');
                    url = url_parts[0] + '/' + fileName.replace(/%/g, "%25").replace(/#/g, "%23");
                    for (var i = 1; i < url_parts.length; i++) {
                        url += '?' + url_parts[i];
                    }
                    <% }
                       else if (ViewerType == AvailableViewers.ShareCad)
                       { %>
                    url += '&filename=/' + fileName;
                    <% } %>
                    viewUrl += encodeURIComponent(url);
                <% } %>
                    setTimeout(function() {
                        if (loadingText) {
                            var loadingImg = document.getElementById('loading-image');
                            if (loadingImg) {
                                loadingImg.style.display = 'none';
                            }
                            loadingText.innerHTML = '<a href="' + Ext.util.Format.htmlEncode(viewUrl) + '" target="_self"><%=HttpUtility.HtmlEncode(Utils.LocalizationsManager.GetString("ViewInServiceLink"))%></a>';
                        }
                        try {
                            if (!!window.addEventListener) {
                                window.addEventListener('popstate', function () {
                                    try {
                                        var locHash = window.location.hash;
                                        if (locHash == '#noback' || locHash == 'noback') {
                                            window.close();
                                        }
                                    } catch (err) {
                                        ProcessScriptError(err, true);
                                    }
                                });
                            } else if (!!window.attachEvent) { // fix for IE8
                                window.attachEvent('onpopstate', function () {
                                    try {
                                        var locHash = window.location.hash;
                                        if (locHash == '#noback' || locHash == 'noback') {
                                            window.close();
                                        }
                                    } catch (err) {
                                        ProcessScriptError(err, true);
                                    }
                                });
                            }
                            
                        } catch (err) {
                            ProcessScriptError(err, true);
                        }
                        window.location.href = viewUrl;
                    }, 50);
                <% } else { %>
                    var innerAlert = function (message) {
                        <% if (Utils.DebugModeJs) { %>
                        if (window.console && window.console.log) {
                            window.console.log(message);
                        }
                        <% } %>
                    };

                    var onReady = function () {
                        innerAlert("Document editor ready");
                    };

                    var onDocumentStateChange = function (event) {
                        var title = document.title.replace(/\*$/g, "");
                        document.title = title + (!!event && !!event.data ? "*" : "");
                        if (!!event && !!event.data && !Ext.isBoolean(event.data)) {
                            innerAlert(event.data);
                        }
                    };

                    var onError = function (event) {
                        if (!!event && !!event.data) {
                            innerAlert(event.data);
                            var msg = Ext.isObject(event.data) ? JSON.stringify(event.data) : String(event.data);
                            ProcessScriptError(msg, true);
                        }
                    };

                    var config = data.onlyofficeConfig || {};
                    config["events"] = {
                        'onReady': onReady,
                        'onDocumentStateChange': onDocumentStateChange,
                        'onError': onError
                    };
                    var docEditor = new DocsAPI.DocEditor("onlyoffice-placeholder", config);
                    var loadingMask = document.getElementById('loading-mask');
                    if (!!loadingMask) {
                        loadingMask.style.display = 'none';
                    }
                <% } %>
                } catch (e) {
                    ProcessScriptError(e);
                }
            });
        }
    </script>
    <link href="../Images/resources_1.5/css/ext-all-notheme.css" type="text/css" rel="stylesheet" />
    <% } %>
    <% } %>
</head>
<body>
    <% if (AdobeImageUrl != null)
       { %>
    <div id="adobe_image_editor"></div>
    <table style="width:100%;height:100%" width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
            <td style="text-align:center;vertical-align:middle" align="center" valign="middle">
                <img id="image_for_edit" style="display:none;" src="<%=HttpUtility.HtmlEncode(AdobeImageUrl)%>" />
            </td>
        </tr>
    </table>
    <% }
       else if (AllowViewing && ViewerType == AvailableViewers.eBook)
       { %>
    <div id="sidebar">
        <!--<div id="panels">
            <input id="searchBox" placeholder="search" type="search" />
            <a id="show-Search" class="show_view icon-search" data-view="Search">Search</a>
            <a id="show-Toc" class="show_view icon-list-1 active" data-view="Toc">TOC</a>
            <a id="show-Bookmarks" class="show_view icon-bookmark" data-view="Bookmarks">Bookmarks</a>
            <a id="show-Notes" class="show_view icon-edit" data-view="Notes">Notes</a>
        </div>-->
        <div id="tocView" class="view" style="padding-top:0px;">
        </div>
        <!--<div id="searchView" class="view">
            <ul id="searchResults"></ul>
        </div>
        <div id="bookmarksView" class="view">
            <ul id="bookmarks"></ul>
        </div>
        <div id="notesView" class="view">
            <div id="new-note">
                <textarea id="note-text"></textarea>
                <button id="note-anchor">Anchor</button>
            </div>
            <ol id="notes"></ol>
        </div>-->
    </div>
    <div id="main">

        <div id="titlebar">
            <div id="opener">
                <a id="slider" class="icon-menu">Menu</a>
            </div>
            <div id="metainfo">
                <span id="book-title"></span>
                <span id="title-seperator">&nbsp;&nbsp;–&nbsp;&nbsp;</span>
                <span id="chapter-title"></span>
            </div>
            <div id="title-controls">
                <!--<a id="bookmark" class="icon-bookmark-empty">Bookmark</a>
                <a id="setting" class="icon-cog">Settings</a>-->
                <% if (!IsIE || IsEdge)
                   { %>
                <a id="fullscreen" class="icon-resize-full">Fullscreen</a>
                <% } %>
            </div>
        </div>

        <div id="divider"></div>
        <div id="prev" class="arrow">‹</div>
        <div id="viewer"></div>
        <div id="next" class="arrow">›</div>

        <div id="loader">
            <img alt="" src="../Scripts/epub/img/loader.gif" />
        </div>
    </div>
    <!--<div class="modal md-effect-1" id="settings-modal">
        <div class="md-content">
            <h3>Settings</h3>
            <div>
                <p>
                    <input type="checkbox" id="sidebarReflow" name="sidebarReflow" />Reflow text when sidebars are open.
                </p>
            </div>
            <div class="closer icon-cancel-circled"></div>
        </div>
    </div>-->
    <div class="overlay"></div>
    <% }
       else if (AllowViewing && ViewerType == AvailableViewers.Djvu)
       { %>
    <div id="djvuContainer"></div>
    <script type="text/javascript">
        var DJVU_CONTEXT = {
            file: <%=JsonConvert.SerializeObject("Download.ashx?action=download&file=" + Uri.EscapeDataString(Request.QueryString["path"]))%>,
            background: "#666"
        };
    </script>
    <% }
       else
       { %>
    <form runat="server">
        <div id="loading-mask">
            <div id="loading">
                <table id="loading-message">
                    <tr>
                        <td>
                            <img id="loading-image" width="32" height="32" alt="" src="../Images/loading.gif" />
                        </td>
                        <td>
                            <span id="loading-text"><%=Utils.LocalizationsManager.GetString("ProgressLoading") %></span>...
                        </td>
                    </tr>
                </table>
            </div>
            <% if (AllowViewing)
               { %>
            <script type="text/javascript" src="../Scripts/ext-base<%=Utils.BuildModeJs%>.js"></script>
            <script type="text/javascript" src="../Scripts/ext-all<%=Utils.BuildModeJs%>.js"></script>
            <%=JavaScriptIncludes.Instance.IncludeExtJSLocale("../")%>
            <script type="text/javascript" src="CommonHandler.ashx"></script>
            <script type="text/javascript">
                Ext.onReady(function () {
                    try {
                        var url = HttpCommander.Remote.CommonHandler.url;
                        if (url.toLowerCase().indexOf('handlers/') == 0) {
                            HttpCommander.Remote.CommonHandler.url = url.substring(9);
                        }
                        Ext.Direct.addProvider(HttpCommander.Remote.CommonHandler);
                        <% if (ONLYOFFICEApiUrl != null)
                           { %>
                        var waitIncludeOOJs, ooCalbackInvoked = false, callbackHandler = function () {
                            var invTmp = ooCalbackInvoked;
                            ooCalbackInvoked = true;
                            window.clearTimeout(waitIncludeOOJs);
                            if (invTmp) {
                                return;
                            }
                            if (Ext.isDefined(window.DocsAPI)) {
                                getLink();
                            } else {
                                var loadingMask = document.getElementById('loading-mask');
                                if (!!loadingMask) {
                                    loadingMask.style.display = 'none';
                                }
                                var isIE = <%=JsonConvert.SerializeObject(IsIE)%>;
                                ProcessScriptError(new Error('ONLYOFFICE Document Server API library not loaded by url '
                                    + htmlEnc(<%=JsonConvert.SerializeObject(ONLYOFFICEApiUrl)%> || '')
                                    + (isIE ? ('<br /><br />Please also check following site in "Trusted sites" list:<br /><span style="font-weight:bold;">'
                                    + htmlEnc(<%=JsonConvert.SerializeObject(ONLYOFFICEApiDomain)%>) + '</span>') : '')), false, true);
                            }
                        };
                        var loadingText = document.getElementById('loading-text');
                        if (loadingText) {
                            loadingText.innerHTML = <%=JsonConvert.SerializeObject(ProgressMessage)%>;
                        }
                        includeJsFile({
                            url: <%=JsonConvert.SerializeObject(ONLYOFFICEApiUrl)%>,
                            callback: callbackHandler
                        });
                        waitIncludeOOJs = window.setTimeout(callbackHandler, 8000);
                        <% } else { %>
                        getLink();
                        <% } %>
                    } catch (e) {
                        ProcessScriptError(e);
                    }
                });
            </script>
            <% } %>
        </div>
    </form>
    <% if (AllowViewing && ONLYOFFICEApiUrl != null) 
       { %>
    <div id="onlyoffice-placeholder"></div>
    <% } %>
    <% } %>
</body>
</html>
