﻿Ext.ns('HttpCommander.Lib');

/* config: htcConfig, debugmode */
HttpCommander.Lib.ActivityMonitor = function (config) {
    var me = this,
        mouse;

    this.config = config;
    this.killSessionTask = null;
    this.killSessionTaskReset = Ext.emptyFn;

    if (!Ext.isObject(config) || !Ext.isObject(config.htcConfig) ||
        !config.htcConfig.sessionTimeout || config.htcConfig.sessionTimeout <= 0)
        return;

    this.killSessionTask = new Ext.util.DelayedTask(function () {
        window.location.href = me.config.htcConfig.relativePath + "Logout.aspx";
    });

    this.killSessionTaskReset = function () {
        if (me.killSessionTask) {
            me.killSessionTask.delay(me.config.htcConfig.sessionTimeout);
        }
    };

    this.disable = function () {
        if (me.killSessionTask) {
            me.killSessionTask.cancel();
        }
    }
};
