﻿Ext.ns('HttpCommander.Lib');

/**
 *  config: htcConfig, getGrid(), getCurrentFolder(),
 *  Msg, globalLoadMask, setSelectPath()
 */
HttpCommander.Lib.UnlockMenu = function (config) {
    return new Ext.menu.Menu({
        items: [{
            itemId: 'unlock',
            text: config.htcConfig.locData.UnlockResourceCommand,
            icon: HttpCommander.Lib.Utils.getIconPath(config, 'unlock')
        }],
        listeners: {
            itemclick: function (item) {
                switch (item.itemId) {
                    case 'unlock':
                        var fileInfo = {
                            path: config.getCurrentFolder()
                        };
                        var selectedRecord = config.getGrid().getSelectionModel().getSelected();
                        if (!!selectedRecord && !!selectedRecord.data) {
                            fileInfo.name = selectedRecord.data.name;
                        }
                        config.globalLoadMask.msg = config.htcConfig.locData.ProgressLoading + "...";
                        config.globalLoadMask.show();
                        HttpCommander.Admin.UnlockFile(fileInfo, function (data, trans) {
                            config.globalLoadMask.hide();
                            if (HttpCommander.Lib.Utils.checkDirectHandlerResult(
                                data, trans, config.Msg, config.htcConfig)) {
                                if (!Ext.isEmpty(fileInfo.path) && !Ext.isEmpty(fileInfo.name)) {
                                    config.setSelectPath({
                                        name: fileInfo.name,
                                        path: fileInfo.path
                                    });
                                }
                                config.openGridFolder(fileInfo.path);
                            }
                        });
                        break;
                }
            }
        }
    });
};