v2.0.0-beta Release Notes - December 12, 2019
=============================================

What's New in Hyperledger Fabric v2.0
-------------------------------------

The following new major features are included in the v2.0.0 Beta release.
For additional details, see the What's New documentation.

**FAB-11237: Decentralized chaincode governance**

Fabric 2.0 introduces decentralized governance for chaincode, with a
new process for installing a chaincode on your peers and starting it on a
channel. The new Fabric chaincode lifecycle allows multiple organizations to
come to agreement on the parameters of a chaincode, such as the chaincode
endorsement policy, before it can be used to interact with the ledger.

**FAB-13584: External chaincode launcher**

While chaincode is still run in a docker container by default in Fabric v2.0,
the external chaincode launcher feature empowers operators to build and launch
chaincode with the technology of their choice.

**Private data enhancements**
- **FAB-10889: Implicit org-specific collections**
- **FAB-15066: Endorsement policies for collections**
- **FAB-13581: memberOnlyWrite collection configuration option**
- **FAB-13527: GetPrivateDataHash chaincode API**
- **FAB-12043: Option to include private data in block events**

The private data enhancements enable new private data application patterns.

**FAB-103: State database cache for CouchDB**

A new peer cache improves performance when using CouchDB state database.


Fixes
-----
All fixes as of release v1.4.4 are also included in v2.0.0-beta.

For the full list of fixes, refer to the release change log.


Changes
-------
**FAB-11144: Removal of native token support**

The native token support included in v2.0.0-alpha has been removed.
An improved implementation is being evaluated for future releases.

**FAB-5177: The ccenv build image no longer includes the shim**

The shim package and dependencies for go chaincode are no longer included in
the chaincode build environment. Chaincode packages that do not include their
own dependencies will no longer successfully build on the peer.  We strongly
recommend that existing go chaincode be updated to vendor the
github.com/hyperledger/fabric-chaincode-go/shim package and its dependencies.
While there are many tools for managing vendored dependencies, we recommend
moving directly to go modules and vendoring with `go mod vendor`.

**FAB-15366: Logger removed from chaincode shim**

Chaincode that used the shim's NewLogger() will need to shift to a new
logging mechanism. Chaincode logging is intended to be the responsibility
of the application developer. As such it should be handled using tools and
libraries that make the most sense to the chaincode developer and the
application in general. Chaincode developers can forward STDOUT and STDERR
from the chaincode container to the peer container by setting
`CORE_VM_DOCKER_ATTACHSTDOUT=true`. While not recommended for production,
once enabled, each chaincode will receive its own logging channel and
STDOUT and STDERR will be integrated in the peers log on a per-line basis.
A production grade approach would be to run a log aggregation service and
forward your logs to the aggregation service.

**FAB-16213: The go chaincode entities extension has been removed**

Chaincode implementations that used the entities extension package from an
earlier version of Fabric will need to vendor a 1.x version of the package
for as part of their chaincode package.

**FAB-14720: Support for CAR chaincode package format removed**

**FAB-15285: Support for invoking system chaincodes from user chaincodes
has been removed.**

System chaincodes, for example QSCC, are intended to be
invoked by a client rather than by a user chaincode. Invoking from a user
chaincode caused deadlocks in prior releases.

**FAB-15390: Support for peer's Admin service has been removed.**

The peer's Admin service exposed APIs such as GetLogSpec() and SetLogSpec().
Instead of using these services, utilize the HTTP operations service that was
introduced in v1.4.0.

**FAB-16303: GetHistoryForKey returns results from newest to oldest**

In prior releases, the GetHistoryForKey chaincode API had no
guarantees on the order of returned results.
Starting in Fabric v2.0, the GetHistoryForKey chaincode API
will return results from newest to oldest in terms of ordered transaction
height (block height and transaction height within block).
This will allow applications to iterate through the top results
to understand recent changes to a key.

**FAB-16722: The 'provisional' genesis method of generating the system channel
for orderers has been removed.**

Existing users of the provisional genesis method
should instead set BootstrapMethod to 'file', and generate a genesis block file
using configtxgen. Orderer nodes will then use the generated file for the
orderer system channel.

**FAB-16477 and FAB-17116: New configuration for orderer genesismethod and genesisfile**

The orderer config `general.genesismethod` and `general.genesisfile` are replaced
by the new `general.bootstrapmethod` and `general.bootstrapfile`.

**FAB-15343: System Chaincode Plugins have been removed.**

As part of a general
move away from go plugins as an extension mechanism for Fabric, the ability to
add system chaincodes via go plugins has been removed.  Users wishing to extend
Fabric with custom system chaincodes may rebuild the peer binary with the
system chaincode built into the binary.  This system chaincode should then be
defined and initialized like any other user chaincode would be.  This new model
is very similar to the plugin model (which required that the plugin to be built
at the same exact commit of Fabric), and addresses the significant shortcomings
around the lifecycle and validation of system chaincode transactions.

**FAB-11096: Docker images with Alpine Linux**

Hyperledger Fabric Docker images will now use Alpine Linux,
a security-oriented, lightweight Linux distribution.

**FAB-11096: Bash not available in Docker images with Alpine Linux**
Bash is no longer available in Fabric images. Utilize Alpine's built-in
sh or ash instead.

**FAB-16987: Go version has been updated to 1.13.4.**


Deprecations
------------

**FAB-15754: The 'Solo' consensus type is deprecated.**

The 'Solo' consensus type has always been marked non-production and should be in
use only in test environments, however for compatibility it is still available,
but may be removed entirely in a future release.

**FAB-16408: The 'Kafka' consensus type is deprecated.**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred
production consensus type.  There is a documented and tested migration path from
Kafka to Raft, and existing users should migrate to the newer Raft consensus type.
For compatibility with existing deployments, Kafka is still supported,
but may be removed entirely in a future release.

**FAB-7559: Support for specifying orderer endpoints at the global level
in channel configuration is deprecated.**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of an organization instead.
Configuring orderer endpoints at the organization level accommodates
scenarios where orderers are run by different organizations. Using
this configuration ensures that only the TLS CA certificates of that organization
are used for orderer communications, in contrast to the global channel level endpoints which
would cause an aggregation of all orderer TLS CA certificates across
all orderer organizations to be used for orderer communications.

Known Issues and Workarounds
----------------------------
**FAB-12134: Same chaincode source receiving fingerprint mismatch error**

When using the legacy chaincode lifecycle, chaincode installed in different
ways may result in "chaincode fingerprint mismatch data mismatch" error
upon instantiation.  This may happen when installing chaincode by using
different SDKs. To workaround the problem, package the chaincode prior to
installation and instantiation, by using the "peer chaincode package" command.


Known Vulnerabilities
---------------------
**FAB-8664: Peer should detect and react when its org has been removed**

This is a relatively low severity problem, because it requires a significant
conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.

For the full list of improvements and fixes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/master/CHANGELOG.md#v200-beta
