v2.3.1 Wednesday, February 3, 2021
==================================

Fixes
-----

**peer - incorrect handling of values set to empty byte array in node chaincode**

Peer should handle key values set to nil or empty byte arrays as a delete of the key.
While the behavior worked as expected when using Go chaincode and Java chaincode,
if using node chaincode it did not work correctly when setting key values to empty byte arrays.
This fix ensures that peer will interpret empty byte arrays as deletes even for node chaincodes.
If using node chaincode with private data, if you had set private data values to an empty
byte array, the private data hash would have been committed incorrectly to the state database.
To repair the state database, after applying the fix, with the peer stopped, request that
the state database be rebuilt by calling "peer node rebuild-dbs" or by deleting the state database.
Upon the next start, the peer will rebuild the state database from the already processed block store.
If subsequent transactions had referenced the existence of such a private data hash by calling
GetPrivateDataHash, then the subsequent transactions may have been processed incorrectly and
the peer will need to additionally reprocess blocks, which can be triggered by calling
"peer node reset" instead of "peer node rebuild-dbs".
If the peer joined channels from a snapshot, "peer node rebuild-dbs" and "peer node reset"
are not available since the peer does not have all blocks since the genesis block. In
these cases the peer will need to be replaced with a new peer that re-joins from the snapshots.
If using regular channel data only and not private data, the empty byte array will not
have been committed, and therefore no action is required on the peer beyond applying the fix.

**orderer - incorrect osnadmin flag --channel-id**

The osnadmin CLI introduced in v2.3.0 used an incorrect flag --channel-id.
The flag has been corrected to be --channelID in order to be consistent
with other CLIs.


Dependencies
------------
Fabric v2.3.1 has been tested with the following dependencies:
* Go 1.14.12
* CouchDB v3.1.1


Deprecations (existing)
-----------------------

**FAB-15754: The 'Solo' consensus type is deprecated.**

The 'Solo' consensus type has always been marked non-production and should be in
use only in test environments, however for compatibility it is still available,
but may be removed entirely in a future release.

**FAB-16408: The 'Kafka' consensus type is deprecated.**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred
production consensus type.  There is a documented and tested migration path from
Kafka to Raft, and existing users should migrate to the newer Raft consensus type.
For compatibility with existing deployments, Kafka is still supported,
but may be removed entirely in a future release.
Additionally, the fabric-kafka and fabric-zookeeper docker images are no longer updated, maintained, or published.

**Fabric CouchDB image is deprecated**

v2.2.0 added support for CouchDB 3.1.0 as the recommended and tested version of CouchDB.
If prior versions are utilized, a Warning will appear in peer log.
Note that CouchDB 3.1.0 requires that an admin username and password be set,
while this was optional in CouchDB v2.x. See the
[Fabric CouchDB documentation](https://hyperledger-fabric.readthedocs.io/en/v2.2.0/couchdb_as_state_database.html#couchdb-configuration)
for configuration details.
Also note that CouchDB 3.1.0 default max_document_size is reduced to 8MB. Set a higher value if needed in your environment.
Finally, the fabric-couchdb docker image will not be updated to v3.1.0 and will no longer be updated, maintained, or published.
Users can utilize the official CouchDB docker image maintained by the Apache CouchDB project instead.

**FAB-7559: Support for specifying orderer endpoints at the global level in channel configuration is deprecated.**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of an organization instead.
Configuring orderer endpoints at the organization level accommodates
scenarios where orderers are run by different organizations. Using
this configuration ensures that only the TLS CA certificates of that organization
are used for orderer communications, in contrast to the global channel level endpoints which
would cause an aggregation of all orderer TLS CA certificates across
all orderer organizations to be used for orderer communications.

**FAB-17428: Support for configtxgen flag `--outputAnchorPeersUpdate` is deprecated.**

The `--outputAnchorPeersUpdate` mechanism for updating anchor peers has always had
limitations (for instance, it only works the first time anchor peers are updated).
Instead, anchor peer updates should be performed through the normal config update flow.

**FAB-15406: The fabric-tools docker image is deprecated**

The fabric-tools docker image will not be published in future Fabric releases.
Instead of using the fabric-tools docker image, users should utilize the
published Fabric binaries. The Fabric binaries can be used to make client calls
to Fabric runtime components, regardless of where the Fabric components are running.

**FAB-15317: Block dissemination via gossip is deprecated**

Block dissemination via gossip is deprecated and may be removed in a future release.
Fabric peers can be configured to receive blocks directly from an ordering service
node by using the following configuration:
```
peer.gossip.orgLeader: true
peer.gossip.useLeaderElection: false
peer.gossip.state.enabled: false
```

**FAB-15061: Legacy chaincode lifecycle is deprecated**

The legacy chaincode lifecycle from v1.x is deprecated and will be removed
in a future release. To prepare for the eventual removal, utilize the v2.x
chaincode lifecycle instead, by enabling V2_0 application capability on all
channels, and redeploying all chaincodes using the v2.x lifecycle. The new
chaincode lifecycle provides a more flexible and robust governance model
for chaincodes. For more details see the
[documentation for enabling the new lifecycle](https://hyperledger-fabric.readthedocs.io/en/release-2.2/enable_cc_lifecycle.html).
