CREATE TABLE MAGIC_API_INFO
(
    ID VARCHAR2 (32) NOT NULL,
    API_METHOD VARCHAR2 (12),
    API_PATH VARCHAR2 (512),
    API_SCRIPT CLOB,
    API_PARAMETER CLOB,
    API_OPTION CLOB,
    API_NAME VARCHAR2 (255),
    API_GROUP_ID VARCHAR2 (32),
    API_REQUEST_BODY CLOB,
    API_REQUEST_HEADER CLOB,
    API_RESPONSE_BODY CLOB,
    API_RESPONSE_HEADER CLOB,
    API_DESCRIPTION VARCHAR2 (512),
    API_CREATE_TIME NUMBER (20),
    API_UPDATE_TIME NUMBER (20)
);
COMMENT ON COLUMN MAGIC_API_INFO.API_METHOD IS '请求方法';
COMMENT ON COLUMN MAGIC_API_INFO.API_PATH IS '请求路径';
COMMENT ON COLUMN MAGIC_API_INFO.API_SCRIPT IS '接口脚本';
COMMENT ON COLUMN MAGIC_API_INFO.API_PARAMETER IS '接口参数';
COMMENT ON COLUMN MAGIC_API_INFO.API_OPTION IS '接口选项';
COMMENT ON COLUMN MAGIC_API_INFO.API_NAME IS '接口名称';
COMMENT ON COLUMN MAGIC_API_INFO.API_GROUP_ID IS '分组ID';
COMMENT ON COLUMN MAGIC_API_INFO.API_REQUEST_BODY IS '请求体';
COMMENT ON COLUMN MAGIC_API_INFO.API_REQUEST_HEADER IS '请求Header';
COMMENT ON COLUMN MAGIC_API_INFO.API_RESPONSE_BODY IS '输出结果';
COMMENT ON COLUMN MAGIC_API_INFO.API_RESPONSE_HEADER IS '输出Header';
COMMENT ON COLUMN MAGIC_API_INFO.API_DESCRIPTION IS '接口描述';
COMMENT ON COLUMN MAGIC_API_INFO.API_CREATE_TIME IS '创建时间';
COMMENT ON COLUMN MAGIC_API_INFO.API_UPDATE_TIME IS '修改时间';
COMMENT ON TABLE MAGIC_API_INFO IS 'MagicAPI接口信息';

CREATE TABLE MAGIC_API_INFO_HIS
(
    ID VARCHAR2 (32),
    API_METHOD VARCHAR2 (12),
    API_PATH VARCHAR2 (512),
    API_SCRIPT CLOB,
    API_PARAMETER CLOB,
    API_OPTION CLOB,
    API_NAME VARCHAR2 (255),
    API_GROUP_ID VARCHAR2 (32),
    API_REQUEST_BODY CLOB,
    API_REQUEST_HEADER CLOB,
    API_RESPONSE_BODY CLOB,
    API_RESPONSE_HEADER CLOB,
    API_DESCRIPTION VARCHAR2 (512),
    API_CREATE_TIME NUMBER (20),
    API_UPDATE_TIME NUMBER (20)
);
COMMENT ON COLUMN MAGIC_API_INFO_HIS.ID IS 'api_id';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_METHOD IS '请求方法';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_PATH IS '请求路径';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_SCRIPT IS '接口脚本';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_PARAMETER IS '接口参数';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_OPTION IS '接口选项';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_NAME IS '接口名称';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_GROUP_ID IS '分组ID';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_REQUEST_BODY IS '请求体';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_REQUEST_HEADER IS '请求Header';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_RESPONSE_BODY IS '输出结果';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_RESPONSE_HEADER IS '输出Header';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_DESCRIPTION IS '接口描述';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_CREATE_TIME IS '创建时间';
COMMENT ON COLUMN MAGIC_API_INFO_HIS.API_UPDATE_TIME IS '修改时间';

CREATE TABLE MAGIC_FUNCTION
(
    ID VARCHAR2 (32) NOT NULL,
    FUNCTION_NAME VARCHAR2 (64),
    FUNCTION_PATH VARCHAR2 (64),
    FUNCTION_PARAMETER CLOB,
    FUNCTION_RETURN_TYPE VARCHAR2 (32),
    FUNCTION_SCRIPT CLOB,
    FUNCTION_GROUP_ID VARCHAR2 (32) NOT NULL,
    FUNCTION_DESCRIPTION VARCHAR2 (512),
    FUNCTION_CREATE_TIME NUMBER (20),
    FUNCTION_UPDATE_TIME NUMBER (20)
);
COMMENT ON COLUMN MAGIC_FUNCTION.ID IS '主键';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_NAME IS '函数名称';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_PATH IS '函数路径';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_PARAMETER IS '参数列表';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_RETURN_TYPE IS '返回值类型';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_SCRIPT IS '脚本';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_GROUP_ID IS '所属分组';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_DESCRIPTION IS '函数描述';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_CREATE_TIME IS '创建时间';
COMMENT ON COLUMN MAGIC_FUNCTION.FUNCTION_UPDATE_TIME IS '修改时间';


CREATE TABLE MAGIC_FUNCTION_HIS
(
    ID VARCHAR2 (32) NOT NULL,
    FUNCTION_NAME VARCHAR2 (64),
    FUNCTION_PATH VARCHAR2 (64),
    FUNCTION_PARAMETER CLOB,
    FUNCTION_RETURN_TYPE VARCHAR2 (32),
    FUNCTION_SCRIPT CLOB,
    FUNCTION_GROUP_ID VARCHAR2 (32) NOT NULL,
    FUNCTION_DESCRIPTION VARCHAR2 (512),
    FUNCTION_CREATE_TIME NUMBER (20),
    FUNCTION_UPDATE_TIME NUMBER (20)
);
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.ID IS 'function_id';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_NAME IS '函数名称';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_PATH IS '函数路径';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_PARAMETER IS '参数列表';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_RETURN_TYPE IS '返回值类型';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_SCRIPT IS '脚本';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_GROUP_ID IS '所属分组';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_DESCRIPTION IS '函数描述';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_CREATE_TIME IS '创建时间';
COMMENT ON COLUMN MAGIC_FUNCTION_HIS.FUNCTION_UPDATE_TIME IS '修改时间';

CREATE TABLE MAGIC_GROUP
(
    ID VARCHAR2 (32) NOT NULL,
    GROUP_NAME VARCHAR2 (64),
    GROUP_TYPE VARCHAR2 (1),
    GROUP_PATH VARCHAR2 (64),
    PARENT_ID VARCHAR2 (32)
);
COMMENT ON COLUMN MAGIC_GROUP.GROUP_NAME IS '组名';
COMMENT ON COLUMN MAGIC_GROUP.GROUP_TYPE IS '组类型，1：接口分组，2：函数分组';
COMMENT ON COLUMN MAGIC_GROUP.GROUP_PATH IS '分组路径';
COMMENT ON COLUMN MAGIC_GROUP.PARENT_ID IS '父级ID';

ALTER TABLE MAGIC_API_INFO
    ADD PRIMARY KEY (ID);
ALTER TABLE MAGIC_FUNCTION
    ADD PRIMARY KEY (ID);
ALTER TABLE MAGIC_GROUP
    ADD PRIMARY KEY (ID);
