(function($){
	$.fn.pop=function(config){
		var options={
			callback:null,
			popHideDelay:1000,
            dialog:"",
            closeBtn:""
		};
				
		var op=$.extend(options,config);
		var phd=op.popHideDelay||null;
		var popView={
			obj:null,
			hasView:false
		};

		this.each(function(){
			var $this=$(this);
			var title=this.title;
			var type=$(this).attr("type");
			var message=$(this).attr("message");
			var trigger=null;
			if(type==="alert"||type==="confirm" || type==="simpleDialog"){
				trigger="click";
			}else{
				trigger="mouseover";
			}
			$this.bind(trigger,function(){
				var bg=null,win=null,pos=null,back=null,$closeBtn;

				if(type==="alert"||type==="confirm"){
					bg=new $.xes.createBackGround();
					win= new createWin(title,type,message,bg.bgDom);
					$(document.body).append(bg.bgDom);	
					bg.bgDom.css("height",window.innerHeight+"px");
					$(document.body).append(win.winDom);
				}else if(type=="pop"){
					if(!popView.obj){
						win= new $.xes.createPoptip(message);					
						$this.parent().append(win.popDom);
						pos=getPopPosition($this,win.popDom);
						win.popDom.show();
						win.popDom.css("left",pos.x+"px");
						win.popDom.css("top",pos.y+"px");						
						popView.obj=win.popDom;
						$this.bind("mouseout",hidePop);
					}else{
						popView.obj.show();
					}
					popView.hasView=true;
				}else if(type=="simpleDialog"){
                    win=$(op.dialog);
                    back= $.xes.createBackGround().bgDom;

                    $(document.body).append(back);
                    $closeBtn=win.find(op.closeBtn);
                    win.show();
                    var uname = win.find("input#CasUsername").val();
                    if (uname=='使用手机/邮箱/学员编号进行登录' || uname =='') {
                    	win.find("input#CasUsername").val("");
                    }
                    back.show();
                    $closeBtn.bind("click",function(){
                    	win.find("div#errInfo").html("&nbsp;");
                    	win.find("input#CasUsername").val("");
                    	win.find("input#CasPassword").val("");
                        win.hide();
                        back.remove();
                    });
                    rePosDialog(win);
                    $(window).bind("resize scroll",function(){
                        rePosDialog(win);
                    });
                }
				
			});
		});



        function rePosDialog(pop){

            var pos=getDialogPosition(pop);
            pop.css("top",pos.top+"px");
            pop.css("left",pos.left+"px");
        }

        function getDialogPosition(pop){
            var width=$(window).width();
            var height=$(window).height();
            var scrollTop= document.documentElement.scrollTop || window.pageYOffset || document.body.scrollTop;
            var scrollLeft= document.documentElement.scrollLeft || window.pageXOffset || document.body.scrollLeft;
            var popWidth=pop.width();
            var popHeight=pop.height();

            return {
                left:(width-popWidth)/2+scrollLeft,
                top:(height-popHeight)/2+scrollTop
            };
        }

		function getPopPosition(btn,pop){
			var btnOffset=btn.offset();
			var btnWidth=btn.width();
			var btnHeight=btn.height();
			var popWidth=pop.width();
			var popHeight=pop.height();

			return {
				x:btnWidth/2+btnOffset.left-popWidth/2,
				y:btnOffset.top-popHeight
			};
		}

		function hidePop(){
			if(phd){
				setTimeout(function(){
					popView.obj.hide();
					popView.hasView=false;
				},phd);
			}else{
				popView.obj.hide();
				popView.hasView=false;
			}
			
		}

		function createWin(title,type,m,bg){
			var winContext=new $.xes.createWin(type,title,m);	
			switch (type){
				case "alert":
					winContext.submit.click(function(){				
						destroy();
					});
					break;
				case "confirm":
					winContext.submit.click(function(){
						op.callback(true);
						destroy();
					});
					winContext.cancel.click(function(){
						op.callback(false);
						destroy();
					});
					break;
			}
			
			winContext.close.click(function(){
				if(type==="confirm"){
					op.callback(false);
				}
				destroy();
			});
			function destroy(){
				winContext.winDom.remove();
				if(bg){
					bg.remove();
				}
			}
			return winContext;
		}
	};
})(jQuery);