<?php

namespace App\Http\Controllers;

use App\Modules\Manage\Model\MenuModel;
use App\Modules\Manage\Model\MenuPermissionModel;
use App\Modules\Manage\Model\Permission;
use App\Modules\Manage\Model\ManagerModel;
use App\Modules\Manage\Model\ConfigModel;
use Illuminate\Support\Facades\Route;
use Cache;


class ManageController extends BasicController
{
    public $manager;
    public function __construct()
    {
        parent::__construct();

        
        if (ManagerModel::getManager())
        {
            
            $this->manageBreadcrumb();
            $this->breadcrumb = $this->theme->breadcrumb();
            $this->manager = ManagerModel::getManager();
            $this->theme->setManager($this->manager->username);

            
            $manageMenu = MenuModel::getMenuPermission();
            $this->theme->set('manageMenu', $manageMenu);
        }

        
        $route = Route::currentRouteName();
        
        if($route!='loginCreatePage')
        {
            $permission = Permission::where('name',$route)->first();
            if(!is_null($permission))
            {
                $permission = MenuPermissionModel::where('permission_id',$permission['id'])->first()->toArray();
                
                $menu_data = MenuModel::getMenu($permission['menu_id']);
                $this->theme->set('menu_data', $menu_data['menu_data']);
                $this->theme->set('menu_ids',$menu_data['menu_ids']);
            }
        }

        
        $basisConfig = ConfigModel::getConfigByType('basis');
        if(!empty($basisConfig)){
            $this->theme->set('basis_config',$basisConfig);
        }

        
        $menuIcon = [
            '后台首页'=>'fa-home',
            '系统配置'=>'fa-cog',
            '用户管理'=>'fa-users',
            '任务控制台'=>'fa-tasks',
            '推荐管理'=>'fa-external-link',
            '站长工具'=>'fa-user',
            '资讯管理'=>'fa-file-text',
            '财务管理'=>'fa-bar-chart-o',
            '短信模板'=>'fa-envelope'
        ];
        $this->theme->set('menuIcon',$menuIcon);
    }
}
