<?php


namespace App\Modules\Bre\Http\Controllers;

use App\Modules\Manage\Model\FeedbackModel;
use App\Modules\Task\Model\TaskCateModel;
use App\Modules\User\Model\TagsModel;
use App\Modules\User\Model\UserDetailModel;
use App\Modules\User\Model\UserModel;
use App\Modules\User\Model\UserTagsModel;
use Illuminate\Http\Request;
use App\Modules\Advertisement\Model\AdTargetModel;
use App\Modules\Advertisement\Model\AdModel;
use Auth;
use Validator;
use App\Modules\Advertisement\Model\RePositionModel;
use App\Modules\Advertisement\Model\RecommendModel;
use App\Modules\User\Model\AuthRecordModel;
use App\Modules\User\Model\CommentModel;
use App\Modules\Manage\Model\ConfigModel;
use Cache;

class IndexController extends \App\Http\Controllers\IndexController
{

    public function __construct()
    {
        parent::__construct();
        $this->initTheme('main');
    }


    public function index()
    {
        $view =[];
        $adTargetID = AdTargetModel::where('code','HOME_TOP_SLIDE')->select('target_id')->first();
        if($adTargetID['target_id']){
            $adPicInfo = AdModel::where('target_id',$adTargetID['target_id'])->select('ad_file','ad_url')->get();
            if(count($adPicInfo)){
               $view['adPicInfo'] = $adPicInfo;
            }else{
                $view['adPicInfo'] = [];
            }
        }
        $adTarget = AdTargetModel::where('code','HOME_BOTTOM')->select('target_id')->first();
        if($adTarget['target_id']){
            $buttomPicInfo = AdModel::where('target_id',$adTarget['target_id'])->select('ad_file','ad_url')->get();
            if(count($adPicInfo)){
                $view['buttomPicInfo'] = $buttomPicInfo;
            }else{
                $view['buttomPicInfo'] = [];
            }
        }
        $useDetail = [];
        $user = Auth::User();
        if($user){
            $useDetail = UserDetailModel::where('uid',$user->id)->select('uid','mobile')->first();
        }
        $view['useDetail'] = $useDetail;
        return $this->theme->scope('bre.index',$view)->render();
    }

    public function breDetail($id)
    {
        echo $id;
        return $this->theme->scope('bre.index')->render();
    }

    
    public function getService(Request $request)
    {
        
        $seoConfig = ConfigModel::getConfigByType('seo');
        if(!empty($seoConfig['seo_service']) && is_array($seoConfig['seo_service'])){
            $this->theme->setTitle($seoConfig['seo_service']['title']);
            $this->theme->set('keywords',$seoConfig['seo_service']['keywords']);
            $this->theme->set('description',$seoConfig['seo_service']['description']);
        }else{
            $this->theme->setTitle('服务商大厅');
        }

        if($request->get('employee_praise_rate')){
            $merge = $request->except('employee_praise_rate');
        }elseif($request->get('receive_task_num')){
            $merge = $request->except('receive_task_num');
        }else{
            $merge = $request->all();
        }

        if($request->get('service_name') || $request->get('keywords')){
            $searchName = $request->get('service_name') ? $request->get('service_name') : $request->get('keywords');
            $list = UserModel::select('user_detail.sign', 'users.name', 'user_detail.avatar', 'users.id','users.email_status')
                ->leftJoin('user_detail', 'users.id', '=', 'user_detail.uid')->where('user_detail.shop_status', 1)->where('users.name','like',"%".$searchName."%");
        }else{
            $list = UserModel::select('user_detail.sign', 'users.name', 'user_detail.avatar', 'users.id','users.email_status')
                ->leftJoin('user_detail', 'users.id', '=', 'user_detail.uid')->where('user_detail.shop_status', 1);
        }
        
        if ($request->get('category')) {
            $category = TaskCateModel::findByPid([$request->get('category')]);

            if (empty($category)) {
                $category_data = TaskCateModel::findById($request->get('category'));
                $category = TaskCateModel::findByPid([$category_data['pid']]);
                $pid = $category_data['pid'];
                $arrTag = TagsModel::where('cate_id', $request->get('category'))->lists('id')->toArray();
                $dataUid = UserTagsModel::whereIn('tag_id', $arrTag)->lists('uid')->toArray();
                $list = $list->whereIn('users.id', $dataUid);
            } else {
                foreach ($category as $item){
                    $arrCateId[] = $item['id'];
                }
                $arrTag = TagsModel::whereIn('cate_id', $arrCateId)->lists('id')->toArray();
                $dataUid = UserTagsModel::whereIn('tag_id', $arrTag)->lists('uid')->toArray();
                $list = $list->whereIn('users.id', $dataUid);
                $pid = $request->get('category');
            }
        } else {
            
            $category = TaskCateModel::findByPid([0]);
            $pid = 0;
        }

        
        if($request->get('employee_praise_rate') && $request->get('employee_praise_rate') == 1){
            $list = $list->orderby('user_detail.employee_praise_rate','DESC');
        }
        
        if($request->get('receive_task_num') && $request->get('receive_task_num') == 1){
            $list = $list->orderby('user_detail.receive_task_num','DESC');
        }

        $paginate = 10;
        $list = $list->paginate($paginate);
        if (!empty($list->toArray()['data'])){

            foreach ($list as $k => $v){
                $arrUid[] = $v->id;
            }
        } else {
            $arrUid = 0;
        }

        
        $comment = CommentModel::whereIn('to_uid',$arrUid)->get()->toArray();
        if(!empty($comment)){
            
            $newComment = array_reduce($comment,function(&$newComment,$v){
                $newComment[$v['to_uid']][] = $v;
                return $newComment;
            });
            $commentCount = array();
            if(!empty($newComment)){
                foreach($newComment as $c => $d){
                    $commentCount[$c]['to_uid'] = $c;
                    $commentCount[$c]['count'] = count($d);
                }
            }
            
            $goodComment = CommentModel::whereIn('to_uid',$arrUid)->where('type',1)->get()->toArray();
            
            $newGoodsComment = array_reduce($goodComment,function(&$newGoodsComment,$v){
                $newGoodsComment[$v['to_uid']][] = $v;
                return $newGoodsComment;
            });
            $goodCommentCount = array();
            if(!empty($newGoodsComment)){
                foreach($newGoodsComment as $a => $b){
                    $goodCommentCount[$a]['to_uid'] = $a;
                    $goodCommentCount[$a]['count'] = count($b);
                }
            }
            
            foreach($list as $key => $value){
                foreach($goodCommentCount as $a => $b){
                    if($value['id'] == $b['to_uid']){
                        $list[$key]['good_comment_count'] = $b['count'];
                    }
                }
                foreach($commentCount as $c => $d){
                    if($value['id'] == $d['to_uid']){
                        $list[$key]['comment_count'] = $d['count'];
                    }
                }
            }
            foreach ($list as $key => $item) {
                
                if($item->comment_count > 0){
                    $item->percent = ceil($item->good_comment_count/$item->comment_count*100);
                }
                else{
                    $item->percent = 100;
                }
            }
        }else{
            foreach ($list as $key => $item) {
                
                $item->percent = 100;
            }
        }

        
        $arrSkill = UserTagsModel::getTagsByUserId($arrUid);

        if(!empty($arrSkill) && is_array($arrSkill)){
            foreach ($arrSkill as $item){
                $arrTagId[] = $item['tag_id'];
            }

            $arrTagName = TagsModel::select('id', 'tag_name')->whereIn('id', $arrTagId)->get()->toArray();
            foreach ($arrSkill as $item){
                foreach ($arrTagName as $value){
                    if ($item['tag_id'] == $value['id']){
                        $arrUserTag[$item['uid']][] = $value['tag_name'];
                    }
                }
            }
            foreach ($list as $key => $item){
                foreach ($arrUserTag as $k => $v){
                    if ($item->id == $k){
                        $list[$key]['skill'] = $v;
                    }
                }
            }
        }

        
        $preArr = UserDetailModel::join('district', 'user_detail.province', '=', 'district.id')->select('district.name','user_detail.uid')->whereIn('user_detail.uid', $arrUid)->get()->toArray();
        $cityArr = UserDetailModel::join('district', 'user_detail.city', '=', 'district.id')->select('district.name','user_detail.uid')->whereIn('user_detail.uid', $arrUid)->get()->toArray();
        foreach($list as $key => $value){
            if(!empty($preArr) && is_array($preArr)){
                foreach($preArr as $g => $h){
                    if($value['id'] == $h['uid']){
                        $list[$key]['pre'] = $h['name'];
                    }
                }
            }
            if(!empty($cityArr) && is_array($cityArr)){
                foreach($cityArr as $i => $j){
                    if($value['id'] == $j['uid']){
                        $list[$key]['city'] = $j['name'];
                    }
                }
            }
        }
        
        $userAuthOne = AuthRecordModel::whereIn('uid', $arrUid)->where('status', 2)->where('auth_code','!=','realname')->get()->toArray();
        $userAuthTwo = AuthRecordModel::whereIn('uid', $arrUid)->where('status', 1)->where('auth_code','realname')->get()->toArray();
        $userAuth = array_merge($userAuthOne,$userAuthTwo);
        $auth = array();
        if(!empty($userAuth) && is_array($userAuth)){
            foreach($userAuth as $a => $b){
                foreach($userAuth as $c => $d){
                    if($b['uid'] = $d['uid']){
                        $auth[$b['uid']][] = $d['auth_code'];
                    }
                }
            }
        }
        if(!empty($auth) && is_array($auth)){
            foreach($auth as $e => $f){
                $auth[$e]['uid'] = $e;
                if(in_array('realname',$f)){
                    $auth[$e]['realname'] = true;
                }else{
                    $auth[$e]['realname'] = false;
                }
                if(in_array('bank',$f)){
                    $auth[$e]['bank'] = true;
                }else{
                    $auth[$e]['bank'] = false;
                }
                if(in_array('alipay',$f)){
                    $auth[$e]['alipay'] = true;
                }else{
                    $auth[$e]['alipay'] = false;
                }
            }
            foreach ($list as $key => $item) {
                
                foreach ($auth as $a => $b) {
                    if ($item->id == $b['uid']) {
                        $list[$key]['auth'] = $b;
                    }
                }
            }

         }


        
        $ad = AdTargetModel::getAdInfo('SELLERLIST_BOTTOM');

        
        $rightAd = AdTargetModel::getAdInfo('SELLERLIST_RIGHT_TOP');

        
        $reTarget = RePositionModel::where('code','SERVICE_SIDE')->where('is_open','1')->select('id','name')->first();
        if($reTarget->id){
            $recommend = RecommendModel::getRecommendInfo($reTarget->id)->select('*')->get();
            if(count($recommend)){
                foreach($recommend as $k=>$v){
                    $comment = CommentModel::where('to_uid',$v['recommend_id'])->count();
                    $goodComment = CommentModel::where('to_uid',$v['recommend_id'])->where('type',1)->count();
                    if($comment){
                        $v['percent'] = $goodComment/$comment;
                    }
                    else{
                        $v['percent'] = 0;
                    }
                    $recommend[$k] = $v;
                }
                $hotList = $recommend;
            }
            else{
                $hotList = [];
            }
        }

        $data = array(
            'pid' => $pid,
            'category' => $category,
            'list' => $list,
            'merge' => $merge,
            'paginate' => $paginate,
            'page' => $request->get('page') ? $request->get('page') : '',
            'skillId' => $request->get('skillId') ? $request->get('skillId') : '',
            'type' => $request->get('type') ? $request->get('type') : 0,
            'ad' => $ad,
            'rightAd' => $rightAd,
            'hotList' => $hotList,
            'targetName' => $reTarget->name
        );
        $this->theme->set('now_menu','/bre/service');
        return $this->theme->scope('bre.servicelist', $data)->render();
    }

    
    public function creatInfo(Request $request){
        $data = $request->except('_token');
        $validator = Validator::make($data,[
            'desc' => 'required|max:255'
        ],
        [
            'desc.required' => '请输入投诉建议',
            'desc.max'      => '投诉建议字数超过限制'


        ]);
        $error = $validator->errors()->all();
        if(count($error)){
            return redirect()->to(\CommonClass::homePage())->with(['error'=>$validator->errors()->first()]);
        }
        if($data['phone']){
            $validator = Validator::make($data,[
                'phone' => 'mobile_phone'
            ],
            [
                'phone.mobile_phone' => '请输入正确的手机格式'


            ]);

            $error = $validator->errors()->all();
            if(count($error)){
                return redirect()->to(\CommonClass::homePage())->with(['error'=>$validator->errors()->first()]);
            }
        }
        $newdata = [
            'desc'          => $data['desc'],
            'created_time'  => date('Y-m-d h:i:s',time())
        ];
        if($data['uid']){
            $newdata['uid'] = $data['uid'];
        }
        if($data['phone']){
            $newdata['phone'] = $data['phone'];
        }
        $res = FeedbackModel::create($newdata);
        if($res){
            return redirect()->to(\CommonClass::homePage())->with(['message'=>'投诉建议提交成功！']);
        }
        return redirect()->to(\CommonClass::homePage())->with(['error'=>'投诉建议提交失败！']);
    }

}