<?php
namespace App\Modules\Finance\Http\Controllers;

use App\Modules\Finance\Http\Requests\CashoutInfoRequest;
use App\Modules\Finance\Http\Requests\CashoutRequest;
use App\Modules\Finance\Http\Requests\PayRequest;
use App\Modules\Finance\Model\CashoutModel;
use App\Modules\Finance\Model\FinancialModel;
use App\Modules\Manage\Model\ConfigModel;
use App\Modules\Order\Model\OrderModel;
use App\Modules\User\Http\Controllers\UserCenterController;
use App\Modules\User\Model\AlipayAuthModel;
use App\Modules\User\Model\BankAuthModel;
use App\Modules\User\Model\UserDetailModel;
use App\Modules\User\Model\UserModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Omnipay;
Use QrCode;

class PayController extends UserCenterController
{
    
    public function __construct()
    {
        parent::__construct();
        $this->initTheme('userfinance');

    }

    
    public function getCash()
    {
        $this->theme->setTitle('我要充值');
        $user = Auth::User();
        $userInfo = UserDetailModel::select('balance')->where('uid', $user->id)->first();

        $payConfig = ConfigModel::getConfigByType('thirdpay');

        if (!empty($userInfo)){
            $data = array(
                'balance' => $userInfo->balance,
                'payConfig' => $payConfig
            );

            return $this->theme->scope('finance.cash', $data)->render();
        }
    }

    
    public function postCash(PayRequest $request)
    {
        $user = Auth::User();
        $config = ConfigModel::getConfigByAlias('cash');
        $config->rule = json_decode($config->rule, true);
        if ($request->get('cash') < $config->rule['recharge_min']) {
            return \CommonClass::formatResponse('充值金额不得小于' . $config->rule['recharge_min'] . '元', 201);
        }
        $data = array(
            'code' => OrderModel::randomCode($user->id),
            'title' => '余额充值',
            'cash' => $request->get('cash'),
            'uid' => $user->id,
            'created_at' => date('Y-m-d H:i:s', time())
        );
        $order = OrderModel::create($data);

        if ($order) {
            $payType = $request->get('pay_type');
            $siteUrl = \CommonClass::getConfig('site_url');

            switch ($payType) {
                case 'alipay':
                    $config = ConfigModel::getPayConfig('alipay');

                    $objOminipay = Omnipay::gateway('alipay');
                    $objOminipay->setPartner($config['partner']);
                    $objOminipay->setKey($config['key']);
                    $objOminipay->setSellerEmail($config['sellerEmail']);
                    $objOminipay->setReturnUrl($siteUrl . '/finance/pay/alipay/return');
                    $objOminipay->setNotifyUrl($siteUrl . '/finance/pay/alipay/notify');

                    $response = Omnipay::purchase([
                        'out_trade_no' => $order->code, 
                        'subject' => \CommonClass::getConfig('site_name') . '余额充值', 
                        'total_fee' => $order->cash, 
                    ])->send();
                    return \CommonClass::formatResponse('确认充值', 200, array('url' => $response->getRedirectUrl(), 'orderCode' => Crypt::encrypt($order->code)));
                    break;
                case 'wechat':
                    return \CommonClass::formatResponse('确认充值', 200, array('url' => '/finance/wechatPay/' . Crypt::encrypt($order), 'orderCode' => Crypt::encrypt($order->code)));
                    break;
                case 'unionbank':
                    $objOminipay = Omnipay::gateway('unionpay');

                    $objOminipay->setReturnUrl($siteUrl . '/finance/pay/unionpay/return');
                    $objOminipay->setNotifyUrl($siteUrl . '/finance/pay/unionpay/notify');

                    $orderParam = [
                        'orderId' => $order->code, 
                        'txnTime' => date('YmdHis'), 
                        'orderDesc' => \CommonClass::getConfig('site_name') . '余额充值', 
                        'txnAmt' => $order->cash, 
                    ];
                    $response = $objOminipay->purchase($orderParam)->send();

                    return \CommonClass::formatResponse('确认充值', 200, array('url' => $response->getRedirectUrl(), 'orderCode' => Crypt::encrypt($order->code)));
                    break;
            }
        }
    }

    
    public function getWechatPay($order)
    {
        $this->theme->setTitle('我要充值');
        $order = Crypt::decrypt($order);
        if ($order) {
            $siteUrl = \CommonClass::getConfig('site_url');

            $config = ConfigModel::getPayConfig('wechatpay');
            $wechat = Omnipay::gateway('wechat');
            $wechat->setAppId($config['appId']);
            $wechat->setMchId($config['mchId']);
            $wechat->setAppKey($config['appKey']);
            $params = array(
                'out_trade_no' => $order->code, 
                'notify_url' => $siteUrl . '/finance/pay/wechat/notify', 
                'body' => \CommonClass::getConfig('site_name') . '余额充值', 
                'total_fee' => $order->cash, 
                'fee_type' => 'CNY', 
            );
            $response = $wechat->purchase($params)->send();

            $img = QrCode::size('280')->generate($response->getRedirectUrl());
            $view = array(
                'cash' => $order->cash,
                'img' => $img
            );
            return $this->theme->scope('pay.wechatpay', $view)->render();
        }

    }

    
    public function alipayReturn(Request $request)
    {
        $gateway = Omnipay::gateway('alipay');

        $options = [
            'request_params' => $_REQUEST,
        ];

        $response = $gateway->completePurchase($options)->send();

        if ($response->isSuccessful() && $response->isTradeStatusOk()) {
            $data = array(
                'pay_account' => $request->get('buyer_email'),
                'code' => $request->get('out_trade_no'),
                'pay_code' => $request->get('trade_no'),
                'money' => $request->get('total_fee'),
            );
            $res = OrderModel::where('code', $data['code'])->first();
            if (!empty($res) && $res->status == 0) {
                $orderModel = new OrderModel();
                $staus = $orderModel->recharge('alipay', $data);
                if ($staus) {
                    echo '支付成功';
                    return redirect('finance/cash');
                }
            }
        } else {
            
            exit('支付失败');
        }
    }

    
    public function alipayNotify(Request $request)
    {
        $gateway = Omnipay::gateway('alipay');

        $options = [
            'request_params' => $_REQUEST,
        ];

        $response = $gateway->completePurchase($options)->send();

        if ($response->isSuccessful() && $response->isTradeStatusOk()) {
            $data = array(
                'pay_account' => $request->get('buyer_email'),
                'code' => $request->get('out_trade_no'),
                'pay_code' => $request->get('trade_no'),
                'money' => $request->get('total_fee'),
            );
            $res = OrderModel::where('code', $data['code'])->first();
            if (!empty($res) && $res->status == 0) {
                $orderModel = new OrderModel();
                $staus = $orderModel->recharge('alipay', $data);
                if ($staus) {
                    exit('支付成功');
                }
            }
        } else {
            
            exit('支付失败');
        }
    }

    
    public function wechatNotify()
    {
        
        $arrNotify = \CommonClass::xmlToArray($GLOBALS['HTTP_RAW_POST_DATA']);
        $content = '<xml>
                    <return_code><![CDATA[SUCCESS]]></return_code>
                    <return_msg><![CDATA[OK]]></return_msg>
                    </xml>';

        if ($arrNotify['result_code'] == 'SUCCESS' && $arrNotify['return_code'] == 'SUCCESS') {
            $data = array(
                'pay_account' => $arrNotify['openid'],
                'code' => $arrNotify['out_trade_no'],
                'pay_code' => $arrNotify['transaction_id'],
                'money' => $arrNotify['total_fee'] / 100,
            );
            $res = OrderModel::where('code', $data['code'])->first();
            if (!empty($res) && $res->status == 0) {
                
                $orderModel = new OrderModel();
                $status = $orderModel->recharge('wechat', $data);
                if ($status) {
                    
                    return response($content)->header('Content-Type', 'text/xml');
                }

            }

        }
    }

    
    public function unionpayReturn()
    {
        $gateway = Omnipay::gateway('unionpay');

        $options = [
            'request_params' => $_REQUEST,
        ];

        $response = $gateway->completePurchase($options)->send();

        if ($response->isPaid()) {
            
        } else {
            
        }
    }

    
    public function unionpayNotify()
    {
        $gateway = Omnipay::gateway('unionpay');

        $options = [
            'request_params' => $_REQUEST,
        ];

        $response = $gateway->completePurchase($options)->send();

        if ($response->isPaid()) {
            
        } else {
            
        }
    }

    
    public function verifyOrder($orderCode)
    {
        $orderCode = Crypt::decrypt($orderCode);

        $orderInfo = OrderModel::where('code', $orderCode)->first();

        if (!empty($orderInfo) && $orderInfo->status) {
            return \CommonClass::formatResponse('success', 200, array('url' => 'finance/cash'));
        }
        return \CommonClass::formatResponse('fail');
    }

    
    public function getCashout()
    {
        $this->theme->setTitle('我要提现');
        $user = Auth::User();
        $userInfo = UserDetailModel::select('balance')->where('uid', $user->id)->first();
        $cashRule = json_decode(ConfigModel::getConfigByAlias('cash')->rule, true);
        
        $alipayAccount = AlipayAuthModel::where('uid', $user->id)->where('status', 2)->orderBy('auth_time', 'desc')->get();
        $bankAccount = BankAuthModel::where('uid', $user->id)->where('status', 2)->orderBy('auth_time', 'desc')->get();
        $data = array(
            'balance' => $userInfo->balance,
            'alipayAccount' => $alipayAccount,
            'bankAccount' => $bankAccount,
            'cashRule' => $cashRule
        );
        return $this->theme->scope('finance.cashout', $data)->render();
    }

    
    public function postCashout(CashoutRequest $request)
    {
        $user = Auth::User();
        $userInfo = UserDetailModel::select('balance')->where('uid', $user->id)->first();
        
        $cashConfig = ConfigModel::getConfigByAlias('cash');
        $cashConfig->rule = json_decode($cashConfig->rule, true);

        $now = strtotime(date('Y-m-d'));
        $start = date('Y-m-d H:i:s', $now);
        $end = date('Y-m-d H:i:s', $now + 24 * 3600);
        
        $cashoutSum = CashoutModel::where('uid', $user->id)->whereBetween('created_at', [$start, $end])->sum('cash');

        $error = array();
        if ($request->get('cash') > $userInfo->balance) {
            $error['cash'] = '提现金额不得大于账户余额';
        }
        if ($cashConfig->rule['withdraw_min'] && $request->get('cash') < $cashConfig->rule['withdraw_min']) {
            $error['cash'] = '单笔提现金额不得小于' . $cashConfig->rule['withdraw_min'] . '元';
        }
        if ($cashConfig->rule['withdraw_max'] && $cashoutSum > $cashConfig->rule['withdraw_max']) {
            $error['cash'] = '提现金额不得大于' . $cashConfig->rule['withdraw_max'] . '元';
        }
        if (!empty($error)) {
            return back()->withErrors($error);
        }
        $account = $request->get('cashout_account');
        $alipayInfo = AlipayAuthModel::where('alipay_account', $account)->where('status', 2)->first();
        $bankInfo = BankAuthModel::where('bank_account', $account)->where('status', 2)->first();

        if (!empty($alipayInfo) || !empty($bankInfo)) {
            if (!empty($alipayInfo)) {
                $cashout_type = 1;
                $account_name = $alipayInfo->alipay_name;
            } elseif (!empty($bankInfo)) {
                $cashout_type = 2;
                $account_name = $bankInfo->realname;
            }
            $data = array(
                'cashout_type' => $cashout_type,
                'cashout_account' => $account,
                'cash' => $request->get('cash'),
                'account_name' => $account_name
            );
            return redirect('finance/cashoutInfo/' . Crypt::encrypt($data));
        }

    }


    
    public function getCashoutInfo($cashoutInfo)
    {
        $cashoutInfo = Crypt::decrypt($cashoutInfo);
        $user = Auth::User();
        $userInfo = UserDetailModel::select('balance')->where('uid', $user->id)->first();
        $data = array(
            'balance' => $userInfo->balance,
            'cashout_type' => $cashoutInfo['cashout_type'],
            'cashout_account' => $cashoutInfo['cashout_account'],
            'cash' => $cashoutInfo['cash'],
            'account_name' => $cashoutInfo['account_name'],
            'fees' => FinancialModel::getFees($cashoutInfo['cash']),
            'cashoutInfo' => Crypt::encrypt($cashoutInfo)
        );
        return $this->theme->scope('finance.cashoutinfo', $data)->render();
    }

    
    public function postCashoutInfo(CashoutInfoRequest $request)
    {
        $alternate_password = $request->get('alternate_password');
        $cashoutInfo = Crypt::decrypt($request->get('cashInfo'));
        $user = Auth::User();
        if (UserModel::encryptPassword($alternate_password, $user->salt) === $user->alternate_password) {
            $data = array(
                'uid' => $user->id,
                'cash' => $cashoutInfo['cash'],
                'fees' => FinancialModel::getFees($cashoutInfo['cash']),
                'real_cash' => $cashoutInfo['cash'] - FinancialModel::getFees($cashoutInfo['cash']),
                'cashout_type' => $cashoutInfo['cashout_type'],
                'cashout_account' => $cashoutInfo['cashout_account'],
            );
            $status = CashoutModel::addCashout($data);
            if ($status)
                return redirect('finance/waitcashout');
        }
        return back()->withErrors(array('alternate_password' => '提现密码错误'));
    }

    
    public function waitCashout()
    {
        return $this->theme->scope('finance.waitcashout')->render();
    }

    
    public function getFinanceList(Request $request)
    {
        $user = Auth::User();

        if ($request->get('type')){
            switch ($request->get('type')){
                case 'cash':
                    $list = FinancialModel::where('uid', $user->id)->where('action', 3)->orderBy('created_at', 'desc')->paginate(10);
                    break;
                case 'cashout':
                    $list = CashoutModel::where('uid', $user->id)->orderBy('created_at', 'desc')->paginate(10);
                    break;
            }
        } else {
            $list = FinancialModel::where('uid', $user->id)->orderBy('created_at', 'desc')->paginate(10);
        }

        $userDetail = UserDetailModel::select('balance')->where('uid', $user->id)->first();
        $data = [
            'balance' => $userDetail->balance,
            'list' => $list,
            'type' => $request->get('type') ? $request->get('type') : ''
        ];

        $this->initTheme('usercenterfinance');
        $this->theme->setTitle('收支明细');
        return $this->theme->scope('finance.financelist', $data)->render();
    }


    
    public function assetdetail(Request $request)
    {

        $user = Auth::User();
        $balance = UserDetailModel::where('uid', $user->id)->first()->balance;
        $list = FinancialModel::where('uid', $user->id);

        $cashIn = FinancialModel::where('uid', $user->id)->whereIn('action', [2, 3, 7])->sum('cash');
        $cashOut = FinancialModel::where('uid', $user->id)->whereIn('action', [1, 4, 5, 6])->sum('cash');

        if ($request->get('start')) {
            $start = date('Y-m-d H:i:s', strtotime($request->get('start')));
            $list = $list->where('created_at', '>', $start);
        }
        if ($request->get('end')) {
            $end = date('Y-m-d H:i:s', strtotime($request->get('end')));
            $list = $list->where('created_at', '<', $end);
        }
        if ($request->get('type')) {
            $list = $list->where('action', $request->get('type'));
        }
        $list = $list->orderBy('created_at', 'desc')->paginate(10);

        $data = [
            'balance' => $balance,
            'list' => $list,
            'cashIn' => $cashIn,
            'cashOut' => $cashOut,
            'start' => $request->get('start'),
            'end' => $request->get('end'),
            'type' => $request->get('type')
        ];
        $this->initTheme('userfinance');
        $this->theme->setTitle('资产明细');
        return $this->theme->scope('finance.assetdetail', $data)->render();
    }

    
    public function assetDetailminute($id)
    {

        $user = Auth::User();
        $avatar = UserDetailModel::where('uid', $user->id)->first()->avatar;
        $info = FinancialModel::where('uid', $user->id)->where('id', $id)->first();
        if (!empty($info)) {

            $data = [
                'info' => $info,
                'avatar' => $avatar
            ];

            $this->initTheme('userfinance');
            $this->theme->setTitle('收支详情');
            return $this->theme->scope('finance.assetDetailminute', $data)->render();
        }

    }
}
