<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateServiceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('service', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title')->comment('增值服务标题');
            $table->string('description')->comment('增值服务描述');
            $table->decimal('price',10,0)->comment('增值服务价格');
            $table->tinyInteger('status', false)->default(1)->comment('状态 1=>启用 2->禁用');
            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('service');
    }
}
