<?php

use Illuminate\Database\Seeder;

class ConfigTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('config')->delete();
        
        \DB::table('config')->insert(array (
            0 => 
            array (
                'id' => 1,
                'alias' => 'site_name',
                'rule' => '客客众包威客开源系统',
                'type' => 'site',
                'title' => '网站名称',
                'desc' => '网站名称',
            ),
            1 => 
            array (
                'id' => 2,
                'alias' => 'site_url',
                'rule' => 'http://demo.kppw.cn',
                'type' => 'site',
                'title' => '网站地址',
                'desc' => '网站地址',
            ),
            2 => 
            array (
                'id' => 3,
                'alias' => 'theme',
                'rule' => 'default',
                'type' => 'basic',
                'title' => '主题',
                'desc' => '主题',
            ),
            3 => 
            array (
                'id' => 5,
                'alias' => 'image_path',
                'rule' => 'http://www.kppw.cn/image/',
                'type' => 'basic',
                'title' => 'Image路径',
                'desc' => 'Image路径',
            ),
            4 => 
            array (
                'id' => 7,
                'alias' => 'record_number',
                'rule' => '鄂ICP备16004849号-1',
                'type' => 'site',
                'title' => '备案信息',
                'desc' => '备案信息',
            ),
            5 => 
            array (
                'id' => 8,
                'alias' => 'copyright',
                'rule' => 'copyright 2015-2025 kppw.cn 版权所有',
                'type' => 'site',
                'title' => '版权信息',
                'desc' => '版权信息',
            ),
            6 => 
            array (
                'id' => 9,
                'alias' => 'contact_email',
                'rule' => '商务合作：hi@kppw.cn',
                'type' => 'site',
                'title' => '联系方式',
                'desc' => '联系方式',
            ),
            7 => 
            array (
                'id' => 10,
                'alias' => 'statistic_code',
            'rule' => '<script>document.write(1);</script>',
                'type' => 'site',
                'title' => '统计代码',
                'desc' => '统计代码',
            ),
            8 => 
            array (
                'id' => 11,
                'alias' => 'site_close',
                'rule' => '1',
                'type' => 'site',
                'title' => '网站关闭',
                'desc' => '网站关闭',
            ),
            9 => 
            array (
                'id' => 12,
                'alias' => 'close_reason',
                'rule' => '网站维护中...',
                'type' => 'basic',
                'title' => '关闭原因',
                'desc' => '关闭原因',
            ),
            10 => 
            array (
                'id' => 13,
                'alias' => 'seo_index',
                'rule' => '{"title":"\\u4f17\\u5305|\\u5a01\\u5ba2\\u5efa\\u7ad9-\\u5728\\u7ebf\\u4ea4\\u6613\\u670d\\u52a1\\u5e73\\u53f0_KPPW\\u6f14\\u793a","keywords":"\\u5a01\\u5ba2,\\u4f17\\u5305,\\u4f17\\u5305\\u5efa\\u7ad9,\\u5a01\\u5ba2\\u5efa\\u7ad9,\\u5efa\\u7ad9\\u7cfb\\u7edf,\\u5728\\u7ebf\\u4ea4\\u6613\\u5e73\\u53f0","description":"\\u5ba2\\u5ba2\\u4e13\\u4e1a\\u5f00\\u6e90\\u5efa\\u7ad9\\u7cfb\\u7edf\\uff0c\\u56fd\\u5185\\u5916\\u77e5\\u540d\\u7ad9\\u957f\\u4f7f\\u7528\\u6700\\u591a\\u7684\\u4f17\\u5305\\u5a01\\u5ba2\\u7cfb\\u7edf\\uff0c\\u5efa\\u5728\\u7ebf\\u4ea4\\u6613\\u5e73\\u53f0\\uff0c\\u9996\\u9009KPPW\\u4f17\\u5305\\u5a01\\u5ba2\\u5f00\\u6e90\\u5efa\\u7ad9\\u7cfb\\u7edf\\u3002"}',
                'type' => 'seo',
                'title' => '首页SEO',
                'desc' => '首页SEO',
            ),
            11 => 
            array (
                'id' => 14,
                'alias' => 'seo_article_list',
                'rule' => '{"title":"\\u6587\\u7ae0\\u5217\\u88681","keywords":"\\u6587\\u7ae0\\u5217\\u88682","description":"\\u6587\\u7ae0\\u5217\\u88683"}',
                'type' => 'seo',
                'title' => '文章列表SEO',
                'desc' => '文章列表SEO',
            ),
            12 => 
            array (
                'id' => 15,
                'alias' => 'seo_article_detail',
                'rule' => '{"title":"\\u6587\\u7ae0\\u8be6\\u7ec61","keywords":"\\u6587\\u7ae0\\u8be6\\u7ec62","description":"\\u6587\\u7ae0\\u8be6\\u7ec63"}',
                'type' => 'seo',
                'title' => '文章详细SEO',
                'desc' => '文章详细SEO',
            ),
            13 => 
            array (
                'id' => 16,
                'alias' => 'seo_case_list',
                'rule' => '{"title":"\\u6848\\u4f8b\\u5217\\u88681","keywords":"\\u6848\\u4f8b\\u5217\\u88682","description":"\\u6848\\u4f8b\\u5217\\u88683"}',
                'type' => 'seo',
                'title' => '案例列表SEO',
                'desc' => '案例列表SEO',
            ),
            14 => 
            array (
                'id' => 17,
                'alias' => 'seo_case_detail',
                'rule' => '{"title":"\\u6848\\u4f8b\\u8be6\\u7ec61","keywords":"\\u6848\\u4f8b\\u8be6\\u7ec62","description":"\\u6848\\u4f8b\\u8be6\\u7ec63"}',
                'type' => 'seo',
                'title' => '案例详细SEO',
                'desc' => '案例详细SEO',
            ),
            15 => 
            array (
                'id' => 18,
                'alias' => 'seo_login',
                'rule' => '{"title":"\\u767b\\u5f551","keywords":"\\u767b\\u5f552","description":" \\u767b\\u5f553 "}',
                'type' => 'seo',
                'title' => '登录SEO',
                'desc' => '登录SEO',
            ),
            16 => 
            array (
                'id' => 19,
                'alias' => 'seo_register',
                'rule' => '{"title":"\\u6ce8\\u518c1","keywords":"\\u6ce8\\u518c2","description":"\\u6ce8\\u518c3"}',
                'type' => 'seo',
                'title' => '注册SEO',
                'desc' => '注册SEO',
            ),
            17 => 
            array (
                'id' => 20,
                'alias' => 'seo_about',
                'rule' => '{"title":"\\u5173\\u4e8e\\u6211\\u4eec1","keywords":"\\u5173\\u4e8e\\u6211\\u4eec2","description":"\\u5173\\u4e8e\\u6211\\u4eec3"}',
                'type' => 'seo',
                'title' => '关于我们SEO',
                'desc' => '关于我们SEO',
            ),
            18 => 
            array (
                'id' => 21,
                'alias' => 'seo_copyright',
                'rule' => '{"title":" \\u7248\\u6743\\u58f0\\u660e1","keywords":" \\u7248\\u6743\\u58f0\\u660e2","description":" \\u7248\\u6743\\u58f0\\u660e3"}',
                'type' => 'seo',
                'title' => '版权声明SEO',
                'desc' => '版权声明SEO',
            ),
            19 => 
            array (
                'id' => 22,
                'alias' => 'seo_disclaimer',
                'rule' => '{"title":"\\u514d\\u8d23\\u58f0\\u660e1","keywords":"\\u514d\\u8d23\\u58f0\\u660e2","description":"\\u514d\\u8d23\\u58f0\\u660e3"}',
                'type' => 'seo',
                'title' => '免责声明SEO',
                'desc' => '免责声明SEO',
            ),
            20 => 
            array (
                'id' => 23,
                'alias' => 'seo_rule',
                'rule' => '{"title":"\\u670d\\u52a1\\u89c4\\u52191","keywords":"\\u670d\\u52a1\\u89c4\\u52192","description":"\\u670d\\u52a1\\u89c4\\u52193"}',
                'type' => 'seo',
                'title' => '服务规则SEO',
                'desc' => '服务规则SEO',
            ),
            21 => 
            array (
                'id' => 24,
                'alias' => 'seo_agreement',
                'rule' => '{"title":"\\u670d\\u52a1\\u534f\\u8bae1","keywords":"\\u670d\\u52a1\\u534f\\u8bae2","description":"\\u670d\\u52a1\\u534f\\u8bae3"}',
                'type' => 'seo',
                'title' => '服务协议SEO',
                'desc' => '服务协议SEO',
            ),
            22 => 
            array (
                'id' => 25,
                'alias' => 'seo_help',
                'rule' => '{"title":"\\u5e38\\u89c1\\u95ee\\u98981","keywords":"\\u5e38\\u89c1\\u95ee\\u98982","description":"\\u5e38\\u89c1\\u95ee\\u98983"}',
                'type' => 'seo',
                'title' => '常见问题SEO',
                'desc' => '常见问题SEO',
            ),
            23 => 
            array (
                'id' => 26,
                'alias' => 'seo_contact',
                'rule' => '{"title":"\\u8054\\u7cfb\\u6211\\u4eec1","keywords":"\\u8054\\u7cfb\\u6211\\u4eec2","description":"\\u8054\\u7cfb\\u6211\\u4eec3"}',
                'type' => 'seo',
                'title' => '联系我们SEO',
                'desc' => '联系我们SEO',
            ),
            24 => 
            array (
                'id' => 27,
                'alias' => 'cash',
                'rule' => '{"recharge_min":"10","withdraw_min":"10","withdraw_max":"10000","per_charge":"2","per_low":"1","per_high":"50"}',
                'type' => 'pay',
                'title' => '支付配置',
                'desc' => '支付配置',
            ),
            25 => 
            array (
                'id' => 28,
                'alias' => 'alipay',
                'rule' => '{"status":1,"sellerEmail":"","partner":"","key":""}',
                'type' => 'thirdpay',
                'title' => '支付宝',
                'desc' => '支付宝快捷支付',
            ),
            26 => 
            array (
                'id' => 29,
                'alias' => 'wechatpay',
                'rule' => '{"status":"1","appId":"","appKey":"","mchId":""}',
                'type' => 'thirdpay',
                'title' => '微信支付',
                'desc' => '微信扫码支付',
            ),
            27 => 
            array (
                'id' => 30,
                'alias' => 'unionpay',
                'rule' => '{"status":1}',
                'type' => 'thirdpay',
                'title' => '银联支付',
                'desc' => '银联快捷支付',
            ),
            28 => 
            array (
                'id' => 31,
                'alias' => 'task_bounty_limit',
                'rule' => '0',
                'type' => 'task',
                'title' => '任务审核金额',
                'desc' => '发布赏金低于该设定金额的任务需要审核，设为0即无限制',
            ),
            29 => 
            array (
                'id' => 32,
                'alias' => 'task_bounty_max_limit',
                'rule' => '100000',
                'type' => 'task',
                'title' => '任务最大金额',
                'desc' => '设置任务最大金额，为0时不生效',
            ),
            30 => 
            array (
                'id' => 33,
                'alias' => 'task_bounty_min_limit',
                'rule' => '100',
                'type' => 'task',
                'title' => '任务最小金额',
                'desc' => '设置任务最小金额',
            ),
            31 => 
            array (
                'id' => 34,
                'alias' => 'task_percentage',
                'rule' => '0',
                'type' => 'task',
                'title' => '任务提成比率',
                'desc' => '站长提取任务佣金的百分比，设置0即无抽佣',
            ),
            32 => 
            array (
                'id' => 35,
                'alias' => 'task_sys_help_switch',
                'rule' => '1',
                'type' => 'task',
                'title' => '系统辅助功能是否开启',
                'desc' => '0表示关闭 1表示开启',
            ),
            33 => 
            array (
                'id' => 36,
                'alias' => 'task_check_time_limit',
                'rule' => '10',
                'type' => 'task',
                'title' => '验收期最大时间限制',
                'desc' => '该功能适用于选稿期结束后有投稿雇主未选稿的时候',
            ),
            34 => 
            array (
                'id' => 37,
                'alias' => 'task_sys_help_rule',
                'rule' => '3',
                'type' => 'task',
                'title' => '系统辅助功能规则',
                'desc' => '1代表最先交稿，2威客好评率，3参与任务数',
            ),
            35 => 
            array (
                'id' => 38,
                'alias' => 'task_delivery_limit_time',
                'rule' => '{"1200":"12","1300":"13","80000":"20","100000":"30"}',
                'type' => 'task',
                'title' => '任务交稿截止时间最大规则',
                'desc' => 'json键值代表钱数，值代表天数',
            ),
            36 => 
            array (
                'id' => 39,
                'alias' => 'task_publicity_day',
                'rule' => '0',
                'type' => 'task',
                'title' => '任务公示天数',
                'desc' => '任务公示天数',
            ),
            37 => 
            array (
                'id' => 40,
                'alias' => 'task_delivery_min',
                'rule' => '8',
                'type' => 'task',
                'title' => '任务交稿截止最小天数',
                'desc' => '任务交稿截止最小天数',
            ),
            38 => 
            array (
                'id' => 41,
                'alias' => 'task_vote_time',
                'rule' => '3',
                'type' => 'task',
                'title' => '任务投票时间限制（小时）',
                'desc' => '大于等于0的整数小时，设置为0即无注册时间限制',
            ),
            39 => 
            array (
                'id' => 42,
                'alias' => 'task_select_work',
                'rule' => '3',
                'type' => 'task',
                'title' => '选稿时间限制',
                'desc' => '大于等于1的整数天',
            ),
            40 => 
            array (
                'id' => 43,
                'alias' => 'task_delivery_max_time',
                'rule' => '3',
                'type' => 'task',
                'title' => '交付期最大时间限制',
                'desc' => '逾期未完成交付，任务直接冻结交由管理员处理',
            ),
            41 => 
            array (
                'id' => 44,
                'alias' => 'qq_api',
                'rule' => '{"status":"1","appId":"","appSecret":""}',
                'type' => 'oauth',
                'title' => 'QQ授权登录',
                'desc' => 'QQ授权登录',
            ),
            42 => 
            array (
                'id' => 45,
                'alias' => 'wechat_api',
                'rule' => '{"status":"1","appId":"","appSecret":""}',
                'type' => 'oauth',
                'title' => '微信授权登录',
                'desc' => '微信授权登录',
            ),
            43 => 
            array (
                'id' => 46,
                'alias' => 'sina_api',
                'rule' => '{"status":"1","appId":"","appSecret":""}',
                'type' => 'oauth',
                'title' => '新浪授权登录',
                'desc' => '新浪授权登录',
            ),
            44 => 
            array (
                'id' => 47,
                'alias' => 'task_fail_percentage',
                'rule' => '0',
                'type' => 'task',
                'title' => '任务失败返金抽成比例',
                'desc' => '发布赏金低于该设定金额的任务需要审核，设为0即无限制',
            ),
            45 => 
            array (
                'id' => 48,
                'alias' => 'attachment',
                'rule' => '{"size":"2","extension":"pdf|jpg|jpeg|png|bmp|gif|zar|txt"}',
                'type' => 'attachment',
                'title' => '附件配置',
                'desc' => '附件配置',
            ),
            46 => 
            array (
                'id' => 49,
                'alias' => 'task_comment_time_limit',
                'rule' => '12',
                'type' => 'task',
                'title' => '任务评价最长时间限制',
                'desc' => '如果超过这个时间没有评价，系统将会默认为好评',
            ),
            47 => 
            array (
                'id' => 51,
                'alias' => 'email',
                'rule' => '{"email_service":"1","enable_encrypted_connection":"2","send_mail_server":"gfdg3333","server_port":"25","email_account":"fdhfdh","account_password":"hfdfh","reply_email_address":"dhfd","mail_code":"1","email_address":"fhdfh"}',
                'type' => 'email',
                'title' => '邮箱配置',
                'desc' => '邮箱配置',
            ),
            48 => 
            array (
                'id' => 53,
                'alias' => 'seo_task',
                'rule' => '{"title":"\\u4efb\\u52a1\\u5927\\u5385|\\u4f17\\u5305\\u5a01\\u5ba2\\u60ac\\u8d4f\\u4efb\\u52a1\\u5c55\\u793a_KPPW\\u6f14\\u793a","keywords":"\\u5a01\\u5ba2\\u4efb\\u52a1,\\u4f17\\u5305\\u4efb\\u52a1,\\u60ac\\u8d4f\\u4efb\\u52a1,\\u4efb\\u52a1\\u5c55\\u793a,KPPW\\u6f14\\u793a","description":"\\u5ba2\\u5ba2\\u4e13\\u4e1a\\u5f00\\u6e90\\u5efa\\u7ad9\\u7cfb\\u7edf\\uff0c\\u4efb\\u52a1\\u5927\\u5385\\uff0c\\u4f17\\u5305\\u5a01\\u5ba2\\u60ac\\u8d4f\\u4efb\\u52a1\\u5c55\\u793a\\u3002 "}',
                'type' => 'seo',
                'title' => '任务大厅seo',
                'desc' => '任务大厅seo',
            ),
            49 => 
            array (
                'id' => 54,
                'alias' => 'seo_service',
                'rule' => '{"title":"\\u670d\\u52a1\\u5546|\\u4f17\\u5305\\u5a01\\u5ba2\\u670d\\u52a1\\u5546\\u5c55\\u793a_KPPW\\u6f14\\u793a","keywords":"\\u670d\\u52a1\\u5546,\\u5a01\\u5ba2\\u670d\\u52a1\\u5546,\\u4f17\\u5305\\u670d\\u52a1\\u5546,\\u670d\\u52a1\\u5546\\u5c55\\u793a,KPPW\\u6f14\\u793a","description":"\\u5ba2\\u5ba2\\u4e13\\u4e1a\\u5f00\\u6e90\\u5efa\\u7ad9\\u7cfb\\u7edf\\uff0c\\u670d\\u52a1\\u5546\\uff0c\\u4f17\\u5305\\u5a01\\u5ba2\\u670d\\u52a1\\u5546\\u5c55\\u793a\\u3002 "}',
                'type' => 'seo',
                'title' => '服务商seo',
                'desc' => '服务商seo',
            ),
            50 => 
            array (
                'id' => 55,
                'alias' => 'seo_article',
                'rule' => '{"title":"\\u8d44\\u8baf\\u4e2d\\u5fc3|\\u4f17\\u5305\\u5a01\\u5ba2\\u8d44\\u8baf\\u4fe1\\u606f\\u4e2d\\u5fc3_KPPW\\u6f14\\u793a","keywords":"\\u8d44\\u8baf\\u4e2d\\u5fc3,\\u5a01\\u5ba2\\u8d44\\u8baf,\\u4f17\\u5305\\u8d44\\u8baf,\\u4fe1\\u606f\\u4e2d\\u5fc3,KPPW\\u6f14\\u793a","description":"\\u5ba2\\u5ba2\\u4e13\\u4e1a\\u5f00\\u6e90\\u5efa\\u7ad9\\u7cfb\\u7edf\\uff0c\\u8d44\\u8baf\\u4e2d\\u5fc3\\uff0c\\u4f17\\u5305\\u5a01\\u5ba2\\u8d44\\u8baf\\u4fe1\\u606f\\u4e2d\\u5fc3\\u3002 "}',
                'type' => 'seo',
                'title' => '咨询中心seo',
                'desc' => '咨询中心seo',
            ),
            51 => 
            array (
                'id' => 59,
                'alias' => 'seo_secondary_domain',
                'rule' => '1',
                'type' => 'seo',
                'title' => '是否开启二级域名',
                'desc' => '是否开启二级域名，1是 ，2否',
            ),
            52 => 
            array (
                'id' => 60,
                'alias' => 'seo_pseudo_static',
                'rule' => '2',
                'type' => 'seo',
                'title' => '是否开启伪静态',
                'desc' => '是否开启伪静态 1是 2否',
            ),
            53 => 
            array (
                'id' => 61,
                'alias' => 'site_logo_1',
                'rule' => 'attachment/sys/0b31865f4e5abf8a8ac9dc69bc312116.png',
                'type' => 'site',
                'title' => '首页logo',
                'desc' => NULL,
            ),
            54 => 
            array (
                'id' => 62,
                'alias' => 'site_logo_2',
                'rule' => 'attachment/sys/a8486b5132d81c7f245bc1ae4a145358.png',
                'type' => 'site',
                'title' => '其他logo',
                'desc' => NULL,
            ),
            55 => 
            array (
                'id' => 63,
                'alias' => 'phone',
                'rule' => '027-87733922',
                'type' => 'site',
                'title' => '联系电话',
                'desc' => NULL,
            ),
            56 => 
            array (
                'id' => 64,
                'alias' => 'company_name',
                'rule' => '武汉客客信息技术有限公司',
                'type' => 'site',
                'title' => '公司名称',
                'desc' => NULL,
            ),
            57 => 
            array (
                'id' => 65,
                'alias' => 'company_address',
                'rule' => '武汉市洪山区珞瑜路786号9层',
                'type' => 'site',
                'title' => '公司地址',
                'desc' => NULL,
            ),
            58 => 
            array (
                'id' => 66,
                'alias' => 'user_forbid_keywords',
                'rule' => '但是感觉都会感觉大幅度',
                'type' => 'basis ',
                'title' => '用户禁止关键字',
                'desc' => NULL,
            ),
            59 => 
            array (
                'id' => 67,
                'alias' => 'content_forbid_keywords',
                'rule' => '三个等级考试机构',
                'type' => 'basis ',
                'title' => '内容禁止关键字',
                'desc' => NULL,
            ),
            60 => 
            array (
                'id' => 68,
                'alias' => 'css_adaptive',
                'rule' => '1',
                'type' => 'basis ',
                'title' => 'css自适应',
                'desc' => 'css自适应 1是 2否',
            ),
            61 => 
            array (
                'id' => 69,
                'alias' => 'open_IM',
                'rule' => '1',
                'type' => 'basis ',
                'title' => '开启IM',
                'desc' => '开启IM 1是 2否',
            ),
            62 => 
            array (
                'id' => 70,
                'alias' => 'new_user_registration_time_limit',
                'rule' => '个的时间赶快死',
                'type' => 'basis ',
                'title' => '新用户注册时间限制',
                'desc' => NULL,
            ),
            63 => 
            array (
                'id' => 71,
                'alias' => 'user_registration_email_activation',
                'rule' => '1',
                'type' => 'basis ',
                'title' => '用户注册邮件激活',
                'desc' => '用户注册邮件激活 1是 2否',
            ),
            64 => 
            array (
                'id' => 81,
                'alias' => 'sina',
                'rule' => '{"sina_url":"www.sina.com","sina_switch":"2"}',
                'type' => 'site',
                'title' => '关注链接 新浪微博',
                'desc' => NULL,
            ),
            65 => 
            array (
                'id' => 82,
                'alias' => 'tencent',
                'rule' => '{"tencent_url":"www.Tencent.com","tencent_switch":"2"}',
                'type' => 'site',
                'title' => '关注链接  腾讯微博',
                'desc' => NULL,
            ),
            66 => 
            array (
                'id' => 83,
                'alias' => 'wechat',
                'rule' => '{"wechat_pic":"attachment\\/sys\\/9d964f8f9e9cec692e02e9d532ed2068.png","wechat_switch":"1"}',
                'type' => 'site',
                'title' => '关注链接 微信',
                'desc' => NULL,
            ),
            67 => 
            array (
                'id' => 84,
                'alias' => 'skin_color_config',
                'rule' => 'blue',
                'type' => 'site',
                'title' => '多彩换肤',
                'desc' => '代表颜色值',
            ),
            68 => 
            array (
                'id' => 85,
                'alias' => 'qq',
                'rule' => '1668966921',
                'type' => 'basis',
                'title' => '企业QQ',
                'desc' => '企业QQ',
            ),
        ));
        
        
    }
}
