<!-- /section:basics/navbar.layout -->
<div class="main-container" id="main-container">

        <div class="page-content-area">
            <div class="">
                <div class="col-xs-12 widget-container-col ui-sortable">
                    <div class="widget-box transparent ui-sortable-handle">
                        <div class="widget-header">
                            <div class="widget-toolbar no-border">
                                <ul class="nav nav-tabs" id="myTab2">
                                    <li class="active">
                                        <a  @if($upID == 1) href="/manage/article/{!! $upID !!}" @elseif($upID == 3) href="/manage/articleFooter/{!! $upID !!}" @endif>文章管理</a>
                                    </li>

                                    <li class="">
                                        <a  @if($upID == 1) href="/manage/addArticle/{!! $upID !!}" @elseif($upID == 3) href="/manage/addArticleFooter/{!! $upID !!}" @endif>文章新建</a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="widget-body">
                            <div class="widget-main padding-12 no-padding-left no-padding-right">
                                <div class="tab-content padding-4">
                                    <div id="basic" class="tab-pane active">
                                        <form @if($upID == 1) action="/manage/article/{{$upID}}" @elseif($upID == 3) action="/manage/articleFooter/{{$upID}}" @endif method="get">
                                            <div class="widget-box">
                                                <div class="widget-header widget-header-flat">
                                                    <h5 class="widget-title">搜索</h5>
                                                </div>
                                                <div class="widget-body">
                                                    <div class="widget-main row">
                                                        <div class="table-responsive">
                                                            <table class="table table-hover text-left">
                                                                <tbody>
                                                                <tr>
                                                                    <td class="text-left">
                                                                        文章标题：<input type="text" name="title" value="@if(isset($title)){!! $title !!}@endif">
                                                                    </td>
                                                                    <td class="text-left">
                                                                        文章编号：<input type="text" name="artID" value="@if(isset( $artID)){!! $artID !!}@endif">
                                                                    </td>
                                                                    <td class="text-left">
                                                                        　　作者：<input type="text"name="author" value="@if(isset( $author)){!! $author !!}@endif">
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="text-left">
                                                                        文章分类：<select name="catID">
                                                                            <option value="{{$upID}}">全部</option>
                                                                            @foreach($category as $items)
                                                                                <option value="{{ $items['id'] }}" @if((isset($catID) && $catID == $items['id']) || ($items['id'] == $upID) && empty($catID))selected="selected"@endif>{{ str_repeat("&nbsp;&nbsp;", $items['level']).str_repeat('--', $items['level']).$items['cate_name'] }}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td class="text-left">
                                                                        显示条数：<select name="paginate">
                                                                            <option value="10" @if(isset($paginate) && $paginate == 10) selected="selected" @endif>10条</option>
                                                                            <option value="20" @if(isset($paginate) && $paginate == 20) selected="selected" @endif>20条</option>
                                                                            <option value="30" @if(isset($paginate) && $paginate == 30) selected="selected" @endif>30条</option>
                                                                        </select>
                                                                    </td>
                                                                    <td class="text-left">
                                                                        结果排序：<select  name="by">
                                                                            <option value="article.created_at" @if($by == 'article.created_at')selected="selected"@endif>发布时间</option>
                                                                            <option value="article.view_times"  @if($by == 'article.view_times')selected="selected"@endif>访问量</option>
                                                                        </select>
                                                                        <select name="order">
                                                                            <option value="ASC" @if($order == 'ASC')selected="selected"@endif>递增</option>
                                                                            <option value="DESC" @if($order == 'DESC')selected="selected"@endif>递减</option>
                                                                        </select>
                                                                        <button type="submit" class="btn btn-primary btn-sm">搜索</button>
                                                                    </td>
                                                                </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                        <div class="space-6"></div>
                                        <div class="well h4 blue">文章列表</div>
                                        <form action="/manage/allDelete" method="post">
                                            {{csrf_field()}}
                                            <div>
                                                <table id="sample-table-1" class="table table-striped table-bordered table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="center">
                                                            <label>
                                                                <input type="checkbox" class="ace" />
                                                                <span class="lbl"></span>
                                                                UID
                                                            </label>
                                                        </th>
                                                        <th>文章分类</th>
                                                        <th>文章标题</th>
                                                        <th>发布时间</th>
                                                        <th>访问量</th>
                                                        <th>作者</th>
                                                        <th>操作</th>
                                                    </tr>
                                                    </thead>

                                                    <tbody>
                                                    @if(!empty($article_data))
                                                    @foreach($article_data['data'] as $item)
                                                    <tr>
                                                        <td class="center">
                                                            <label>
                                                                <input type="checkbox" name="artID_{{$item['id']}}" class="ace" value="{{$item['id']}}"/>
                                                                <span class="lbl"></span>
                                                                {{$item['id']}}
                                                            </label>
                                                        </td>

                                                        <td>
                                                            {{$item['cate_name']}}
                                                        </td>
                                                        <td>
                                                            {{$item['title']}}
                                                        </td>
                                                        <td>
                                                            {{--{{ date('Y-m-d H:i:s',$item['addTime']) }}--}}
                                                            {{$item['created_at']}}
                                                        </td>
                                                        <td>
                                                            {{$item['view_times'] ? $item['view_times'] : "0"}}
                                                        </td>
                                                        <td>
                                                            {{$item['author']}}
                                                        </td>
                                                        <td>
                                                            <div class="hidden-sm hidden-xs btn-group">
                                                                <a title="浏览" class="btn btn-xs btn-success" href="/article/{{$item['id']}}">
                                                                    <i class="ace-icon fa fa-search bigger-120"></i>浏览
                                                                </a>
                                                                <a class="btn btn-xs btn-info"
                                                                   @if($upID == 1)href="/manage/editArticle/{{$item['id']}}/{!! $upID !!}"
                                                                   @elseif($upID == 3) href="/manage/editArticleFooter/{{$item['id']}}/{!! $upID !!}" @endif target="_blank">
                                                                    <i class="fa fa-edit bigger-120"></i>编辑
                                                                </a>
                                                                <a title="删除" class="btn btn-xs btn-danger" href="/manage/articleDelete/{{$item['id']}}/{!! $upID !!}" >
                                                                    <i class="ace-icon fa fa-trash-o bigger-120"></i>删除
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                    @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="dataTables_info" id="sample-table-2_info">
                                                        <label><input type="checkbox" class="ace" id="allcheck"/>
                                                            <span class="lbl"></span>全选
                                                        </label>
                                                        <button id="all_delete" type="submit" class="btn btn-sm btn-primary ">批量删除</button>
                                                    </div>
                                                </div>
                                                <div class="col-sm-6">
                                                    <div class="dataTables_paginate paging_bootstrap text-right">
                                                        <ul class="pagination">
                                                            @if(!empty($article_data['prev_page_url']))
                                                                <li><a href="{!! URL('manage/article').'/'.$upID.'?'.http_build_query(array_merge($merge,['page'=>$article_data['current_page']-1])) !!}">上一页</a></li>
                                                            @endif
                                                            @if($article_data['last_page']>1)
                                                                @for($i=1;$i<=$article_data['last_page'];$i++)
                                                                    <li class="{{ ($i==$article_data['current_page'])?'active disabled':'' }}"><a href="{!! URL('manage/article').'/'.$upID.'?'.http_build_query(array_merge($merge,['page'=>$i])) !!}">{{ $i }}</a></li>
                                                                @endfor
                                                            @endif
                                                            @if(!empty($article_data['next_page_url']))
                                                                <li><a href="{!! URL('manage/article').'/'.$upID.'?'.http_build_query(array_merge($merge,['page'=>$article_data['current_page']+1])) !!}">下一页</a></li>
                                                            @endif
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /.row -->
        </div><!-- /.page-content-area -->
    </div><!-- /.main-content -->

    <a href="#" id="btn-scroll-up" class="btn-scroll-up btn btn-sm btn-inverse">
        <i class="ace-icon fa fa-angle-double-up icon-only bigger-110"></i>
    </a>
</div><!-- /.main-container -->
{!! Theme::asset()->container('custom-css')->usepath()->add('backstage', 'css/backstage/backstage.css') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('datepicker', 'plugins/ace/js/date-time/bootstrap-datepicker.min.js') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('custom', 'plugins/ace/js/jquery-ui.custom.min.js') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('touch-punch', 'plugins/ace/js/jquery.ui.touch-punch.min.js') !!}

{!! Theme::asset()->container('specific-js')->usepath()->add('chosen', 'plugins/ace/js/chosen.jquery.min.js') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('autosize', 'plugins/ace/js/jquery.autosize.min.js') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('inputlimiter', 'plugins/ace/js/jquery.inputlimiter.1.3.1.min.js') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('maskedinput', 'plugins/ace/js/jquery.maskedinput.min.js') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('hotkeys', 'plugins/ace/js/jquery.hotkeys.min.js') !!}
{!! Theme::asset()->container('specific-js')->usepath()->add('wysiwyg', 'plugins/ace/js/bootstrap-wysiwyg.min.js') !!}

{!! Theme::asset()->container('custom-js')->usepath()->add('dataTab', 'plugins/ace/js/dataTab.js') !!}
{!! Theme::asset()->container('custom-js')->usepath()->add('jquery_dataTables', 'plugins/ace/js/jquery.dataTables.bootstrap.js') !!}

{!! Theme::asset()->container('custom-js')->usepath()->add('articlelist', 'js/doc/articlelist.js') !!}


