<div class="page-content-area">
    <div class="row">
        <div class="col-xs-12 widget-container-col ui-sortable">
            <div class="widget-body">
                <div class="widget-main padding-12 no-padding-left no-padding-right">
                    <div class="tab-content padding-4">
                        <div id="basic" class="tab-pane active">
                            <h3 class="header smaller lighter blue">热词搜索管理</h3>
                            <div class="widget-box">
                                <div class="widget-header widget-header-flat">
                                    <h5 class="widget-title">搜索</h5>
                                </div>
                                <div class="widget-body">
                                    <div class="widget-main">
                                        <div class="table-responsive">
                                            <table class="table hotwordsList-table">
                                                <tbody>
                                                <form  role="form" action="/manage/hotwordsList" method="get">
                                                    <tr class="col-xs-12">
                                                        <td class="col-md-4">
                                                            请输入编号 <input type="text" name="id" value="@if(isset($id)){!! $id !!}@endif">
                                                        </td>
                                                        <td class="col-md-4">
                                                            请输入名称 <input type="text" name="words" value="@if(isset($words)){!! $words !!}@endif">
                                                        </td>
                                                        <td class="col-md-4">
                                                            排序 <select name="listorder">
                                                                <option value="1" @if($listorder == '1')selected="selected"@endif>按编号升序</option>
                                                                <option value="2" @if($listorder == '2')selected="selected"@endif>按编号降序</option>
                                                                <option value="3" @if($listorder == '3')selected="selected"@endif>搜索量升序</option>
                                                                <option value="4" @if($listorder == '4')selected="selected"@endif>搜索量降序</option>
                                                            </select>
                                                            <button type="submit" class="btn btn-primary btn-sm">搜索</button>
                                                        </td>
                                                    </tr>
                                                </form>
                                                <form  role="form" action="/manage/hotwordsCreate" method="post">
                                                    {{ csrf_field() }}
                                                    <tr class="col-xs-12">
                                                        <td class="text-left col-md-4">
                                                            　热词名称 <input type="text" name="words">
                                                            <p>　　　　　{!! $errors->first('words') !!}</p>
                                                        </td>
                                                        <td class="text-left col-md-4">
                                                            　　　次数 <input type="text" name="count">
                                                            <p>　　　　　{!! $errors->first('count') !!}</p>
                                                        </td>
                                                        <td class="col-md-4">
                                                           　　　　　　　　　　<button type="submit" class="btn btn-primary btn-sm">添加</button>
                                                            <p></p>
                                                        </td>
                                                    </tr>
                                                </form>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="space-6"></div>
                            <div class="well h4 blue">动态列表</div>
                            <div>
                                <table id="sample-table-1" class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th class="center">
                                            <label>
                                                <input type="checkbox"  name="" class="ace allcheck"/>
                                                <span class="lbl"></span>
                                                编号
                                            </label>
                                        </th>
                                        <th>排序</th>
                                        <th class="hidden-480">词语搜索</th>
                                        <th class="hidden-480">总搜索量</th>
                                        <th>最近搜索时间</th>
                                        <th>操作</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($HotwordsList as $v)
                                        <tr>
                                            <td class="center">
                                                <label>
                                                    <input type="checkbox" class="ace checkbox" name="chk[]" value="{!! $v->id !!}"/>
                                                    <span class="lbl"></span>
                                                    {!! $v->id !!}
                                                </label>
                                            </td>

                                            <td>
                                                <input type="text" name="sort" value="{!! $v->sort !!}" rel="{{ $v->id }}" onblur="changeSort(this)">
                                            </td>
                                            <td class="hidden-480">
                                                {!! $v->words !!}
                                            </td>
                                            <td>
                                                {!! $v->count !!}
                                            </td>
                                            <td>
                                                {!! $v->time !!}
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="/manage/hotwordsDelete/{!! $v->id !!}">
                                                        <button title="删除" class="btn btn-xs btn-danger">
                                                            <i class="ace-icon fa fa-trash-o bigger-120"></i>删除
                                                        </button>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="dataTables_info" id="sample-table-2_info">
                                        <label>
                                            <input type="checkbox" class="ace allcheck"/><span class="lbl"></span>
                                            全选
                                        </label>
                                        <button class="btn btn-primary btn-sm" id="largeDel">批量删除</button>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    @if($HotwordsList->total()){!! $HotwordsList->currentPage() !!}@else 0 @endif / {!! $HotwordsList->lastPage() !!}页
                                </div>
                                <div class="col-sm-6">
                                    <div class="dataTables_paginate paging_bootstrap text-right">
                                        {!! $HotwordsList->render() !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{!! Theme::asset()->container('custom-css')->usepath()->add('backstage', 'css/backstage/backstage.css') !!}
{!! Theme::asset()->container('custom-js')->usePath()->add('listorderedit-js', 'js/doc/listorderedit.js') !!}