<div class="col-xs-12 widget-container-col ui-sortable">
    <div class="widget-box transparent ui-sortable-handle">
        <div class="widget-header">
            <div class="widget-toolbar no-border">
                <ul class="nav nav-tabs" id="myTab2">
                    <li class="">
                        <a href="/advertisement/adTarget">推荐位管理</a>
                    </li>
                    <li class="active">
                        <a href="/advertisement/serverList">推荐位列表</a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="widget-body">
            <div class="widget-main padding-12 no-padding-left no-padding-right">
                <div class="tab-content padding-4">
                    <div id="flow" class="tab-pane row active">
                        <div class="widget-box">
                            <div class="widget-header widget-header-flat">
                                <h5 class="widget-title">推荐位列表</h5>
                            </div>
                            <div class="widget-body">
                                <form  role="form" action="/advertisement/serverList" method="get">
                                    <div class="widget-main row">
                                        <div class="table-responsive">
                                            <table class="table table-hover text-left">
                                                <tbody>
                                                <tr>
                                                    <td class="text-left">
                                                        名称：<input type="text" id="recommend_name" name="recommend_name" value="@if(isset($recommend_name)){!! $recommend_name !!}@endif">
                                                    </td>
                                                    <td class="text-left">
                                                        位置：<select name="position_id">
                                                            <option value="0">全部</option>
                                                            @foreach($positionInfo as $positionInfoV)
                                                                <option value="{!! $positionInfoV->id !!}" @if($positionInfoV->id == $position_id)selected="selected"@endif>{!! $positionInfoV->name !!}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="text-left">
                                                        　　
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="text-left">
                                                        类型：<select name="is_open">
                                                            <option value="0">全部</option>
                                                            <option value="1">开启</option>
                                                            <option value="2">关闭</option>
                                                        </select>
                                                    </td>
                                                    <td class="text-left">
                                                        结果排序：<select name="by">
                                                            <option value="sort" @if(isset($by) && $by == 'sort')selected="selected"@endif>默认排序</option>
                                                        </select>
                                                        <select name="order">
                                                            <option value="asc" @if(isset($order) && $order == 'asc')selected="selected"@endif>递增</option>
                                                            <option value="desc" @if(isset($order) && $order == 'desc')selected="selected"@endif>递减</option>
                                                        </select>


                                                    </td>
                                                    <td class="text-left">
                                                        显示条数：<select name="paginate">
                                                            <option value="10" @if(isset($paginate) && $paginate == 10)selected="selected"@endif>10条</option>
                                                            <option value="20" @if(isset($paginate) && $paginate == 20)selected="selected"@endif>20条</option>
                                                            <option value="30" @if(isset($paginate) && $paginate == 30)selected="selected"@endif>30条</option>
                                                        </select>
                                                        <button type="submit" class="btn btn-primary btn-sm">搜索</button>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="space-6"></div>
                        <div class="well h4 blue">推荐位列表</div>
                        <div>
                            <table id="sample-table-1" class="table table-striped table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th class="center">
                                        推荐名称
                                    </th>
                                    <th>位置</th>
                                    <th>排序</th>
                                    <th>起始时间</th>
                                    <th>截止时间</th>
                                    <th>编辑时间</th>
                                    <th>是否可用</th>
                                    <th>操作</th>
                                </tr>
                                </thead>

                                <tbody>
                                @foreach($serviceList as $serviceListV )
                                    <tr>
                                        <td class="center">
                                            {!! $serviceListV->recommend_name !!}
                                        </td>

                                        <td>
                                            {!! $serviceListV->name !!}
                                        </td>
                                        <td>
                                            {!! $serviceListV->sort !!}
                                        </td>
                                        <td class="hidden-480">
                                            @if($serviceListV->start_time != '0000-00-00 00:00:00')
                                                {!! $serviceListV->start_time !!}
                                            @else
                                                永久有效
                                            @endif
                                        </td>
                                        <td>
                                            @if($serviceListV->end_time == '0000-00-00 00:00:00')
                                                永久有效
                                            @elseif(strtotime($serviceListV->end_time) <= time())
                                                {!! $serviceListV->end_time !!}(<span style="color:red">已过期</span>)
                                            @else
                                                {!! $serviceListV->end_time !!}
                                            @endif
                                        </td>
                                        <td>
                                            {!! $serviceListV->created_at !!}
                                        </td>
                                        <td>
                                            @if($serviceListV->is_open == '1')
                                                开启
                                            @elseif($serviceListV->is_open == '2')
                                                关闭
                                            @endif
                                        </td>
                                        <td>
                                            <div class="hidden-sm hidden-xs btn-group">
                                                <a class="btn btn-xs btn-info" href="/advertisement/updateRecommend/{!! $serviceListV->id !!}">
                                                    <i class="fa fa-edit bigger-120"></i>编辑
                                                </a>
                                                <a title="删除" class="btn btn-xs btn-danger" href="/advertisement/deleteReInfo/{!! $serviceListV->id !!}">
                                                    <i class="ace-icon fa fa-trash-o bigger-120"></i>删除
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="dataTables_info" id="sample-table-2_info">
                                    <a href="/advertisement/insertRecommend"><button class="btn btn-sm btn-primary">添加推荐</button></a>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="dataTables_paginate paging_bootstrap">
                                    {!! $serviceList->appends($search)->render() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
