<?php

class stripComment {

    function run($path){

        if (is_dir($path)) {
            $files = $this->getfiles($path);
            foreach ($files as $file) {
                if (file_exists($file)) {
                    $content = file_get_contents($file);
                    $content = $this->stripWhitespace($content);
                    file_put_contents($file, $content);
                    echo "Strip file:[".$file."] comment success!\r\n";
                } else {
                    echo "File:[".$file."] is not exists!\r\n";
                }
            }
        } else {
            echo "Dir:[".$path."] is not exists!\r\n";
        }

    }

    /**
     * 去除代码中的空白和注释
     * @param string $content 代码内容
     * @return string
     */
    function stripWhitespace($content) {
        $stripStr   = '';
        //分析php源码
        $tokens     = token_get_all($content);
        $last_space = false;
        for ($i = 0, $j = count($tokens); $i < $j; $i++) {
            if (is_string($tokens[$i])) {
                $last_space = false;
                $stripStr  .= $tokens[$i];
            } else {
                switch ($tokens[$i][0]) {
                    //过滤各种PHP注释
                    case T_COMMENT:
                        $stripStr .= "\r\n";
                        break;
                    case T_DOC_COMMENT:
                        break;
                    /*//过滤空格
                    case T_WHITESPACE:
                        if (!$last_space) {
                            $stripStr  .= ' ';
                            $last_space = true;
                        }
                        break;*/
                    case T_START_HEREDOC:
                        $stripStr .= "<<<THINK\n";
                        break;
                    case T_END_HEREDOC:
                        $stripStr .= "THINK;\n";
                        for($k = $i+1; $k < $j; $k++) {
                            if(is_string($tokens[$k]) && $tokens[$k] == ';') {
                                $i = $k;
                                break;
                            } else if($tokens[$k][0] == T_CLOSE_TAG) {
                                break;
                            }
                        }
                        break;
                    default:
                        $last_space = false;
                        $stripStr  .= $tokens[$i][1];
                }
            }
        }
        return $stripStr;
    }

    /**
     * 遍历获取目录下的指定类型的文件
     * @param $path
     * @param array $files
     * @return array
     */
    function getfiles( $path , &$files = array() )
    {
        if ( !is_dir( $path ) ) return null;
        $handle = opendir( $path );
        while ( false !== ( $file = readdir( $handle ) ) ) {
            if ( $file != '.' && $file != '..' ) {
                $path2 = $path . '/' . $file;
                if ( is_dir( $path2 ) ) {
                    $this->getfiles( $path2 , $files );
                } else {
                    if ( preg_match( "/\.(php)$/i" , $file ) ) {
                        $files[] = $path2;
                    }
                }
            }
        }
        return $files;
    }

}


$stripComment = new stripComment();
//$stripComment->run(dirname(__FILE__).'/envCheck1.php');
//
//$files = $stripComment->getfiles(dirname(__FILE__).'/Task');
//var_dump($files);
$stripComment->run(dirname(__FILE__).'/app/Modules');
$stripComment->run(dirname(__FILE__).'/app/Http');