﻿
function getObj(a)
{return(typeof(a)=="object")?a:document.getElementById(a)}

function getValue(a)
{return getObj(a).value}

function getRV(b){var d="";var a=document.getElementsByName(b);for(var c=0;c<a.length;c++){if(a[c].checked){d=a[c].value}}return d}

function setValue(b,a)
{getObj(b).value=a}

function replaceSpace(str){   //删除字符串中所有空格  
	return str.replace(/\s/g,"");   
}
function Trim(str){  //删除左右两端的空格 
	return str.replace(/(^\s*)|(\s*$)/g, ""); 
} 
function Ltrim(str){  //删除左边的空格 
	return str.replace(/(^\s*)/g,""); 
} 
function Rtrim(str){  //删除右边的空格 
	return str.replace(/(\s*$)/g,""); 
} 


//****************************************************************
//* 名　　称：DataLength
//* 功    能：计算数据的长度
//* 入口参数：fData：需要计算的数据
//* 出口参数：返回fData的长度(Unicode长度为2，非Unicode长度为1)
//*****************************************************************
function DataLength(fData)
{
    var intLength=0
    for (var i=0;i<fData.length;i++)
    {
        if ((fData.charCodeAt(i) < 0) || (fData.charCodeAt(i) > 255))
            intLength=intLength+2
        else
            intLength=intLength+1   
    }
    return intLength
}


//****************************************************************
//* 名　　称：IsEmpty
//* 功    能：判断是否为空
//* 入口参数：fData：要检查的数据
//* 出口参数：True：空                             
//*           False：非空
//*****************************************************************
function IsEmpty(fData)
{
    return ((fData==null) || (fData.length==0) )
}


//****************************************************************
//* 名　　称：IsDigit
//* 功    能：判断是否为数字
//* 入口参数：fData：要检查的数据
//* 出口参数：True：是0到9的数字                             
//*           False：不是0到9的数字
//*****************************************************************
function IsDigit(fData)
{
    return ((fData>="0") && (fData<="9"))
}


//****************************************************************
//* 名　　称：IsInteger
//* 功    能：判断是否为正整数
//* 入口参数：fData：要检查的数据
//* 出口参数：True：是整数，或者数据是空的                           
//*           False：不是整数
//*****************************************************************
function IsInteger(fData)
{
    //如果为空，返回true
    if (IsEmpty(fData))
        return true
    if ((isNaN(fData)) || (fData.indexOf(".")!=-1) || (fData.indexOf("-")!=-1))
        return false   
   
    return true   
}

//****************************************************************
//* 名　　称：IsEmail
//* 功    能：判断是否为正确的Email地址
//* 入口参数：fData：要检查的数据
//* 出口参数：True：正确的Email地址，或者空                             
//*           False：错误的Email地址
//*****************************************************************
function IsEmail(fData)
{
    if (IsEmpty(fData))
        return true
    if (fData.indexOf("@")==-1)
        return false
    var NameList=fData.split("@");
    if (NameList.length!=2)
        return false
    if (NameList[0].length<1 )
        return false  
    if (NameList[1].indexOf(".")<=0)
        return false
    if (fData.indexOf("@")>fData.indexOf("."))
return false
    if (fData.indexOf(".")==fData.length-1)
return false
   
    return true   
}

//****************************************************************
//* 名　　称：IsPhone
//* 功    能：判断是否为正确的电话号码（可以含"()"、"（）"、"+"、"-"和空格）
//* 入口参数：fData：要检查的数据
//* 出口参数：True：正确的电话号码，或者空                             
//*           False：错误的电话号码
//* 错误信息：
//*****************************************************************
function IsPhone(fData)
{
    var str;
    var fDatastr="";
    if (IsEmpty(fData))
        return true
    for (var i=0;i<fData.length;i++)
    {
        str=fData.substring(i,i+1);
        if (str!="(" && str!=")" && str!="（" && str!="）" && str!="+" && str!="-" && str!=" ")
           fDatastr=fDatastr+str;
    }
    //alert(fDatastr);
    if (isNaN(fDatastr))
        return false
    return true   
}

//****************************************************************
//* 名　　称：IsPlusNumeric
//* 功    能：判断是否为正确的正数（可以含小数部分）
//* 入口参数：fData：要检查的数据
//* 出口参数：True：正确的正数，或者空                             
//*           False：错误的正数
//* 错误信息：
//*****************************************************************
function IsPlusNumeric(fData)
{
    if (IsEmpty(fData))
        return true
    if ((isNaN(fData)) || (fData.indexOf("-")!=-1))
        return false
    return true   
}

//****************************************************************
//* 名　　称：IsNumeric
//* 功    能：判断是否为正确的数字（可以为负数，小数）
//* 入口参数：fData：要检查的数据
//* 出口参数：True：正确的数字，或者空                             
//*           False：错误的数字
//* 错误信息：
//*****************************************************************
function IsNumeric(fData)
{
    if (IsEmpty(fData))
        return true
    if (isNaN(fData))
        return false
       
    return true   
}


//****************************************************************
//* 名　　称：IsIntegerInRange
//* 功    能：判断一个数字是否在指定的范围内
//* 入口参数：fInput：要检查的数据
//*           fLower：检查的范围下限，如果没有下限，请用null
//*           fHigh：检查的上限，如果没有上限，请用null
//* 出口参数：True：在指定的范围内                             
//*           False：超出指定范围
//*****************************************************************
function IsIntegerInRange(fInput,fLower,fHigh)
{
    if (fLower==null)
        return (fInput<=fHigh)
    else if (fHigh==null)
        return (fInput>=fLower)
    else        
        return ((fInput>=fLower) && (fInput<=fHigh))
}


//复制内容进剪贴板
function copyToClipboard(txt,msg) {

      if(window.clipboardData) {

              window.clipboardData.clearData();

              window.clipboardData.setData("Text", txt);

      } else if(navigator.userAgent.indexOf("Opera") != -1) {

           window.location = txt;

      } else if (window.netscape) {

           try {

                netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");

           } catch (e) {

                alert("被浏览器拒绝！\n请在浏览器地址栏输入'about:config'并回车\n然后将 'signed.applets.codebase_principal_support'设置为'true'");

           }

           var clip = Components.classes['@mozilla.org/widget/clipboard;1'].createInstance(Components.interfaces.nsIClipboard);

           if (!clip)

                return;

           var trans = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);

           if (!trans)

                return;

           trans.addDataFlavor('text/unicode');

           var str = new Object();

           var len = new Object();

           var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);

           var copytext = txt;

           str.data = copytext;

           trans.setTransferData("text/unicode",str,copytext.length*2);

           var clipid = Components.interfaces.nsIClipboard;

           if (!clip)

                return false;

           clip.setData(trans,null,clipid.kGlobalClipboard);

      }

	  msg = (typeof(msg)=="undefined")?'复制成功':msg;

      alert(msg+'!');

 }

 

//跟随鼠标移动的帮助提示框
function wsug(e, str) {

    var oThis = arguments.callee;
    if (!str) {
        oThis.sug.style.visibility = 'hidden';
        document.onmousemove = null;
        return;
    }
    if (!oThis.sug) {
        var div = document.createElement('div'), css = 'top:0; left:0; position:absolute; z-index:100; visibility:hidden';
        div.style.cssText = css;
        div.setAttribute('style', css);
        var sug = document.createElement('div'), css = 'font:normal 12px/16px "宋体"; white-space:nowrap; color:#666; padding:7px 9px; position:absolute; left:0; top:0; z-index:10; background:#FFF8E1; border:1px solid #FFDC62';
        sug.style.cssText = css;
        sug.setAttribute('style', css);
        var dr = document.createElement('div'), css = 'position:absolute; top:3px; left:3px; background:#333; filter:alpha(opacity=50); opacity:0.5; z-index:9';
        dr.style.cssText = css;
        dr.setAttribute('style', css);
        var ifr = document.createElement('iframe'), css = 'position:absolute; left:0; top:0; z-index:8; filter:alpha(opacity=0); opacity:0';
        ifr.style.cssText = css;
        ifr.setAttribute('style', css);
        div.appendChild(ifr);
        div.appendChild(dr);
        div.appendChild(sug);
        div.sug = sug;
        document.body.appendChild(div);
        oThis.sug = div;
        oThis.dr = dr;
        oThis.ifr = ifr;
        div = dr = ifr = sug = null;
    }
    var e = e || window.event, obj = oThis.sug, dr = oThis.dr, ifr = oThis.ifr;
    obj.sug.innerHTML = str;

    var w = obj.sug.offsetWidth, h = obj.sug.offsetHeight, dw = document.documentElement.clientWidth || document.body.clientWidth; dh = document.documentElement.clientHeight || document.body.clientHeight;
    var st = document.documentElement.scrollTop || document.body.scrollTop, sl = document.documentElement.scrollLeft || document.body.scrollLeft;
    var left = e.clientX + sl + 17 + w < dw + sl && e.clientX + sl + 15 || e.clientX + sl - 8 - w, top = e.clientY + st + 17;
    obj.style.left = left + 10 + 'px';
    obj.style.top = top + 10 + 'px';
    dr.style.width = w + 'px';
    dr.style.height = h + 'px';
    ifr.style.width = w + 3 + 'px';
    ifr.style.height = h + 3 + 'px';
    obj.style.visibility = 'visible';
    document.onmousemove = function(e) {
        var e = e || window.event, st = document.documentElement.scrollTop || document.body.scrollTop, sl = document.documentElement.scrollLeft || document.body.scrollLeft;
        var left = e.clientX + sl + 17 + w < dw + sl && e.clientX + sl + 15 || e.clientX + sl - 8 - w, top = e.clientY + st + 17 + h < dh + st && e.clientY + st + 17 || e.clientY + st - 5 - h;
        obj.style.left = left + 'px';
        obj.style.top = top + 'px';
    }
}


