/**
 * @classDescription &#15164;rquee&#15167;&#599;&#428;ǿ&#55532;&#892;&#428;&#150;&#48842; * @author Aken Li(www.kxbd.com)
 * @date 2009-07-27
 * @dependence jQuery 1.3.2
 * @DOM
 *  	<div id="marquee">
 *  		<ul>
 *   			<li></li>
 *   			<li></li>
 *  		</ul>
 *  	</div>
 * @CSS
 *  	#marquee {width:200px;height:50px;overflow:hidden;}
 * @Usage
 *  	$('#marquee').kxbdSuperMarquee(options);
 * @options
 *		distance:200,//&#1211;&#17337;ă+
 *		duration:20,//&#48822;&#62503;e&#52581;&#17298;&#438;&#62129;&#51491;&#50493;B&#57324;&#15118;&#44042;&#5022;&#48822;&#62503;X *		time:5,//&#867;y&#7972;&#15157;ȥ&#938;e
 *		direction: 'left',//S&#65021;&#1010;&#15143;left','right','up','down'
 *		scrollAmount:1,//&#12147;&#17056;*		scrollDelay:20//&#689;&#14627;&#52581;&#938;&#41027;&#45728;*		isEqual:true,//&#761;&#1232;S&#64836;&#1322;&#728;&#14655;&#53895;K&#3400;,true,false
 *		loop: 0,//&#1133;&#48633;&#17290;&#55532;0&#689;&#990;
 *		btnGo:{left:'#goL',right:'#goR'},//&#62998;&#439;&#54258;&#16741;ID&#15123;&#1035;&#312;wleft,right,up,down&#3476;&#1254;&#708;ڐ&#54258;
 *		eventGo:'click',//&#691;&#6794;&#188;*		controlBtn:{left:'#goL',right:'#goR'},//&#62998;&#444;&#1227;&#1657;ă&#16741;ID&#15123;&#1035;&#312;wleft,right,up,down&#3476;&#1254;&#708;ڐ&#54258;
 *		newAmount:4,//&#50379;&#1657;Ĵ&#56548;
 *		eventA:'mouseenter',//&#691;&#6794;&#188;&#59628;&#50379;&#1610; *		eventB:'mouseleave',//&#691;&#6794;&#188;&#59628;&#1325;B
 *		navId:'#marqueeNav', //ǿ&#53789;&#439;ID&#15157;&#52925;DOM:<ul><li>1</li><li>2</li><ul>,ǿ&#53459;S:.navOn
 *		eventNav:'click' //ǿ&#53890;&#53130; */
(function($){

	$.fn.kxbdSuperMarquee = function(options){
		var opts = $.extend({},$.fn.kxbdSuperMarquee.defaults, options);
		
		return this.each(function(){
			var $marquee = $(this);//S&#62762;&#728;&#541;&#439;
			var _scrollObj = $marquee.get(0);//S&#62762;&#728;&#541;&#439;DOM
			var scrollW = $marquee.width();//S&#62762;&#728;&#541;&#439;&#56712;
			var scrollH = $marquee.height();//S&#62762;&#728;&#541;&#439;&#2038;&#522;			var $element = $marquee.children(); //S&#62762;&#728;
			var $kids = $element.children();//S&#62931;&#1322;&#728;
			var scrollSize=0;//S&#62762;&#728;&#14324;		var _type = (opts.direction == 'left' || opts.direction == 'right') ? 1:0;//S&#61472;&#1037;&#15153;&#1523;&#1234;&#15152;&#591;&#962;
			var scrollId, rollId, isMove, marqueeId;
			var t,b,c,d,e; //S&#64943;&#47989;&#306;&#906;&#56116;:&#689;&#51491;&#51386;&#64138;&#52548;&#1411;&#15139;:&#19780;&#1411;&#15140;:&#13712;&#689;&#51491;&#51578;&#55370;ʦ&#1411;
			var _size, _len; //&#1491;&#1322;&#728;&#2036;Խ&#53897;		var $nav,$navBtns;
			var arrPos = []; 
			var numView = 0; //&#761;&#64791;&#1236;&#41688;
			var numRoll=0; //&#150;&#48885;&#308;&#906;&#53897;		var numMoved = 0;//&#1169;&#60242;&#438;&#64836;&#45706;			//m&#1236;&#41688;&#4665;&#1322;&#728;&#64374;&#12021;&#53941;&#49849;&#1491;&#1322;&#728;&#64374;&#522;			$element.css(_type?'width':'height',10000);
			//&#48200;&#7798;&#41688;&#2036;		var navHtml = '<ul>';
			if (opts.isEqual) {
				_size = $kids[_type?'outerWidth':'outerHeight']();
				_len = $kids.length;
				scrollSize = _size * _len;
				for(var i=0;i<_len;i++){
					arrPos.push(i*_size);
					navHtml += '<li>'+ (i+1) +'</li>';
				}
			}else{
				$kids.each(function(i){
					arrPos.push(scrollSize);
					scrollSize += $(this)[_type?'outerWidth':'outerHeight']();
					navHtml += '<li>'+ (i+1) +'</li>';
				});
			}
			navHtml += '</ul>';
			
			//S&#62762;&#728;&#1500;&#14324;`&#1242;&#541;&#439;&#14324;&#12025;
			if (scrollSize<(_type?scrollW:scrollH)) return; 
			//&#62146;&#7798;&#1236;&#41688;&#56006;&#19621;&#555;&#1322;&#728;&#44259;&#52386;&#616;&#1322;&#728;&#64374;&#522;			$element.append($kids.clone()).css(_type?'width':'height',scrollSize*2);
			
			//&#150;&#48885;&#52925;
			if (opts.navId) {
				$nav = $(opts.navId).append(navHtml).hover( stop, start );
				$navBtns = $('li', $nav);
				$navBtns.each(function(i){
					$(this).bind(opts.eventNav,function(){
						if(isMove) return;
						if(numView==i) return;
						rollFunc(arrPos[i]);
						$navBtns.eq(numView).removeClass('navOn');
						numView = i;
						$(this).addClass('navOn');
					});
				});
				$navBtns.eq(numView).addClass('navOn');
			}
			
			//&#616;߄¦&#1411;
			if (opts.direction == 'right' || opts.direction == 'down') {
				_scrollObj[_type?'scrollLeft':'scrollTop'] = scrollSize;
			}else{
				_scrollObj[_type?'scrollLeft':'scrollTop'] = 0;
			}
			
			if(opts.isMarquee){
				//S&#65514;&#700;
				//marqueeId = setInterval(scrollFunc, opts.scrollDelay);
				marqueeId = setTimeout(scrollFunc, opts.scrollDelay);
				//&#691;&#6843;&#61053;&#867;&#1465;S&#62089;			$marquee.hover(
					function(){
						clearInterval(marqueeId);
					},
					function(){
						//marqueeId = setInterval(scrollFunc, opts.scrollDelay);
						clearInterval(marqueeId);
						marqueeId = setTimeout(scrollFunc, opts.scrollDelay);
					}
				);
				
				//&#62998;&#444;&#1227;&#1620;&#758;&#62089;			if(opts.controlBtn){
					$.each(opts.controlBtn, function(i,val){
						$(val).bind(opts.eventA,function(){
							opts.direction = i;
							opts.oldAmount = opts.scrollAmount;
							opts.scrollAmount = opts.newAmount;
						}).bind(opts.eventB,function(){
							opts.scrollAmount = opts.oldAmount;
						});
					});
				}
			}else{
				if(opts.isAuto){
					//&#150;&#48895;&#41660;
					start();
					
					//&#691;&#6843;&#61053;&#867;&#1465;&#150;&#48842;					$marquee.hover( stop, start );
				}
			
				//&#62998;&#391;&#3763;&#1503;
				if(opts.btnGo){
					$.each(opts.btnGo, function(i,val){
						$(val).bind(opts.eventGo,function(){
							if(isMove == true) return;
							opts.direction = i;
							rollFunc();
							if (opts.isAuto) {
								stop();
								start();
							}
						});
					});
				}
			}
			
			function scrollFunc(){
				var _dir = (opts.direction == 'left' || opts.direction == 'right') ? 'scrollLeft':'scrollTop';
				
				if(opts.isMarquee){
					if (opts.loop > 0) {
						numMoved+=opts.scrollAmount;
						if(numMoved>scrollSize*opts.loop){
							_scrollObj[_dir] = 0;
							return clearInterval(marqueeId);
						} 
					}
					var newPos = _scrollObj[_dir]+(opts.direction == 'left' || opts.direction == 'up'?1:-1)*opts.scrollAmount;
				}else{
					if(opts.duration){
						if(t++<d){
							isMove = true;
							var newPos = Math.ceil(easeOutQuad(t,b,c,d));		//ƽ맨&#1037;: linear, easeOutQuad, easeOutQuint
							if(t==d){
								newPos = e;
							}
						}else{
							newPos = e;
							clearInterval(scrollId);
							isMove = false;
							return;
						}
					}else{
						var newPos = e;
						clearInterval(scrollId);
					}
				}
				
				if(opts.direction == 'left' || opts.direction == 'up'){
					if(newPos>=scrollSize){
						newPos-=scrollSize;
					}
				}else{
					if(newPos<=0){
						newPos+=scrollSize;
					}
				}
				_scrollObj[_dir] = newPos;
				
				if(opts.isMarquee){
					marqueeId = setTimeout(scrollFunc, opts.scrollDelay);
				}else if(t<d){
					if(scrollId) clearTimeout(scrollId);
					scrollId = setTimeout(scrollFunc, opts.scrollDelay);
				}else{
					isMove = false;
				}
				
			};
			
			function rollFunc(pPos){
				isMove = true;
				var _dir = (opts.direction == 'left' || opts.direction == 'right') ? 'scrollLeft':'scrollTop';
				var _neg = opts.direction == 'left' || opts.direction == 'up'?1:-1;

				numRoll = numRoll +_neg;
				//&#56689;&#496;&#761;&#64788;&#41688;&#41330;&#11780;&#6453;&#52925;CSS
				if(pPos == undefined&&opts.navId){
					$navBtns.eq(numView).removeClass('navOn');
					numView +=_neg;
					if(numView>=_len){
						numView = 0;
					}else if(numView<0){
						numView = _len-1;
					}
					$navBtns.eq(numView).addClass('navOn');
					numRoll = numView;
				}

				var _temp = numRoll<0?scrollSize:0;
				t=0;
				b=_scrollObj[_dir];
				//c=(pPos != undefined)?pPos:_neg*opts.distance;
				e=(pPos != undefined)?pPos:_temp+(opts.distance*numRoll)%scrollSize;
				if(_neg==1){
					if(e>b){
						c = e-b;
					}else{
						c = e+scrollSize -b;
					}
				}else{
					if(e>b){
						c =e-scrollSize-b;
					}else{
						c = e-b;
					}
				}
				d=opts.duration;
				
				//scrollId = setInterval(scrollFunc, opts.scrollDelay);
				if(scrollId) clearTimeout(scrollId);
				scrollId = setTimeout(scrollFunc, opts.scrollDelay);
			}
			
			function start(){
				rollId = setInterval(function(){
					rollFunc();
				}, opts.time*1000);
			}
			function stop(){
				clearInterval(rollId);
			}
			
			function linear (t, b, c, d) {
				return c*t/d + b;
			};
			
			function easeOutQuad(t,b,c,d){
				return -c *(t/=d)*(t-2) + b;
			}
			
			function easeOutQuint(t,b,c,d){
				return c*((t=t/d-1)*t*t*t*t + 1) + b;
			}
			

		});
	};
	$.fn.kxbdSuperMarquee.defaults = {
		isMarquee:false,//&#647;J&#41825;rquee
		isEqual:true,//&#761;&#1232;S&#64836;&#1322;&#728;&#14655;&#53895;K&#3400;,true,false
		loop: 0,//&#1133;&#48633;&#17290;&#55532;0&#689;&#990;
		newAmount:3,//&#50379;&#1657;Ĵ&#56548;
		eventA:'mousedown',//&#691;&#6794;&#188;&#59628;&#50379;&#1610;		eventB:'mouseup',//&#691;&#6794;&#188;&#59628;&#1325;B
		isAuto:true,//&#647;S&#1334;&#61590;&#48842;		time:5,//&#867;y&#7972;&#15157;ȥ&#938;e
		duration:50,//&#48822;&#62503;e&#52581;&#17298;&#438;&#62129;&#51491;&#50493;B&#57324;&#15118;&#44042;&#5022;&#48822;&#62503;X		eventGo:'click', //&#691;&#6794;&#188;&#59628;&#1010;&#496;&#1010;&#44247;&#1994;		direction: 'left',//S&#65021;&#1010;&#15143;left','right','up','down'
		scrollAmount:1,//&#12147;&#17033;	scrollDelay:10,//&#689;&#14602;		eventNav:'click'//ǿ&#53890;&#53130;	};
	
	$.fn.kxbdSuperMarquee.setDefaults = function(settings) {
		$.extend( $.fn.kxbdSuperMarquee.defaults, settings );
	};
	
})(jQuery);















