﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="list.aspx.cs" Inherits="wjdhcms_SAAS.module.content.list" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="Expires" content="0">
<title>信息管理</title>

    <!-- start: CSS file-->
    <!-- Vendor CSS-->
    <link href="../static/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
    <link href="../static/vendor/skycons/css/skycons.css" rel="stylesheet" />
    <link href="../static/vendor/font-awesome/css/font-awesome.min.css" rel="stylesheet" />

    <!-- Plugins CSS-->
    <link href="../static/plugins/bootkit/css/bootkit.css" rel="stylesheet" />     
    
    
    <!-- Page CSS -->   
    <link href="../static/css/style.css" rel="stylesheet" />
    <link href="../static/css/add-ons.min.css" rel="stylesheet" />
    <!-- end: CSS file--> 
      
    
    <!-- Head Libs -->
    <script src="../static/plugins/modernizr/js/modernizr.js"></script>
    
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="../static/js/html5shiv.min.js"></script>
      <script src="../static/js/respond.min.js"></script>
    <![endif]-->    
    

</head>

<body class="mainbody">
  <div class="container-fluid">
    <div class="row"> 
            <div class="col-lg-12">
              <div class="panel">
                <div class="panel-heading bk-bg-primary">
                  <div class="list-articles">
		    <a href="javascript:history.back()"class="btn btn-default " style="float:right"><i class="fa  fa-chevron-left"></i>返回</a>
                    <a href="edit.aspx?action=add&catid=<%=catid %>" class="release btn btn-default"><i class="fa fa-pencil-square-o"></i>发布内容</a>
                    <button type="button" class="btn btn-default" id="selectAll"><i class="fa  fa-check-square-o"></i>全选</button>
                    <button type="button" class="btn btn-default" id="selectback"><i class="fa   fa-check-square"></i>反选</button>
                    <button type="button" class="bk-margin-right-15 btn btn-default" onclick="batchDelete('../../api/content.ashx?action=del&id=')"><i class="fa fa-trash-o"></i>删除</button>
                    <div class="btn-group">
                    <button type="button" class="bk-margin-right-15 btn btn-default dropdown-toggle" data-toggle="dropdown">批量移动 <span class="caret"></span></button>
                      <ul class="dropdown-menu" role="menu" id="menulist">
                      </ul>
                    </div>
                  </div>
                </div>
                <div class="panel-body">
                  <div class="table-responsive">
                    <table class="table table-bordered table-striped table-condensed table-hover article-list">
                      <thead>
                        <tr>
                          <th width="4%" align="center" class="text-center">选择</th>
                          <th width="4%">排序</th> 
                          <th width="4%" align="center" class="text-center">ID</th>
                          <th>标题</th>
                          <th width="10%">属性</th> 
                          <th width="10%">发布时间</th> 
                          <th width="10%">操作</th>                                          
                        </tr>
                      </thead>   
                      <tbody>
                                                                   
                      </tbody>
                    </table>
                  </div>
                  <div class="pages text-right">
                    <ul class="pagination">
                      <li id="pageprev"><span>&laquo;</span></li>
                      <ul class="pagination" id="page-list"></ul>
                      <li id="pagenext"><span>&raquo;</span></li>
                    </ul>
                    <ul class="pagination">
                      <li id="pageall"><span></span></li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>  
  </div>

    <!-- start: JavaScript-->
    
    <!-- Vendor JS-->       
    <script src="../static/vendor/js/jquery-2.1.1.min.js"></script>
    <script src="../static/vendor/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="../static/vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="../static/vendor/skycons/js/skycons.js"></script>    
    


    <!-- Pages JS -->

    <script src="../static/js/ajax.js"></script>
    
    <!-- end: JavaScript-->

   


    <script>
        $(function () {
            addlist(1);

            //点击翻页
            $('#page-list').on('click', 'li', function () {
                var that = $(this);
                var index = that.find('span').text();
                if (!that.hasClass('disabled')) {
                    addlist(index);
                }
            });
            //上一页
            $('#pageprev').on("click", function () {
                if (!$(this).hasClass('disabled')) {
                    var page = $('#page-list li[class*="active"').index();
                    addlist(page);
                    console.log(page)
                }
            })
            //下一页
            $('#pagenext').on("click", function () {
                if (!$(this).hasClass('disabled')) {
                    var page = $('#page-list li[class*="active"').index();
                    addlist(page + 2);
                    console.log(page + 2)
                }
            })
            //更改排序
            $('.table').on('input propertychange', '.listorder', function () {
                var that = $(this);
                var id = that.parents('tr').attr('id').replace('l', '');
                var val = that.val();
                val = val.replace(/[^0-9-]+/, '');
                that.val(val);
                if (val != '') {
                    $.post('../../api/content.ashx?action=listorder&id=' + id + '&value=' + val, function (data, textStatus, xhr) {
                        console.log(val)
                    }).error(function () {
                        console.log('cauowu')
                    });
                }
            });
            //设置推荐置顶热门
            $('.article-list').on('click', 'tbody span', function () {
                var that = $(this);
                var id = that.parents('tr').attr('id').replace('l', '');
                var index = that.index();
                if (index == 0) {
                    var attribute = 'tuijian';
                    if (that.attr("class") == 'active') {
                        var value = '0';
                    } else {
                        var value = '1';
                    }
                } else if (index == 1) {
                    var attribute = 'hot';
                    if (that.attr("class") == 'active') {
                        var value = '0';
                    } else {
                        var value = '1';
                    }
                } else if (index == 2) {
                    var attribute = 'top';
                    if (that.attr("class") == 'active') {
                        var value = '0';
                    } else {
                        var value = '1';
                    }
                }
                get_json('../../api/content.ashx?action=shuxing&id=' + id + '&' + attribute + '=' + value, function (data, textStatus, xhr) {
                    console.log(data.data);
                    if (data.data == 1) {
                        that.addClass('active')
                    } else {
                        that.removeClass('active')
                    }
                });


            });
        });

        get_json('../../api/category.ashx?action=getmove&catid=<%=catid%>', function (data) {
            var parentlist = data.data.parentlist;
            var curpage = $('#page-list li[class*="active"').index() + 2;
            var list = '';
            for (var i = 0; i < parentlist.length; i++) {
                if (parentlist[i].list != 0) {
                    list += '<li><a href="#" class="disabled">├' + parentlist[i].catname + '</a></li>';
                    for (var k = 0; k < parentlist[i].list.length; k++) {
                        if (parentlist[i].list[k].list != 0) {
                            list += '<li><a href="#" class="disabled">│├' + parentlist[i].list[k].catname + '</a></li>';
                            for (var j = 0; j < parentlist[i].list[k].list.length; j++) {
                                list += '<li><a href="#" onclick="moveMenu(' + parentlist[i].list[k].list[j].id + ',' + curpage + ')">││├' + parentlist[i].list[k].list[j].catname + '</a></li>';
                            }
                        } else {
                            list += '<li><a href="#" onclick="moveMenu(' + parentlist[i].list[k].id + ',' + curpage + ')">│├' + parentlist[i].list[k].catname + '</a></li>';
                        }

                    }
                } else {
                    list += '<li><a href="#" onclick="moveMenu(' + parentlist[i].id + ',' + curpage + ')">├' + parentlist[i].catname + '</a></li>';
                }
            }
            $('#menulist').append(list);
        }, '栏目加载失败！');


        function addlist(page) {
            get_json("/api/content.ashx?action=list&catid=<%=catid%>&page=" + page, function (data) {
                pages(data);
                getlist(data);
                $("[data-toggle='tooltip']").tooltip();
            })
        };

        function getlist(data) {
            var list = '';
            for (var i = 0; i < data.data.list.length; i++) {
                var id = data.data.list[i].id;
                var title = data.data.list[i].title;
                var page = data.data.page;
                var catid = data.data.list[i].catid;
                var catname = data.data.list[i].catname;
                var tuijian = data.data.list[i].tuijian;
                var hot = data.data.list[i].hot;
                var top = data.data.list[i].top;
                var sort = data.data.list[i].listorder;
                var add_time = data.data.list[i].add_time;
                add_time = formatTime(add_time, "yyyy-MM-dd hh:mm:ss");
                var active1 = '<span>推荐</span>';
                var active2 = '<span>热门</span>';
                var active3 = '<span>置顶</span>';
                if (tuijian == 1) {
                    active1 = '<span class="active">推荐</span>';
                }
                if (hot == 1) {
                    active2 = '<span class="active">热门</span>';
                }
                if (top == 1) {
                    active3 = '<span class="active">置顶</span>';
                }
                list += '<tr id="l' + id + '">'
                        + '<td class="text-center">'
                          + '<div class="checkbox-custom checkbox-inline">'
                            + '<input type="checkbox" id="inline-checkbox' + id + '" value="' + id + '">'
                            + '<label for="inline-checkbox' + id + '"></label>'
                          + '</div>'
                        + '</td>'
                        + '<td>'
                          + '<input type="text" name="text-input" class="form-control listorder" value="' + sort + '">'
                        + '</td>'
                        + '<td class="text-center">' + id + '</td>'
                        + '<td>' + title + '</td>'
                        + '<td>'
                          + active1 + active2 + active3
                        + '</td>'
                        + '<td>' + add_time + '</td>'
                        + '<td>'
                          + '<a class="btn btn-success" href="edit.aspx?action=edit&id=' + id + '&catid=' + catid + '&page=' + page + '" data-toggle="tooltip" title="编辑">'
                            + '<i class="fa fa-edit"></i>'
                          + '</a>'
                          + '<button class="btn btn-info delete" onClick="Delete(\'../../api/content.ashx?action=del&id=' + id + '\')" data-toggle="tooltip" title="删除">'
                            + '<i class="fa fa-trash-o"></i>'
                          + '</button>'
                        + '</td>'
                      + '</tr>'
            }
            $('.table tbody').html(list);
        }

    </script>
    
</body>

</html>
