﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="list.aspx.cs" Inherits="wjdhcms_SAAS.module.link.list" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>广告管理</title>

    <!-- start: CSS file-->
    <!-- Vendor CSS-->
    <link href="../static/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
    <link href="../static/vendor/skycons/css/skycons.css" rel="stylesheet" />
    <link href="../static/vendor/font-awesome/css/font-awesome.min.css" rel="stylesheet" />

    <!-- Plugins CSS-->
    <link href="../static/plugins/bootkit/css/bootkit.css" rel="stylesheet" />    
    
    
    <!-- Page CSS -->   
    <link href="../static/css/style.css" rel="stylesheet" />
    <link href="../static/css/add-ons.min.css" rel="stylesheet" />
    <!-- end: CSS file--> 
      
    
    <!-- Head Libs -->
    <script src="../static/plugins/modernizr/js/modernizr.js"></script>
    
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="../static/js/html5shiv.min.js"></script>
      <script src="../static/js/respond.min.js"></script>
    <![endif]-->    
    

</head>

<body class="mainbody">
  <div class="container-fluid">
    <div class="row"> 
            <div class="col-lg-12">
              <div class="panel">
                <div class="panel-heading bk-bg-primary">
                  <div class="list-articles">
                    <a href="edit.aspx?action=add&pid=0" class="release btn btn-default"><i class="fa fa-pencil-square-o"></i>新增</a>
                    <a href="editclass.aspx?action=add" class="release btn btn-default"><i class="fa fa-pencil-square-o"></i>新增分类</a>
                    <a href="listclass.aspx" class="btn btn-default"><i class="fa fa-columns"></i>分类管理</a>
                  </div>
                </div>
                <div class="panel-body">
                  <div class="table-responsive">
                    <table class="table table-bordered table-striped table-condensed table-hover article-list">
                      <thead>
                        <tr>
                          <th width="4%">排序</th>
                          <th width="4%" align="center" class="text-center">ID</th>
                          <th>名称</th>
                          <th width="20%">分类</th>
                          <th width="20%">时间</th> 
                          <th width="10%">操作</th>                                          
                        </tr>
                      </thead>   
                      <tbody>

                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>  
  </div>

    <!-- start: JavaScript-->
    
    <!-- Vendor JS-->       
    <script src="../static/vendor/js/jquery-2.1.1.min.js"></script>
    <script src="../static/vendor/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="../static/vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="../static/vendor/skycons/js/skycons.js"></script> 
    
    <!-- Plugins JS-->
    
    <!-- Theme JS -->   


    <!-- Pages JS -->
    <script src="../static/js/ajax.js"></script>
    <!-- end: JavaScript-->

    <script>

        $(function () {
            get_json('../../api/link.ashx?action=list', function (data) {
                var list = '';
                for (var i = 0; i < data.data.length; i++) {
                    var addate = formatTime(data.data[i].add_time, "yyyy-MM-dd hh:mm:ss");
                    list += ''
                     + '<tr id="l' + data.data[i].id + '">'
                        + '<td>'
                          + '<input type="text" name="listorder" class="form-control listorder" value="' + data.data[i].listorder + '">'
                        + '</td>'
                        + '<td align="center">' + data.data[i].id + '</td>'
                        + '<td>' + data.data[i].title + '</td>'
                        + '<td>' + data.data[i].ptitle + '</td>'
                        + '<td>' + addate + '</td>'
                        + '<td>'
                          + '<a class="btn btn-success" href="edit.aspx?action=edit&id=' + data.data[i].id + '&pid=' + data.data[i].pid + '" data-toggle="tooltip" title="编辑" data-original-title="编辑">'
                            + '<i class="fa fa-edit"></i>'
                          + '</a>'
                          + '<button onClick="Delete(\'../../api/link.ashx?action=del&id=' + data.data[i].id + '\')" class="btn btn-info delete" data-toggle="tooltip" title="删除" data-original-title="删除">'
                            + '<i class="fa fa-trash-o"></i>'
                          + '</button>'
                        + '</td>'
                      + '</tr>'
                };
                $('.table tbody').html(list);
                $("[data-toggle='tooltip']").tooltip();
            });
            //更改排序
            $('.table').on('input propertychange', '.listorder', function () {
                var that = $(this);
                var id = that.parent().parent().find('label').text();
                var val = that.val();
                val = val.replace(/[^0-9-]+/, '');
                that.val(val);
                if (val != '') {
                    $.post('/ajax/success.aspx?action=listorder&id=' + id + '&value=' + val, function (data, textStatus, xhr) {
                        console.log(val)
                    }).error(function () {
                        console.log('cauowu')
                    });
                }
            });
        })
    </script>
    
</body>

</html>

