﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="list_field.aspx.cs" Inherits="wjdhcms_SAAS.module.model.list_field" %>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<meta name="apple-mobile-web-app-capable" content="yes" />
<title>栏目管理</title>

    <!-- start: CSS file-->
    <!-- Vendor CSS-->
    <link href="../static/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
    <link href="../static/vendor/skycons/css/skycons.css" rel="stylesheet" />
    <link href="../static/vendor/font-awesome/css/font-awesome.min.css" rel="stylesheet" />

    <!-- Plugins CSS-->
    <link href="../static/plugins/bootkit/css/bootkit.css" rel="stylesheet" />   
    
    <!-- Page CSS -->   
    <link href="../static/css/style.css" rel="stylesheet" />
    <link href="../static/css/add-ons.min.css" rel="stylesheet" />
    <!-- end: CSS file--> 
      
    
    <!-- Head Libs -->
    
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="../static/js/html5shiv.min.js"></script>
      <script src="../static/js/respond.min.js"></script>
    <![endif]-->    
    

</head>

<body class="mainbody">
  <div class="container-fluid">
    <div class="row"> 
            <div class="col-lg-12">
              <div class="panel">
                <div class="panel-heading bk-bg-primary">
                  <div class="list-articles">
                    <a href="edit_field.aspx?model_id=<%=model_id %>&name=<%=name %>" class="release btn btn-default"><i class="fa fa-pencil-square-o"></i>新增字段</a>
                  </div>
                </div>
                <div class="panel-body">
                  <div class="table-responsive">
                    <table class="table table-bordered table-striped table-condensed table-hover article-list">
                      <thead>
                        <tr>
                          <th>字段名称</th>
                          <th width="20%">字段别名</th>
                          <th width="20%">输入类型</th>
                          <th width="20%">提示文字</th>
                          <th width="10%">操作</th>                                          
                        </tr>
                      </thead>   
                      <tbody>
                      </tbody>
                    </table>
                  </div>
                
                </div>
              </div>
            </div>
          </div>  
  </div>

    <!-- start: JavaScript-->
    
    <!-- Vendor JS-->       
    <script src="../static/vendor/js/jquery-2.1.1.min.js"></script>
    <script src="../static/vendor/js/jquery-migrate-1.2.1.min.js"></script>
    <script src="../static/vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="../static/vendor/skycons/js/skycons.js"></script> 
    
    <!-- Plugins JS-->
    
    <!-- Theme JS -->   


    <!-- Pages JS -->
    <script src="../static/js/ajax.js"></script>
    <!-- end: JavaScript-->

    <script>
        $(function () {
            get_json('../../api/models.ashx?action=listfield&model_id=' + $.getUrlParam('model_id'), function (data, waiting) {
                var list = '';
                for (var i = 0; i < data.data.length; i++) {
                    var id = data.data[i].id;
                    var title = data.data[i].field_name;
                    var type = data.data[i].field_type;
                    var alias = data.data[i].field_eng;
                    var tip = data.data[i].field_tips;
                    var model_name = data.data[i].model_name;
                    list += ''
                      + '<tr id="l' + id + '">'
                        + '<td>' + title + '</td>'
                        + '<td>' + alias + '</td>'
                        + '<td>' + type + '</td>'
                        + '<td>' + tip + '</td>'
                        + '<td>'
                          + '<a class="btn btn-success" href="edit_field.aspx?action=edit&name=' + model_name + '&id=' + id + '" data-toggle="tooltip" title="编辑" data-original-title="编辑">'
                            + '<i class="fa fa-edit"></i>'
                          + '</a>'
                          + '<button onClick="Delete(\'..\/..\/api\/models.ashx?action=delfield&id=' + id + '\')" class="btn btn-info delete" data-toggle="tooltip" title="删除" data-original-title="删除">'
                            + '<i class="fa fa-trash-o"></i>'
                          + '</button>'
                        + '</td>'
                      + '</tr>'
                };
                $('.table tbody').html(list);
                $("[data-toggle='tooltip']").tooltip();
            });
        });
    </script>
    
</body>

</html>
