<%
'

Class Class_OpenWBS_Cache

	Public Pv_CacheTime,Pu_VCacheFlag,Pv_CreateCacheByAdmin
	Private Pv_CacheFilePath
	Private Pv_CacheName,Pv_CacheData,Pv_CacheNum,Pv_CreateCacheNum

	Private Sub Class_Initialize()
		Pv_CacheTime      = CacheTime
		Pu_VCacheFlag     = CacheFlag
		Pv_CacheNum       = 200
		Pv_CreateCacheNum = 0
		Pv_CreateCacheByAdmin = False
		OpenWBS.Error(60) = "Please set cache name."'û.
		OpenWBS.Error(61) = "Cache value not exist."'ֵ.
		OpenWBS.Error(62) = "Save cache file error, please check cache folder is writable and can delete."'滺ļʧܣ黺Ŀ¼ǷдɾȨ.
	End Sub
	Private Sub Class_Terminate()
	End Sub
	Public Property Let CacheTime(ByVal BV_CacheTime)
		Pv_CacheTime = BV_CacheTime
	End Property
	Public Property Get CacheTime
		CacheTime = Pv_CacheTime
	End Property
	
	Public Property Let CacheFilePath(ByVal BV_Path)
		Pv_CacheFilePath = BV_Path
	End Property
	Public Property Get CacheFilePath
		CacheFilePath = Pv_CacheFilePath
	End Property
	
	Public Property Let CreateCacheByAdmin(ByVal BV_CBool)
		Pv_CreateCacheByAdmin = BV_CBool
	End Property
	Public Property Get CreateCacheByAdmin
		CreateCacheByAdmin = Pv_CreateCacheByAdmin
	End Property
	
	'жϾ̬ҳǷѹ
	Public Function CheckCache(ByVal BV_CacheName)
		CheckCache = CheckCacheFile(BV_CacheName)
	End Function
	
	'жϾ̬ҳǷѹ
	Public Function CheckCacheFile(ByVal BV_CacheName)
		On Error Resume Next
		Pv_CacheName=LCase(BV_CacheName)
		Dim Fn_CachePath,Fn_File
		Dim Fn_Result : Fn_Result = False
		If Pv_CacheName<>"" Then
			Pv_CacheName = Pv_CacheFilePath & Pv_CacheName
			Fn_CachePath = Server.MapPath(Pv_CacheName)
			If OpenWBS.FSO.FileExists(Fn_CachePath) Then
				If Pv_CreateCacheByAdmin = False Then 
					Set Fn_File=OpenWBS.FSO.ObjectFSO.GetFile(Fn_CachePath)
					If DateDiff("s",CDate(Fn_File.DateLastModified),Now()) < Pv_CacheTime Then
						Fn_Result = True
					End If
					Set Fn_File=Nothing
				Else
					Fn_Result = False
				End If
			End If
		End If
		CheckCacheFile = Fn_Result
	End Function
	
	'ȡ̬ҳ
	Public Function GetCache(ByVal BV_CacheName)
		GetCache = GetCacheFile(BV_CacheName)
	End Function

	'澲̬ҳ
	Public Function SetCache(ByVal BV_CacheName,ByVal BV_CacheValue)
		Call SetCacheFile(BV_CacheName,BV_CacheValue,true)
	End Function
	
	'澲̬ҳ
	Public Function SetCacheFile(ByVal BV_CacheName,ByVal BV_CacheValue,ByVal BV_OverWrite)
		'On Error Resume Next
		Dim Fn_Temp
		Pv_CacheName=LCase(BV_CacheName)
		If Pv_CacheName<>"" Then
			Pv_CacheName = Pv_CacheFilePath & Pv_CacheName
			Fn_Temp      = OpenWBS.FSO.OverWrite
			OpenWBS.FSO.OverWrite = BV_OverWrite
			If OpenWBS.FSO.SaveTextFile(Pv_CacheName,BV_CacheValue) Then
				Pv_CreateCacheNum = Pv_CreateCacheNum + 1
			Else
				OpenWBS.Error.Msg = "OpenWBS.Cache.SetCacheFile: "& BV_CacheName
				OpenWBS.Error.Raise 61
				Err.Clear
			End If
			OpenWBS.FSO.OverWrite = Fn_Temp
		Else
			OpenWBS.Error.Msg = "OpenWBS.Cache.SetCacheFile: "& BV_CacheName
			OpenWBS.Error.Raise 60
			Err.Clear
		End If
	End Function
	
	'ȡ̬ҳ
    Public Function GetCacheFile(ByVal BV_CacheName)
		On Error Resume Next
		Dim Fn_Text
		Pv_CacheName=LCase(BV_CacheName)
		If Pv_CacheName<>"" Then
			Pv_CacheName = Pv_CacheFilePath & Pv_CacheName
			Fn_Text = OpenWBS.Read(SystemPath & Pv_CacheName)
		End If
		GetCacheFile = Fn_Text
	End Function

	Public Sub ClearCache(ByVal BV_CacheName)
		Pv_CacheName=LCase(BV_CacheName)
		Application.Lock
		Application(Pu_VCacheFlag & Pv_CacheName) = Empty
		Application.unLock
	End Sub
	
	Public Function ClearAll()
		Application.Lock()
		Application.Contents.RemoveAll()
		Application.UnLock()
	End Function

	Public Function HavedTime(Byval BV_CacheName)
		Pv_CacheName=LCase(BV_CacheName)
		If Pv_CacheName<>"" Then
			Pv_CacheData=Application(Pu_VCacheFlag & Pv_CacheName)
			If IsArray(Pv_CacheData) Then
				HavedTime=Pv_CacheData(1)
			Else
				Die "Error_CacheValue"
			End If
		Else
			Die "Error_CacheName"
		End If
	End Function

	Public Function ShowAllCache()
		Dim Fn_ACon
		Echo "CACHE_OBJECT_NUM: "& GetCacheNum() &"<br><br>"
		for each Fn_ACon in Application.Contents
			Echo Fn_ACon &"<br>"
		next
	End Function

	Public Function GetCacheNum()
		GetCacheNum = application.Contents.Count
	End Function
	
	Public Function CreateCacheNum()
		CreateCacheNum = Pv_CreateCacheNum
	End Function

	Public Function ClearOtherCache()
		Dim Fn_i,Fn_ACon,Fn_OtherNum
		Fn_OtherNum = GetCacheNum - Pv_CacheNum
		Fn_i = 0
		For Each Fn_ACon In Application.Contents
			Application.Lock()
			application.contents.remove(Fn_ACon)
			Application.UnLock()
			Fn_i = Fn_i + 1
			If Fn_i=Fn_OtherNum Then Exit For
		Next
	End Function
End Class
%>