<?php
namespace app\index\controller;
use think\Controller;
use think\Db;
/*
首页等页面
*/
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2021 http://mifenlei.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 梦雨 <50361804@qq.com>
// +----------------------------------------------------------------------
class Index extends Controller
{
    //首页
    public function index()
    {
        return view();
    }
    //文章分类
    public function info()
    {
        if (input('alias')) {
            $c = Db::name('cate')->where(array('alias' => input('alias')))->find();
            $this->assign('c', $c);
        } 
        // 始终获取顶级的id
        if ($c['tid']==0) {
            $id=$c['id'];
            $name=$c['name'];
        } else {
            $id=$c['tid'];
            $name=fun_sc_p('cate', array('id' => $c['tid']), 'name');
        }
        $this->assign('id', $id);
        $this->assign('name', $name);
        $this->assign('hover', 'info');
        $this->assign('sosotitle', '新闻资讯');
        return view();
    }
    // 文章详情
    public function detail()
    {
        $t = Db::name('article')->where(array('id' => input('id'), 'open' => 1))->find();
        $this->assign('t', $t);
        $cate = Db::name('cate')->where(array('id' => $t['tid']))->find();
        $this->assign('cate', $cate);
        $this->assign('hover', 'info');
        $this->assign('sosotitle', '新闻资讯');
        if (empty($t['id'])) {
            return $this->error('页面不存在','/');
        }
        Db::name('article')->where('id', input('id'))->setInc('view', 1);
        return view();
    }
    // 信息首页
    public function xinxi()
    {
        $this->assign('hover', 'xinxi');
        $this->assign('hovers', 'xinxi');
        return view();
    }
    // 模型首页
    public function lists()
    {
        if (input('c')) {
            $c = Db::name('cate_m')->where(array('id' => input('c')))->find();
            $this->assign('c', $c);
        } 
        if (input('diqu')) {
            $d = Db::name('cate_diqu')->where(array('id' => input('diqu')))->find();
            $this->assign('d', $d);
        } 
        $m = Db::name('model')->where(array('name' => input('m')))->find();
        $this->assign('m', $m);
        // 始终获取顶级的id
        if ($d['tid']==0) {
            $id=$d['id'];
            $name=$d['name'];
        } else {
            $id=$d['tid'];
            $name=fun_sc_p('cate_diqu', array('id' => $d['tid']), 'name');
        }
        $this->assign('id', $id);
        $this->assign('name', $name);
        $this->assign('hover', input('m'));
        $this->assign('hovers', 'xinxi');
        $this->assign('html', $html);
        if (isMobile()) {
            $muban=$m['list_wap'];
        } else {
            $muban=$m['list'];
        }
        $html='template/'.muban().'/index/'.preg_replace('/.html/','',$muban).'.html';
        if (file_exists($html)) {
            return view($html);
        }else {
            return $this->fetch('/index:list');
        } 
    }
    //模型内容详情
    public function html()
    {
		$t=Db::name(input('m'))->where(array('id'=>input('id'),'open'=>1))->find();
        $this->assign('t',$t);
        $m = Db::name('model')->where(array('name' => input('m')))->find();
        $this->assign('m', $m);
        $s = Db::name('shangjia')->where(array('uid' => $t['uid'], 'open' => 1))->find();
        $this->assign('s', $s);
        Db::name(input('m'))->where('id', input('id'))->setInc('view', 1);
        // 更新置顶信息
        if ($t['settop_time']<time()) {
            Db::name(input('m'))->strict(false)->where(array('id'=>input('id')))->update(array('settop'=>0,'vip'=>0,'settop_time'=>''));
        }
        if ($t['settop']==0) {
            Db::name(input('m'))->strict(false)->where(array('id'=>input('id')))->update(array('settop'=>0,'vip'=>0,'settop_time'=>''));
        }
        // 更新信息状态过期
        if ($t['time_daoqi']!=0) {
            if ($t['time_daoqi']<time()) {
                if (set('guoqi',5)==1) {
                    // 直接删除
                    Db::name(input('m'))->strict(false)->delete(array('id' => input('id')));
                } else {
                    // 设置隐藏
                    Db::name(input('m'))->strict(false)->where(array('id'=>input('id')))->update(array('open'=>4));
                }
            }
        }
        //新增电话转换图片
        if (input('img')) {
            $im = imagecreate(120, 30);
            $bg = imagecolorallocatealpha($im,255, 255, 255,0 );
            $textcolor = imagecolorallocate($im, 65, 65, 65);
            imagestring($im, 5,10,8, $t[input('img')], $textcolor);
            header('Content-type: image/png');
            imagepng($im);
            imagedestroy($im);
        }
        if ($t['open']!=1) {
            return $this->error('页面已丢失');
        }
        $this->assign('hover', input('m'));
        $this->assign('hovers', 'xinxi');
        if (isMobile()) {
            $muban=$m['html_wap'];
        } else {
            $muban=$m['html'];
        }
        $html='template/'.muban().'/index/'.preg_replace('/.html/','',$muban).'.html';
        if (file_exists($html)) {
            return view($html);
        }else {
            return $this->fetch('/index:html');
        } 
    }
    // 海报页面
    public function haibao()
    {
		$t=Db::name(input('m'))->where(array('id'=>input('id'),'open'=>1))->find();
        $this->assign('t',$t);
        $m = Db::name('model')->where(array('name' => input('m')))->find();
        $this->assign('m', $m);
        $s = Db::name('shangjia')->where(array('uid' => $t['uid'], 'open' => 1))->find();
        $this->assign('s', $s);
        Db::name(input('m'))->where('id', input('id'))->setInc('view', 1);
        if ($t['open']!=1) {
            return $this->error('页面已丢失');
        }
        $this->assign('hover', input('m'));
        $this->assign('hovers', 'xinxi');
        if (isMobile()) {
            $muban=$m['html_wap'];
        } else {
            $muban=$m['html'];
        }
        if (input('img')) {
            $filename = input('img');//图片地址,可以绝对地址也可以相对地址
            header("Content-Type: application/force-download");
            header('Content-Disposition: attachment; filename="'.$filename.'"');
            $img = file_get_contents($filename);
            echo $img;
            return;
        }
        $html='template/'.muban().'/index/haibao.html';
        if (file_exists($html)) {
            return view($html);
        }else {
            return view('template/mifenlei/index/haibao.html');
        } 
    }
    // 发布信息
    public function add()
    {
        $this->assign('hover', 'add');
        return view();
    }
    // 商家列表
    public function shangjia()
    {
        if (input('c')) {
            $c = Db::name('cate_shangjia')->where(array('id' => input('c')))->find();
            $this->assign('c', $c);
        } 
        if (input('diqu')) {
            $d = Db::name('cate_diqu')->where(array('id' => input('diqu')))->find();
            $this->assign('d', $d);
        } 
        // 始终获取商家分类顶级的id
        if ($c['tid']==0) {
            $tid=$c['id'];
        } else {
            $tid=$c['tid'];
        }
        // 始终获取地区分类顶级的id
        if ($d['tid']==0) {
            $id=$d['id'];
        } else {
            $id=$d['tid'];
        }
        $this->assign('id', $id);
        $this->assign('tid', $tid);
        $this->assign('hover', 'shangjia');
        $this->assign('sosotitle', '商家中心');
        return view();
    }
    // 商家详情
     public function business()
    {
        $t = Db::name('shangjia')->where(array('id' => input('id'), 'open' => 1))->find();
        $this->assign('t', $t);
        $c = Db::name('cate_shangjia')->where(array('id' => $t['tid']))->find();
        $this->assign('c', $c);
        $s = Db::name('cate_diqu')->where(array('id' => $t['sid']))->find();
        $this->assign('s', $s);
        if (empty($t['id'])) {
            return $this->error('页面不存在','/');
        }
        //新增电话转换图片
        if (input('img')) {
            $im = imagecreate(120, 30);
            $bg = imagecolorallocatealpha($im,255, 255, 255,0 );
            $textcolor = imagecolorallocate($im, 65, 65, 65);
            imagestring($im, 5,10,8, $t[input('img')], $textcolor);
            header('Content-type: image/png');
            imagepng($im);
            imagedestroy($im);
        }
        Db::name('shangjia')->where('id', input('id'))->setInc('view', 1);
        $this->assign('hover', 'shangjia');
        $this->assign('sosotitle', '商家中心');
        if ($t['settop_time']>time()) {
            return $this->fetch('/index:business_vip');
        } else {
            if ($t['settop']==1) {
                Db::name('shangjia')->strict(false)->where(array('id'=>$t['id']))->update(array('settop'=>0));
            }
            return $this->fetch('/index:business');
        }
    }
    //单页
    public function dan()
    {
        $dan = Db::name('dan');
        $c = $dan->where(array('alias' => input('alias'),'open' => 1))->find();   
        $this->assign('c',$c);
        if (empty($c['id'])) {
            return $this->error('页面不存在');
        }
        $this->assign('hover', 'dan');
        return view('template/'.muban().'/dan/'.$c['muban']);
    }
    // 自定义页面
    public function dans()
    {
        $html='template/'.muban().'/dan/'.input('id').'.html';
        if (file_exists($html)) {
            return view($html);
        }else {
            return '模板文件不存在<br><br>'.$html.'<br><br>自行创建该文件进行编辑';
        }
    }
    // 创建模板扩展控制
    public function tpl($controller=null,$method = null,$json=false){
    	$class_path = "\\template\\".$controller."\\mifenlei";
    	if(!is_file("template/".$controller."/mifenlei.php")){
			exit("没有这样的控制器");
		} else {
		    require_once "template/".$controller."/mifenlei.php";
		}
    	$c = new $class_path();
    	if(is_callable(array($class_path,$method))) {
            $c->$method();
        } else {
            exit("方法".$method."不存在");
        }
    }
    //用于显示模板的方法
    protected function view($templateFile = ''){
        $class = get_class($this);
        $view_path = 'template/'.substr($class,strrpos($class, '\\')+1).'/view/';
		$templateFile = $view_path.$templateFile.'.html';
		if(!is_file($templateFile)){
			exit("模板不存在:$templateFile");
		} else {
		    echo $this->fetch($templateFile);
		}
    	echo $this->fetch($templateFile);
    }
}