# 版本说明

## 版本规则

Hyperf 采用 x.y.z 的版本号规则来命名各个版本，如 1.2.3 版本，1 即为 x，2 即为 y，3 即为 z，您可以根据该版本规则来制定您对 Hyperf 框架的更新计划。
- x 表示一个重大版本，当 Hyperf 的核心进行大量的重构变动时，或当存在大量的破坏性 API 变更时，会作为一个 x 版本发布，x 版本变更通常来说是无法与之前的 x 版本兼容，但也不一定代表完全无法兼容，具体根据对应版本的升级指南来进行甄别。
- y 表示一个主要功能迭代版本，当一些公开的 API 进行了破坏性的变更后，包括公开 API 的变更和删除，导致前置版本可能无法兼容的时候，会以 y 版本来进行发布。
- z 表示一个完全兼容的修复版本，当对各个组件的已有功能进行 BUG 修复或安全修复时，会选择以一个 z 版本来发布，当一个 BUG 导致了某个功能完全无法使用时，亦可能在 z 版本内修复这个 BUG 时对 API 进行破坏性变更，但由于功能此前已经完全无法使用故此类变更不会以 y 版本来发布，除了 BUG 修复，z 版本也可能会包括一些新增的功能或组件，这些功能和组件均不会影响此前的代码使用。

## 升级版本

当您希望升级 Hyperf 版本时，如果是对 x 和 y 版本的升级，请根据文档内对应版本的升级指南来进行操作。如您希望对 z 版本进行升级，可直接在您的项目的根目录执行 `composer update hyperf` 命令来对依赖包进行更新，我们不建议您单独升级某一个组件的版本，而是统一升级所有组件来获得更加一致的体验。