# 2.1 介紹

Hyperf 是基於 `Swoole 4.5+` 實現的高性能、高靈活性的 PHP 協程框架，內置協程服務器及大量常用的組件，性能較傳統基於 `PHP-FPM` 的框架有質的提升，提供超高性能的同時，也保持着極其靈活的可擴展性，標準組件均基於 [PSR 標準](https://www.php-fig.org/psr) 實現，基於強大的依賴注入設計，保證了絕大部分組件或類都是 `可替換` 與 `可複用` 的。

框架組件庫除了常見的協程版的 `MySQL 客户端`、`Redis 客户端`，還為您準備了協程版的 `Eloquent ORM`、`WebSocket 服務端及客户端`、`JSON RPC 服務端及客户端`、`GRPC 服務端及客户端`、`Zipkin/Jaeger (OpenTracing) 客户端`、`Guzzle HTTP 客户端`、`Elasticsearch 客户端`、`Consul 客户端`、`ETCD 客户端`、`AMQP 組件`、`Apollo 配置中心`、`阿里雲 ACM 應用配置管理`、`ETCD 配置中心`、`基於令牌桶算法的限流器`、`通用連接池`、`熔斷器`、`Swagger 文檔生成`、`Swoole Tracker`、`視圖引擎`、`Snowflake 全局 ID 生成器` 等組件，省去了自己實現對應協程版本的麻煩。

Hyperf 還提供了 `基於 PSR-11 的依賴注入容器`、`註解`、`AOP 面向切面編程`、`基於 PSR-15 的中間件`、`自定義進程`、`基於 PSR-14 的事件管理器`、`Redis/RabbitMQ 消息隊列`、`自動模型緩存`、`基於 PSR-16 的緩存`、`Crontab 秒級定時任務`、`國際化`、`Validation 表單驗證器` 等非常便捷的功能，滿足豐富的技術場景和業務場景，開箱即用。

# 框架初衷

儘管現在基於 PHP 語言開發的框架處於一個百家爭鳴的時代，但仍舊未能看到一個優雅的設計與超高性能的共存的完美框架，亦沒有看到一個真正為 PHP 微服務鋪路的框架，此為 Hyperf 及其團隊成員的初衷，我們將持續投入併為此付出努力，也歡迎你加入我們參與開源建設。

# 設計理念

`Hyperspeed + Flexibility = Hyperf`，從名字上我們就將 `超高速` 和 `靈活性` 作為 Hyperf 的基因。

- 對於超高速，我們基於 Swoole 協程並在框架設計上進行大量的優化以確保超高性能的輸出。
- 對於靈活性，我們基於 Hyperf 強大的依賴注入組件，組件均基於 [PSR 標準](https://www.php-fig.org/psr) 的契約和由 Hyperf 定義的契約實現，達到框架內的絕大部分的組件或類都是可替換的。

基於以上的特點，Hyperf 將存在豐富的可能性，如實現 Web 服務，網關服務，分佈式中間件，微服務架構，遊戲服務器，物聯網（IOT）等。

# 生產可用

我們為組件進行了大量的單元測試以保證邏輯的正確，同時維護了高質量的文檔，在 Hyperf 正式對外開放之前，便已經過了嚴酷的生產環境的考驗，我們才正式的對外開放該項目，至今，已有很多的大型/中小型互聯網公司在生產環境使用 Hyperf。
