# 1.1 升級指南

1.1 版新增了很多的功能，但一些改動也涉及到了對 Skeleton 骨架的調整，以及配置項的結構調整，如果您已經投入了業務使用的項目且是基於官方提供的 Skeleton 項目創建的 1.0 應用項目，那麼可以根據下面的內容點來調整您的骨架項目，如果您是一個新的項目，按照文檔通過 `composer create-project hyperf/hyperf-skeleton` 命令創建新的項目即可使用新的 skeleton 結構。

## 升級 Swoole 到 4.4+

1.1 版將最低的 Swoole 版本要求從 4.3+ 提升到了 4.4+，這兩個版本之間有一些使用上的細節問題，Hyperf 已經在較早的版本便已適配了，對於 Hyperf 的用户而言無需理會這之間的差異，我們提升最低 Swoole 版本要求主要是為了減少我們的歷史負擔，而 Swoole 4.4 作為 Swoole 的 LTS(長期支持版本) 也意味着更加的穩定可靠。   

Hyperf 在啟動時會進行 Swoole 版本檢測，但為了更好的統一各處對 Swoole 版本的依賴約束，我們建議您將 `composer.json` 內對 Swoole 的依賴條件改為 `"ext-swoole": ">=4.4"`。

## 增加 SWOOLE_HOOK_FLAGS 常量

在應用的入口文件 `bin/hyperf.php` 以及單測的入口文件 `test/bootstrap.php` 裏增加一行常量定義如下：

```php
! defined('SWOOLE_HOOK_FLAGS') && define('SWOOLE_HOOK_FLAGS', SWOOLE_HOOK_ALL);
```

參考：[入口文件參考](https://github.com/hyperf/hyperf-skeleton/blob/70062b7bbf29e23cda2f30680e02aa3b26ebd6f7/bin/hyperf.php#L11) [單測入口文件參考](https://github.com/hyperf/hyperf-skeleton/blob/70062b7bbf29e23cda2f30680e02aa3b26ebd6f7/test/bootstrap.php#L20)

## 移動 config/dependencies.php 文件並調整文件結構

移動 `config/dependencies.php` → `config/autoload/dependencies.php`，並去除配置文件中的第一層 `dependencies`，如下：

1.0 的文件結構：
```php
<?php
// config/dependencies.php 文件

return [
    'dependencies' => [
        FooInterface::class => Foo::class
    ],
];
```

1.1 的文件結構：
```php
<?php
// config/autoload/dependencies.php 文件

return [
    FooInterface::class => Foo::class
];
```

## 調整 config/container.php 文件的內容

由於 1.1 版本調整了 `dependencies.php` 文件的位置和結構，所處我們還需要調整一下 `config/container.php` 文件，以便依賴注入容器能夠正確的運行，與此同時，我們也為 `config/container.php` 提供了更加簡便的寫法，`DefinitionSourceFactory` 將很多默認的行為聚合了起來，您只需將 `config/container.php` 文件的內容更換成下面的內容即可：

> 默認開啟註解掃描緩存功能，可修改 `DefinitionSourceFactory` 入參的第一個參數來關閉此功能

```php
<?php
/**
 * Initial a dependency injection container that implemented PSR-11 and return the container.
 */
declare(strict_types=1);

use Hyperf\Di\Container;
use Hyperf\Di\Definition\DefinitionSourceFactory;
use Hyperf\Utils\ApplicationContext;
use Psr\Container\ContainerInterface;

$container = new Container((new DefinitionSourceFactory(true))());
if (! $container instanceof ContainerInterface) {
    throw new RuntimeException('The dependency injection container is invalid.');
}
return ApplicationContext::setContainer($container);
```

## 調整 WebSocket 控制器

由於 1.1 版本調整了 `onMessage` 和 `onOpen` 的入參約束，所以需要手動修改其為 `Swoole\WebSocket\Server`，具體代碼如下

```php
<?php
declare(strict_types=1);

namespace App\Controller;

use Hyperf\Contract\OnMessageInterface;
use Hyperf\Contract\OnOpenInterface;
use Swoole\Http\Request;
use Swoole\Websocket\Frame;
use Swoole\WebSocket\Server as WebSocketServer;

class WebSocketController implements OnMessageInterface, OnOpenInterface
{
    public function onMessage(WebSocketServer $server, Frame $frame): void
    {
    }

    public function onOpen(WebSocketServer $server, Request $request): void
    {
    }
}
```

## 調整自定義組件的 ConfigProvider

1.0 版本中 `scan.path` 在 1.1 版本中調整為 `annotations.scan.path`，您需要修改所有自定義組件的 ConfigProvider 類來適配此變更，如您的自定義組件不涉及到註解掃描的功能配置，則可忽略此調整，如下所示：

1.0 的 ConfigProvider 文件結構：
```php
class ConfigProvider
{

    public function __invoke(): array
    {
        return [
            'scan' => [
                'paths' => [
                    __DIR__,
                ],
            ],
        ];
    }
}
```

1.1 的 ConfigProvider 文件結構：
```php
class ConfigProvider
{

    public function __invoke(): array
    {
        return [
            'annotations' => [
                'scan' => [
                    'paths' => [
                        __DIR__,
                    ],
                ],
            ],
        ];
    }
}
```

## 調整默認的本地化語言

如果您在之前有使用 [hyperf/translation](https://github.com/hyperf/translation) 組件，那麼您需要檢查一下 `config/autoload/translation.php` 文件內的 `locale` 配置項，如為 `zh-CN`，則需要改為 `zh_CN`，在 1.1 版本，我們統一了這個配置的值。

## 調整 composer.json 的依賴

由於要升級到 1.1 版本的組件，而原來 skeleton 項目默認情況下是依賴 1.0.x 版本的組件的，所以我們需要對依賴的約束條件進行一些調整，將原來所有 Hyperf 組件的依賴 `~1.0.0` 修改為 `~1.1.0`，修改完後需運行 `composer update` 來將依賴項升級到 1.1 版本。   

必須將所有 Hyperf 依賴都升級到 1.1 版本才可用，因為 1.1 調整了組件適配的 ConfigProvider 機制。

## 完成升級

至此，1.1 升級即已完成，但由於 Hyperf 的各個底層文件都是可以通過 DI 來實現重寫的，如您重寫了某些本次升級調整到了的框架內部文件，您仍需再根據您的實際情況進行一定的調整。   

如您在升級上或升級後遇到任何的問題，請前往 [Github Issue](https://github.com/hyperf/hyperf/issues) 提交您的 issue，説明您遇到的問題，我們會盡快幫助您解決。
