

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for temmoku_fenlei_action
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_action`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_action` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `aid` mediumint(9) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '类型1为置顶，2为十万火急,3为预约刷新',
  `startime` int(10) NOT NULL COMMENT '开始时间',
  `endtime` int(10) NOT NULL COMMENT '结束时间',
  `next_refresh_time` int(10) NOT NULL DEFAULT '0' COMMENT '下一次刷新的时间',
  `refresh_num` int(10) NOT NULL DEFAULT '0' COMMENT '刷新次数',
  `day` tinyint(3) NOT NULL COMMENT '天数，一般不使用，只是记录',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='信息操作';

-- ----------------------------
-- Table structure for temmoku_fenlei_action_order
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_action_order`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_action_order` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `state` tinyint(1) NOT NULL DEFAULT '0' COMMENT '支付状态，1为支付 0为未支付',
  `posttime` int(10) NOT NULL COMMENT '订单创建时间',
  `payment` varchar(255) NOT NULL COMMENT '使用的支付方式',
  `trade_no` varchar(255) NOT NULL DEFAULT '' COMMENT '支付成功后返回的订单号',
  `aid` mediumint(9) NOT NULL,
  `rmb` decimal(10,2) NOT NULL COMMENT '需要支付的金额',
  `type` tinyint(1) NOT NULL COMMENT '类型1为置顶，2为急,3为预约刷新',
  `transaction_code` bigint(20) NOT NULL,
  `day` int(10) NOT NULL COMMENT '顶，急用到',
  `refresh_num` int(10) NOT NULL DEFAULT '0' COMMENT '预约刷新用到',
  `refresh_starttime` int(10) NOT NULL DEFAULT '0' COMMENT '预约刷新的起始时间',
  `refresh_endtime` int(10) NOT NULL DEFAULT '0' COMMENT '预约刷新的结束时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for temmoku_fenlei_article
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_article`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_article` (
  `aid` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '自动生成的ID',
  `cid` mediumint(9) NOT NULL DEFAULT '0' COMMENT '栏目的cid',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `mid` mediumint(9) DEFAULT '0' COMMENT '模型mid',
  `uid` mediumint(7) NOT NULL DEFAULT '0' COMMENT '发布人的UID',
  `username` varchar(255) NOT NULL DEFAULT '' COMMENT '发布人',
  `title` varchar(255) DEFAULT NULL COMMENT '文章标题',
  `color` varchar(255) DEFAULT NULL COMMENT '标题颜色',
  `bold` tinyint(1) DEFAULT '0' COMMENT '是否加粗，1为是 ，0为否',
  `keyword` varchar(255) DEFAULT NULL COMMENT '文章关键词',
  `description` text COMMENT '文章简要',
  `thumb` varchar(255) DEFAULT NULL COMMENT '缩略图地址',
  `is_pic` tinyint(1) DEFAULT '0' COMMENT '是否有缩略图1为是 ，默认0不是',
  `posttime` int(10) DEFAULT '0' COMMENT '发布时间',
  `clicks` int(10) DEFAULT '0' COMMENT '查看次数',
  `state` tinyint(3) DEFAULT '0' COMMENT '审核状态 1为审 2为未',
  `state_time` int(10) DEFAULT '0' COMMENT '审核时间',
  `reorder` int(10) DEFAULT '0' COMMENT '排序',
  `password` varchar(32) DEFAULT NULL COMMENT '是否是加密文章',
  `price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品价格',
  `is_merchant` tinyint(3) NOT NULL DEFAULT '0' COMMENT '是否是商家发布的信息',
  `truename` varchar(6) NOT NULL,
  `tel` varchar(255) NOT NULL,
  `oicq` bigint(20) NOT NULL DEFAULT '0',
  `weixin` varchar(255) NOT NULL,
  `is_msg` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0只接受站内私信 1私信加电话',
  `is_done` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否搞定1为已搞定，0为未',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for temmoku_fenlei_attribute_list
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_attribute_list`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_attribute_list` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `aid` mediumint(9) NOT NULL,
  `cid` mediumint(9) NOT NULL DEFAULT '0',
  `fid` mediumint(9) NOT NULL,
  `value` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for temmoku_fenlei_category
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_category`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_category` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `upcid` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT '从上到下的级别',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `cmid` int(11) NOT NULL DEFAULT '0',
  `reorder` int(11) NOT NULL DEFAULT '0' COMMENT '排序专用',
  `dir_name` varchar(255) NOT NULL DEFAULT '',
  `seo_name` varchar(255) NOT NULL DEFAULT '',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '',
  `seo_description` varchar(255) NOT NULL DEFAULT '',
  `content` text COMMENT '单页内容',
  `setting` text,
  `ad` text,
  `price_grade` tinyint(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cid`),
  KEY `cid` (`cid`),
  KEY `upcid` (`upcid`)
) ENGINE=MyISAM AUTO_INCREMENT=119 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of temmoku_fenlei_category
-- ----------------------------
INSERT INTO `temmoku_fenlei_category` VALUES ('3', '跳骚市场', '0', '1', '1', '0', '0', '', '', '', '', '', 'a:4:{s:6:\"search\";a:2:{s:7:\"attr_id\";a:3:{i:0;s:2:\"39\";i:1;s:2:\"41\";i:2;s:2:\"45\";}s:8:\"attr_mid\";a:3:{i:0;s:1:\"6\";i:1;s:1:\"6\";i:2;s:1:\"6\";}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('2', '房产', '0', '1', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('4', '汽车服务', '0', '1', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('5', '招聘', '0', '1', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('6', '交友', '0', '1', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('7', '宠物', '0', '1', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('8', '生活服务', '0', '1', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('9', '教育培训', '0', '1', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('10', '手机数码', '3', '2', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('11', '生活百货', '3', '2', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('12', '办公设备', '3', '2', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('13', '二手手机', '10', '3', '0', '6', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:2:\"11\";i:2;s:2:\"22\";i:3;s:2:\"33\";i:4;s:2:\"44\";i:5;s:2:\"55\";}s:6:\"urgent\";a:5:{i:1;s:2:\"66\";i:2;s:2:\"77\";i:3;s:2:\"88\";i:4;s:2:\"99\";i:5;s:3:\"999\";}}s:11:\"group_power\";a:2:{i:2;a:2:{s:10:\"is_trigger\";s:1:\"1\";s:7:\"trigger\";s:3:\"111\";}i:1;a:2:{s:10:\"is_trigger\";s:1:\"1\";s:7:\"trigger\";s:3:\"222\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('14', '笔记本', '10', '3', '0', '7', '0', '', '', '', '', '', 'a:7:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:9:\"increment\";a:5:{i:1;s:2:\"10\";i:2;s:1:\"9\";i:3;s:1:\"8\";i:4;s:1:\"7\";i:5;s:1:\"6\";}s:9:\"posthaste\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('15', '台式电脑', '10', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('16', '二手照相机', '10', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('17', '数码产品', '10', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('18', '手机配件', '10', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('19', '平板电脑', '10', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('20', '二手家具', '11', '3', '0', '6', '0', '', '', '', '', '', 'a:5:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:9:\"increment\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('21', '家用家电', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('22', '母婴用品', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('23', '家居日用', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('24', '二手自行车', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('25', '文体乐器', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('26', '门票卡券', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('27', '工艺收藏', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('28', '奇石盆景', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('29', '虚拟物品', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('30', '服饰箱包', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('31', '图书音像', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('32', '食品农产', '11', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('33', '办公用品', '12', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('34', '办公家具', '12', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('35', '工业设备', '12', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('36', '设备租赁', '12', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('37', '房屋买卖', '2', '2', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('38', '商业地产', '2', '2', '1', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('39', '求租求购', '37', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('40', '日租短租', '37', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('41', '找室友合租', '37', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('42', '新房出售', '37', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('43', '房屋出租', '37', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('44', '二手房', '37', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('45', '商铺出租', '38', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('46', '商铺出售', '38', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('47', '商铺转让', '38', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('48', '厂房仓库', '38', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('49', '写字楼出租', '38', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('50', '写字楼出售', '38', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('51', '二手车轿车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('52', '货车', '4', '2', '1', '0', '0', 'huoche', '', '', '', '', 'a:4:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('53', '工程车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('54', '二手摩托车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('55', '面包车/客车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('56', '拖拉机/收割机', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('57', '二手电动车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('58', '二手自行车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('59', '贷款购车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('60', '新车优惠', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('61', '本地下线车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('62', '汽车用品', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('63', '拼车/顺风车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('64', '维修保养', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('65', '汽车配件', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('66', '过户/验车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('67', '高价收车', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('68', '抵押车/不过户车辆', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('69', '其他车辆', '4', '2', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('70', '自卸车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('71', '半挂车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('72', '厢式货车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('73', '平板车', '52', '3', '0', '6', '0', '', '', '', '', '', 'a:4:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('74', '牵引车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('75', '油罐车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('76', '挂车斗/罐体', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('77', '水泥罐车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('78', '随车吊', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('79', '冷藏车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('80', '粉罐车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('81', '皮卡', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('82', '新车挂靠', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('83', '拖板车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('84', '气瓶车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('85', '气罐车', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('86', '其他', '52', '3', '0', '0', '0', '', '', '', '', '', '', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('91', '销售', '5', '2', '0', '0', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:6:\"urgent\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('92', '工人', '5', '2', '0', '0', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:6:\"urgent\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('93', '司机', '5', '2', '0', '0', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:6:\"urgent\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('94', '餐饮', '5', '2', '0', '0', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:6:\"urgent\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('95', '出国劳务', '5', '2', '0', '0', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:6:\"urgent\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('96', '物流运输', '5', '2', '0', '0', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:6:\"urgent\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('97', '超市零售', '5', '2', '0', '0', '0', '', '', '', '', '', 'a:6:{s:6:\"search\";a:1:{s:7:\"attr_id\";a:0:{}}s:4:\"rows\";s:0:\"\";s:6:\"number\";s:0:\"\";s:3:\"tpl\";a:2:{s:7:\"article\";s:0:\"\";s:8:\"category\";s:0:\"\";}s:11:\"value_added\";a:2:{s:3:\"top\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}s:6:\"urgent\";a:5:{i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";}}s:11:\"group_power\";a:2:{i:2;a:1:{s:7:\"trigger\";s:0:\"\";}i:1;a:1:{s:7:\"trigger\";s:0:\"\";}}}', '', '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('98', '同城交友', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('99', '同城征婚', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('100', '同城活动', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('101', '婚介服务', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('102', '技能交换', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('103', '找人寻物', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('104', '宝贝寻家', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('105', '交友群', '6', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('106', '狗狗', '7', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('107', '猫猫', '7', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('108', '花鸟虫鱼', '7', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('109', '宠物服务', '7', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('110', '宠物医院', '7', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('111', '宠物用品', '7', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('112', '保姆月嫂', '8', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('113', '生活配送', '8', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('114', '物品回收', '8', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('115', '搬家', '8', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('116', '保洁清洗', '8', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('117', '洗衣护理', '8', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');
INSERT INTO `temmoku_fenlei_category` VALUES ('118', '空调移机', '8', '2', '0', '0', '0', '', '', '', '', null, null, null, '0');

-- ----------------------------
-- Table structure for temmoku_fenlei_collection
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_collection`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_collection` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(9) NOT NULL,
  `aid` mediumint(9) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of temmoku_fenlei_collection
-- ----------------------------

-- ----------------------------
-- Table structure for temmoku_fenlei_content
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_content`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_content` (
  `nid` mediumint(7) NOT NULL AUTO_INCREMENT,
  `aid` mediumint(7) NOT NULL,
  `content` mediumtext,
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for temmoku_fenlei_content_6
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_content_6`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_content_6` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `aid` mediumint(9) DEFAULT '0',
  `wanted` varchar(255) NOT NULL,
  `gongli` varchar(255) NOT NULL,
  `clnf` varchar(255) NOT NULL,
  `pfbz` varchar(255) NOT NULL,
  `qdxs` varchar(255) NOT NULL,
  `qcml` smallint(3) NOT NULL,
  `gcfw` varchar(255) NOT NULL,
  `field_6365` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;



-- ----------------------------
-- Table structure for temmoku_fenlei_content_7
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_content_7`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_content_7` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `aid` mediumint(9) DEFAULT '0',
  `field_74861` int(11) NOT NULL,
  `field_1045` varchar(255) NOT NULL,
  `field_3301` int(10) NOT NULL,
  `field_4623` varchar(255) NOT NULL,
  `field_8615` text NOT NULL,
  `field_7971` varchar(255) NOT NULL,
  `field_3472` varchar(255) NOT NULL,
  `field_1595` text NOT NULL,
  `field_8853` text NOT NULL,
  `field_3181` mediumtext NOT NULL,
  `field_5682` mediumtext NOT NULL,
  `field_5140` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for temmoku_fenlei_field
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_field`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_field` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL COMMENT '字段名称',
  `field` varchar(255) NOT NULL COMMENT '字段名',
  `field_attr` varchar(255) NOT NULL COMMENT '字段属性',
  `field_length` varchar(255) NOT NULL DEFAULT '' COMMENT '字段长度',
  `type` varchar(255) NOT NULL COMMENT '字段类型',
  `unit` varchar(255) NOT NULL COMMENT '单位名称',
  `mid` mediumint(9) NOT NULL COMMENT '所属模型',
  `is_list_show` tinyint(1) NOT NULL DEFAULT '0',
  `is_search` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否开启检索 1为可以 0不可以',
  `choice_model` tinyint(3) NOT NULL DEFAULT '0' COMMENT '选择模式，0为单选，1为多选。一般用在前台，比如商城',
  `value` text NOT NULL COMMENT '预设值',
  `is_required` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填 1为必填',
  `is_regular` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否正则验证',
  `regular` varchar(255) NOT NULL COMMENT '正则表达式',
  `regular_msg` varchar(255) NOT NULL COMMENT '正则验证不通过时的说明',
  `is_xss` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'XSS过滤 0为不，1为过滤',
  `msg` varchar(255) NOT NULL COMMENT '字段输入提示',
  `setting` text NOT NULL COMMENT '其它配置参数，应该是序列化后的数据',
  `height` smallint(6) NOT NULL COMMENT '输入框高度，一般用于textarea',
  `reorder` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of temmoku_fenlei_field
-- ----------------------------
INSERT INTO `temmoku_fenlei_field` VALUES ('27', '单行文本', 'field_74861', 'INT', '11', 'Text', '斤', '7', '0', '1', '0', '', '1', '0', '', '', '0', '单行文本', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('28', '复选框', 'field_1045', '', '0', 'Checkbox', '', '7', '0', '0', '0', '值|||名称@@@1\r\n值1|||名称', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('29', '日期时间', 'field_3301', '', '0', 'Date', '', '7', '1', '0', '0', 'Y-m-d H:i', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('30', '单文件', 'field_4623', '', '0', 'File', '', '7', '0', '1', '0', '.gif .jpg .jpeg .zip .png .rar', '0', '0', '', '', '0', '', 'a:5:{s:7:\"up_type\";s:3:\"rar\";s:7:\"is_down\";s:1:\"0\";s:20:\"ziduan_down_url_list\";s:0:\"\";s:4:\"play\";s:7:\"jplayer\";s:4:\"size\";s:4:\"1000\";}', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('32', '多文件', 'field_8615', '', '0', 'Files', '', '7', '0', '0', '0', '.gif .jpg .jpeg .zip .png .rar', '0', '0', '', '', '0', '', 'a:3:{s:7:\"up_type\";s:6:\"images\";s:4:\"play\";s:7:\"jplayer\";s:4:\"size\";s:4:\"1000\";}', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('33', '单选按钮', 'field_7971', '', '0', 'Radio', '', '7', '0', '0', '0', '值1|||名称1\r\n值2|||名称2@@@1', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('34', '下拉选择框', 'field_3472', '', '0', 'Select', '个', '7', '1', '1', '0', '值|||名称\r\n值1|||名称1\r\n值2|||名称2@@@10', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('35', '多行文本', 'field_1595', '', '0', 'Textarea', '', '7', '0', '1', '0', '', '0', '0', '', '', '0', '', 'N;', '100', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('36', '百度编辑器', 'field_8853', '', '0', 'Ueditor', '', '7', '0', '0', '0', '', '0', '0', '', '', '0', '', 'a:1:{s:12:\"Ueditor_type\";s:1:\"1\";}', '100', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('46', '价格选择器有值', 'field_5682', '', '0', 'Price', '', '7', '0', '1', '1', '白色\r\n黑色\r\n灰色', '0', '0', '', '', '0', '', 'N;', '0', '100');
INSERT INTO `temmoku_fenlei_field` VALUES ('38', '购车服务', 'gcfw', 'VARCHAR', '255', 'Radio', '', '6', '1', '1', '0', '1|||提供挂靠@@@1\r\n2|||可过户\r\n3|||可分期', '1', '0', '/^[0-9-]+$/', '', '0', '字段提示', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('39', '供求', 'wanted', 'VARCHAR', '255', 'Radio', '', '6', '0', '1', '0', '1|||出售@@@1\r\n2|||求购', '0', '0', '', '', '0', '', 'N;', '0', '100');
INSERT INTO `temmoku_fenlei_field` VALUES ('40', '排放标准', 'pfbz', 'VARCHAR', '255', 'Select', '', '6', '1', '1', '0', '5|||国五@@@1\r\n4|||国四\r\n3|||国三\r\n2|||国二', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('41', '马力', 'qcml', 'SMALLINT', '3', 'Text', '', '6', '0', '1', '0', '', '1', '0', '', '', '0', '对字段简短的提示', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('42', '公里数', 'gongli', 'VARCHAR', '255', 'Text', '公里', '6', '1', '0', '0', '', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('43', '车辆年份', 'clnf', 'VARCHAR', '255', 'Select', '', '6', '0', '1', '0', '2019|||2019年@@@1\r\n2018|||2018年\r\n2017|||2017年', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('44', '驱动形式', 'qdxs', 'VARCHAR', '255', 'Select', '', '6', '0', '1', '0', '1|||4*2@@@1\r\n2|||6*2\r\n3|||6*4\r\n4|||6*6\r\n5|||8*2\r\n6|||8*4', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('45', '属性名称', 'field_6365', 'VARCHAR', '255', 'Checkbox', '', '6', '1', '1', '0', '值|||名称@@@1\r\n值1|||名称1@@@1', '0', '0', '', '', '0', '', 'N;', '0', '0');
INSERT INTO `temmoku_fenlei_field` VALUES ('47', '价格选择器无值', 'field_5140', '', '0', 'Price', '', '7', '0', '0', '1', '', '0', '0', '', '', '0', '', 'N;', '0', '90');

-- ----------------------------
-- Table structure for temmoku_fenlei_free_refresh
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_free_refresh`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_free_refresh` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `aid` mediumint(9) NOT NULL,
  `uid` mediumint(9) NOT NULL,
  `time` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='免费刷新';


-- ----------------------------
-- Table structure for temmoku_fenlei_module
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_module`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_module` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '目录名称',
  `unit` varchar(255) NOT NULL DEFAULT '' COMMENT '价格单位',
  `close` tinyint(1) NOT NULL DEFAULT '0' COMMENT '禁用？',
  `reorder` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `dirname` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='万能模块模型表';

-- ----------------------------
-- Records of temmoku_fenlei_module
-- ----------------------------
INSERT INTO `temmoku_fenlei_module` VALUES ('6', '货车服务-&gt;汽车分类', '元/月', '0', '0');
INSERT INTO `temmoku_fenlei_module` VALUES ('7', '222', '元/月', '0', '100');

-- ----------------------------
-- Table structure for temmoku_fenlei_photo
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_photo`;
CREATE TABLE IF NOT EXISTS `temmoku_fenlei_photo` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `aid` mediumint(9) NOT NULL,
  `name` varchar(255) DEFAULT '',
  `picurl` varchar(255) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='图片库';


-- ----------------------------
-- Table structure for temmoku_fenlei_setting
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_fenlei_setting`;
CREATE TABLE IF NOT EXISTS`temmoku_fenlei_setting` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `s_key` varchar(255) DEFAULT NULL,
  `s_name` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of temmoku_fenlei_setting
-- ----------------------------
INSERT INTO `temmoku_fenlei_setting` VALUES ('1', 'webstate', '1');
INSERT INTO `temmoku_fenlei_setting` VALUES ('2', 'name', '分类信息');
INSERT INTO `temmoku_fenlei_setting` VALUES ('3', 'way_close', '模块关闭原因');
INSERT INTO `temmoku_fenlei_setting` VALUES ('4', 'unit', '件\r\n套\r\n个\r\n只\r\n台');
INSERT INTO `temmoku_fenlei_setting` VALUES ('5', 'url_rules', '2');

