<?php

/**
 * The phpMyFAQ instances database class with CREATE TABLE statements
 * for the stop words.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/
 *
 * @package   phpMyFAQ
 * @author    Thorsten Rinne <thorsten@phpmyfaq.de>
 * @copyright 2015-2020 phpMyFAQ Team
 * @license   http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link      https://www.phpmyfaq.de
 * @since     2015-09-05
 */

namespace phpMyFAQ\Instance\Database;

use phpMyFAQ\Configuration;

/**
 * Class Stopwords
 *
 * @package phpMyFAQ\Instance\Database
 */
class Stopwords
{
    /**
     * @var array
     */
    private $insertQueries = [
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (0, 'cs', 'dnes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1, 'cs', 'cz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2, 'cs', 'timto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3, 'cs', 'budes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (4, 'cs', 'budem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (5, 'cs', 'byli')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (6, 'cs', 'jses')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (7, 'cs', 'muj')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (8, 'cs', 'svym')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (9, 'cs', 'ta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (10, 'cs', 'tomto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (11, 'cs', 'tohle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (12, 'cs', 'tuto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (13, 'cs', 'tyto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (14, 'cs', 'jej')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (15, 'cs', 'zda')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (16, 'cs', 'proc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (17, 'cs', 'mate')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (18, 'cs', 'tato')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (19, 'cs', 'kam')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (20, 'cs', 'tohoto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (21, 'cs', 'kdo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (22, 'cs', 'kteri')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (23, 'cs', 'mi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (24, 'cs', 'nam')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (25, 'cs', 'tom')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (26, 'cs', 'tomuto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (27, 'cs', 'mit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (28, 'cs', 'nic')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (29, 'cs', 'proto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (30, 'cs', 'kterou')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (31, 'cs', 'byla')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (32, 'cs', 'toho')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (33, 'cs', 'protoze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (34, 'cs', 'asi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (35, 'cs', 'ho')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (36, 'cs', 'nasi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (37, 'cs', 'napiste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (38, 'cs', 're')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (39, 'cs', 'coz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (40, 'cs', 'tim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (41, 'cs', 'takze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (42, 'cs', 'svych')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (43, 'cs', 'jeji')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (44, 'cs', 'svymi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (45, 'cs', 'jste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (46, 'cs', 'aj')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (47, 'cs', 'tu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (48, 'cs', 'tedy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (49, 'cs', 'teto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (50, 'cs', 'bylo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (51, 'cs', 'kde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (52, 'cs', 'ke')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (53, 'cs', 'prave')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (54, 'cs', 'ji')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (55, 'cs', 'nad')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (56, 'cs', 'nejsou')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (57, 'cs', 'ci')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (58, 'cs', 'pod')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (59, 'cs', 'tema')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (60, 'cs', 'mezi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (61, 'cs', 'pres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (62, 'cs', 'ty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (63, 'cs', 'pak')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (64, 'cs', 'vam')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (65, 'cs', 'ani')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (66, 'cs', 'kdyz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (67, 'cs', 'vsak')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (68, 'cs', 'ne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (69, 'cs', 'jsem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (70, 'cs', 'tento')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (71, 'cs', 'clanku')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (72, 'cs', 'clanky')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (73, 'cs', 'aby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (74, 'cs', 'jsme')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (75, 'cs', 'pred')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (76, 'cs', 'pta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (77, 'cs', 'jejich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (78, 'cs', 'byl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (79, 'cs', 'jeste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (80, 'cs', 'az')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (81, 'cs', 'bez')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (82, 'cs', 'take')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (83, 'cs', 'pouze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (84, 'cs', 'prvni')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (85, 'cs', 'vase')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (86, 'cs', 'ktera')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (87, 'cs', 'nas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (88, 'cs', 'novy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (89, 'cs', 'tipy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (90, 'cs', 'pokud')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (91, 'cs', 'muze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (92, 'cs', 'design')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (93, 'cs', 'strana')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (94, 'cs', 'jeho')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (95, 'cs', 'sve')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (96, 'cs', 'jine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (97, 'cs', 'zpravy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (98, 'cs', 'nove')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (99, 'cs', 'neni')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (100, 'cs', 'vas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (101, 'cs', 'jen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (102, 'cs', 'podle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (103, 'cs', 'zde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (104, 'cs', 'clanek')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (105, 'cs', 'uz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (106, 'cs', 'email')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (107, 'cs', 'byt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (108, 'cs', 'vice')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (109, 'cs', 'bude')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (110, 'cs', 'jiz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (111, 'cs', 'nez')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (112, 'cs', 'ktery')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (113, 'cs', 'by')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (114, 'cs', 'ktere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (115, 'cs', 'co')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (116, 'cs', 'nebo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (117, 'cs', 'ten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (118, 'cs', 'tak')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (119, 'cs', 'ma')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (120, 'cs', 'pri')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (121, 'cs', 'od')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (122, 'cs', 'po')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (123, 'cs', 'jsou')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (124, 'cs', 'jak')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (125, 'cs', 'dalsi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (126, 'cs', 'ale')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (127, 'cs', 'si')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (128, 'cs', 've')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (129, 'cs', 'to')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (130, 'cs', 'jako')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (131, 'cs', 'za')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (132, 'cs', 'zpet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (133, 'cs', 'ze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (134, 'cs', 'do')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (135, 'cs', 'pro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (136, 'cs', 'je')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (137, 'da', 'af')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (138, 'da', 'alle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (139, 'da', 'andet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (140, 'da', 'andre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (141, 'da', 'at')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (142, 'da', 'begge')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (143, 'da', 'da')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (144, 'da', 'de')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (145, 'da', 'den')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (146, 'da', 'denne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (147, 'da', 'der')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (148, 'da', 'deres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (149, 'da', 'det')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (150, 'da', 'dette')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (151, 'da', 'dig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (152, 'da', 'din')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (153, 'da', 'dog')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (154, 'da', 'du')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (155, 'da', 'ej')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (156, 'da', 'eller')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (157, 'da', 'en')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (158, 'da', 'end')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (159, 'da', 'ene')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (160, 'da', 'eneste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (161, 'da', 'enhver')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (162, 'da', 'et')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (163, 'da', 'fem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (164, 'da', 'fire')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (165, 'da', 'flere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (166, 'da', 'fleste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (167, 'da', 'for')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (168, 'da', 'fordi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (169, 'da', 'forrige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (170, 'da', 'fra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (171, 'da', 'f√•')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (172, 'da', 'f√∏r')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (173, 'da', 'god')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (174, 'da', 'han')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (175, 'da', 'hans')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (176, 'da', 'har')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (177, 'da', 'hendes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (178, 'da', 'her')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (179, 'da', 'hun')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (180, 'da', 'hvad')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (181, 'da', 'hvem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (182, 'da', 'hver')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (183, 'da', 'hvilken')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (184, 'da', 'hvis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (185, 'da', 'hvor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (186, 'da', 'hvordan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (187, 'da', 'hvorfor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (188, 'da', 'hvorn√•r')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (189, 'da', 'i')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (190, 'da', 'ikke')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (191, 'da', 'ind')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (192, 'da', 'ingen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (193, 'da', 'intet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (194, 'da', 'jeg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (195, 'da', 'jeres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (196, 'da', 'kan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (197, 'da', 'kom')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (198, 'da', 'kommer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (199, 'da', 'lav')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (200, 'da', 'lidt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (201, 'da', 'lille')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (202, 'da', 'man mand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (203, 'da', 'mange')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (204, 'da', 'med')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (205, 'da', 'meget')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (206, 'da', 'men')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (207, 'da', 'mens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (208, 'da', 'mere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (209, 'da', 'mig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (210, 'da', 'ned')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (211, 'da', 'ni')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (212, 'da', 'nogen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (213, 'da', 'noget')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (214, 'da', 'ny')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (215, 'da', 'nyt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (216, 'da', 'n√¶r')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (217, 'da', 'n√¶ste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (218, 'da', 'n√¶sten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (219, 'da', 'og')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (220, 'da', 'op')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (221, 'da', 'otte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (222, 'da', 'over')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (223, 'da', 'p√•')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (224, 'da', 'se')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (225, 'da', 'seks')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (226, 'da', 'ses')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (227, 'da', 'som')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (228, 'da', 'stor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (229, 'da', 'store')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (230, 'da', 'syv')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (231, 'da', 'ti')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (232, 'da', 'til')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (233, 'da', 'to')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (234, 'da', 'tre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (235, 'da', 'ud')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (236, 'de', 'ab')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (237, 'de', 'bei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (238, 'de', 'da')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (239, 'de', 'deshalb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (240, 'de', 'ein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (241, 'de', 'für')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (242, 'de', 'haben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (243, 'de', 'hier')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (244, 'de', 'ich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (245, 'de', 'ja')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (246, 'de', 'kann')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (247, 'de', 'machen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (248, 'de', 'muesste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (249, 'de', 'nach')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (250, 'de', 'oder')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (251, 'de', 'seid')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (252, 'de', 'sonst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (253, 'de', 'und')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (254, 'de', 'vom')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (255, 'de', 'wann')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (256, 'de', 'wenn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (257, 'de', 'wie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (258, 'de', 'zu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (259, 'de', 'bin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (260, 'de', 'eines')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (261, 'de', 'hat')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (262, 'de', 'manche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (263, 'de', 'solches')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (264, 'de', 'an')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (265, 'de', 'anderm')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (266, 'de', 'bis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (267, 'de', 'das')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (268, 'de', 'deinem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (269, 'de', 'demselben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (270, 'de', 'dir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (271, 'de', 'doch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (272, 'de', 'einig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (273, 'de', 'er')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (274, 'de', 'eurer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (275, 'de', 'hatte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (276, 'de', 'ihnen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (277, 'de', 'ihre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (278, 'de', 'ins')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (279, 'de', 'jenen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (280, 'de', 'keinen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (281, 'de', 'manchem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (282, 'de', 'meinen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (283, 'de', 'nichts')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (284, 'de', 'seine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (285, 'de', 'soll')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (286, 'de', 'unserm')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (287, 'de', 'welche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (288, 'de', 'werden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (289, 'de', 'wollte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (290, 'de', 'während')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (291, 'de', 'alle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (292, 'de', 'allem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (293, 'de', 'allen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (294, 'de', 'aller')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (295, 'de', 'alles')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (296, 'de', 'als')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (297, 'de', 'also')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (298, 'de', 'am')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (299, 'de', 'ander')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (300, 'de', 'andere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (301, 'de', 'anderem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (302, 'de', 'anderen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (303, 'de', 'anderer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (304, 'de', 'anderes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (305, 'de', 'andern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (306, 'de', 'anderr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (307, 'de', 'anders')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (308, 'de', 'auch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (309, 'de', 'auf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (310, 'de', 'aus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (311, 'de', 'bist')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (312, 'de', 'bsp.')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (313, 'de', 'daher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (314, 'de', 'damit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (315, 'de', 'dann')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (316, 'de', 'dasselbe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (317, 'de', 'dazu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (318, 'de', 'daß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (319, 'de', 'dein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (320, 'de', 'deine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (321, 'de', 'deinen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (322, 'de', 'deiner')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (323, 'de', 'deines')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (324, 'de', 'dem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (325, 'de', 'den')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (326, 'de', 'denn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (327, 'de', 'denselben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (328, 'de', 'der')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (329, 'de', 'derer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (330, 'de', 'derselbe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (331, 'de', 'derselben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (332, 'de', 'des')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (333, 'de', 'desselben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (334, 'de', 'dessen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (335, 'de', 'dich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (336, 'de', 'die')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (337, 'de', 'dies')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (338, 'de', 'diese')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (339, 'de', 'dieselbe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (340, 'de', 'dieselben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (341, 'de', 'diesem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (342, 'de', 'diesen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (343, 'de', 'dieser')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (344, 'de', 'dieses')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (345, 'de', 'dort')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (346, 'de', 'du')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (347, 'de', 'durch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (348, 'de', 'eine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (349, 'de', 'einem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (350, 'de', 'einen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (351, 'de', 'einer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (352, 'de', 'einige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (353, 'de', 'einigem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (354, 'de', 'einigen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (355, 'de', 'einiger')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (356, 'de', 'einiges')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (357, 'de', 'einmal')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (358, 'de', 'es')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (359, 'de', 'etwas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (360, 'de', 'euch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (361, 'de', 'euer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (362, 'de', 'eure')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (363, 'de', 'eurem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (364, 'de', 'euren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (365, 'de', 'eures')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (366, 'de', 'ganz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (367, 'de', 'ganze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (368, 'de', 'ganzen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (369, 'de', 'ganzer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (370, 'de', 'ganzes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (371, 'de', 'gegen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (372, 'de', 'gemacht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (373, 'de', 'gesagt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (374, 'de', 'gesehen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (375, 'de', 'gewesen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (376, 'de', 'gewollt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (377, 'de', 'hab')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (378, 'de', 'habe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (379, 'de', 'hatten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (380, 'de', 'hin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (381, 'de', 'hinter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (382, 'de', 'ihm')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (383, 'de', 'ihn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (384, 'de', 'ihr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (385, 'de', 'ihrem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (386, 'de', 'ihren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (387, 'de', 'ihrer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (388, 'de', 'ihres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (389, 'de', 'im')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (390, 'de', 'in')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (391, 'de', 'indem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (392, 'de', 'ist')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (393, 'de', 'jede')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (394, 'de', 'jedem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (395, 'de', 'jeden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (396, 'de', 'jeder')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (397, 'de', 'jedes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (398, 'de', 'jene')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (399, 'de', 'jenem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (400, 'de', 'jener')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (401, 'de', 'jenes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (402, 'de', 'jetzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (403, 'de', 'kein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (404, 'de', 'keine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (405, 'de', 'keinem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (406, 'de', 'keiner')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (407, 'de', 'keines')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (408, 'de', 'konnte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (409, 'de', 'können')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (410, 'de', 'könnte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (411, 'de', 'mache')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (412, 'de', 'machst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (413, 'de', 'macht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (414, 'de', 'machte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (415, 'de', 'machten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (416, 'de', 'man')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (417, 'de', 'manchen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (418, 'de', 'mancher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (419, 'de', 'manches')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (420, 'de', 'mein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (421, 'de', 'meine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (422, 'de', 'meinem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (423, 'de', 'meiner')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (424, 'de', 'meines')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (425, 'de', 'mich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (426, 'de', 'mir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (427, 'de', 'mit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (428, 'de', 'muss')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (429, 'de', 'musste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (430, 'de', 'müßt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (431, 'de', 'nicht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (432, 'de', 'noch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (433, 'de', 'nun')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (434, 'de', 'nur')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (435, 'de', 'ob')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (436, 'de', 'ohne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (437, 'de', 'sage')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (438, 'de', 'sagen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (439, 'de', 'sagt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (440, 'de', 'sagte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (441, 'de', 'sagten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (442, 'de', 'sagtest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (443, 'de', 'sehe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (444, 'de', 'sehen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (445, 'de', 'sehr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (446, 'de', 'seht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (447, 'de', 'sein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (448, 'de', 'seinem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (449, 'de', 'seinen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (450, 'de', 'seiner')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (451, 'de', 'seines')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (452, 'de', 'selbst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (453, 'de', 'sich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (454, 'de', 'sicher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (455, 'de', 'sie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (456, 'de', 'sind')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (457, 'de', 'so')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (458, 'de', 'solche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (459, 'de', 'solchem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (460, 'de', 'solchen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (461, 'de', 'solcher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (462, 'de', 'sollte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (463, 'de', 'sondern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (464, 'de', 'um')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (465, 'de', 'uns')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (466, 'de', 'unse')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (467, 'de', 'unsen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (468, 'de', 'unser')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (469, 'de', 'unses')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (470, 'de', 'unter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (471, 'de', 'viel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (472, 'de', 'von')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (473, 'de', 'vor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (474, 'de', 'war')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (475, 'de', 'waren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (476, 'de', 'warst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (477, 'de', 'was')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (478, 'de', 'weg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (479, 'de', 'weil')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (480, 'de', 'weiter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (481, 'de', 'welchem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (482, 'de', 'welchen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (483, 'de', 'welcher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (484, 'de', 'welches')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (485, 'de', 'werde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (486, 'de', 'wieder')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (487, 'de', 'will')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (488, 'de', 'wir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (489, 'de', 'wird')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (490, 'de', 'wirst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (491, 'de', 'wo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (492, 'de', 'wolle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (493, 'de', 'wollen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (494, 'de', 'wollt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (495, 'de', 'wollten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (496, 'de', 'wolltest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (497, 'de', 'wolltet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (498, 'de', 'würde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (499, 'de', 'würden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (500, 'de', 'z.B.')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (501, 'de', 'zum')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (502, 'de', 'zur')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (503, 'de', 'zwar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (504, 'de', 'zwischen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (505, 'de', 'über')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (506, 'de', 'aber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (507, 'de', 'abgerufen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (508, 'de', 'abgerufene')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (509, 'de', 'abgerufener')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (510, 'de', 'abgerufenes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (511, 'de', 'acht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (512, 'de', 'acute')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (513, 'de', 'allein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (514, 'de', 'allerdings')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (515, 'de', 'allerlei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (516, 'de', 'allg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (517, 'de', 'allgemein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (518, 'de', 'allmählich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (519, 'de', 'allzu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (520, 'de', 'alsbald')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (521, 'de', 'amp')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (522, 'de', 'and')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (523, 'de', 'andererseits')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (524, 'de', 'andernfalls')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (525, 'de', 'anerkannt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (526, 'de', 'anerkannte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (527, 'de', 'anerkannter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (528, 'de', 'anerkanntes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (529, 'de', 'anfangen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (530, 'de', 'anfing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (531, 'de', 'angefangen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (532, 'de', 'angesetze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (533, 'de', 'angesetzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (534, 'de', 'angesetzten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (535, 'de', 'angesetzter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (536, 'de', 'ansetzen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (537, 'de', 'anstatt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (538, 'de', 'arbeiten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (539, 'de', 'aufgehört')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (540, 'de', 'aufgrund')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (541, 'de', 'aufhören')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (542, 'de', 'aufhörte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (543, 'de', 'aufzusuchen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (544, 'de', 'ausdrücken')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (545, 'de', 'ausdrückt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (546, 'de', 'ausdrückte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (547, 'de', 'ausgenommen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (548, 'de', 'ausser')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (549, 'de', 'ausserdem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (550, 'de', 'author')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (551, 'de', 'autor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (552, 'de', 'außen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (553, 'de', 'außer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (554, 'de', 'außerdem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (555, 'de', 'außerhalb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (556, 'de', 'background')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (557, 'de', 'bald')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (558, 'de', 'bearbeite')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (559, 'de', 'bearbeiten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (560, 'de', 'bearbeitete')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (561, 'de', 'bearbeiteten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (562, 'de', 'bedarf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (563, 'de', 'bedurfte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (564, 'de', 'bedürfen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (565, 'de', 'been')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (566, 'de', 'befragen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (567, 'de', 'befragte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (568, 'de', 'befragten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (569, 'de', 'befragter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (570, 'de', 'begann')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (571, 'de', 'beginnen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (572, 'de', 'begonnen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (573, 'de', 'behalten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (574, 'de', 'behielt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (575, 'de', 'beide')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (576, 'de', 'beiden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (577, 'de', 'beiderlei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (578, 'de', 'beides')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (579, 'de', 'beim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (580, 'de', 'beinahe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (581, 'de', 'beitragen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (582, 'de', 'beitrugen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (583, 'de', 'bekannt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (584, 'de', 'bekannte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (585, 'de', 'bekannter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (586, 'de', 'bekennen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (587, 'de', 'benutzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (588, 'de', 'bereits')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (589, 'de', 'berichten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (590, 'de', 'berichtet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (591, 'de', 'berichtete')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (592, 'de', 'berichteten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (593, 'de', 'besonders')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (594, 'de', 'besser')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (595, 'de', 'bestehen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (596, 'de', 'besteht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (597, 'de', 'beträchtlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (598, 'de', 'bevor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (599, 'de', 'bezüglich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (600, 'de', 'bietet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (601, 'de', 'bisher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (602, 'de', 'bislang')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (603, 'de', 'biz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (604, 'de', 'bleiben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (605, 'de', 'blieb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (606, 'de', 'bloss')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (607, 'de', 'bloß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (608, 'de', 'border')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (609, 'de', 'brachte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (610, 'de', 'brachten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (611, 'de', 'brauchen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (612, 'de', 'braucht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (613, 'de', 'bringen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (614, 'de', 'bräuchte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (615, 'de', 'bzw')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (616, 'de', 'böden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (617, 'de', 'ca')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (618, 'de', 'ca.')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (619, 'de', 'collapsed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (620, 'de', 'com')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (621, 'de', 'comment')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (622, 'de', 'content')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (623, 'de', 'da?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (624, 'de', 'dabei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (625, 'de', 'dadurch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (626, 'de', 'dafür')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (627, 'de', 'dagegen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (628, 'de', 'dahin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (629, 'de', 'damals')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (630, 'de', 'danach')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (631, 'de', 'daneben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (632, 'de', 'dank')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (633, 'de', 'danke')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (634, 'de', 'danken')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (635, 'de', 'dannen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (636, 'de', 'daran')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (637, 'de', 'darauf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (638, 'de', 'daraus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (639, 'de', 'darf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (640, 'de', 'darfst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (641, 'de', 'darin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (642, 'de', 'darum')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (643, 'de', 'darunter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (644, 'de', 'darüber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (645, 'de', 'darüberhinaus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (646, 'de', 'dass')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (647, 'de', 'davon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (648, 'de', 'davor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (649, 'de', 'demnach')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (650, 'de', 'denen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (651, 'de', 'dennoch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (652, 'de', 'derart')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (653, 'de', 'derartig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (654, 'de', 'derem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (655, 'de', 'deren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (656, 'de', 'derjenige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (657, 'de', 'derjenigen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (658, 'de', 'derzeit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (659, 'de', 'desto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (660, 'de', 'deswegen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (661, 'de', 'diejenige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (662, 'de', 'diesseits')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (663, 'de', 'dinge')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (664, 'de', 'direkt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (665, 'de', 'direkte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (666, 'de', 'direkten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (667, 'de', 'direkter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (668, 'de', 'doc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (669, 'de', 'doppelt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (670, 'de', 'dorther')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (671, 'de', 'dorthin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (672, 'de', 'drauf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (673, 'de', 'drei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (674, 'de', 'dreißig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (675, 'de', 'drin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (676, 'de', 'dritte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (677, 'de', 'drunter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (678, 'de', 'drüber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (679, 'de', 'dunklen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (680, 'de', 'durchaus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (681, 'de', 'durfte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (682, 'de', 'durften')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (683, 'de', 'dürfen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (684, 'de', 'dürfte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (685, 'de', 'eben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (686, 'de', 'ebenfalls')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (687, 'de', 'ebenso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (688, 'de', 'ehe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (689, 'de', 'eher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (690, 'de', 'eigenen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (691, 'de', 'eigenes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (692, 'de', 'eigentlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (693, 'de', 'einbaün')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (694, 'de', 'einerseits')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (695, 'de', 'einfach')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (696, 'de', 'einführen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (697, 'de', 'einführte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (698, 'de', 'einführten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (699, 'de', 'eingesetzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (700, 'de', 'einigermaßen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (701, 'de', 'eins')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (702, 'de', 'einseitig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (703, 'de', 'einseitige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (704, 'de', 'einseitigen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (705, 'de', 'einseitiger')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (706, 'de', 'einst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (707, 'de', 'einstmals')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (708, 'de', 'einzig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (709, 'de', 'elf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (710, 'de', 'ende')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (711, 'de', 'entsprechend')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (712, 'de', 'entweder')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (713, 'de', 'ergänze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (714, 'de', 'ergänzen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (715, 'de', 'ergänzte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (716, 'de', 'ergänzten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (717, 'de', 'erhalten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (718, 'de', 'erhielt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (719, 'de', 'erhielten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (720, 'de', 'erhält')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (721, 'de', 'erneut')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (722, 'de', 'erst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (723, 'de', 'erste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (724, 'de', 'ersten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (725, 'de', 'erster')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (726, 'de', 'eröffne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (727, 'de', 'eröffnen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (728, 'de', 'eröffnet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (729, 'de', 'eröffnete')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (730, 'de', 'eröffnetes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (731, 'de', 'etc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (732, 'de', 'etliche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (733, 'de', 'etwa')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (734, 'de', 'fall')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (735, 'de', 'falls')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (736, 'de', 'fand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (737, 'de', 'fast')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (738, 'de', 'ferner')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (739, 'de', 'finden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (740, 'de', 'findest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (741, 'de', 'findet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (742, 'de', 'folgende')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (743, 'de', 'folgenden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (744, 'de', 'folgender')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (745, 'de', 'folgendes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (746, 'de', 'folglich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (747, 'de', 'for')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (748, 'de', 'fordern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (749, 'de', 'fordert')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (750, 'de', 'forderte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (751, 'de', 'forderten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (752, 'de', 'fortsetzen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (753, 'de', 'fortsetzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (754, 'de', 'fortsetzte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (755, 'de', 'fortsetzten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (756, 'de', 'fragte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (757, 'de', 'frau')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (758, 'de', 'frei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (759, 'de', 'freie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (760, 'de', 'freier')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (761, 'de', 'freies')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (762, 'de', 'fuer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (763, 'de', 'fünf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (764, 'de', 'gab')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (765, 'de', 'ganzem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (766, 'de', 'gar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (767, 'de', 'gbr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (768, 'de', 'geb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (769, 'de', 'geben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (770, 'de', 'geblieben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (771, 'de', 'gebracht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (772, 'de', 'gedurft')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (773, 'de', 'geehrt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (774, 'de', 'geehrte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (775, 'de', 'geehrten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (776, 'de', 'geehrter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (777, 'de', 'gefallen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (778, 'de', 'gefiel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (779, 'de', 'gefälligst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (780, 'de', 'gefällt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (781, 'de', 'gegeben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (782, 'de', 'gehabt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (783, 'de', 'gehen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (784, 'de', 'geht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (785, 'de', 'gekommen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (786, 'de', 'gekonnt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (787, 'de', 'gemocht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (788, 'de', 'gemäss')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (789, 'de', 'genommen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (790, 'de', 'genug')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (791, 'de', 'gern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (792, 'de', 'gestern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (793, 'de', 'gestrige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (794, 'de', 'getan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (795, 'de', 'geteilt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (796, 'de', 'geteilte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (797, 'de', 'getragen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (798, 'de', 'gewissermaßen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (799, 'de', 'geworden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (800, 'de', 'ggf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (801, 'de', 'gib')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (802, 'de', 'gibt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (803, 'de', 'gleich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (804, 'de', 'gleichwohl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (805, 'de', 'gleichzeitig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (806, 'de', 'glücklicherweise')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (807, 'de', 'gmbh')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (808, 'de', 'gratulieren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (809, 'de', 'gratuliert')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (810, 'de', 'gratulierte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (811, 'de', 'gute')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (812, 'de', 'guten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (813, 'de', 'gängig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (814, 'de', 'gängige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (815, 'de', 'gängigen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (816, 'de', 'gängiger')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (817, 'de', 'gängiges')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (818, 'de', 'gänzlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (819, 'de', 'haette')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (820, 'de', 'halb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (821, 'de', 'hallo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (822, 'de', 'hast')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (823, 'de', 'hattest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (824, 'de', 'hattet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (825, 'de', 'heraus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (826, 'de', 'herein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (827, 'de', 'heute')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (828, 'de', 'heutige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (829, 'de', 'hiermit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (830, 'de', 'hiesige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (831, 'de', 'hinein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (832, 'de', 'hinten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (833, 'de', 'hinterher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (834, 'de', 'hoch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (835, 'de', 'html')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (836, 'de', 'http')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (837, 'de', 'hundert')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (838, 'de', 'hätt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (839, 'de', 'hätte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (840, 'de', 'hätten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (841, 'de', 'höchstens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (842, 'de', 'igitt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (843, 'de', 'image')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (844, 'de', 'immer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (845, 'de', 'immerhin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (846, 'de', 'important')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (847, 'de', 'indessen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (848, 'de', 'info')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (849, 'de', 'infolge')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (850, 'de', 'innen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (851, 'de', 'innerhalb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (852, 'de', 'insofern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (853, 'de', 'inzwischen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (854, 'de', 'irgend')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (855, 'de', 'irgendeine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (856, 'de', 'irgendwas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (857, 'de', 'irgendwen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (858, 'de', 'irgendwer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (859, 'de', 'irgendwie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (860, 'de', 'irgendwo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (861, 'de', 'je')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (862, 'de', 'jed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (863, 'de', 'jedenfalls')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (864, 'de', 'jederlei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (865, 'de', 'jedoch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (866, 'de', 'jemand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (867, 'de', 'jenseits')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (868, 'de', 'jährig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (869, 'de', 'jährige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (870, 'de', 'jährigen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (871, 'de', 'jähriges')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (872, 'de', 'kam')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (873, 'de', 'kannst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (874, 'de', 'kaum')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (875, 'de', 'kei nes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (876, 'de', 'keinerlei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (877, 'de', 'keineswegs')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (878, 'de', 'klar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (879, 'de', 'klare')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (880, 'de', 'klaren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (881, 'de', 'klares')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (882, 'de', 'klein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (883, 'de', 'kleinen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (884, 'de', 'kleiner')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (885, 'de', 'kleines')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (886, 'de', 'koennen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (887, 'de', 'koennt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (888, 'de', 'koennte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (889, 'de', 'koennten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (890, 'de', 'komme')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (891, 'de', 'kommen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (892, 'de', 'kommt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (893, 'de', 'konkret')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (894, 'de', 'konkrete')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (895, 'de', 'konkreten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (896, 'de', 'konkreter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (897, 'de', 'konkretes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (898, 'de', 'konnten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (899, 'de', 'könn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (900, 'de', 'könnt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (901, 'de', 'könnten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (902, 'de', 'künftig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (903, 'de', 'lag')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (904, 'de', 'lagen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (905, 'de', 'langsam')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (906, 'de', 'lassen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (907, 'de', 'laut')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (908, 'de', 'lediglich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (909, 'de', 'leer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (910, 'de', 'legen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (911, 'de', 'legte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (912, 'de', 'legten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (913, 'de', 'leicht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (914, 'de', 'leider')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (915, 'de', 'lesen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (916, 'de', 'letze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (917, 'de', 'letzten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (918, 'de', 'letztendlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (919, 'de', 'letztens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (920, 'de', 'letztes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (921, 'de', 'letztlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (922, 'de', 'lichten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (923, 'de', 'liegt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (924, 'de', 'liest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (925, 'de', 'links')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (926, 'de', 'längst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (927, 'de', 'längstens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (928, 'de', 'mag')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (929, 'de', 'magst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (930, 'de', 'mal')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (931, 'de', 'mancherorts')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (932, 'de', 'manchmal')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (933, 'de', 'mann')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (934, 'de', 'margin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (935, 'de', 'med')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (936, 'de', 'mehr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (937, 'de', 'mehrere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (938, 'de', 'meist')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (939, 'de', 'meiste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (940, 'de', 'meisten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (941, 'de', 'meta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (942, 'de', 'mindestens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (943, 'de', 'mithin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (944, 'de', 'mochte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (945, 'de', 'morgen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (946, 'de', 'morgige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (947, 'de', 'muessen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (948, 'de', 'muesst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (949, 'de', 'musst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (950, 'de', 'mussten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (951, 'de', 'muß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (952, 'de', 'mußt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (953, 'de', 'möchte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (954, 'de', 'möchten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (955, 'de', 'möchtest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (956, 'de', 'mögen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (957, 'de', 'möglich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (958, 'de', 'mögliche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (959, 'de', 'möglichen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (960, 'de', 'möglicher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (961, 'de', 'möglicherweise')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (962, 'de', 'müssen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (963, 'de', 'müsste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (964, 'de', 'müssten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (965, 'de', 'müßte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (966, 'de', 'nachdem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (967, 'de', 'nacher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (968, 'de', 'nachhinein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (969, 'de', 'nahm')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (970, 'de', 'natürlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (971, 'de', 'ncht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (972, 'de', 'neben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (973, 'de', 'nebenan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (974, 'de', 'nehmen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (975, 'de', 'nein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (976, 'de', 'neu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (977, 'de', 'neue')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (978, 'de', 'neuem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (979, 'de', 'neuen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (980, 'de', 'neuer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (981, 'de', 'neues')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (982, 'de', 'neun')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (983, 'de', 'nie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (984, 'de', 'niemals')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (985, 'de', 'niemand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (986, 'de', 'nimm')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (987, 'de', 'nimmer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (988, 'de', 'nimmt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (989, 'de', 'nirgends')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (990, 'de', 'nirgendwo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (991, 'de', 'nter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (992, 'de', 'nutzen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (993, 'de', 'nutzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (994, 'de', 'nutzung')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (995, 'de', 'nächste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (996, 'de', 'nämlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (997, 'de', 'nötigenfalls')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (998, 'de', 'nützt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (999, 'de', 'oben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1000, 'de', 'oberhalb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1001, 'de', 'obgleich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1002, 'de', 'obschon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1003, 'de', 'obwohl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1004, 'de', 'oft')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1005, 'de', 'online')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1006, 'de', 'org')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1007, 'de', 'padding')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1008, 'de', 'per')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1009, 'de', 'pfui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1010, 'de', 'plötzlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1011, 'de', 'pro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1012, 'de', 'reagiere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1013, 'de', 'reagieren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1014, 'de', 'reagiert')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1015, 'de', 'reagierte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1016, 'de', 'rechts')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1017, 'de', 'regelmäßig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1018, 'de', 'rief')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1019, 'de', 'rund')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1020, 'de', 'sang')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1021, 'de', 'sangen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1022, 'de', 'schlechter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1023, 'de', 'schließlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1024, 'de', 'schnell')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1025, 'de', 'schon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1026, 'de', 'schreibe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1027, 'de', 'schreiben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1028, 'de', 'schreibens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1029, 'de', 'schreiber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1030, 'de', 'schwierig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1031, 'de', 'schätzen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1032, 'de', 'schätzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1033, 'de', 'schätzte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1034, 'de', 'schätzten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1035, 'de', 'sechs')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1036, 'de', 'sect')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1037, 'de', 'sehrwohl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1038, 'de', 'sei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1039, 'de', 'seit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1040, 'de', 'seitdem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1041, 'de', 'seite')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1042, 'de', 'seiten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1043, 'de', 'seither')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1044, 'de', 'selber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1045, 'de', 'senke')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1046, 'de', 'senken')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1047, 'de', 'senkt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1048, 'de', 'senkte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1049, 'de', 'senkten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1050, 'de', 'setzen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1051, 'de', 'setzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1052, 'de', 'setzte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1053, 'de', 'setzten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1054, 'de', 'sicherlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1055, 'de', 'sieben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1056, 'de', 'siebte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1057, 'de', 'siehe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1058, 'de', 'sieht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1059, 'de', 'singen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1060, 'de', 'singt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1061, 'de', 'sobald')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1062, 'de', 'sodaß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1063, 'de', 'soeben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1064, 'de', 'sofern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1065, 'de', 'sofort')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1066, 'de', 'sog')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1067, 'de', 'sogar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1068, 'de', 'solange')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1069, 'de', 'solc hen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1070, 'de', 'solch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1071, 'de', 'sollen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1072, 'de', 'sollst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1073, 'de', 'sollt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1074, 'de', 'sollten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1075, 'de', 'solltest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1076, 'de', 'somit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1077, 'de', 'sonstwo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1078, 'de', 'sooft')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1079, 'de', 'soviel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1080, 'de', 'soweit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1081, 'de', 'sowie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1082, 'de', 'sowohl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1083, 'de', 'spielen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1084, 'de', 'später')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1085, 'de', 'startet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1086, 'de', 'startete')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1087, 'de', 'starteten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1088, 'de', 'statt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1089, 'de', 'stattdessen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1090, 'de', 'steht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1091, 'de', 'steige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1092, 'de', 'steigen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1093, 'de', 'steigt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1094, 'de', 'stets')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1095, 'de', 'stieg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1096, 'de', 'stiegen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1097, 'de', 'such')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1098, 'de', 'suchen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1099, 'de', 'sämtliche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1100, 'de', 'tages')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1101, 'de', 'tat')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1102, 'de', 'tatsächlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1103, 'de', 'tatsächlichen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1104, 'de', 'tatsächlicher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1105, 'de', 'tatsächliches')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1106, 'de', 'tausend')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1107, 'de', 'teile')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1108, 'de', 'teilen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1109, 'de', 'teilte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1110, 'de', 'teilten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1111, 'de', 'titel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1112, 'de', 'total')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1113, 'de', 'trage')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1114, 'de', 'tragen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1115, 'de', 'trotzdem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1116, 'de', 'trug')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1117, 'de', 'trägt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1118, 'de', 'tun')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1119, 'de', 'tust')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1120, 'de', 'tut')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1121, 'de', 'txt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1122, 'de', 'tät')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1123, 'de', 'ueber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1124, 'de', 'umso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1125, 'de', 'unbedingt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1126, 'de', 'ungefähr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1127, 'de', 'unmöglich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1128, 'de', 'unmögliche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1129, 'de', 'unmöglichen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1130, 'de', 'unmöglicher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1131, 'de', 'unnötig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1132, 'de', 'unsem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1133, 'de', 'unser')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1134, 'de', 'unsere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1135, 'de', 'unserem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1136, 'de', 'unseren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1137, 'de', 'unserer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1138, 'de', 'unseres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1139, 'de', 'unten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1140, 'de', 'unterbrach')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1141, 'de', 'unterbrechen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1142, 'de', 'unterhalb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1143, 'de', 'unwichtig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1144, 'de', 'usw')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1145, 'de', 'var')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1146, 'de', 'vergangen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1147, 'de', 'vergangene')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1148, 'de', 'vergangener')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1149, 'de', 'vergangenes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1150, 'de', 'vermag')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1151, 'de', 'vermutlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1152, 'de', 'vermögen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1153, 'de', 'verrate')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1154, 'de', 'verraten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1155, 'de', 'verriet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1156, 'de', 'verrieten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1157, 'de', 'version')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1158, 'de', 'versorge')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1159, 'de', 'versorgen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1160, 'de', 'versorgt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1161, 'de', 'versorgte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1162, 'de', 'versorgten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1163, 'de', 'versorgtes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1164, 'de', 'veröffentlichen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1165, 'de', 'veröffentlicher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1166, 'de', 'veröffentlicht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1167, 'de', 'veröffentlichte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1168, 'de', 'veröffentlichten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1169, 'de', 'veröffentlichtes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1170, 'de', 'viele')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1171, 'de', 'vielen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1172, 'de', 'vieler')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1173, 'de', 'vieles')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1174, 'de', 'vielleicht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1175, 'de', 'vielmals')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1176, 'de', 'vier')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1177, 'de', 'vollständig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1178, 'de', 'voran')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1179, 'de', 'vorbei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1180, 'de', 'vorgestern')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1181, 'de', 'vorher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1182, 'de', 'vorne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1183, 'de', 'vorüber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1184, 'de', 'völlig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1185, 'de', 'während')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1186, 'de', 'wachen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1187, 'de', 'waere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1188, 'de', 'warum')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1189, 'de', 'weder')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1190, 'de', 'wegen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1191, 'de', 'weitere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1192, 'de', 'weiterem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1193, 'de', 'weiteren')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1194, 'de', 'weiterer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1195, 'de', 'weiteres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1196, 'de', 'weiterhin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1197, 'de', 'weiß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1198, 'de', 'wem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1199, 'de', 'wen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1200, 'de', 'wenig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1201, 'de', 'wenige')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1202, 'de', 'weniger')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1203, 'de', 'wenigstens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1204, 'de', 'wenngleich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1205, 'de', 'wer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1206, 'de', 'werdet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1207, 'de', 'weshalb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1208, 'de', 'wessen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1209, 'de', 'wichtig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1210, 'de', 'wieso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1211, 'de', 'wieviel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1212, 'de', 'wiewohl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1213, 'de', 'willst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1214, 'de', 'wirklich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1215, 'de', 'wodurch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1216, 'de', 'wogegen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1217, 'de', 'woher')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1218, 'de', 'wohin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1219, 'de', 'wohingegen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1220, 'de', 'wohl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1221, 'de', 'wohlweislich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1222, 'de', 'womit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1223, 'de', 'woraufhin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1224, 'de', 'woraus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1225, 'de', 'worin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1226, 'de', 'wurde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1227, 'de', 'wurden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1228, 'de', 'währenddessen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1229, 'de', 'wär')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1230, 'de', 'wäre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1231, 'de', 'wären')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1232, 'de', 'zahlreich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1233, 'de', 'zehn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1234, 'de', 'zeitweise')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1235, 'de', 'ziehen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1236, 'de', 'zieht')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1237, 'de', 'zog')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1238, 'de', 'zogen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1239, 'de', 'zudem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1240, 'de', 'zuerst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1241, 'de', 'zufolge')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1242, 'de', 'zugleich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1243, 'de', 'zuletzt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1244, 'de', 'zumal')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1245, 'de', 'zurück')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1246, 'de', 'zusammen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1247, 'de', 'zuviel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1248, 'de', 'zwanzig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1249, 'de', 'zwei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1250, 'de', 'zwölf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1251, 'de', 'ähnlich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1252, 'de', 'übel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1253, 'de', 'überall')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1254, 'de', 'überallhin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1255, 'de', 'überdies')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1256, 'de', 'übermorgen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1257, 'de', 'übrig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1258, 'de', 'übrigens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1259, 'en', 'a')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1260, 'en', 'a')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1261, 'en', 'able')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1262, 'en', 'about')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1263, 'en', 'about')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1264, 'en', 'above')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1265, 'en', 'above')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1266, 'en', 'abroad')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1267, 'en', 'according')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1268, 'en', 'accordingly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1269, 'en', 'across')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1270, 'en', 'across')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1271, 'en', 'actually')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1272, 'en', 'adj')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1273, 'en', 'after')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1274, 'en', 'after')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1275, 'en', 'afterwards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1276, 'en', 'afterwards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1277, 'en', 'again')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1278, 'en', 'again')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1279, 'en', 'against')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1280, 'en', 'against')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1281, 'en', 'ago')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1282, 'en', 'ahead')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1283, 'en', 'all')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1284, 'en', 'all')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1285, 'en', 'allow')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1286, 'en', 'allows')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1287, 'en', 'almost')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1288, 'en', 'almost')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1289, 'en', 'alone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1290, 'en', 'alone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1291, 'en', 'along')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1292, 'en', 'along')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1293, 'en', 'alongside')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1294, 'en', 'already')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1295, 'en', 'already')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1296, 'en', 'also')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1297, 'en', 'also')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1298, 'en', 'although')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1299, 'en', 'although')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1300, 'en', 'always')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1301, 'en', 'always')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1302, 'en', 'am')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1303, 'en', 'am')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1304, 'en', 'amid')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1305, 'en', 'amidst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1306, 'en', 'among')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1307, 'en', 'among')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1308, 'en', 'amongst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1309, 'en', 'amongst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1310, 'en', 'amoungst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1311, 'en', 'amount')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1312, 'en', 'an')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1313, 'en', 'an')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1314, 'en', 'and')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1315, 'en', 'and')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1316, 'en', 'another')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1317, 'en', 'another')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1318, 'en', 'any')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1319, 'en', 'any')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1320, 'en', 'anybody')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1321, 'en', 'anyhow')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1322, 'en', 'anyhow')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1323, 'en', 'anyone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1324, 'en', 'anyone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1325, 'en', 'anything')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1326, 'en', 'anything')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1327, 'en', 'anyway')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1328, 'en', 'anyway')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1329, 'en', 'anyways')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1330, 'en', 'anywhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1331, 'en', 'anywhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1332, 'en', 'apart')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1333, 'en', 'appear')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1334, 'en', 'appreciate')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1335, 'en', 'appropriate')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1336, 'en', 'are')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1337, 'en', 'are')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1338, 'en', 'around')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1339, 'en', 'around')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1340, 'en', 'as')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1341, 'en', 'as')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1342, 'en', 'aside')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1343, 'en', 'ask')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1344, 'en', 'asking')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1345, 'en', 'associated')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1346, 'en', 'at')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1347, 'en', 'at')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1348, 'en', 'available')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1349, 'en', 'away')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1350, 'en', 'awfully')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1351, 'en', 'b')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1352, 'en', 'back')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1353, 'en', 'back')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1354, 'en', 'backward')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1355, 'en', 'backwards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1356, 'en', 'be')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1357, 'en', 'be')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1358, 'en', 'became')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1359, 'en', 'became')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1360, 'en', 'because')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1361, 'en', 'because')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1362, 'en', 'become')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1363, 'en', 'become')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1364, 'en', 'becomes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1365, 'en', 'becomes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1366, 'en', 'becoming')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1367, 'en', 'becoming')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1368, 'en', 'been')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1369, 'en', 'been')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1370, 'en', 'before')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1371, 'en', 'before')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1372, 'en', 'beforehand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1373, 'en', 'beforehand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1374, 'en', 'begin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1375, 'en', 'behind')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1376, 'en', 'behind')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1377, 'en', 'being')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1378, 'en', 'being')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1379, 'en', 'believe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1380, 'en', 'below')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1381, 'en', 'below')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1382, 'en', 'beside')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1383, 'en', 'beside')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1384, 'en', 'besides')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1385, 'en', 'besides')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1386, 'en', 'best')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1387, 'en', 'better')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1388, 'en', 'between')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1389, 'en', 'between')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1390, 'en', 'beyond')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1391, 'en', 'beyond')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1392, 'en', 'bill')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1393, 'en', 'both')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1394, 'en', 'both')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1395, 'en', 'bottom')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1396, 'en', 'brief')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1397, 'en', 'but')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1398, 'en', 'but')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1399, 'en', 'by')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1400, 'en', 'by')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1401, 'en', 'c')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1402, 'en', 'call')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1403, 'en', 'came')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1404, 'en', 'can')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1405, 'en', 'can')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1406, 'en', 'cannot')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1407, 'en', 'cannot')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1408, 'en', 'cant')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1409, 'en', 'cant')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1410, 'en', 'caption')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1411, 'en', 'cause')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1412, 'en', 'causes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1413, 'en', 'certain')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1414, 'en', 'certainly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1415, 'en', 'changes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1416, 'en', 'clearly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1417, 'en', 'co')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1418, 'en', 'co')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1419, 'en', 'co.')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1420, 'en', 'com')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1421, 'en', 'come')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1422, 'en', 'comes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1423, 'en', 'computer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1424, 'en', 'con')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1425, 'en', 'concerning')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1426, 'en', 'consequently')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1427, 'en', 'consider')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1428, 'en', 'considering')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1429, 'en', 'contain')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1430, 'en', 'containing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1431, 'en', 'contains')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1432, 'en', 'corresponding')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1433, 'en', 'could')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1434, 'en', 'could')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1435, 'en', 'couldnt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1436, 'en', 'course')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1437, 'en', 'cry')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1438, 'en', 'currently')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1439, 'en', 'd')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1440, 'en', 'dare')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1441, 'en', 'de')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1442, 'en', 'definitely')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1443, 'en', 'describe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1444, 'en', 'described')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1445, 'en', 'despite')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1446, 'en', 'detail')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1447, 'en', 'did')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1448, 'en', 'different')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1449, 'en', 'directly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1450, 'en', 'do')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1451, 'en', 'do')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1452, 'en', 'does')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1453, 'en', 'doing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1454, 'en', 'done')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1455, 'en', 'done')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1456, 'en', 'down')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1457, 'en', 'down')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1458, 'en', 'downwards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1459, 'en', 'due')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1460, 'en', 'during')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1461, 'en', 'during')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1462, 'en', 'e')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1463, 'en', 'each')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1464, 'en', 'each')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1465, 'en', 'edu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1466, 'en', 'eg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1467, 'en', 'eg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1468, 'en', 'eight')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1469, 'en', 'eight')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1470, 'en', 'eighty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1471, 'en', 'either')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1472, 'en', 'either')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1473, 'en', 'eleven')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1474, 'en', 'else')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1475, 'en', 'else')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1476, 'en', 'elsewhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1477, 'en', 'elsewhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1478, 'en', 'empty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1479, 'en', 'end')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1480, 'en', 'ending')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1481, 'en', 'enough')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1482, 'en', 'enough')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1483, 'en', 'entirely')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1484, 'en', 'especially')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1485, 'en', 'et')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1486, 'en', 'etc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1487, 'en', 'etc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1488, 'en', 'even')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1489, 'en', 'even')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1490, 'en', 'ever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1491, 'en', 'ever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1492, 'en', 'evermore')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1493, 'en', 'every')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1494, 'en', 'every')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1495, 'en', 'everybody')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1496, 'en', 'everyone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1497, 'en', 'everyone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1498, 'en', 'everything')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1499, 'en', 'everything')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1500, 'en', 'everywhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1501, 'en', 'everywhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1502, 'en', 'ex')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1503, 'en', 'exactly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1504, 'en', 'example')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1505, 'en', 'except')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1506, 'en', 'except')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1507, 'en', 'f')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1508, 'en', 'fairly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1509, 'en', 'far')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1510, 'en', 'farther')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1511, 'en', 'few')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1512, 'en', 'few')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1513, 'en', 'fewer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1514, 'en', 'fifteen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1515, 'en', 'fifth')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1516, 'en', 'fify')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1517, 'en', 'fill')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1518, 'en', 'find')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1519, 'en', 'fire')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1520, 'en', 'first')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1521, 'en', 'first')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1522, 'en', 'five')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1523, 'en', 'five')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1524, 'en', 'followed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1525, 'en', 'following')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1526, 'en', 'follows')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1527, 'en', 'for')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1528, 'en', 'for')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1529, 'en', 'forever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1530, 'en', 'former')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1531, 'en', 'former')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1532, 'en', 'formerly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1533, 'en', 'formerly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1534, 'en', 'forth')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1535, 'en', 'forty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1536, 'en', 'forward')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1537, 'en', 'found')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1538, 'en', 'found')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1539, 'en', 'four')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1540, 'en', 'four')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1541, 'en', 'from')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1542, 'en', 'from')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1543, 'en', 'front')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1544, 'en', 'full')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1545, 'en', 'further')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1546, 'en', 'further')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1547, 'en', 'furthermore')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1548, 'en', 'g')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1549, 'en', 'get')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1550, 'en', 'get')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1551, 'en', 'gets')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1552, 'en', 'getting')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1553, 'en', 'give')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1554, 'en', 'given')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1555, 'en', 'gives')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1556, 'en', 'go')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1557, 'en', 'go')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1558, 'en', 'goes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1559, 'en', 'going')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1560, 'en', 'gone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1561, 'en', 'got')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1562, 'en', 'gotten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1563, 'en', 'greetings')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1564, 'en', 'h')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1565, 'en', 'had')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1566, 'en', 'had')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1567, 'en', 'half')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1568, 'en', 'happens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1569, 'en', 'hardly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1570, 'en', 'has')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1571, 'en', 'has')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1572, 'en', 'hasnt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1573, 'en', 'have')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1574, 'en', 'have')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1575, 'en', 'having')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1576, 'en', 'he')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1577, 'en', 'he')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1578, 'en', 'hello')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1579, 'en', 'help')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1580, 'en', 'hence')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1581, 'en', 'hence')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1582, 'en', 'her')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1583, 'en', 'her')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1584, 'en', 'here')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1585, 'en', 'here')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1586, 'en', 'hereafter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1587, 'en', 'hereafter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1588, 'en', 'hereby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1589, 'en', 'hereby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1590, 'en', 'herein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1591, 'en', 'herein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1592, 'en', 'hereupon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1593, 'en', 'hereupon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1594, 'en', 'hers')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1595, 'en', 'hers')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1596, 'en', 'herself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1597, 'en', 'herself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1598, 'en', 'hi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1599, 'en', 'him')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1600, 'en', 'him')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1601, 'en', 'himself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1602, 'en', 'himself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1603, 'en', 'his')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1604, 'en', 'his')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1605, 'en', 'hither')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1606, 'en', 'hopefully')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1607, 'en', 'how')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1608, 'en', 'how')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1609, 'en', 'howbeit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1610, 'en', 'however')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1611, 'en', 'however')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1612, 'en', 'hundred')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1613, 'en', 'hundred')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1614, 'en', 'i')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1615, 'en', 'i')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1616, 'en', 'ie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1617, 'en', 'ie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1618, 'en', 'if')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1619, 'en', 'if')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1620, 'en', 'ignored')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1621, 'en', 'immediate')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1622, 'en', 'in')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1623, 'en', 'in')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1624, 'en', 'inasmuch')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1625, 'en', 'inc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1626, 'en', 'inc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1627, 'en', 'inc.')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1628, 'en', 'indeed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1629, 'en', 'indeed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1630, 'en', 'indicate')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1631, 'en', 'indicated')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1632, 'en', 'indicates')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1633, 'en', 'inner')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1634, 'en', 'inside')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1635, 'en', 'insofar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1636, 'en', 'instead')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1637, 'en', 'interest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1638, 'en', 'into')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1639, 'en', 'into')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1640, 'en', 'inward')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1641, 'en', 'is')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1642, 'en', 'is')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1643, 'en', 'it')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1644, 'en', 'it')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1645, 'en', 'its')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1646, 'en', 'its')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1647, 'en', 'itself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1648, 'en', 'itself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1649, 'en', 'j')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1650, 'en', 'just')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1651, 'en', 'k')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1652, 'en', 'keep')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1653, 'en', 'keep')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1654, 'en', 'keeps')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1655, 'en', 'kept')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1656, 'en', 'know')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1657, 'en', 'known')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1658, 'en', 'knows')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1659, 'en', 'l')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1660, 'en', 'last')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1661, 'en', 'last')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1662, 'en', 'lately')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1663, 'en', 'later')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1664, 'en', 'latter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1665, 'en', 'latter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1666, 'en', 'latterly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1667, 'en', 'latterly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1668, 'en', 'least')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1669, 'en', 'least')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1670, 'en', 'less')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1671, 'en', 'less')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1672, 'en', 'lest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1673, 'en', 'let')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1674, 'en', 'like')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1675, 'en', 'liked')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1676, 'en', 'likely')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1677, 'en', 'likewise')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1678, 'en', 'little')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1679, 'en', 'look')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1680, 'en', 'looking')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1681, 'en', 'looks')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1682, 'en', 'low')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1683, 'en', 'lower')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1684, 'en', 'ltd')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1685, 'en', 'ltd')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1686, 'en', 'm')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1687, 'en', 'made')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1688, 'en', 'made')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1689, 'en', 'mainly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1690, 'en', 'make')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1691, 'en', 'makes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1692, 'en', 'many')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1693, 'en', 'many')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1694, 'en', 'may')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1695, 'en', 'may')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1696, 'en', 'maybe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1697, 'en', 'me')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1698, 'en', 'me')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1699, 'en', 'mean')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1700, 'en', 'meantime')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1701, 'en', 'meanwhile')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1702, 'en', 'meanwhile')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1703, 'en', 'merely')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1704, 'en', 'might')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1705, 'en', 'might')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1706, 'en', 'mill')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1707, 'en', 'mine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1708, 'en', 'mine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1709, 'en', 'minus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1710, 'en', 'miss')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1711, 'en', 'more')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1712, 'en', 'more')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1713, 'en', 'moreover')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1714, 'en', 'moreover')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1715, 'en', 'most')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1716, 'en', 'most')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1717, 'en', 'mostly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1718, 'en', 'mostly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1719, 'en', 'move')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1720, 'en', 'mr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1721, 'en', 'mrs')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1722, 'en', 'much')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1723, 'en', 'much')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1724, 'en', 'must')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1725, 'en', 'must')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1726, 'en', 'my')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1727, 'en', 'my')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1728, 'en', 'myself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1729, 'en', 'myself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1730, 'en', 'n')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1731, 'en', 'name')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1732, 'en', 'name')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1733, 'en', 'namely')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1734, 'en', 'namely')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1735, 'en', 'nd')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1736, 'en', 'near')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1737, 'en', 'nearly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1738, 'en', 'necessary')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1739, 'en', 'need')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1740, 'en', 'needs')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1741, 'en', 'neither')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1742, 'en', 'neither')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1743, 'en', 'never')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1744, 'en', 'never')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1745, 'en', 'neverf')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1746, 'en', 'neverless')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1747, 'en', 'nevertheless')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1748, 'en', 'nevertheless')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1749, 'en', 'new')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1750, 'en', 'next')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1751, 'en', 'next')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1752, 'en', 'nine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1753, 'en', 'nine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1754, 'en', 'ninety')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1755, 'en', 'no')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1756, 'en', 'no')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1757, 'en', 'nobody')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1758, 'en', 'nobody')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1759, 'en', 'non')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1760, 'en', 'none')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1761, 'en', 'none')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1762, 'en', 'nonetheless')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1763, 'en', 'noone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1764, 'en', 'noone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1765, 'en', 'no-one')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1766, 'en', 'nor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1767, 'en', 'nor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1768, 'en', 'normally')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1769, 'en', 'not')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1770, 'en', 'not')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1771, 'en', 'nothing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1772, 'en', 'nothing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1773, 'en', 'notwithstanding')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1774, 'en', 'novel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1775, 'en', 'now')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1776, 'en', 'now')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1777, 'en', 'nowhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1778, 'en', 'nowhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1779, 'en', 'o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1780, 'en', 'obviously')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1781, 'en', 'of')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1782, 'en', 'of')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1783, 'en', 'off')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1784, 'en', 'off')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1785, 'en', 'often')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1786, 'en', 'often')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1787, 'en', 'oh')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1788, 'en', 'ok')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1789, 'en', 'okay')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1790, 'en', 'old')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1791, 'en', 'on')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1792, 'en', 'on')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1793, 'en', 'once')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1794, 'en', 'once')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1795, 'en', 'one')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1796, 'en', 'one')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1797, 'en', 'ones')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1798, 'en', 'only')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1799, 'en', 'only')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1800, 'en', 'onto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1801, 'en', 'onto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1802, 'en', 'opposite')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1803, 'en', 'or')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1804, 'en', 'or')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1805, 'en', 'other')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1806, 'en', 'other')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1807, 'en', 'others')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1808, 'en', 'others')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1809, 'en', 'otherwise')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1810, 'en', 'otherwise')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1811, 'en', 'ought')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1812, 'en', 'our')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1813, 'en', 'our')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1814, 'en', 'ours')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1815, 'en', 'ours')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1816, 'en', 'ourselves')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1817, 'en', 'ourselves')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1818, 'en', 'out')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1819, 'en', 'out')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1820, 'en', 'outside')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1821, 'en', 'over')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1822, 'en', 'over')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1823, 'en', 'overall')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1824, 'en', 'own')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1825, 'en', 'own')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1826, 'en', 'p')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1827, 'en', 'part')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1828, 'en', 'particular')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1829, 'en', 'particularly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1830, 'en', 'past')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1831, 'en', 'per')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1832, 'en', 'per')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1833, 'en', 'perhaps')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1834, 'en', 'perhaps')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1835, 'en', 'placed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1836, 'en', 'please')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1837, 'en', 'please')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1838, 'en', 'plus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1839, 'en', 'possible')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1840, 'en', 'presumably')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1841, 'en', 'probably')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1842, 'en', 'provided')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1843, 'en', 'provides')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1844, 'en', 'put')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1845, 'en', 'q')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1846, 'en', 'que')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1847, 'en', 'quite')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1848, 'en', 'qv')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1849, 'en', 'r')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1850, 'en', 'rather')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1851, 'en', 'rather')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1852, 'en', 'rd')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1853, 'en', 're')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1854, 'en', 're')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1855, 'en', 'really')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1856, 'en', 'reasonably')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1857, 'en', 'recent')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1858, 'en', 'recently')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1859, 'en', 'regarding')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1860, 'en', 'regardless')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1861, 'en', 'regards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1862, 'en', 'relatively')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1863, 'en', 'respectively')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1864, 'en', 'right')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1865, 'en', 'round')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1866, 'en', 's')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1867, 'en', 'said')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1868, 'en', 'same')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1869, 'en', 'same')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1870, 'en', 'saw')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1871, 'en', 'say')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1872, 'en', 'saying')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1873, 'en', 'says')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1874, 'en', 'second')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1875, 'en', 'secondly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1876, 'en', 'see')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1877, 'en', 'see')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1878, 'en', 'seeing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1879, 'en', 'seem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1880, 'en', 'seem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1881, 'en', 'seemed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1882, 'en', 'seemed')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1883, 'en', 'seeming')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1884, 'en', 'seeming')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1885, 'en', 'seems')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1886, 'en', 'seems')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1887, 'en', 'seen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1888, 'en', 'self')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1889, 'en', 'selves')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1890, 'en', 'sensible')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1891, 'en', 'sent')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1892, 'en', 'serious')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1893, 'en', 'serious')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1894, 'en', 'seriously')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1895, 'en', 'seven')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1896, 'en', 'several')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1897, 'en', 'several')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1898, 'en', 'shall')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1899, 'en', 'she')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1900, 'en', 'she')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1901, 'en', 'should')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1902, 'en', 'should')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1903, 'en', 'show')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1904, 'en', 'side')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1905, 'en', 'since')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1906, 'en', 'since')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1907, 'en', 'sincere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1908, 'en', 'six')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1909, 'en', 'six')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1910, 'en', 'sixty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1911, 'en', 'so')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1912, 'en', 'so')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1913, 'en', 'some')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1914, 'en', 'some')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1915, 'en', 'somebody')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1916, 'en', 'someday')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1917, 'en', 'somehow')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1918, 'en', 'somehow')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1919, 'en', 'someone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1920, 'en', 'someone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1921, 'en', 'something')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1922, 'en', 'something')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1923, 'en', 'sometime')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1924, 'en', 'sometime')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1925, 'en', 'sometimes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1926, 'en', 'sometimes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1927, 'en', 'somewhat')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1928, 'en', 'somewhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1929, 'en', 'somewhere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1930, 'en', 'soon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1931, 'en', 'sorry')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1932, 'en', 'specified')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1933, 'en', 'specify')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1934, 'en', 'specifying')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1935, 'en', 'still')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1936, 'en', 'still')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1937, 'en', 'sub')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1938, 'en', 'such')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1939, 'en', 'such')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1940, 'en', 'sup')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1941, 'en', 'sure')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1942, 'en', 'system')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1943, 'en', 't')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1944, 'en', 'take')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1945, 'en', 'take')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1946, 'en', 'taken')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1947, 'en', 'taking')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1948, 'en', 'tell')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1949, 'en', 'ten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1950, 'en', 'tends')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1951, 'en', 'th')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1952, 'en', 'than')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1953, 'en', 'than')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1954, 'en', 'thank')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1955, 'en', 'thanks')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1956, 'en', 'thanx')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1957, 'en', 'that')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1958, 'en', 'that')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1959, 'en', 'thats')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1960, 'en', 'the')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1961, 'en', 'the')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1962, 'en', 'their')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1963, 'en', 'their')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1964, 'en', 'theirs')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1965, 'en', 'them')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1966, 'en', 'them')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1967, 'en', 'themselves')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1968, 'en', 'themselves')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1969, 'en', 'then')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1970, 'en', 'then')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1971, 'en', 'thence')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1972, 'en', 'thence')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1973, 'en', 'there')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1974, 'en', 'there')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1975, 'en', 'thereafter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1976, 'en', 'thereafter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1977, 'en', 'thereby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1978, 'en', 'thereby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1979, 'en', 'therefore')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1980, 'en', 'therefore')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1981, 'en', 'therein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1982, 'en', 'therein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1983, 'en', 'theres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1984, 'en', 'thereupon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1985, 'en', 'thereupon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1986, 'en', 'these')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1987, 'en', 'these')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1988, 'en', 'they')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1989, 'en', 'they')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1990, 'en', 'thick')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1991, 'en', 'thin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1992, 'en', 'thing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1993, 'en', 'things')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1994, 'en', 'think')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1995, 'en', 'third')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1996, 'en', 'third')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1997, 'en', 'thirty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1998, 'en', 'this')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (1999, 'en', 'this')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2000, 'en', 'thorough')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2001, 'en', 'thoroughly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2002, 'en', 'those')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2003, 'en', 'those')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2004, 'en', 'though')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2005, 'en', 'though')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2006, 'en', 'three')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2007, 'en', 'three')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2008, 'en', 'through')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2009, 'en', 'through')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2010, 'en', 'throughout')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2011, 'en', 'throughout')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2012, 'en', 'thru')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2013, 'en', 'thru')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2014, 'en', 'thus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2015, 'en', 'thus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2016, 'en', 'till')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2017, 'en', 'to')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2018, 'en', 'to')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2019, 'en', 'together')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2020, 'en', 'together')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2021, 'en', 'too')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2022, 'en', 'too')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2023, 'en', 'took')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2024, 'en', 'top')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2025, 'en', 'toward')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2026, 'en', 'toward')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2027, 'en', 'towards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2028, 'en', 'towards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2029, 'en', 'tried')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2030, 'en', 'tries')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2031, 'en', 'truly')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2032, 'en', 'try')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2033, 'en', 'trying')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2034, 'en', 'twelve')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2035, 'en', 'twenty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2036, 'en', 'twice')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2037, 'en', 'two')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2038, 'en', 'two')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2039, 'en', 'u')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2040, 'en', 'un')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2041, 'en', 'un')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2042, 'en', 'under')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2043, 'en', 'under')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2044, 'en', 'underneath')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2045, 'en', 'undoing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2046, 'en', 'unfortunately')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2047, 'en', 'unless')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2048, 'en', 'unlike')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2049, 'en', 'unlikely')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2050, 'en', 'until')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2051, 'en', 'until')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2052, 'en', 'unto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2053, 'en', 'up')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2054, 'en', 'up')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2055, 'en', 'upon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2056, 'en', 'upon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2057, 'en', 'upwards')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2058, 'en', 'us')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2059, 'en', 'us')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2060, 'en', 'use')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2061, 'en', 'used')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2062, 'en', 'useful')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2063, 'en', 'uses')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2064, 'en', 'using')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2065, 'en', 'usually')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2066, 'en', 'v')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2067, 'en', 'value')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2068, 'en', 'various')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2069, 'en', 'versus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2070, 'en', 'very')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2071, 'en', 'very')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2072, 'en', 'via')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2073, 'en', 'via')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2074, 'en', 'viz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2075, 'en', 'vs')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2076, 'en', 'w')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2077, 'en', 'want')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2078, 'en', 'wants')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2079, 'en', 'was')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2080, 'en', 'was')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2081, 'en', 'way')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2082, 'en', 'we')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2083, 'en', 'we')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2084, 'en', 'welcome')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2085, 'en', 'well')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2086, 'en', 'well')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2087, 'en', 'went')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2088, 'en', 'were')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2089, 'en', 'were')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2090, 'en', 'what')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2091, 'en', 'what')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2092, 'en', 'whatever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2093, 'en', 'whatever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2094, 'en', 'when')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2095, 'en', 'when')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2096, 'en', 'whence')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2097, 'en', 'whence')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2098, 'en', 'whenever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2099, 'en', 'whenever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2100, 'en', 'where')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2101, 'en', 'where')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2102, 'en', 'whereafter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2103, 'en', 'whereafter')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2104, 'en', 'whereas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2105, 'en', 'whereas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2106, 'en', 'whereby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2107, 'en', 'whereby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2108, 'en', 'wherein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2109, 'en', 'wherein')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2110, 'en', 'whereupon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2111, 'en', 'whereupon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2112, 'en', 'wherever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2113, 'en', 'wherever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2114, 'en', 'whether')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2115, 'en', 'whether')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2116, 'en', 'which')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2117, 'en', 'which')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2118, 'en', 'whichever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2119, 'en', 'while')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2120, 'en', 'while')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2121, 'en', 'whilst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2122, 'en', 'whither')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2123, 'en', 'whither')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2124, 'en', 'who')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2125, 'en', 'who')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2126, 'en', 'whoever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2127, 'en', 'whoever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2128, 'en', 'whole')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2129, 'en', 'whole')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2130, 'en', 'whom')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2131, 'en', 'whom')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2132, 'en', 'whomever')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2133, 'en', 'whose')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2134, 'en', 'whose')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2135, 'en', 'why')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2136, 'en', 'why')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2137, 'en', 'will')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2138, 'en', 'will')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2139, 'en', 'willing')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2140, 'en', 'wish')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2141, 'en', 'with')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2142, 'en', 'with')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2143, 'en', 'within')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2144, 'en', 'within')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2145, 'en', 'without')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2146, 'en', 'without')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2147, 'en', 'wonder')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2148, 'en', 'would')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2149, 'en', 'would')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2150, 'en', 'x')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2151, 'en', 'y')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2152, 'en', 'yes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2153, 'en', 'yet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2154, 'en', 'yet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2155, 'en', 'you')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2156, 'en', 'you')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2157, 'en', 'your')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2158, 'en', 'your')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2159, 'en', 'yours')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2160, 'en', 'yours')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2161, 'en', 'yourself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2162, 'en', 'yourself')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2163, 'en', 'yourselves')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2164, 'en', 'yourselves')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2165, 'en', 'z')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2166, 'en', 'zero')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2167, 'es', 'un')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2168, 'es', 'una')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2169, 'es', 'unas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2170, 'es', 'unos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2171, 'es', 'uno')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2172, 'es', 'sobre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2173, 'es', 'todo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2174, 'es', 'tambi√©n')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2175, 'es', 'tras')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2176, 'es', 'otro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2177, 'es', 'alg√∫n')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2178, 'es', 'alguno')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2179, 'es', 'alguna')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2180, 'es', 'algunos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2181, 'es', 'algunas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2182, 'es', 'ser')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2183, 'es', 'es')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2184, 'es', 'soy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2185, 'es', 'eres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2186, 'es', 'somos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2187, 'es', 'sois')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2188, 'es', 'estoy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2189, 'es', 'esta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2190, 'es', 'estamos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2191, 'es', 'estais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2192, 'es', 'estan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2193, 'es', 'como')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2194, 'es', 'en')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2195, 'es', 'para')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2196, 'es', 'atras')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2197, 'es', 'porque')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2198, 'es', 'por qu√©')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2199, 'es', 'estado')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2200, 'es', 'estaba')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2201, 'es', 'ante')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2202, 'es', 'antes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2203, 'es', 'siendo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2204, 'es', 'ambos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2205, 'es', 'pero')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2206, 'es', 'por')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2207, 'es', 'poder')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2208, 'es', 'puede')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2209, 'es', 'puedo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2210, 'es', 'podemos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2211, 'es', 'podeis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2212, 'es', 'pueden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2213, 'es', 'fui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2214, 'es', 'fue')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2215, 'es', 'fuimos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2216, 'es', 'fueron')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2217, 'es', 'hacer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2218, 'es', 'hago')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2219, 'es', 'hace')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2220, 'es', 'hacemos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2221, 'es', 'haceis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2222, 'es', 'hacen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2223, 'es', 'cada')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2224, 'es', 'fin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2225, 'es', 'incluso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2226, 'es', 'primero')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2227, 'es', 'desde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2228, 'es', 'conseguir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2229, 'es', 'consigo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2230, 'es', 'consigue')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2231, 'es', 'consigues')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2232, 'es', 'conseguimos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2233, 'es', 'consiguen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2234, 'es', 'ir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2235, 'es', 'voy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2236, 'es', 'va')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2237, 'es', 'vamos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2238, 'es', 'vais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2239, 'es', 'van')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2240, 'es', 'vaya')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2241, 'es', 'gueno')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2242, 'es', 'ha')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2243, 'es', 'tener')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2244, 'es', 'tengo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2245, 'es', 'tiene')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2246, 'es', 'tenemos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2247, 'es', 'teneis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2248, 'es', 'tienen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2249, 'es', 'el')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2250, 'es', 'la')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2251, 'es', 'lo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2252, 'es', 'las')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2253, 'es', 'los')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2254, 'es', 'su')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2255, 'es', 'aqui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2256, 'es', 'mio')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2257, 'es', 'tuyo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2258, 'es', 'ellos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2259, 'es', 'ellas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2260, 'es', 'nos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2261, 'es', 'nosotros')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2262, 'es', 'vosotros')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2263, 'es', 'vosotras')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2264, 'es', 'si')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2265, 'es', 'dentro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2266, 'es', 'solo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2267, 'es', 'solamente')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2268, 'es', 'saber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2269, 'es', 'sabes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2270, 'es', 'sabe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2271, 'es', 'sabemos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2272, 'es', 'sabeis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2273, 'es', 'saben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2274, 'es', 'ultimo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2275, 'es', 'largo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2276, 'es', 'bastante')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2277, 'es', 'haces')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2278, 'es', 'muchos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2279, 'es', 'aquellos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2280, 'es', 'aquellas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2281, 'es', 'sus')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2282, 'es', 'entonces')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2283, 'es', 'tiempo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2284, 'es', 'verdad')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2285, 'es', 'verdadero')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2286, 'es', 'verdadera')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2287, 'es', 'cierto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2288, 'es', 'ciertos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2289, 'es', 'cierta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2290, 'es', 'ciertas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2291, 'es', 'intentar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2292, 'es', 'intento')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2293, 'es', 'intenta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2294, 'es', 'intentas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2295, 'es', 'intentamos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2296, 'es', 'intentais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2297, 'es', 'intentan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2298, 'es', 'dos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2299, 'es', 'bajo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2300, 'es', 'arriba')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2301, 'es', 'encima')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2302, 'es', 'usar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2303, 'es', 'uso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2304, 'es', 'usas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2305, 'es', 'usa')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2306, 'es', 'usamos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2307, 'es', 'usais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2308, 'es', 'usan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2309, 'es', 'emplear')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2310, 'es', 'empleo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2311, 'es', 'empleas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2312, 'es', 'emplean')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2313, 'es', 'ampleamos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2314, 'es', 'empleais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2315, 'es', 'valor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2316, 'es', 'muy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2317, 'es', 'era')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2318, 'es', 'eras')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2319, 'es', 'eramos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2320, 'es', 'eran')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2321, 'es', 'modo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2322, 'es', 'bien')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2323, 'es', 'cual')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2324, 'es', 'cuando')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2325, 'es', 'donde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2326, 'es', 'mientras')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2327, 'es', 'quien')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2328, 'es', 'con')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2329, 'es', 'entre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2330, 'es', 'sin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2331, 'es', 'trabajo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2332, 'es', 'trabajar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2333, 'es', 'trabajas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2334, 'es', 'trabaja')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2335, 'es', 'trabajamos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2336, 'es', 'trabajais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2337, 'es', 'trabajan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2338, 'es', 'podria')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2339, 'es', 'podrias')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2340, 'es', 'podriamos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2341, 'es', 'podrian')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2342, 'es', 'podriais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2343, 'es', 'yo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2344, 'fr', 'alors')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2345, 'fr', 'au')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2346, 'fr', 'aucuns')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2347, 'fr', 'aussi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2348, 'fr', 'autre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2349, 'fr', 'avant')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2350, 'fr', 'avec')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2351, 'fr', 'avoir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2352, 'fr', 'bon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2353, 'fr', 'car')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2354, 'fr', 'ce')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2355, 'fr', 'cela')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2356, 'fr', 'ces')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2357, 'fr', 'ceux')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2358, 'fr', 'chaque')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2359, 'fr', 'ci')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2360, 'fr', 'comme')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2361, 'fr', 'comment')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2362, 'fr', 'dans')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2363, 'fr', 'des')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2364, 'fr', 'du')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2365, 'fr', 'dedans')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2366, 'fr', 'dehors')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2367, 'fr', 'depuis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2368, 'fr', 'deux')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2369, 'fr', 'devrait')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2370, 'fr', 'doit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2371, 'fr', 'donc')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2372, 'fr', 'dos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2373, 'fr', 'droite')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2374, 'fr', 'd√©but')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2375, 'fr', 'elle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2376, 'fr', 'elles')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2377, 'fr', 'en')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2378, 'fr', 'encore')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2379, 'fr', 'essai')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2380, 'fr', 'est')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2381, 'fr', 'et')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2382, 'fr', 'eu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2383, 'fr', 'fait')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2384, 'fr', 'faites')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2385, 'fr', 'fois')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2386, 'fr', 'font')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2387, 'fr', 'force')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2388, 'fr', 'haut')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2389, 'fr', 'hors')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2390, 'fr', 'ici')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2391, 'fr', 'il')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2392, 'fr', 'ils')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2393, 'fr', 'je')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2394, 'fr', 'juste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2395, 'fr', 'la')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2396, 'fr', 'le')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2397, 'fr', 'les')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2398, 'fr', 'leur')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2399, 'fr', 'l√†')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2400, 'fr', 'ma')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2401, 'fr', 'maintenant')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2402, 'fr', 'mais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2403, 'fr', 'mes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2404, 'fr', 'mine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2405, 'fr', 'moins')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2406, 'fr', 'mon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2407, 'fr', 'mot')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2408, 'fr', 'm√™me')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2409, 'fr', 'ni')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2410, 'fr', 'nomm√©s')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2411, 'fr', 'notre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2412, 'fr', 'nous')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2413, 'fr', 'nouveaux')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2414, 'fr', 'ou')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2415, 'fr', 'o√π')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2416, 'fr', 'par')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2417, 'fr', 'parce')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2418, 'fr', 'parole')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2419, 'fr', 'pas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2420, 'fr', 'personnes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2421, 'fr', 'peut')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2422, 'fr', 'peu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2423, 'fr', 'pi√®ce')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2424, 'fr', 'plupart')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2425, 'fr', 'pour')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2426, 'fr', 'pourquoi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2427, 'fr', 'quand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2428, 'fr', 'que')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2429, 'fr', 'quel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2430, 'fr', 'quelle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2431, 'fr', 'quelles')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2432, 'fr', 'quels')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2433, 'fr', 'qui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2434, 'fr', 'sa')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2435, 'fr', 'sans')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2436, 'fr', 'ses')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2437, 'fr', 'seulement')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2438, 'fr', 'si')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2439, 'fr', 'sien')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2440, 'fr', 'son')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2441, 'fr', 'sont')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2442, 'fr', 'sous')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2443, 'fr', 'soyez')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2444, 'fr', 'sujet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2445, 'fr', 'sur')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2446, 'fr', 'ta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2447, 'fr', 'tandis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2448, 'fr', 'tellement')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2449, 'fr', 'tels')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2450, 'fr', 'tes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2451, 'fr', 'ton')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2452, 'fr', 'tous')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2453, 'fr', 'tout')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2454, 'fr', 'trop')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2455, 'fr', 'tr√®s')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2456, 'fr', 'tu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2457, 'fr', 'valeur')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2458, 'fr', 'voie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2459, 'fr', 'voient')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2460, 'fr', 'vont')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2461, 'fr', 'votre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2462, 'fr', 'vous')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2463, 'fr', 'vu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2464, 'fr', '√ßa')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2465, 'fr', '√©taient')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2466, 'fr', '√©tat')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2467, 'fr', '√©tions')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2468, 'fr', '√©t√©')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2469, 'hu', 'a')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2470, 'hu', 'az')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2471, 'hu', 'egy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2472, 'hu', 'be')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2473, 'hu', 'ki')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2474, 'hu', 'le')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2475, 'hu', 'fel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2476, 'hu', 'meg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2477, 'hu', 'el')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2478, 'hu', '√°t')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2479, 'hu', 'r√°')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2480, 'hu', 'ide')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2481, 'hu', 'oda')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2482, 'hu', 'sz√©t')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2483, 'hu', 'össze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2484, 'hu', 'vissza')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2485, 'hu', 'de')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2486, 'hu', 'h√°t')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2487, 'hu', '√©s')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2488, 'hu', 'vagy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2489, 'hu', 'hogy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2490, 'hu', 'van')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2491, 'hu', 'lesz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2492, 'hu', 'volt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2493, 'hu', 'csak')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2494, 'hu', 'nem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2495, 'hu', 'igen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2496, 'hu', 'mint')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2497, 'hu', '√©n')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2498, 'hu', 'te')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2499, 'hu', '√µ')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2500, 'hu', 'mi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2501, 'hu', 'ti')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2502, 'hu', '√µk')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2503, 'it', 'a')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2504, 'it', 'adesso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2505, 'it', 'ai')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2506, 'it', 'al')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2507, 'it', 'alla')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2508, 'it', 'allo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2509, 'it', 'allora')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2510, 'it', 'altre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2511, 'it', 'altri')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2512, 'it', 'altro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2513, 'it', 'anche')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2514, 'it', 'ancora')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2515, 'it', 'avere')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2516, 'it', 'aveva')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2517, 'it', 'avevano')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2518, 'it', 'ben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2519, 'it', 'buono')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2520, 'it', 'che')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2521, 'it', 'chi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2522, 'it', 'cinque')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2523, 'it', 'comprare')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2524, 'it', 'con')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2525, 'it', 'consecutivi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2526, 'it', 'consecutivo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2527, 'it', 'cosa')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2528, 'it', 'cui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2529, 'it', 'da')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2530, 'it', 'del')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2531, 'it', 'della')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2532, 'it', 'dello')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2533, 'it', 'dentro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2534, 'it', 'deve')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2535, 'it', 'devo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2536, 'it', 'di')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2537, 'it', 'doppio')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2538, 'it', 'due')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2539, 'it', 'e')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2540, 'it', 'ecco')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2541, 'it', 'fare')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2542, 'it', 'fine')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2543, 'it', 'fino')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2544, 'it', 'fra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2545, 'it', 'gente')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2546, 'it', 'giu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2547, 'it', 'ha')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2548, 'it', 'hai')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2549, 'it', 'hanno')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2550, 'it', 'ho')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2551, 'it', 'il')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2552, 'it', 'indietro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2553, 'it', 'invece')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2554, 'it', 'io')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2555, 'it', 'la')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2556, 'it', 'lavoro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2557, 'it', 'le')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2558, 'it', 'lei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2559, 'it', 'lo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2560, 'it', 'loro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2561, 'it', 'lui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2562, 'it', 'lungo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2563, 'it', 'ma')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2564, 'it', 'me')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2565, 'it', 'meglio')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2566, 'it', 'molta')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2567, 'it', 'molti')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2568, 'it', 'molto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2569, 'it', 'nei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2570, 'it', 'nella')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2571, 'it', 'no')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2572, 'it', 'noi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2573, 'it', 'nome')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2574, 'it', 'nostro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2575, 'it', 'nove')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2576, 'it', 'nuovi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2577, 'it', 'nuovo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2578, 'it', 'o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2579, 'it', 'oltre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2580, 'it', 'ora')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2581, 'it', 'otto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2582, 'it', 'peggio')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2583, 'it', 'pero')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2584, 'it', 'persone')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2585, 'it', 'piu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2586, 'it', 'poco')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2587, 'it', 'primo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2588, 'it', 'promesso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2589, 'it', 'qua')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2590, 'it', 'quarto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2591, 'it', 'quasi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2592, 'it', 'quattro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2593, 'it', 'quello')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2594, 'it', 'questo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2595, 'it', 'qui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2596, 'it', 'quindi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2597, 'it', 'quinto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2598, 'it', 'rispetto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2599, 'it', 'sara')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2600, 'it', 'secondo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2601, 'it', 'sei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2602, 'it', 'sembra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2603, 'it', 'sembrava')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2604, 'it', 'senza')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2605, 'it', 'sette')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2606, 'it', 'sia')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2607, 'it', 'siamo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2608, 'it', 'siete')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2609, 'it', 'solo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2610, 'it', 'sono')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2611, 'it', 'sopra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2612, 'it', 'soprattutto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2613, 'it', 'sotto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2614, 'it', 'stati')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2615, 'it', 'stato')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2616, 'it', 'stesso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2617, 'it', 'su')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2618, 'it', 'subito')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2619, 'it', 'sul')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2620, 'it', 'sulla')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2621, 'it', 'tanto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2622, 'it', 'te')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2623, 'it', 'tempo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2624, 'it', 'terzo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2625, 'it', 'tra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2626, 'it', 'tre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2627, 'it', 'triplo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2628, 'it', 'ultimo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2629, 'it', 'un')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2630, 'it', 'una')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2631, 'it', 'uno')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2632, 'it', 'va')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2633, 'it', 'vai')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2634, 'it', 'voi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2635, 'it', 'volte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2636, 'nb', 'alle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2637, 'nb', 'andre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2638, 'nb', 'arbeid')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2639, 'nb', 'av')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2640, 'nb', 'begge')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2641, 'nb', 'bort')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2642, 'nb', 'bra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2643, 'nb', 'bruke')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2644, 'nb', 'da')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2645, 'nb', 'denne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2646, 'nb', 'der')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2647, 'nb', 'deres')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2648, 'nb', 'det')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2649, 'nb', 'din')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2650, 'nb', 'disse')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2651, 'nb', 'du')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2652, 'nb', 'eller')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2653, 'nb', 'en')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2654, 'nb', 'ene')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2655, 'nb', 'eneste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2656, 'nb', 'enhver')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2657, 'nb', 'enn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2658, 'nb', 'er')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2659, 'nb', 'et')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2660, 'nb', 'folk')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2661, 'nb', 'for')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2662, 'nb', 'fordi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2663, 'nb', 'fors√õke')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2664, 'nb', 'fra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2665, 'nb', 'f√Ö')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2666, 'nb', 'f√õr')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2667, 'nb', 'f√õrst')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2668, 'nb', 'gjorde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2669, 'nb', 'gj√õre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2670, 'nb', 'god')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2671, 'nb', 'g√Ö')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2672, 'nb', 'ha')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2673, 'nb', 'hadde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2674, 'nb', 'han')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2675, 'nb', 'hans')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2676, 'nb', 'hennes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2677, 'nb', 'her')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2678, 'nb', 'hva')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2679, 'nb', 'hvem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2680, 'nb', 'hver')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2681, 'nb', 'hvilken')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2682, 'nb', 'hvis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2683, 'nb', 'hvor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2684, 'nb', 'hvordan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2685, 'nb', 'hvorfor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2686, 'nb', 'i')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2687, 'nb', 'ikke')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2688, 'nb', 'inn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2689, 'nb', 'innen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2690, 'nb', 'kan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2691, 'nb', 'kunne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2692, 'nb', 'lage')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2693, 'nb', 'lang')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2694, 'nb', 'lik')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2695, 'nb', 'like')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2696, 'nb', 'makt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2697, 'nb', 'mange')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2698, 'nb', 'med')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2699, 'nb', 'meg')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2700, 'nb', 'meget')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2701, 'nb', 'men')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2702, 'nb', 'mens')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2703, 'nb', 'mer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2704, 'nb', 'mest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2705, 'nb', 'min')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2706, 'nb', 'mye')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2707, 'nb', 'm√Ö')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2708, 'nb', 'm√Öte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2709, 'nb', 'navn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2710, 'nb', 'nei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2711, 'nb', 'ny')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2712, 'nb', 'n√Ö')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2713, 'nb', 'n√Ör')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2714, 'nb', 'og')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2715, 'nb', 'ogs√Ö')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2716, 'nb', 'om')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2717, 'nb', 'opp')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2718, 'nb', 'oss')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2719, 'nb', 'over')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2720, 'nb', 'part')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2721, 'nb', 'punkt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2722, 'nb', 'p√Ö')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2723, 'nb', 'rett')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2724, 'nb', 'riktig')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2725, 'nb', 'samme')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2726, 'nb', 'sant')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2727, 'nb', 'si')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2728, 'nb', 'siden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2729, 'nb', 'sist')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2730, 'nb', 'skulle')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2731, 'nb', 'slik')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2732, 'nb', 'slutt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2733, 'nb', 'som')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2734, 'nb', 'start')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2735, 'nb', 'stille')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2736, 'nb', 's√Ö')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2737, 'nb', 'tid')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2738, 'nb', 'til')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2739, 'nb', 'tilbake')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2740, 'nb', 'tilstand')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2741, 'nb', 'under')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2742, 'nb', 'ut')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2743, 'nb', 'uten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2744, 'nb', 'var')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2745, 'nb', 'ved')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2746, 'nb', 'verdi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2747, 'nb', 'vi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2748, 'nb', 'vil')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2749, 'nb', 'ville')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2750, 'nb', 'vite')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2751, 'nb', 'v√Ör')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2752, 'nb', 'v√ñre')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2753, 'nb', 'v√ñrt')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2754, 'nl', 'aan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2755, 'nl', 'af')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2756, 'nl', 'al')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2757, 'nl', 'als')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2758, 'nl', 'bij')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2759, 'nl', 'dan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2760, 'nl', 'dat')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2761, 'nl', 'die')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2762, 'nl', 'dit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2763, 'nl', 'een')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2764, 'nl', 'en')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2765, 'nl', 'er')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2766, 'nl', 'had')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2767, 'nl', 'heb')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2768, 'nl', 'hem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2769, 'nl', 'het')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2770, 'nl', 'hij')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2771, 'nl', 'hoe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2772, 'nl', 'hun')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2773, 'nl', 'ik')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2774, 'nl', 'in')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2775, 'nl', 'is')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2776, 'nl', 'je')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2777, 'nl', 'kan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2778, 'nl', 'me')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2779, 'nl', 'men')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2780, 'nl', 'met')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2781, 'nl', 'mij')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2782, 'nl', 'nog')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2783, 'nl', 'nu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2784, 'nl', 'of')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2785, 'nl', 'ons')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2786, 'nl', 'ook')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2787, 'nl', 'te')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2788, 'nl', 'tot')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2789, 'nl', 'uit')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2790, 'nl', 'van')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2791, 'nl', 'was')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2792, 'nl', 'wat')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2793, 'nl', 'we')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2794, 'nl', 'wel')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2795, 'nl', 'wij')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2796, 'nl', 'zal')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2797, 'nl', 'ze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2798, 'nl', 'zei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2799, 'nl', 'zij')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2800, 'nl', 'zo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2801, 'pl', 'a')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2802, 'pl', 'aby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2803, 'pl', 'acz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2804, 'pl', 'aczkolwiek')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2805, 'pl', 'a?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2806, 'pl', 'ale')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2807, 'pl', 'ale?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2808, 'pl', 'bardzo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2809, 'pl', 'bardziej')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2810, 'pl', 'bez')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2811, 'pl', 'b?d?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2812, 'pl', 'b?dzie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2813, 'pl', 'bo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2814, 'pl', 'by')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2815, 'pl', 'by?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2816, 'pl', 'byli')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2817, 'pl', 'by?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2818, 'pl', 'by?a')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2819, 'pl', 'by?o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2820, 'pl', 'by?y')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2821, 'pl', 'cali')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2822, 'pl', 'ca?a')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2823, 'pl', 'ca?y')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2824, 'pl', 'co')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2825, 'pl', 'cokolwiek')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2826, 'pl', 'co?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2827, 'pl', 'czasami')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2828, 'pl', 'czasem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2829, 'pl', 'czy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2830, 'pl', 'czemu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2831, 'pl', 'dla')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2832, 'pl', 'dlaczego')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2833, 'pl', 'do')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2834, 'pl', 'gdy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2835, 'pl', 'gdy?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2836, 'pl', 'gdzie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2837, 'pl', 'gdziekolwiek')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2838, 'pl', 'gdzie?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2839, 'pl', 'i')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2840, 'pl', 'ile')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2841, 'pl', 'ich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2842, 'pl', 'inna')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2843, 'pl', 'inny')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2844, 'pl', 'i?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2845, 'pl', 'ja')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2846, 'pl', 'jak')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2847, 'pl', 'jaka?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2848, 'pl', 'jakich?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2849, 'pl', 'jaki?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2850, 'pl', 'jaki?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2851, 'pl', 'jakkolwiek')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2852, 'pl', 'jako')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2853, 'pl', 'jako?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2854, 'pl', 'j?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2855, 'pl', 'jednak')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2856, 'pl', 'jednak?e')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2857, 'pl', 'jego')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2858, 'pl', 'jej')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2859, 'pl', 'jest')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2860, 'pl', 'jeszcze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2861, 'pl', 'je?eli')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2862, 'pl', 'ju?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2863, 'pl', 'kiedy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2864, 'pl', 'kim?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2865, 'pl', 'kto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2866, 'pl', 'ktokolwiek')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2867, 'pl', 'kto?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2868, 'pl', 'kt√≥ra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2869, 'pl', 'kt√≥re')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2870, 'pl', 'kt√≥ry')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2871, 'pl', 'kt√≥rych')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2872, 'pl', 'lat')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2873, 'pl', 'lecz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2874, 'pl', 'lub')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2875, 'pl', 'ma')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2876, 'pl', 'mi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2877, 'pl', 'mimo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2878, 'pl', 'mnie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2879, 'pl', 'moim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2880, 'pl', 'mo?e')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2881, 'pl', 'mo?liwe')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2882, 'pl', 'mo?na')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2883, 'pl', 'mu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2884, 'pl', 'na')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2885, 'pl', 'nad')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2886, 'pl', 'nas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2887, 'pl', 'natomiast')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2888, 'pl', 'nawet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2889, 'pl', 'nic')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2890, 'pl', 'nich')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2891, 'pl', 'nie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2892, 'pl', 'nigdy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2893, 'pl', 'ni?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2894, 'pl', 'no')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2895, 'pl', 'o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2896, 'pl', 'obok')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2897, 'pl', 'od')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2898, 'pl', 'oko?o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2899, 'pl', 'on')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2900, 'pl', 'ona')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2901, 'pl', 'ono')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2902, 'pl', 'oraz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2903, 'pl', 'pan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2904, 'pl', 'pana')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2905, 'pl', 'pani')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2906, 'pl', 'po')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2907, 'pl', 'pod')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2908, 'pl', 'podczas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2909, 'pl', 'teraz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2910, 'pl', 'te?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2911, 'pl', 'trzeba')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2912, 'pl', 'to')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2913, 'pl', 'tobie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2914, 'pl', 'tote?')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2915, 'pl', 'tu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2916, 'pl', 'twoim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2917, 'pl', 'twoja')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2918, 'pl', 'twoje')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2919, 'pl', 'tw√≥j')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2920, 'pl', 'twym')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2921, 'pl', 'ty')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2922, 'pl', 'tych')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2923, 'pl', 'tylko')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2924, 'pl', 'tym')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2925, 'pl', 'w')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2926, 'pl', 'we')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2927, 'pl', 'wed?ug')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2928, 'pl', 'wi?c')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2929, 'pl', 'w?a?nie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2930, 'pl', 'wszyscy')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2931, 'pl', 'wszystko')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2932, 'pl', 'wszystkie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2933, 'pl', 'z')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2934, 'pl', 'za')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2935, 'pl', 'zapewne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2936, 'pl', 'zawsze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2937, 'pl', 'ze')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2938, 'pl', 'znowu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2939, 'pl', 'zn√≥w')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2940, 'pl', '?adna')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2941, 'pl', '?adne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2942, 'pl', '?adnych')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2943, 'pl', '?e')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2944, 'pl', '?eby')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2945, 'pl', '')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2946, 'pl', '')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2947, 'pt', '√∫ltimo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2948, 'pt', '√©')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2949, 'pt', 'acerca')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2950, 'pt', 'agora')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2951, 'pt', 'algmas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2952, 'pt', 'alguns')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2953, 'pt', 'ali')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2954, 'pt', 'ambos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2955, 'pt', 'antes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2956, 'pt', 'apontar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2957, 'pt', 'aquela')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2958, 'pt', 'aquelas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2959, 'pt', 'aquele')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2960, 'pt', 'aqueles')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2961, 'pt', 'aqui')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2962, 'pt', 'atr√°s')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2963, 'pt', 'bem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2964, 'pt', 'bom')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2965, 'pt', 'cada')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2966, 'pt', 'caminho')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2967, 'pt', 'cima')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2968, 'pt', 'com')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2969, 'pt', 'como')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2970, 'pt', 'comprido')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2971, 'pt', 'conhecido')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2972, 'pt', 'corrente')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2973, 'pt', 'das')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2974, 'pt', 'debaixo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2975, 'pt', 'dentro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2976, 'pt', 'desde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2977, 'pt', 'desligado')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2978, 'pt', 'deve')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2979, 'pt', 'devem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2980, 'pt', 'dever√°')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2981, 'pt', 'direita')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2982, 'pt', 'diz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2983, 'pt', 'dizer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2984, 'pt', 'dois')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2985, 'pt', 'dos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2986, 'pt', 'e')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2987, 'pt', 'ela')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2988, 'pt', 'ele')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2989, 'pt', 'eles')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2990, 'pt', 'em')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2991, 'pt', 'enquanto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2992, 'pt', 'ent√£o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2993, 'pt', 'est√°')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2994, 'pt', 'est√£o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2995, 'pt', 'estado')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2996, 'pt', 'estar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2997, 'pt', 'estar√°')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2998, 'pt', 'este')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (2999, 'pt', 'estes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3000, 'pt', 'esteve')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3001, 'pt', 'estive')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3002, 'pt', 'estivemos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3003, 'pt', 'estiveram')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3004, 'pt', 'eu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3005, 'pt', 'far√°')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3006, 'pt', 'faz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3007, 'pt', 'fazer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3008, 'pt', 'fazia')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3009, 'pt', 'fez')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3010, 'pt', 'fim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3011, 'pt', 'foi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3012, 'pt', 'fora')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3013, 'pt', 'horas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3014, 'pt', 'iniciar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3015, 'pt', 'inicio')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3016, 'pt', 'ir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3017, 'pt', 'ir√°')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3018, 'pt', 'ista')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3019, 'pt', 'iste')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3020, 'pt', 'isto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3021, 'pt', 'ligado')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3022, 'pt', 'maioria')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3023, 'pt', 'maiorias')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3024, 'pt', 'mais')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3025, 'pt', 'mas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3026, 'pt', 'mesmo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3027, 'pt', 'meu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3028, 'pt', 'muito')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3029, 'pt', 'muitos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3030, 'pt', 'n√≥s')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3031, 'pt', 'n√£o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3032, 'pt', 'nome')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3033, 'pt', 'nosso')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3034, 'pt', 'novo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3035, 'pt', 'o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3036, 'pt', 'onde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3037, 'pt', 'os')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3038, 'pt', 'ou')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3039, 'pt', 'outro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3040, 'pt', 'para')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3041, 'pt', 'parte')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3042, 'pt', 'pegar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3043, 'pt', 'pelo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3044, 'pt', 'pessoas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3045, 'pt', 'pode')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3046, 'pt', 'poder√°')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3047, 'pt', 'podia')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3048, 'pt', 'por')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3049, 'pt', 'porque')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3050, 'pt', 'povo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3051, 'pt', 'promeiro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3052, 'pt', 'qu√™')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3053, 'pt', 'qual')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3054, 'pt', 'qualquer')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3055, 'pt', 'quando')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3056, 'pt', 'quem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3057, 'pt', 'quieto')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3058, 'pt', 's√£o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3059, 'pt', 'saber')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3060, 'pt', 'sem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3061, 'pt', 'ser')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3062, 'pt', 'seu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3063, 'pt', 'somente')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3064, 'pt', 't√™m')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3065, 'pt', 'tal')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3066, 'pt', 'tamb√©m')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3067, 'pt', 'tem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3068, 'pt', 'tempo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3069, 'pt', 'tenho')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3070, 'pt', 'tentar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3071, 'pt', 'tentaram')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3072, 'pt', 'tente')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3073, 'pt', 'tentei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3074, 'pt', 'teu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3075, 'pt', 'teve')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3076, 'pt', 'tipo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3077, 'pt', 'tive')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3078, 'pt', 'todos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3079, 'pt', 'trabalhar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3080, 'pt', 'trabalho')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3081, 'pt', 'tu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3082, 'pt', 'um')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3083, 'pt', 'uma')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3084, 'pt', 'umas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3085, 'pt', 'uns')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3086, 'pt', 'usa')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3087, 'pt', 'usar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3088, 'pt', 'valor')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3089, 'pt', 'veja')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3090, 'pt', 'ver')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3091, 'pt', 'verdade')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3092, 'pt', 'verdadeiro')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3093, 'tr', 'acaba')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3094, 'tr', 'altm√Ω√æ')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3095, 'tr', 'alt√Ω')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3096, 'tr', 'ama')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3097, 'tr', 'bana')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3098, 'tr', 'baz√Ω')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3099, 'tr', 'belki')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3100, 'tr', 'ben')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3101, 'tr', 'benden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3102, 'tr', 'beni')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3103, 'tr', 'benim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3104, 'tr', 'be√æ')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3105, 'tr', 'bin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3106, 'tr', 'bir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3107, 'tr', 'biri')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3108, 'tr', 'birka√ß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3109, 'tr', 'birkez')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3110, 'tr', 'bir√æey')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3111, 'tr', 'bir√æeyi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3112, 'tr', 'biz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3113, 'tr', 'bizden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3114, 'tr', 'bizi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3115, 'tr', 'bizim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3116, 'tr', 'bu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3117, 'tr', 'buna')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3118, 'tr', 'bunda')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3119, 'tr', 'bundan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3120, 'tr', 'bunu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3121, 'tr', 'bunun')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3122, 'tr', 'da')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3123, 'tr', 'daha')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3124, 'tr', 'dahi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3125, 'tr', 'de')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3126, 'tr', 'defa')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3127, 'tr', 'diye')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3128, 'tr', 'doksan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3129, 'tr', 'dokuz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3130, 'tr', 'dört')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3131, 'tr', 'elli')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3132, 'tr', 'en')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3133, 'tr', 'gibi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3134, 'tr', 'hem')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3135, 'tr', 'hep')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3136, 'tr', 'hepsi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3137, 'tr', 'her')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3138, 'tr', 'hi√ß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3139, 'tr', 'iki')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3140, 'tr', 'ile')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3141, 'tr', 'INSERmi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3142, 'tr', 'ise')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3143, 'tr', 'i√ßin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3144, 'tr', 'katrilyon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3145, 'tr', 'kez')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3146, 'tr', 'ki')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3147, 'tr', 'kim')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3148, 'tr', 'kimden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3149, 'tr', 'kime')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3150, 'tr', 'kimi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3151, 'tr', 'k√Ωrk')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3152, 'tr', 'milyar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3153, 'tr', 'milyon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3154, 'tr', 'mu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3155, 'tr', 'mü')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3156, 'tr', 'm√Ω')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3157, 'tr', 'nas√Ωl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3158, 'tr', 'ne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3159, 'tr', 'neden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3160, 'tr', 'nerde')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3161, 'tr', 'nerede')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3162, 'tr', 'nereye')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3163, 'tr', 'niye')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3164, 'tr', 'ni√ßin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3165, 'tr', 'on')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3166, 'tr', 'ona')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3167, 'tr', 'ondan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3168, 'tr', 'onlar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3169, 'tr', 'onlardan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3170, 'tr', 'onlari')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3171, 'tr', 'onlar√Ωn')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3172, 'tr', 'onu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3173, 'tr', 'otuz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3174, 'tr', 'sanki')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3175, 'tr', 'sekiz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3176, 'tr', 'seksen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3177, 'tr', 'sen')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3178, 'tr', 'senden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3179, 'tr', 'seni')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3180, 'tr', 'senin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3181, 'tr', 'siz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3182, 'tr', 'sizden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3183, 'tr', 'sizi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3184, 'tr', 'sizin')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3185, 'tr', 'trilyon')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3186, 'tr', 'tüm')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3187, 'tr', 've')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3188, 'tr', 'veya')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3189, 'tr', 'ya')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3190, 'tr', 'yani')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3191, 'tr', 'yedi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3192, 'tr', 'yetmi√æ')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3193, 'tr', 'yirmi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3194, 'tr', 'yüz')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3195, 'tr', '√ßok')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3196, 'tr', '√ßünkü')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3197, 'tr', 'ü√ß')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3198, 'tr', '√æey')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3199, 'tr', '√æeyden')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3200, 'tr', '√æeyi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3201, 'tr', '√æeyler')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3202, 'tr', '√æu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3203, 'tr', '√æuna')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3204, 'tr', '√æunda')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3205, 'tr', '√æundan')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3206, 'lt', 'ant')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3207, 'lt', 'apie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3208, 'lt', 'ar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3209, 'lt', 'arba')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3210, 'lt', 'aš')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3211, 'lt', 'be')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3212, 'lt', 'bei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3213, 'lt', 'bet')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3214, 'lt', 'būti')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3215, 'lt', 'būtų')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3216, 'lt', 'buvo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3217, 'lt', 'čia')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3218, 'lt', 'dabar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3219, 'lt', 'dar')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3220, 'lt', 'daug')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3221, 'lt', 'daugiau')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3222, 'lt', 'dėl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3223, 'lt', 'gal')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3224, 'lt', 'gali')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3225, 'lt', 'į')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3226, 'lt', 'iki')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3227, 'lt', 'ir')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3228, 'lt', 'iš')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3229, 'lt', 'yra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3230, 'lt', 'jam')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3231, 'lt', 'jau')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3232, 'lt', 'jei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3233, 'lt', 'jeigu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3234, 'lt', 'ji')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3235, 'lt', 'jį')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3236, 'lt', 'jie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3237, 'lt', 'jis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3238, 'lt', 'jo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3239, 'lt', 'jog')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3240, 'lt', 'jos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3241, 'lt', 'jų')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3242, 'lt', 'juk')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3243, 'lt', 'juos')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3244, 'lt', 'jūs')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3245, 'lt', 'ką')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3246, 'lt', 'kad')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3247, 'lt', 'kai')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3248, 'lt', 'kaip')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3249, 'lt', 'kas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3250, 'lt', 'ko')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3251, 'lt', 'kol')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3252, 'lt', 'kur')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3253, 'lt', 'kuris')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3254, 'lt', 'labai')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3255, 'lt', 'man')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3256, 'lt', 'mano')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3257, 'lt', 'mes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3258, 'lt', 'mūsų')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3259, 'lt', 'ne')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3260, 'lt', 'nebuvo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3261, 'lt', 'nei')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3262, 'lt', 'nėra')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3263, 'lt', 'nes')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3264, 'lt', 'net')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3265, 'lt', 'nieko')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3266, 'lt', 'nors')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3267, 'lt', 'nuo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3268, 'lt', 'o')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3269, 'lt', 'pats')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3270, 'lt', 'per')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3271, 'lt', 'po')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3272, 'lt', 'prie')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3273, 'lt', 'prieš')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3274, 'lt', 'savo')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3275, 'lt', 'su')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3276, 'lt', 'tačiau')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3277, 'lt', 'tada')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3278, 'lt', 'tai')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3279, 'lt', 'taip')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3280, 'lt', 'tarė')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3281, 'lt', 'tarp')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3282, 'lt', 'ten')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3283, 'lt', 'tiek')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3284, 'lt', 'tik')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3285, 'lt', 'to')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3286, 'lt', 'todėl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3287, 'lt', 'tu')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3288, 'lt', 'turi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3289, 'lt', 'už')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3290, 'lt', 'vėl')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3291, 'lt', 'vieną')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3292, 'lt', 'vienas')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3293, 'lt', 'vis')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3294, 'lt', 'visi')",
        "INSERT INTO %sfaqstopwords (id, lang, stopword) VALUES (3295, 'lt', 'viskas')",
    ];

    /**
     * @var Configuration
     */
    private $config;

    /**
     * Constructor.
     *
     * @param Configuration $config
     */
    public function __construct(Configuration $config)
    {
        $this->config = $config;
    }

    /**
     * Executes all INSERT INTO statements.
     *
     * @param string $prefix
     *
     * @return bool
     */
    public function executeInsertQueries($prefix = '')
    {
        foreach ($this->insertQueries as $stmt) {
            $result = $this->config->getDb()->query(sprintf($stmt, $prefix));

            if (!$result) {
                echo sprintf($stmt, $prefix);
                echo $this->config->getDb()->error();

                return false;
            }
        }

        return true;
    }
}
