<?php

/**
 * 礼物系统
 * 2020-4-16 16:04:46
*/

class beaultController extends baseController
{
    //查看是否有竞拍活动
    public function selectActivityAction(){
        $time = date('Y-m-d H:i:s');
        $one = (new beautifulActivityModule())->ActivityIsOpen($time);
        if ($one['type']){
            returnSuccess([],config('code')['200'],200);
        }else{
            returnFail(config('code')['2022'],$one,2022);
        }
    }
    //查询靓号列表
    public function selectBeaultNumberAction(){
        $data = (new beautifulActivityModule())->getList();
        $arr = [];
        foreach ($data as $k=>$v){
            $arr[$k]['id'] = $v['id'];
            $arr[$k]['number'] = $v['number'];
        }
//        //查询靓号竞拍内容
//        $nei = (new commonModule('sl_beaultfil_state'))->orderBy('id desc')->one();
//        $arr['content'] = $nei;
        returnSuccess($arr,config('code')['200'],200);
    }
    //搜索靓号
    public function getOneNumberAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        if(empty($data['number'])){
            returnFail(config('code')['2023'],[],2023);
        }
        //查询靓号
        $one = (new beautifulNumberModule())->getOneNumber($data['number']);
        $arr['id'] = $one['id'];
        $arr['number'] = $one['number'];
        returnSuccess($arr,config('code')['200'],200);
    }
    //获取一个靓号的价格
    public function getOneNumberPriceAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        if(empty($data['id'])){
            returnFail(config('code')['2024'],[],2024);
        }
        $one = (new beautifulNumberModule())->findOne($data['id']);
        if (empty($one)){
            returnFail(config('code')['2025'],[],2025);
        }
        $one['piecewise'] = explode('|',$one['piecewise']);
        $one['piecewise_time'] = explode('|',$one['piecewise_time']);
        $arr = [];
        $arr['id'] = $one['id'];
        foreach ($one['piecewise'] as $k=>$v){
            $arr[$k]['day'] = $one['piecewise_time'][$k];
            $arr[$k]['price'] = $one['piecewise'][$k];
        }
        returnSuccess($arr,config('code')['200'],200);
    }
    //购买一个靓号
    public function userBuyNumberAction(){
        $redis = new Redis();

        //连接
        $redis->connect('127.0.0.1', 6379);
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $redis->rpush("mylist",$xin['number']);

        if(empty($data['id'])){
            returnFail(config('code')['2024'],[],2024);
        }
        if(empty($data['index']) && $data['index']!=0){
            returnFail(config('code')['2024'],[],2024);
        }
        //查找相应靓号的价格
        $one = (new beautifulNumberModule())->findOne($data['id']);
        if (empty($one)){
            returnFail(config('code')['2025'],[],2025);
        }
        $one['piecewise'] = explode('|',$one['piecewise']);
        $one['piecewise_time'] = explode('|',$one['piecewise_time']);
        $day = $one['piecewise_time'][$data['index']];
        $price = $one['piecewise'][$data['index']];
        $user_diamond = $xin['diamond']*1;
        $value = $redis->lpop('mylist');
        //查询用户的余额是否足够
        if ($xin['diamond']*1<=$price*1){
            returnFail(config('code')['2026'],[],2026);
        }
        //用户钻石足够 消耗用户钻石购买靓号时间
        $time = date("Y-m-d H:i:s",strtotime("+{$day} day"));
        $user = new userModule();

        if ($one['is_sell']=='1'){
            returnFail(config('code')['2028'],[],2028);
        }
        //开始事务
        $user->start_T();

        //插入用户购买日志
        $log = (new buyBeautifulModule())->insert(['user'=>$xin['id'],'number'=>$value,'sell_time'=>date('Y-m-d H:i:s')
        ,'over_time'=>$time,'price'=>$price,'type'=>1]);
        //日志插入成功  扣除用户相应的钻石余额
        $user_diamond = $user_diamond-$price*1;
        $update = $user->where(['number'=>$value])->update(['beault_number'=>$one['number'],'beault_end_time'=>$time,
            'diamond'=>$user_diamond]);
        //修改靓号的状态 变成已售出
        $update_beault = (new beautifulNumberModule())->where(['id'=>$one['id']])->update(['is_sell'=>1]);
        if ($log && $update && $update_beault){
            //提交事务
             $user->comit_T();
                returnSuccess(['msg'=>'购买成功'],config('code')['200'],200);
        }else{
            //回滚事务
             $user->roll_T();
             returnFail(config('code')['2027'],[],2027);
        }
    }
    //定时任务  清除过期的贵族靓号规则
    public function timingClearUserBeaultAction(){
        $where = "is NOT NULL AND beault_end_time<NOW()";

    }


    ########################################################新加设计图#########################
    //获取靓号竞拍池
    public function biddingAction(){
        $data = (new beautifulActivityModule())->getLists();
        $arr = [];
        //查询用户竞拍过靓号选中没有
        $xin = (new commonModule())->getUserInfoByToken();
        $pai = (new buyBeautifulModule())->where(['sure'=>1,'is_deal'=>1,'user'=>$xin['id']])->one();
        if (!empty($pai)){
            returnSuccess($pai,config('code')['20000'],20000);
        }
        foreach ($data as $k=>$v){
            $arr['data'][$k]['id'] = $v['id'];
            $arr['data'][$k]['number'] = $v['number'];
        }
        //获取内容简介
        $one = (new commonModule('sl_beaultfil_state'))->orderBy('id desc')->one();
        $one['content'] = html_entity_decode($one['content']);
        $arr['content'] = $one;
        returnSuccess($arr,config('code')['200'],200);
    }
    //获取一个靓号详情
    public function getBiddingOneAction(){
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        if (empty($data['bidding_id'])){
            returnFail(config('code')['3014'],[],3014);
        }

        $one = (new beautifulNumberModule())->findOne($data['bidding_id']);
        $one['sell_time'] = strtotime($one['sell_time']);
        //获取当前出价最高的
        $highest = (new buyBeautifulModule())->highest($one['number']);
        if (empty($highest)){
            $one['buy'] = [];
        }
        $one['buy']['price'] = $highest['price'];
        //查询用户昵称
        $user = (new userModule())->findOne($highest['user']);
        $one['buy']['nickname'] = $user['nickname'];
        $one['buy']['id'] = $user['id'];
        returnSuccess($one,config('code')['200'],200);
    }
    //用户靓号竞拍
    public function buyBiddingAction(){
        $time = date('Y-m-d H:i:s');
        $all = (new buyBeautifulModule())->findBySql("SELECT * FROM `sl_buy_beautiful` WHERE is_deal=0 and end_time<='{$time}' GROUP BY number");
        foreach ($all as $k=>$v){
            //查询单一的最大值
            $one = (new buyBeautifulModule())->where(['number'=>$v['number']])->orderBy('price desc')->one();
            $uodate = (new buyBeautifulModule())->where(['number'=>$v['number']])->update(['is_deal'=>1]);
            $uodate1 = (new buyBeautifulModule())->where(['id'=>$one['id']])->update(['sure'=>1]);
            //修改状态值
        }
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        if (empty($data['bidding_id'])){
            returnFail(config('code')['3014'],[],3014);
        }
        if (empty($data['price'])){
            returnFail(config('code')['3015'],[],3015);
        }
        
        $one = (new beautifulNumberModule())->findOne($data['bidding_id']);
        if ($data['price']<$one['lowest_price']){
            returnFail(config('code')['3016'].$one['lowest_price'],[],3016);
        }
        $highest = (new buyBeautifulModule())->highest($one['number']);
        //获取当前最大出价
        if ($data['price']<$highest['price']){
            returnFail(config('code')['3017'].$highest['price'],[],3017);
        }
        //数据验证成功插入数据库
        $arr['user'] = $xin['id'];
        $arr['number'] = $one['number'];
        $arr['sell_time'] = date('Y-m-d H:i:s');
        $arr['type'] = 2;
        $arr['end_time'] = $one['sell_time'];
        $arr['price'] = $data['price'];
        $arr['over_time'] = date("Y-m-d",strtotime("+30 day"));;
        $insert = (new buyBeautifulModule())->insert($arr);
        if ($insert){
            returnSuccess($arr,config('code')['200'],200);
        }else{
            returnFail(config('code')['10001'],[],10001);
        }
    }
    //竞拍靓号选择
    public function determineAction(){

    }
}