<?php
class helpCenterController extends baseController
{

    //获取所有的文章
    public function getAllNewsAction(){
        $data=Request::unsetRoute()->all();

        //获取状态值
        if(empty($data['type'])){
            returnFail(config('code')['201'],[],201);
        }

        $data = (new helpCenterModule())->getAllByType($data['type']);
        returnSuccess($data,config('code')['200'],200);
    }

    //意见反馈
    public function feedbackAction(){

        //获取状态值
        $data = Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        if(empty($data['user_number'])){
            returnFail([],config('code')['202'],202);
        }
        if(empty($data['content'])){
            returnFail([],config('code')['203'],203);
        }
        if(empty($data['phone'])){
            returnFail([],config('code')['204'],204);
        }
        if(!empty($data['phone'])){
            if(!preg_match("/^1[345789]\d{9}$/", $data['phone'])) {//正则匹配 电话号码是否正确
                returnFail([],config('code')['204'],204);
            }
        }
        $data['create_time'] = date('Y-m-d H:i:s');
        $insert = (new userFeedbackModule())->userAdd($data);
        if ($insert){
            returnSuccess($data,config('code')['200'],200);
        }else{
            returnFail([],config('code')['10001'],10001);
        }
    }

}