<?php
/**
 * 用户登录
*/
class loginController extends baseController
{

    //手机登录
    public function loginByPhoneAction(){
        //获取手机号信息
        $request = Request::unsetRoute()->all();
        //参数验证
        $userModule = new userModule();
        $res = $userModule->verLoginData($request);
        //参数验证完成，执行登录
        if ($res){
            $user = $userModule->getInfoByTel($request["phone"]);
            if (!empty($user) && $user["state"] == 1){
                $this->getLoginToken($user);   //登录成功，生成新token
            }else{
                returnFail([],getcodestr(3012),3012);
            }
        }

    }

    //获取短信验证码-注册
    public function getPhoneCodeAction(){
        $tel = $this->common->Post("phone");
        //验证手机号
        $reg_phone = '/0?(13|14|15|16|17|18|19)[0-9]{9}/';  //手机号码正则
        if(empty($tel)){
            returnFail([],$this->getcodestr(3002),3002);
        }elseif(!preg_match($reg_phone,$tel)){
            returnFail([],$this->getcodestr(3003),3003);
        }else{
            //发送验证码
            $this->library("Sms");
            $Sms = new Sms();
            $res = $Sms->lingkai($tel, "","验证码");
            if($res["status"] == 1){
                returnSuccess([],$this->getcodestr(3004),200);
            }else{
                returnFail([],$this->getcodestr(3005),3005);
            }
        }
    }

}