<?php
class userController extends baseController
{

    //查询用户等级
    public function userLeavelAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        //根据用户编号查询用户等级
        $one = (new userModule())->where(['number'=>$data['user_number']])->one();
        if (empty($one)){
            returnFail(config('code')['205'],[],205);
        }
        if(empty($one['experience'])){
            $one['experience'] = 0;
        }
        //查询用户的经验值
        $level = (new userLevelModule())->getUserLevel($one['experience'],$one['experience']);

    }

    //获取用户基本信息
    public function getUserInfoAction(){
        $user_number = $this->common->Post("user_number");
        if (!empty($user_number)){
            $user_info = (new userModule())->getUserInfoByNumber($user_number);
            $xin = (new commonModule())->getUserInfoByToken();
            $data['user_number'] = $xin['number'];
            $data['usered_number'] = $user_number;
            $data['is_see'] = 2;
            $data['create_time'] = date('Y-m-d H:i:s');
            $insert = (new userHistoryModule())->addHistory($data);
        }else{
            $user_info = (new userModule())->getUserInfoByToken();
        }
        if (empty($user_info)){
            returnFail([],getcodestr(205),205);
        }
        if ($user_info['is_certification']==2 && !empty($user_info['id_card'])){
            $user_info['is_certification']=3;
        }
        returnSuccess($user_info,getcodestr(200),200);
    }

    //修改用户信息
    public function updateUserInfoAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        unset($data['diamond']);
        unset($data['money']);
        unset($data['ratio']);
        unset($data['phone']);
        unset($data['experience']);
        unset($data['is_vip']);
        $data['sex'] = $data['sex_id'];
        $update = (new userModule())->where(['number'=>$data['user_number']])->update($data);
        if ($update){
            returnSuccess($data,config('code')['200'],200);
        }else{
            returnFail(config('code')['2032'],'用户信息未修改',2032);
        }
    }

    //获取用户性别分类
    public function getUserSexInfoAction(){
        $data = (new parameterModel())->where(['classid'=>531])->orderBy('u4 asc ,id asc')->all();
        $arr = [];
        foreach ($data as $k=>$v){
            $arr[$k]['id'] = $v['u2'];
            $arr[$k]['sex'] = $v['u1'];
        }
        returnSuccess($arr,config('code')['200'],200);
    }

    //修改用户性别
    public function updateUserSexAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        if(empty($data['sex_id'])){
            returnFail(config('code')['2000'],[],2000);
        }
        $update = (new userModule())->where(['number'=>$data['user_number']])->update(['sex'=>$data['sex_id']]);
        if ($update){
            returnSuccess($data,config('code')['200'],200);
        }else{
            returnFail(config('code')['10001'],[],10001);
        }
    }

    //查看用户主页
//    public function viewUserHomeAction(){
//        $data=Request::unsetRoute()->all();
//        //获取状态值
//        if(empty($data['user_number'])){
//            returnFail(config('code')['202'],[],202);
//        }
//    }
    //用户关注 拉黑 取消关注、取消拉黑
    public function userFocusAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        if(empty($data['usered_number'])){
            returnFail(config('code')['2001'],[],2001);
        }
        if(empty($data['type'])){
            returnFail(config('code')['2002'],[],2002);
        }
        //数据验证成功
        $data['create_time'] = date('Y-m-d H:i:s');
        $see = (new userShieldingModule())->userFocus($data);
    }

    //获取我的关注列表
    public function getUserFocusAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $data = (new userShieldingModule())->getUserFocus($data['user_number']);
    }

    //获取我的粉丝列表
    public function getUserFansAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $data = (new userShieldingModule())->getUserFans($data['user_number']);
    }

    //用户认证
    public function userCertificationAction(){
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $one =  (new userModule())->where(['number'=>$data['user_number']])->one();
        if ($one['is_certification']==1){
            returnFail(config('code')['2010'],config('code')['2010'],2010);
        }
        //获取状态值
        if(empty($data['user_number'])){
            returnFail(config('code')['202'],config('code')['202'],202);
        }
        if(empty($data['name'])){
            returnFail(config('code')['2003'],config('code')['2003'],2003);
        }
        if(empty($data['sex'])){
            returnFail(config('code')['2004'],config('code')['2004'],2004);
        }
        if(empty($data['id_card'])){
            returnFail(config('code')['2005'],config('code')['2005'],2005);
        }

        if(!preg_match("/^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}([0-9]|X)$/", $data['id_card'])) {//正则匹配 电话号码是否正确
            returnFail(config('code')['2005'],config('code')['2010'],2005);
        }
        if(empty($data['place'])){
            returnFail(config('code')['2007'],config('code')['2007'],2007);
        }
        if(empty($data['card_img'])){
            returnFail(config('code')['2007'],config('code')['2007'],2008);
        }
        if(empty($data['card_imgs'])){
            returnFail(config('code')['2008'],config('code')['2008'],2009);
        }
        //数据验证成功  修改用户状态
        $update = (new userModule())->where(['number'=>$data['user_number']])->update($data);
        if ($update){
            returnSuccess($data,config('code')['200'],200);
        }else{
            returnFail(config('code')['10001'],config('code')['10001'],10001);
        }
    }

    //返回关于我们中的文章
    public function getAllAgreementAction(){
        $arr = (new userAgreementModule())->orderBy('id asc')->all();
        $data = [];
        foreach ($arr as $k=>$v){
            $data[$k]['id'] = $v['id'];
            $data[$k]['name'] = $v['name'];
        }
        returnSuccess($data,config('code')['200'],200);
    }

    //获取关于我们中的协议
    public function getAboutAgreementAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        if(empty($data['id'])){
            returnFail(config('code')['2002'],[],2002);
        }
        $arr = (new userAgreementModule())->getOne($data['id']);
        returnSuccess($arr,config('code')['200'],200);
    }

    //获取用户的黑名单
    public function getUserBlacklistAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $data = (new userShieldingModule())->getUserBlacklist($data['user_number']);
    }

    //获取用户账号与安全状态
    public function getUserSecurityStatusAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $one = (new userModule())->where(['number'=>$data['user_number']])->one();
        if (empty($one)){
            returnFail(config('code')['205'],[],205);
        }
        $arr = [] ;
        if (empty($one['phone'])){
            $arr['status'] = false;
            $arr['msg'] = '未绑定手机号';
        }else{
            $arr['status'] = true;
            $arr['msg'] = '已绑定手机号';
            $arr['phone'] = $one['phone'];
        }
        returnSuccess($arr,config('code')['200'],200);
    }

    //绑定用户手机号
    public function bandUserPhoneAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        if(empty($data['phone'])){
            returnFail(config('code')['3002'],[],3002);
        }
        $reg_phone = '/0?(13|14|15|16|17|18|19)[0-9]{9}/';  //手机号码正则
        if(!preg_match($reg_phone,$data['phone'])){
            returnFail(config('code')['3003'],[],3003);
        }
        if(empty($data['code'])){
            returnFail(config('code')['3007'],[],3007);
        }
        //验证验证码
        $yan = (new smslogModel())->validationCode($data);
        //信息验证成功 修改用户手机号
        $data['update_time'] = date('Y-m-d H:i:s');
        $update = (new userModule())->bandUserPhone($data);
        if ($update){
            returnSuccess($update,config('code')['200'],200);
        }else{
            returnFail([],$this->getcodestr(1001),1001);
        }
    }

    //获取、修改用户的推送管理
    public function getUserPushAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $one = (new userModule())->where(['number'=>$data['user_number']])->one();
        if (empty($one)){
            returnFail([],$this->getcodestr(205),205);
        }
        if(empty($data['is_push'])){
            $arr = [];
            $arr['number'] = $data['user_number'];
            $arr['is_push'] = $one['is_push'];
            returnSuccess($arr,config('code')['200'],200);
        }else{
            //修改用户推送管理
            $one['is_push'] = $data['is_push'];
            $one['update_time'] = date('Y-m-d H:i:s');
            $update = (new userModule())->update($one);
            if ($update){
                returnSuccess($update,config('code')['200'],200);
            }else{
                returnFail([],$this->getcodestr(1001),1001);
            }
        }
    }

    //清空观看直播记录
    public function delUserSeeLogAction(){
        $userSeeLiveLogModule = new userSeeLiveLogModule();
        $user = $userSeeLiveLogModule->getUserInfoByToken();
        $userSeeLiveLogModule->where(["user"=>$user["number"]])->delete();
        returnSuccess([],getcodestr(200),200);
    }

    //清空搜索历史记录
    public function delUserSearchLogAction(){
        $searchModule = new searchModule();
        $user = $searchModule->getUserInfoByToken();
        $searchModule->where(["number"=>$user["number"]])->delete();
        returnSuccess([],getcodestr(200),200);
    }

    //获取聊天历史记录
    public function getUserSayAction(){
        $request = Request::unsetRoute()->all();
        if(empty($request["usernumbered"])){
            returnFail([],getcodestr(206),206);
        }
        $page = !empty($request["page"])?$request["page"]:1;
        $limit = !empty($request["limit"])?$request["limit"]:10;
        $offset = ($page * 1 - 1) * $limit;
        $userSayModule = new userSayModule();
        $user = $userSayModule->getUserInfoByToken();
        $user_say = $userSayModule
            ->where(["number"=>$user["number"],"usered_number"=>$request["usernumbered"]])
            ->orderBy("dtime desc,id desc")
            ->limit($offset,$limit)
            ->all();
        returnSuccess($user_say,getcodestr(200),200);

    }

    //判断两个用户之间的关系：黑名单状态、关注与粉丝关系
    public function userRelationshipAction(){
        $userModule = new userModule();
        $user_info = $userModule->getUserInfoByToken();
        $usered = $this->common->Post("user");
        //查询两个用户
        $usered_info = $userModule->getUserInfoByNumber($usered);
        if (empty($user_info) || empty($usered_info)){
            returnFail([],"用户账号异常");
        }

        //查询关系//
        $re_user = [];
        $re_usered = [];

        $userShieldingModule = new userShieldingModule();
        //判断是否关注与被关注
        $gz_user = $userShieldingModule->where(["user_number"=>$usered_info["number"],"usered_number"=>$usered,"type"=>2])->one();
        $gz_usered = $userShieldingModule->where(["user_number"=>$usered,"usered_number"=>$usered_info["number"],"type"=>2])->one();
        $re_user["is_focus"] = !empty($gz_user) ? 1 : 2;      //1关注 2未关注
//        $re_user["be_fans"] = !empty($gz_usered) ? 1 : 2;   //1被关注 2未被关注
        $re_usered["is_focus"] = !empty($gz_usered) ? 1 : 2;  //1关注 2未关注
//        $re_usered["be_fans"] = !empty($gz_user) ? 1 : 2;   //1被关注 2未被关注

        //判断是否拉黑与被拉黑
        $lh_user = $userShieldingModule->where(["user_number"=>$usered_info["number"],"usered_number"=>$usered,"type"=>1])->one();
        $lh_usered = $userShieldingModule->where(["user_number"=>$usered,"usered_number"=>$usered_info["number"],"type"=>1])->one();
        $re_user["is_black"] = !empty($lh_user) ? 1 : 2;      //1拉黑 2未拉黑
//        $re_user["be_black"] = !empty($lh_usered) ? 1 : 2;   //1被拉黑 2未被拉黑
        $re_usered["is_black"] = !empty($lh_usered) ? 1 : 2;  //1拉黑 2未拉黑
//        $re_usered["be_black"] = !empty($lh_user) ? 1 : 2;   //1被拉黑 2未被拉黑


//        $data = [];
//        $data[$usered_info["number"]] = $re_user;
//        $data[$usered] = $re_usered;

        returnSuccess($re_user);

    }

    ##########################################兑换类接口#######################################

    //用户印币兑换钻石列表
    public function userExchangeListAction(){
        //获取状态值
        $data = (new commonModule('sl_user_change_rules'))->where(['is_open'=>0])->orderBy('id asc')->all();
        returnSuccess($data,config('code')['200'],200);
    }

    //用户印币兑钻
    public function userExchangeAction(){
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $user_money = $xin['money']*1;
        if ($user_money<$data['num']){
            returnFail([],$this->getcodestr(2011),2011);
        }
        $now_money  = $user_money-($data['num']*1);
        $user_diamond = $xin['diamond']*1+$data['num']*1;
        //数据验证正确  修改用户状态
        $update = (new userModule())->where(['id'=>$xin['id']])->update(['money'=>$now_money,'diamond'=>$user_diamond,
                    'update_time'=>date('Y-m-d H:i:s')]);
        if ($update){
            //数据插入成功  创建日志
            $log = (new commonModule('user_pay_log'))->insert(['user_number'=>$data['user_number'],'type'=>3,
                'money'=>$data['num'],'diamond'=>$data['num'],'dtime'=>date('Y-m-d H:i:s')]);
            returnSuccess($log,config('code')['200'],200);
        }else{
            returnFail([],$this->getcodestr(1001),1001);
        }
    }
    ######################################暂定设计图##########################################



    #######################################我的发布###########################################
    //发布短视频或者图片动态
    public function userReleaseAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        if(empty($data['title'])){
            returnFail(config('code')['2012'],[],2012);
        }
        if(empty($data['url'])){
            returnFail(config('code')['2013'],[],2013);
        }
        if(empty($data['img'])){
            returnFail(config('code')['2014'],[],2014);
        }
        $data['create_time'] = date('Y-m-d H:i:s');
         //地址暂定
        //数据验证成功  插入数据库
        $insert = (new userVideoLogModule())->insert($data);
        if ($insert){
            returnSuccess($insert,config('code')['200'],200);
        }else{
            returnFail(config('code')['10001'],[],10001);
        }
    }

    //获取用户发布的小视屏
    public function getUserReleaseAction(){
        $data=Request::unsetRoute()->all();
        //获取状态值
        if(empty($data['page'])){
            returnFail(config('code')['2015'],[],2015);
        }
        if(empty($data['limit'])){
            returnFail(config('code')['2016'],[],2016);
        }
        $page = ($data['page']*1-1)*$data['limit'];
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        $arr = (new userVideoLogModule())->where(['user_number'=>$data['user_number'],'status'=>1])
            ->orderBy('create_time desc')->limit($page,$data['limit'])->all();
        foreach ($arr as $k=>$v){
            $arr[$k]['address'] = explode(';',$v['address']);
            //获取小视屏的收藏和评论量
            $arr[$k]['collection'] = (new userVideoModule())->where(['type'=>1,'video_id'=>$v['id']])->count();
            $arr[$k]['say'] = (new videoTalkModule())->where(['video_id'=>$v['id']])->count();
        }
        returnSuccess($arr,config('code')['200'],200);
    }

    //小视频收藏
    public function userCollectionAction(){
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        //获取状态值
        if(empty($data['type'])){
            //type 为1时  收藏 2时 分享
            returnFail(config('code')['201'],[],201);
        }
        if(empty($data['video_id'])){
            returnFail(config('code')['2017'],[],2017);
        }
        $data['create_time'] = date('Y-m-d H:i:s');
        if ($data['type']==1){
            $one = (new userVideoModule())->userCollection($data);
        }
        if($data['type']==2){
            $one = (new userVideoModule())->insert($data);
            if ($one){
                returnSuccess($one,config('code')['200'],200);
            }else{
                returnFail(config('code')['1001'],[],1001);
            }
        }
    }

    //用户小视屏评价
    public function userEvaluationAction(){

        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        if(empty($data['video_id'])){
            returnFail(config('code')['2017'],[],2017);
        }
        if(empty($data['content'])){
            returnFail(config('code')['2020'],[],2020);
        }
        $data['create_time'] = date('Y-m-d H:i:s');
        //数据验证成功 插入数据库
        $insert = (new videoTalkModule())->insert($data);
        if ($insert){
            returnSuccess($data,config('code')['200'],200);
        }else{
            returnFail(config('code')['1001'],[],1001);
        }
    }

    //获取官方动态
    public function getDynamicAction(){
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['user_number'] = $xin['number'];
        if(empty($data['page'])){
            returnFail(config('code')['2015'],[],2015);
        }
        if(empty($data['limit'])){
            returnFail(config('code')['2016'],[],2016);
        }
        if (empty($data['type'])){
            $arr = (new commonModule('sl_news_type'))->orderBy('sort desc')->limit(0,3)->all();
            $data['type'] = $arr[0]['id'];
        }
        $page = ($data['page']*1-1)*$data['limit'];
        $arr = (new newsModule())->where(['type'=>$data['type']])->orderBy('sort desc')->limit($page,$data['limit'])->all();
        $num = (new newsModule())->where(['type'=>$data['type']])->count();
        $ye = ceil($num/$data['limit']);
        foreach ($arr as $k=>$v){
            $arr[$k]['content']  = html_entity_decode($v['content']);
            $arr[$k]['content']  = strip_tags($arr[$k]['content']);
        }
        $dd = ['data' => $arr,
            'msg' => config('code')['200'],
            'code' => 200,
            'total'=>$ye];

        $this->common->ajaxReturn($dd);
    }

    //获取动态分类
    public function getDynamicTypeAction(){
        $data=Request::unsetRoute()->all();
        $arr = (new commonModule('sl_news_type'))->orderBy('sort desc')->limit(0,3)->all();
        returnSuccess($arr,config('code')['200'],200);
    }

    //获取用户的最近来访
    public function getUserHistoryAction(){
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['number'] = $xin['number'];

        if (empty($data['page'])){
            returnFail(config('code')['2033'],[],2033);
        }
        if (empty($data['limit'])){
            returnFail(config('code')['2034'],[],2034);
        }
        $page = ($data['page']*1-1)*$data['limit'];
        //获取用户的最近来访记录
        $arr = (new userHistoryModule())->where(['usered_number'=>$xin['number']])->orderBy("create_time desc")->limit($page,$data['limit'])->all();
        $user = [];
        //查询出来后  修改用户的最近来访数据
        foreach ($arr as $k=>$v){
            $update = (new userHistoryModule())->where(['id'=>$v['id']])->update(['is_see'=>1]);
            //查寻是用户的信息
            $one = (new userModule())->where(['number'=>$v['user_number']])->one();
            $user[$k]['avatar'] = $one['avatar'];
            $user[$k]['number'] = $one['number'];
            $user[$k]['nickname'] = $one['nickname'];
            $user[$k]['sex'] = $one['sex'];
            $user[$k]['age'] = $this->birthday($one['birthday']);
            $user[$k]['time'] =strtotime($v['create_time']);
            $user[$k]['time'] = date('m月d日H:i',$user[$k]['time']);
            //查询是否关注过该用户
            $focus = (new userShieldingModule())->where(['user_number'=>$xin['number'],'usered_number'=>$v['user_number'],'type'=>2])->one();
            empty($focus)?$user[$k]['is_focus'] = false:$user[$k]['is_focus'] = true;
        }
        returnSuccess($user,getcodestr(200),200);

    }

    //计算年龄
    public function birthday($birthday){
        $age = strtotime($birthday);
        if($age === false){
            return false;
        }
        list($y1,$m1,$d1) = explode("-",date("Y-m-d",$age));
        $now = strtotime("now");
        list($y2,$m2,$d2) = explode("-",date("Y-m-d",$now));
        $age = $y2 - $y1;
        if((int)($m2.$d2) < (int)($m1.$d1))
            $age -= 1;
        return $age;
    }

    //获取关注用户短视频
    public function getUserFocusVideoAction(){

        //获取参数
        $userModel = new userModule();
        $user = $userModel->getUserInfoByToken();
        $page = $this->common->Post("page");
        $limit = $this->common->Post("limit");
        $page = !empty($page) ? $page : 1;
        $limit = !empty($limit) ? $limit : 10;
        $offset = ($page * 1 - 1) * $limit;

        //查询关注用户
        $userShieldingModule = new userShieldingModule();
        $focus_users = $userShieldingModule
            ->where(["user_number"=>$user["number"],"type"=>2])
            ->all();
        $focus_user = [];
        foreach ($focus_users as $v){
            $focus_user[] = $v["usered_number"];
        }

        //查询短视频
        $video = [];
        if (!empty($focus_user)){
            $focus_user_str = implode(",",$focus_user);
            $shortVideoModule = new shortVideoModule();
            $video = $shortVideoModule
                ->where("user_number in ($focus_user_str) and status = 1")
                ->orderBy("create_time desc,id desc")
                ->limit($offset,$limit)
                ->all();

            //查询视频其它信息
            $userVideoModule = new userVideoModule();
            $videoTalkModule = new videoTalkModule();
            $videoTypeModule = new videoTypeModule();
            $videoSpanModule = new videoSpanModule();
            $userSeeVideoLogModule = new userSeeVideoLogModule();
            if (!empty($video)){
                foreach ($video as &$val){
                    $val['collection'] = $userVideoModule->where(['type' => 1,'video_id' => $val['id']])->count();   //收藏
                    $val['say'] = $videoTalkModule->where(['video_id' => $val['id']])->count();                      //评论
                    $val["type"] = $videoTypeModule->findOne($val["type"]);                                          //类型
                    //标签
                    if (!empty($v["span"])){
                        $val["span"] = $videoSpanModule->where("id in ({$val['span']})")->all();
                    }else{
                        $val["span"] = "";
                    }
                    $val["play"] = $userSeeVideoLogModule->where(["video" => $val["id"]])->count();                  //播放量
                    //查询用户头像
                    $up_info = $userModel->where(['number'=>$val['user_number']])->one();
                    $val['avatar'] = "https://zhibo.cdsile.cn".$up_info['avatar'];
                }
            }
        }
        returnSuccess($video,getcodestr(200),200);
    }

    ########################################直播相关######################################

    /**
     * 断播通知
     * 2020-6-3 14:48:09
     * junshi
     */
    public function breakNoticeAction(){

        //获取参数
        $request = Request::unsetRoute()->all();
        $title = $request["title"];     //流名
        $platform = (new platformModule())->orderBy("id asc")->one();
        $hub_name = $platform["hub_name"];
        $user_number = str_replace($hub_name,"",$title);

        //查询直播内容结束直播
        $userLiveLogModule = new userLiveLogModule();
        $live_info = $userLiveLogModule->getOneByWhere(["live_type"=>1,"user_number"=>$user_number]);
        $data = [
            "live_type" => 2,
            "is_offline" => 1,
            "finish_time" => date("Y-m-d H:i:s"),
        ];
        $userLiveLogModule->where(["id"=>$live_info["id"]])->update($data);
    }

    //获取我看过的主播
    public function getAnchorAction(){
        $data = Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['number'] = $xin['number'];
        $arr = (new userSeeLiveLogModule())->getUserSee($xin['number']);
        returnSuccess($arr,getcodestr(200),200);
    }

    //获取直播时长统计
    public function getLiveLogAction(){
        $data=Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['number'] = $xin['number'];
        $live = new liveController();
        $liu = 'cdsile-onlive'.$xin['number'];
        $log = $live->getStreamHistoryAction($liu);
        $num = 0;
        foreach ($log as $k=>$v){
            $num+=($v['end']*1-$v['start']*1);
        }
        $data['time'] = $this->time2string($num);
        returnSuccess($data,getcodestr(200),200);
    }

    function time2string($second){

        $day = floor($second/(3600*24));
        $second = $second%(3600*24);//除去整天之后剩余的时间

        $hour = floor($second/3600);
        $second = $second%3600;//除去整小时之后剩余的时间
        $minute = floor($second/60);
        $second = $second%60;//除去整分钟之后剩余的时间
        //返回字符串
        if (empty($day)){
            if (empty($hour)){
                if (!empty($minute)){
                    return $minute.'分'.$second.'秒';
                }else{
                    return $second.'秒';
                }
            }else {
                return $hour.'小时'.$minute.'分'.$second.'秒';
            }
        }else{
            return $day.'天'.$hour.'小时'.$minute.'分'.$second.'秒';
        }

    }

    //获取短视频评论列表
    public function getUserSayListAction(){
        $data=Request::unsetRoute()->all();
        if (empty($data['video_id'])){
            returnFail(config('code')['9009'],[],9009);
        }
        //查询初始评论
        $list  = (new videoTalkModule())->where(['video_id'=>$data['video_id'],'evaluation_id'=>''])->all();
        foreach ($list as $k=>$v){
            $list[$k]= $this->getOness($v['id'],$list[$k]);
            $list[$k]['nickname'] = (new userModule())->where(['number'=>$v['user_number']])->one();
            $list[$k]['avatar'] = $_SERVER['HTTP_HOST'].$list[$k]['nickname']['avatar'];
            $list[$k]['nickname'] = $list[$k]['nickname']['nickname'];
        }
        foreach ($list as $k=>$v){
            foreach ($v['child'] as $kk=>$vv){
                $list[$k]['child'][$kk]['nickname'] = (new userModule())->where(['number'=>$vv['user_number']])->one();
                $list[$k]['child'][$kk]['avatar'] = $_SERVER['HTTP_HOST'].$list[$k]['child'][$kk]['nickname']['avatar'];
                $list[$k]['child'][$kk]['nickname'] = $list[$k]['child'][$kk]['nickname']['nickname'];
                $one = (new videoTalkModule())->findOne($vv['evaluation_id']);
                $list[$k]['child'][$kk]['nicknamed'] = (new userModule())->where(['number'=>$one['user_number']])->one();
                $list[$k]['child'][$kk]['avatard'] = $_SERVER['HTTP_HOST'].$list[$k]['child'][$kk]['nicknamed']['avatar'];
                $list[$k]['child'][$kk]['nicknamed'] = $list[$k]['child'][$kk]['nicknamed']['nickname'];
            }
        }
        returnSuccess($list,getcodestr(200),200);
    }

    //递归  获取评论内容
     function getOness($id,$arr){
        $one = (new videoTalkModule())->where(['evaluation_id'=>$id])->one();
        if (!empty($one['content'])){
            $arr['child'][] = $one;
            return $this->getOness($one['id'],$arr);
        }else{
            return $arr;
        }
    }

    //用户搜索历史记录
    public function searchHistoryAction(){
        $data = Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['number'] = $xin['number'];
        //判断用户登录状态
        if (empty($xin)){
            //返回空的搜索记录
            returnSuccess([],getcodestr(200),200);
        }else{
            //查询用户的的搜索纪录
            $all = (new searchModule())->where(['number'=>$xin['number']])->all();
        }
        returnSuccess($all,getcodestr(200),200);
    }

    //用户搜索
    public function searchAction(){
        //用户搜索
        $data = Request::unsetRoute()->all();
        $xin = (new commonModule())->getUserInfoByToken();
        $data['number'] = $xin['number'];

        if (empty($data['text'])){
            returnFail(config('code')['2035'],[],2035);
        }
        $time = date('Y-m-d H:i:s');
        if (!empty($xin)){
            //查看用户是否搜索过该词
            $one = (new commonModule('sl_search'))->findBySql("select * from sl_search where number = '{$xin['number']}' and text= '{$data['text']}' ");
            if (empty($one)){
                $insert = (new commonModule('sl_search'))->insert(['dtime'=>$time,'number'=>$xin['number'],'text'=>$data['text']]);
            }else{
                $update = (new commonModule('sl_search'))->where(['id'=>$one['id']])->update(['dtime'=>$time]);
            }
        }

        //查询用户
        $all = (new userModule())->getUserList($data['text']);
        $userShieldingModule = new userShieldingModule();
        foreach ($all as &$v){
            $follow_info = $userShieldingModule->where(["user_number"=>$xin['number'],"usered_number"=>$v["number"],"type"=>2])->one();
            $v["is_follow"] = !empty($follow_info) ? 1 : 2;
        }
        returnSuccess($all,getcodestr(200),200);
    }

    /**
     * 为您推荐
     * tip：按照用户观看主播类型来推，没有记录就推送热门
     * 2020-9-3 15:41:53
     * junshi
    */
    public function liveRecommendAction(){
        $user = (new commonModule())->getUserInfoByToken();
        $type = (new userSeeLiveLogModule())->getList($user["number"]);
        $userLiveLogModel = new userLiveLogModule();
        //判断是否有类型
        $where = "live_type = 1";
        if (!empty($type)){
            $type_str = implode(",",$type);
            $where .= " and type_id in ($type_str)";
        }
        $live = $userLiveLogModel->where($where)->orderBy("user_num desc,create_time desc")->limit(0,10)->all();
        returnSuccess($live,getcodestr(200),200);
    }

    /**
     * 查询主播日数据月数据
     * parameter:type 1 日数据 2月数据 date 查询日期 yyy-mm-dd格式
     * 2020-9-3 16:32:10
     * junshi
    */
    public function anchorProfitAction(){
        $request = Request::unsetRoute()->all();
        $userModule = new userModule();
        $user = $userModule->getUserInfoByToken();
        $userModule->getAnchorProfit($request,$user["number"]);
    }

    /**
     * 查询直播间信息
     * 2020-10-10 15:48:45
     * junshi
     */
    public function getRoomInfoAction(){
        $user_number = $this->common->Post("user_number");
        $where = [
            "user_number" => $user_number,
            "live_type" => 1,
            "is_offline" => 2
        ];
        $data = (new userLiveLogModule())
            ->where($where)
            ->orderBy("id desc")
            ->one();
        if (!empty($data)){
            returnSuccess($data);
        }
        returnFail([],"用户未开启直播");
    }

    /**
     * 获取举报类型
     * 2020-10-10 17:16:03
     * junshi
     */
    public function getReportTypeAction(){
        $data = (new userReportTypeModule())->orderBy("sort desc")->all();
        returnSuccess($data);
    }

    /**
     * 举报
     * 2020-10-10 15:48:45
     * junshi
     */
    public function userReportAction(){
        $request = Request::unmeaning()->all();
        $userReportModule = new userReportModule();
        $user = $userReportModule->getUserInfoByToken();
        $userReportModule->userReport($request,$user);
    }

    #######################################分享收益###########################################

    /**
     * 添加分享记录
     * 2020-9-4 10:08:25
     * junshi
    */
    public function addShareLogAction(){
        //获取参数，参数验证
        $request = Request::unsetRoute()->all();
        $userShareModule = new userShareModule();
        $userShareModule->addShareLog($request);
    }

    /**
     * 查询个人分享收益
     * 2020-9-4 11:08:44
     * junshi
    */
    public function getShareLogAction(){
        $userShareModule = new userShareModule();
        $user = $userShareModule->getUserInfoByToken();
        $shareLog = $userShareModule->where(["user_number"=>$user["number"]])->all();
        $coin = 0;
        $userModule = new userModule();
        foreach ($shareLog as &$v){
            $coin += $v["coin"] * 1;
            $v["nickname"] = $userModule->getUserInfoByNumber($v["usered_number"])["nickname"];
        }
        $data = [
            "coin" => $coin,
            "num" => count($shareLog),
            "list" => $shareLog
        ];
        returnSuccess($data,getcodestr(200),200);
    }


}