<?php

/**
 * 贵族系统
 * 2020-4-11 17:05:31
 * junshi
*/

class vipController extends baseController
{
    /**
     * 查询贵族列表
    */
    public function getVipListAction(){
        $vip_list = (new vipPackageModule())->getAllBySort();
        //查询贵族特权
        $vipPowerModule = new vipPowerModule();
        foreach ($vip_list as $k => $v){
            $vip_power = explode(",",$v["privilege"]);
            $vip_power_arr = [];
            foreach ($vip_power as $k1 => $v1){
                $vip = $vipPowerModule->findOne($v1);
                $vip_power_arr[] = $vip;
            }
            $vip_list[$k]["vip_power"] = $vip_power_arr;
        }
        returnSuccess($vip_list,getcodestr(200),200);
    }

    /**
     * 根据id查询贵族信息
    */
    public function getVipOneAction(){
        $id = $this->common->Post("id");
        $vip = (new vipPackageModule())->findOne($id);
        if (empty($vip)){
            returnFail([],getcodestr(7001),7001);
        }
        $vip_power = explode(",",$vip["privilege"]);
        $vip_power_arr = [];
        foreach ($vip_power as $k1 => $v1){
            $vip_power_arr[] = (new vipPowerModule())->findOne($v1);
        }
        $vip["vip_power"] = $vip_power_arr;
        returnSuccess($vip,getcodestr(200),200);
    }

    /**
     * 查询开通说明
    */
    public function getOpenNoteAction(){
        $type = $this->common->Post("type");
        //参数判断
        if (empty($type)){
            returnFail([],getcodestr(7002),7002);
        }
        if (!in_array($type,[1,2])){
            returnFail([],getcodestr(7002),7002);
        }
        //查询说明
        $note = (new vipNoteModule())->getAllBySort(["type" => $type]);
        returnSuccess($note,getcodestr(200),200);
    }

    /**
     * 获取贵族单价列表
    */
    public function getVipPriceListAction(){
        $id = $this->common->Post("vip");
        $vip = (new vipPackageModule())->findOne($id);
        if (empty($vip)){
            returnFail([],getcodestr(7001),7001);
        }
        //查询贵族价格
        $vip_price = (new vipPriceModule())->getAllBySort(["vip"=>$id]);
        foreach ($vip_price as &$v){
            //到期时间
            $v["over_time"] = date("Y-m-d",time() + $v["days"] + 24 * 3600);
        }
        returnSuccess($vip_price,getcodestr(200),200);
    }

    /**
     * 开通贵族
     * 需要判断的信息：
     * 1.验证开通等级限制
     * 2.验证支付方式（连续包月不可使用贵族币与贵族积分）
     * 3.使用贵族币支付验证贵族币是否足够，不够提醒充值
     * 4.判断是否使用积分支付，使用积分支付时判断积分抵扣情况
    */
    public function openingVipAction(){

        //获取参数信息
        $request = Request::unsetRoute()->all();
        $vipOrderModule = new vipOrderModule();
        $user_info = $vipOrderModule->getUserInfoByToken();
        //参数判断
        $res = $vipOrderModule->verOpeningVip($request,$user_info);
        if ($res){
            $this->payOrderAction($res);
        }else{
            returnFail([],getcodestr(7008),7008);
        }
    }

    /**
     * 订单创建成功，执行支付
    */
    public function payOrderAction($order){
        $res = (new vipOrderModule())->payOrder($order);
        if ($res){
            //支付成功，执行回调逻辑
            $this->vipPaySuccess($order);
        }else{
            returnFail([],getcodestr(8001),8001);
        }
    }

    /**
     * 贵族支付成功后的逻辑处理
     * 1.给用户开通贵族，扣除相应积分、贵族币
     * 2.记录用户消费日志
     * 3.修改订单状态
    */
    public function vipPaySuccess($order_number){

        //查询订单信息
        $vipOrderModule = new vipOrderModule();
        $order = $vipOrderModule->getInfoByOrderNumber($order_number);
        //查询套餐价格信息
        $price_info = (new vipPriceModule())->findOne($order["vip_price"]);
        //查询用户信息
        $userModule = new userModule();
        $user_info = $userModule->getUserInfoByToken();

        //给用户开通贵族，扣除相应积分、贵族币
        $vip_over_time = $user_info["vip_over_time"];
        if (strtotime($vip_over_time) > time()){    //以前的vip
            $vip_over_time_now = strtotime($vip_over_time) + $price_info["days"] * 24 * 3600;
        }else{
            $vip_over_time_now = time() + $price_info["days"] * 24 * 3600;
        }

        //支付的贵族币
        $pay_coin = $order["pay_method"] == 3?$order["pay"]:0;
        $noble_currency = $user_info["noble_currency"] + $price_info["vip_coin"] - $pay_coin;       //贵族币
        $noble_integral = $user_info["noble_integral"] + $price_info["score"] - $order["score"];    //贵族积分
        $diamond = $user_info["diamond"] + $price_info["diamond"];

        //组合用户修改数据
        $user_update = [
            "is_vip" => 1,                                                          //贵族
            "vip_type" => $order["vip"],                                            //贵族类型
            "vip_over_time" => date("Y-m-d H:i:s",$vip_over_time_now),      //到期时间
            "noble_currency" => $noble_currency,                                    //贵族币
            "noble_integral" => $noble_integral,                                    //贵族积分
            "diamond" => $diamond,                                                  //钻石
        ];
        $userModule->start_T();
        $res_user_update = $userModule->where(["id"=>$user_info["id"]])->update($user_update);

        //订单状态
        $order_update = [
            "status" => 2,                                  //订单状态
            "pay_time" => date("Y-m-d H:i:s"),      //支付时间
        ];
        $res_order_update = $vipOrderModule->where(["id"=>$order["id"]])->update($order_update);

        //开通贵族记录
        $insert_log = [
            "user" => $user_info["number"],
            "vip" => $order["vip"],
            "create_time" => date("Y-m-d H:i:s"),
            "over_time" => date("Y-m-d H:i:s",$vip_over_time_now),
        ];
        $res_insert_log = (new userNobleModule())->insert($insert_log);

        //结果
        if ($res_user_update && $res_order_update && $res_insert_log){  //成功
            $userModule->comit_T();
            returnSuccess([],getcodestr(200),200);
        }else{  //失败
            $userModule->roll_T();
            returnFail([],getcodestr(10001),10001);
        }

    }

    /**
     * 贵族特权
    */

}