<?php

/**
 * 验证token
 * @date:2020-5-9 10:20:05
 * @author: junshi
 * @param: $GLOBALS
 * @return:
 */
function checktoken($tokenstr) {
    $common = new Common();
    $appkey = $GLOBALS['config_api']['appkey'];

    $tokenArray = unserialize($common->decryptByqingmiphp($tokenstr));
    $data = $tokenArray;

    $returndata['status'] = false;
    $returndata['msg'] = "error";
    $returndata['code'] = 2001;

    if($data["appkey"] != $appkey){
        $returndata['msg'] ="token错误";
        $returndata['code'] = 5401;
        return $returndata;
    }

    if($data['time'] < time()){
        $returndata['msg']="token 超时";
        $returndata['code']=1403;
        return $returndata;

    }

    //验证用户是否存在
    if($data[""] == 1){
        //访客登录
        $UserM = new UserModule();
        $userdata=$UserM->getUserdataByUsernumber($data["user_number"]);
        if(count($userdata)==0){
            $returndata['msg']="用户不存在";
            $returndata['code']=1404;
            return $returndata;
        }else{
            //var_dump($userdata);die();
        }
    }else if($data[""]==2){
        //员工登录
        $ImUserM = new ImUserModule();
        $userdata=$ImUserM->getUserdataByUsernumber($data["user_number"]);
        if(count($userdata)==0){
            $returndata['msg']="用户不存在";
            $returndata['code']=1404;
            return $returndata;
        }else{
            //var_dump($userdata);die();
        }

    }else{
        $returndata['msg']="用户类型不存在";
        $returndata['code']=1404;
    }

    $returndata['status'] = true;
    $returndata['msg'] = "token 合法";
    $returndata['code'] = 1000;
    return $returndata;

}

/**
 * 验证签名是否正确
 * @date: 2019年1月28日 下午7:01:24
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */
function checksign($signstr){

    $returndata['status']=false;
    $returndata['msg']="error";

    if($signstr!=getsign())
    {
        $returndata['msg']="签名错误";
        return $returndata;
    }else{
        $returndata['status']=true;
        $returndata['msg']="签名正确";
        return $returndata;
    }

}

/**
 * 生成签名
 * @date: 2019年1月28日 下午6:16:47
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */
function getsign(){

    $data= Request::unsetRoute()->all();
    //var_dump($data);die();
    if(!empty($data['zutu'])){
        $data['zutu']= $_REQUEST["zutu"];
    }
    //去掉sign和token
    if (array_key_exists("sign",$data ) ) {
        unset($data['sign']);
    }
    if (array_key_exists("token",$data ) ) {
        //unset($data['token']);
    }

    $ASCIIstr= strtolower(ASCII($data));
    return strtoupper(md5($ASCIIstr));
}

//自定义ascii排序
function ASCII($params = array()){
    if(!empty($params)){
        $p =  ksort($params);
        if($p){
            $str = '';
            foreach ($params as $k=>$val){
                $str .= $k  . $val;
            }
            $strs =$str;
            return $strs;
        }
    }
    return '参数错误';
}

/**
 * 二维数组的重复项：
 * @date: 2019年2月27日 下午3:37:14
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */

function assoc_unique($arr, $key="id") {

    $tmp_arr = array();

    foreach ($arr as $k => $v) {

        if (in_array($v[$key], $tmp_arr)) {//搜索$v[$key]是否在$tmp_arr数组中存在，若存在返回true

            unset($arr[$k]);

        } else {

            $tmp_arr[] = $v[$key];

        }

    }

    sort($arr); //sort函数对数组进行排序

    return $arr;

}

/**
 * 多维数组排序
 * @date: 2019年6月20日 下午5:12:00
 * @author: 龚华尧
 * @param: $GLOBALS
$data[] = array('volume' => 67, 'edition' => 2);
$data[] = array('volume' => 86, 'edition' => 1);
$data[] = array('volume' => 85, 'edition' => 6);
$data[] = array('volume' => 98, 'edition' => 2);
$data[] = array('volume' => 86, 'edition' => 6);
$data[] = array('volume' => 67, 'edition' => 7);
// Pass the array, followed by the column names and sort flags
$sorted = array_orderby($data, 'volume', SORT_DESC, 'edition', SORT_ASC);
 * @return:
 */
function array_orderby()
{
    $args = func_get_args();
    $data = array_shift($args);
    foreach ($args as $n => $field) {
        if (is_string($field)) {
            $tmp = array();
            foreach ($data as $key => $row)
                $tmp[$key] = $row[$field];
            $args[$n] = $tmp;
        }
    }
    $args[] = &$data;
    call_user_func_array('array_multisort', $args);
    return array_pop($args);
}

/**
 * 计算相似性函数
 * @date: 2019年6月21日 上午10:56:19
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */
function similarity(array $vec1, array $vec2) {
    return dotProduct($vec1, $vec2) / (absVector($vec1) * absVector($vec2));
}

function dotProduct(array $vec1, array $vec2) {
    $result = 0;
    foreach (array_keys($vec1) as $key1) {
        foreach (array_keys($vec2) as $key2) {
            if ($key1 === $key2) $result += $vec1[$key1] * $vec2[$key2];
        }
    }
    return $result;
}

function absVector(array $vec) {
    $result = 0;
    foreach (array_values($vec) as $value) {
        $result += $value * $value;
    }
    return sqrt($result);
}

/**
 * 实用的php清除html,php去除空格与换行,php清除空白行和换行,提取页面纯文本
 * @date: 2019年6月21日 下午5:02:36
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */
function DeleteHtml($str)
{
    $str = trim(strip_tags($str)); //清除字符串两边的空格
    $str = preg_replace("/\t/","",$str); //使用正则表达式替换内容，如：空格，换行，并将替换为空。
    $str = preg_replace("/\r\n/","",$str);
    $str = preg_replace("/\r/","",$str);
    $str = preg_replace("/\n/","",$str);
    $str = preg_replace("/ /","",$str);
    $str = preg_replace("/  /","",$str);  //匹配html中的空格
    $str = str_replace("&nbsp;","",$str);

    return trim($str); //返回字符串
}

/**
 * 去掉数组中的空值
 * @date: 2019年6月28日 上午7:31:32
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */
function Arrayremove_nullvalue($arr) {
    foreach( $arr as $k=>$v){
        if( !$v )
            unset( $arr[$k] );
    }
    return $arr;
}

/**
 * 查询接口参数
 * @date: 2019年7月13日 下午6:13:16
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */
function RequestBody($key="")
{

    //获取body里的参数
    $bodyData = @file_get_contents('php://input');
    //将获取到的值转化为数组格式
    $bodyData = json_decode($bodyData,true);
    if($bodyData==""){
        return "";
    }else{
        if($key==""){
            return $bodyData;
        }else{
            return $bodyData[$key];
        }

    }

}

/**
 * 查询header参数
 * @date: 2019年7月13日 下午6:18:59
 * @author: 龚华尧
 * @param: $GLOBALS
 * @return:
 */
function GetHeader($key="AUTHORIZATION") {
    //获取header里的参数Authorization
    //如果header里放入的值为Authorization，到header里会自动加上HTTP_，并且转化为大写，取值时如下
    $data = $_SERVER['HTTP_'.strtoupper($key)];
    if($data==""){
        return "";
    }else{
        return $data;
    }
}