<?php

/**
 * 直播监控
 * 2020-4-26 11:27:10
 * junshi
*/

include LIB_PATH.'qiniu'.DS.'lib'.DS.'Pili_v2.php';

class liveMonitorController extends baseController {

    //公共参数
    private $ak;                 //Access Key
    private $sk;                 //Secret Key200
    private $hubName;            //空间名称
    //域名地址
    private $rtmp_push;          //RTMP推流
    private $rtmp_play;          //RTMP播放
    private $hls_play;           //HLS播放
    private $hdl_play;           //HDL播放
    private $cover;              //直播封面/截图
    private $choose_play;        //点播
    private $main_key;           //防盗链主密钥
    private $fu_key;             //防盗链副密钥
    private $main_url;           //主域名

    //构造函数查询出所需数据
    public function __construct()
    {
        parent::__construct("BaseController");

        //公共参数
        $platform = (new platformModule())->getInfoByHubName("cdsile-onlive");
        $this->ak = $platform["access_key"];
        $this->sk = $platform["secret_key"];
        $this->hubName = $platform["hub_name"];
        $this->rtmp_push = $platform["rtmp_push"];
        $this->rtmp_play = $platform["rtmp_play"];
        $this->hls_play = $platform["hls_play"];
        $this->hdl_play = $platform["hdl_play"];
        $this->cover = $platform["cover"];
        $this->choose_play = $platform["choose_play"];
        $this->main_key = $platform["main_key"];
        $this->fu_key = $platform["fu_key"];
        $this->main_url = $platform["main_url"];

    }

	/**
     * 监控正在直播的主播
     *
	*/
	public function indexAction(){

	    //查询正在直播的主播
        $userLiveLog = new userLiveLogModule();
        $live = $userLiveLog->getOnLiveAll();
        if (empty($live)){
            die("目前暂无直播！");
        }
	    include CUR_VIEW_PATH . "SliveMonitor".DS."index.html";

	}

	/**
     * 播放 play
	*/
	public function playAction(){

	    //获取直播信息
	    $id = $this->common->Get("id");
        $userLiveLog = new userLiveLogModule();
        $live = $userLiveLog->findOne($id);
        //查询用户信息
        $userModule = new userModule();
        $user = $userModule->getUserInfoByNumber($live["user_number"]);
        $live["user"] = $user;
        //获取播放地址
        $play_url = $this->getHDLPlay($this->hubName.$user["number"],3600);
        $replace = 'http://'.$this->hdl_play;   //反向代理
        $live["play_url"] = str_replace($replace,$this->main_url,$play_url);

        //获取直播时长
        $live["live_time"] = $this->backLiveTime(time() - strtotime($live["create_time"]));
        //获取警告主播
        $user_number = $this->common->Get("id");
        //查询警告类型
        $warning_type = (new warningTypeModule())->getAllBySort();
        include CUR_VIEW_PATH . "SliveMonitor".DS."play.html";

    }

    /**
     * 警告
    */
    public function warningAction(){
        $id = $this->common->Post("id");
        returnSuccess($id,"OK",0);
    }

    /**
     * 警告内容
    */
    public function warningContentAction(){
        //获取警告主播
        $user_number = $this->common->Get("id");
        //查询警告类型
        $warning_type = (new warningTypeModule())->getAllBySort();
        include CUR_VIEW_PATH ."SliveMonitor".DS."warningContent.html";
    }

    /**
     * 警告主播
    */
    public function warningUserAction(){

        //获取参数
        $request = Request::unsetRoute()->all();
        $id = $request['id'];

        //执行添加
        $liveWarningModule = new liveWarningModule();
        $liveWarningModule->warning($request,$id);

    }

    /**
     * 禁播
     */
    public function banAction(){
        $number = $this->common->Post("id");
        $res = (new userModule())->ban($number);
        if ($res){
            returnSuccess([],"禁播成功",200);
        }else{
            returnFail([],"禁播失败",-1);
        }
    }

    /**
     * 关闭
     */
    public function closeAction(){
        $id = $this->common->Post("id");
        $res = (new userLiveLogModule())->close($id);
        if ($res){
            returnSuccess([],"关播成功",200);
        }else{
            returnFail([],"关播失败",-1);
        }
    }

    /**
     * 获取HDL直播地址
     * parameter:
     * hub_name     空间名称
     * streamKey    流名称
     * time         防盗链有效时间，默认5分钟
     * return: url  推流地址
     */
    public function getHDLPlay($streamKey,$time){
        //验证参数
        $time = !empty($time)?$time:300;  //防盗链有效时间
        $url = Qiniu\Pili\HDLPlayURL($this->hdl_play, $this->hubName, $streamKey);
        $path = "/".$this->hubName."/".$streamKey.".flv";  //兑换防盗链
        $url_final = $this->getPlaySign($url,$path,$time);
        return $url_final;
    }

    //获取直播防添加盗链后的播放地址
    public function getPlaySign($url,$path,$time = 60 * 5){
        $t = dechex(time() + $time);   //有效时间5分钟
        $s = $this->main_key.$path.$t;
        $sign = strtolower(md5($s));
        $url_final = $url."?sign=".$sign."&t=".$t;
        return $url_final;
    }

    //返回直播时长
    public function backLiveTime($seconds){
        $hour = floor($seconds/3600);
        $minute = floor(($seconds-3600 * $hour)/60);
        $second = floor((($seconds-3600 * $hour) - 60 * $minute) % 60);
        $hour = $hour<10?"0".$hour:$hour;
        $minute = $minute<10?"0".$minute:$minute;
        $second = $second<10?"0".$second:$second;
        $result = $hour.':'.$minute.':'.$second;
        return $result;
    }

}