<?php
// 商品类型模型
class tableModel extends Model
{
    public function __construct()
    {
        parent::__construct("table");
    }

    public function getall($page=0,$limit=10)
    {
        $page = $page==""?0:($page-1);
        $limit= $limit==""?0:$limit;
        $tablelist = $this->findBySql("SELECT *,(SELECT u2 from sl_parameter where u1=mx.u3 ) as tablelianjie from sl_table as mx order by id desc limit ".$page*$limit.",".$limit );
        return  $tablelist;

    }

    public function getTablenameByTableid($table_id) {
        $tabledetail = $this->findOne($table_id);
        if(!empty($tabledetail))
        {
            return $tabledetail['u1'];
        }else{
            return "";
        }
    }



    /**

     * 判断是否已存在

     * @date: 2018年9月28日 下午6:35:04

     * @author: 龚华尧

     * @param: variable

     * @return:

     */
    public function isadded($table)
    {
        $data['u1']=$table['u1'];
        $data['u2']=$table['u2'];

        if($this->where($data)->all())
        {
            return false;
        }else {
            return true;
        }
    }

    // 删除表和sl_fileds 里对应的字段
    function deleteModel($model_id, $model_name)
    {
        $filedModel = new Model("filed");
        $this->db->exec_update_delete("drop table $model_name ");
        $this->db->exec_update_delete("delete from sl_filed where model_id='{$model_id}' ");
    }

    // 根据模型类型，添加模型
    public function addtableByType($type, $tableName)
    {
        switch (trim($type)) {
            case "文章模型":
                $this->createArticleModelTable($type, $tableName);
                $this->addFiled($tableName);
                break;
            case "表单模型":
                $this->createBiaodanModelTable($type, $tableName);
                $this->addFiled($tableName);
                break;

            case "用户模型":
                $this->createYonghuModelTable($type, $tableName);
                $this->addFiled($tableName);
                break;

            case "分类模型":
                $this->createCategoryModelTable($type, $tableName);
                $this->addFiled($tableName);
                break;

            case "商品模型":
                $this->createGoodsModelTable($type, $tableName);
                $this->addProductFiled($tableName);
                break;

            default:
                echo "没有这个模型!";
        }
    }

    /*
     * `model_id` varchar(50) CHARACTER SET utf8 DEFAULT ' ' COMMENT '模型id',
     * `u1` varchar(50) CHARACTER SET utf8 DEFAULT ' ' COMMENT '数据库字段名',
     * `u2` varchar(50) CHARACTER SET utf8 DEFAULT ' ' COMMENT '字段名称',
     * `u3` varchar(50) CHARACTER SET utf8 DEFAULT ' ' COMMENT '字段提示',
     * `u4` varchar(10) CHARACTER SET utf8 DEFAULT '否' COMMENT '是否必填',
     * `u5` varchar(10) CHARACTER SET utf8 DEFAULT '否' COMMENT '是否显示',
     * `u6` varchar(10) CHARACTER SET utf8 DEFAULT '否' COMMENT '是否检索',
     *
     * `u7` varchar(50) CHARACTER SET utf8 DEFAULT '文本框' COMMENT '字段类型',
     * `u8` varchar(50) CHARACTER SET utf8 DEFAULT ' ' COMMENT '默认值',
     * `u9` varchar(50) CHARACTER SET utf8 DEFAULT '10%' COMMENT '列表CSS',
     * `u10` varchar(10) CHARACTER SET utf8 DEFAULT '0' COMMENT '排序',
     */
    public function addFiled($tableName)
    {
        $filed = new Model("filed");
        $table = new Model($tableName);
        $model_id = $this->where(["u1"=>$tableName])->one()['id'];
        $array = $table->getFieldsAndTypes();
        foreach ($array as $v) {
            if ($v['column_name'] != 'id' && $v['column_name'] != 'sort_id' ) {

                $data['model_id'] = $model_id;
                $data['u1'] = $v['column_name'];
                $data['u2'] = $v['column_comment'];
                $data['u3'] = "";
                $data['u4'] = ($v['is_nullable'] == 'YES') ? '否' : '是';
                $data['u5'] = '否';
                $data['u6'] = '否';
                $data['u8'] = $v['column_default'];
                $data['u9'] = "80";
                $data['u10'] = $v['id'];

                // 得到字段的类型
                $filed_type = "文本框";
                switch ($v['data_type']) {
                    case "int":
                        $filed_type = "数字";
                        break;
                    case "mediumint":
                        $filed_type = "数字";
                        break;
                    case "tinyint":
                        $filed_type = "数字";
                        break;
                    case "smallint":
                        $filed_type = "数字";
                        break;
                    case "decimal":
                        $filed_type = "金额";
                        break;
                    case "char":
                        if($data['u2']=="密码")
                        {
                            $filed_type = "密码";
                        }else if($data['u2']=="编号"){
                            $filed_type = "编号";
                        }else if($data['u2']=="商品规格"){
                            $filed_type = "商品规格";
                        }else if($data['u2']=="商品价格"){
                            $filed_type = "商品价格";
                        }else
                        {
                            $filed_type = "文本框";
                        }

                        break;
                    case "mediumtext":
                        $filed_type = "文本编辑器";
                        break;
                    case "varchar":
                        $filed_type = "文本域";
                        break;
                    case "timestamp":
                        $filed_type = "时间框";
                        break;
                }
                $data['u7'] = $filed_type;
                //是否显示
                $data['u5'] = '是';

                $filed->insert($data);
            }
        }
    }

    // 创建文章模型表的SQL
    public function createArticleModelTable($type, $tableName)
    {
        $sql = "
        CREATE TABLE `{$tableName}` (
        `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
        `sort_id` char(100) DEFAULT '0' COMMENT '分类id',
        `biaoti` char(100) NOT NULL DEFAULT '' COMMENT '标题',
        `laiyuan` char(100)  NULL DEFAULT '' COMMENT '来源',
        `status`char(100) NULL DEFAULT '终审' COMMENT '状态：待审,终审,回收站',
        `paixu` int(10) unsigned DEFAULT '1' COMMENT '排序',
        `url` char(100) DEFAULT NULL COMMENT '链接',
        `suolutu` char(100) DEFAULT NULL COMMENT '缩略图',
        `description` varchar(250) DEFAULT NULL COMMENT '文章摘要',
        `content` mediumtext COMMENT '详细内容',
        `seokeywords` varchar(250) DEFAULT NULL COMMENT 'seo关键字',
        `seodescription` varchar(250) DEFAULT NULL COMMENT 'seo描述',
        `seotitle` varchar(250) DEFAULT NULL COMMENT 'SEO标题',
        `username` char(100) DEFAULT NULL COMMENT '用户名',
        `dtime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '添加时间',
        PRIMARY KEY (`id`)
        ) ENGINE=INNODB  DEFAULT CHARSET=utf8  AUTO_INCREMENT=1 COMMENT='{$tableName}模型主表';";

        if ($this->db->exec_update_delete($sql)) {
            return true;
        } else {
            // 失败返回false
            return false;
        }
    }

    // 创建表单模型表的SQL
    public function createBiaodanModelTable($type, $tableName)
    {
        $sql = "
        CREATE TABLE `{$tableName}` (
        `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
        
        `dtime` timestamp NULL DEFAULT now() COMMENT '添加时间',
        PRIMARY KEY (`id`)
        ) ENGINE=INNODB  DEFAULT CHARSET=utf8  AUTO_INCREMENT=1 COMMENT='{$tableName}模型主表';";

        if ($this->db->exec_update_delete($sql)) {
            // 成功，并判断受影响的记录数
            return true;
        } else {
            // 失败返回false
            return false;
        }
    }


    // 创建用户模型表的SQL
    public function createYonghuModelTable($type, $tableName)
    {
        $sql = "
        CREATE TABLE `{$tableName}` (
        `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
        `yonghuming` char(100) NOT NULL DEFAULT '' COMMENT '用户名',
        `mima` char(200) NOT NULL DEFAULT '' COMMENT '密码',
        `dtime` timestamp NULL DEFAULT now() COMMENT '添加时间',
        PRIMARY KEY (`id`)
        ) ENGINE=INNODB  DEFAULT CHARSET=utf8  AUTO_INCREMENT=1 COMMENT='{$tableName}模型主表';";

        if ($this->db->exec_update_delete($sql)) {
            return true;
        } else {
            // 失败返回false
            return false;
        }
    }


    // 创建分类模型表的SQL
    public function createCategoryModelTable($type, $tableName)
    {
        $sql = "
        CREATE TABLE `{$tableName}` (
        `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
        `class_id` char(100) DEFAULT '0' COMMENT '分类id',
        `biaoti` char(100) NOT NULL DEFAULT '' COMMENT '标题',
        `paixu` int(10) unsigned DEFAULT '1' COMMENT '排序',
        `dtime` timestamp NULL DEFAULT now() COMMENT '添加时间',
        PRIMARY KEY (`id`)
        ) ENGINE=INNODB  DEFAULT CHARSET=utf8  AUTO_INCREMENT=1 COMMENT='{$tableName}模型主表';";

        if ($this->db->exec_update_delete($sql)) {
            // 成功，并判断受影响的记录数
            return true;
        } else {
            // 失败返回false
            return false;
        }
    }


    // 创建商品模型表的SQL
    public function createGoodsModelTable($type, $tableName)
    {
//        $sql = "
//        CREATE TABLE `{$tableName}` (
//        `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
//        `goods_number` char(100) DEFAULT '' COMMENT '编号',
//        `biaoti` char(100) NOT NULL DEFAULT '' COMMENT '标题',
//        `goods_parameter` char(100) DEFAULT '' COMMENT '商品规格',
//        `goods_price` char(100) DEFAULT '0' COMMENT '商品价格',
//        `paixu` int(10) unsigned DEFAULT '1' COMMENT '排序',
//        `dtime` timestamp NULL DEFAULT now() COMMENT '添加时间',
//        PRIMARY KEY (`id`)
//        ) ENGINE=INNODB  DEFAULT CHARSET=utf8  AUTO_INCREMENT=1 COMMENT='{$tableName}模型主表';";

        $sql="
        CREATE TABLE `{$tableName}` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT COMMENT '商品id', 
  `cate_id` varchar(64) NOT NULL COMMENT '分类id',
  `mer_id` int(10) unsigned  DEFAULT '0' COMMENT '商户Id(0为总后台管理员创建,不为0的时候是商户后台创建)',
  `image` varchar(256) NOT NULL COMMENT '商品图片',
  `slider_image` varchar(2000) NOT NULL COMMENT '轮播图',
  `store_name` varchar(128) NOT NULL COMMENT '商品名称',
  `store_info` varchar(256) NOT NULL COMMENT '商品简介',
  `keyword` varchar(256) NOT NULL COMMENT '关键字',
  `bar_code` varchar(15)  DEFAULT '' COMMENT '产品条码（一维码）',
  `price` decimal(8,2) unsigned  DEFAULT '0.00' COMMENT '商品价格',
  `vip_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '会员价格',
  `ot_price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '市场价', 
  `cost` decimal(8,2) unsigned NOT NULL COMMENT '成本价',
  `postage` decimal(8,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '邮费',
  `unit_name` varchar(32) NOT NULL COMMENT '单位名',
  `sales` mediumint(11) unsigned NOT NULL DEFAULT '0' COMMENT '销量',
  `stock` mediumint(11) unsigned NOT NULL DEFAULT '0' COMMENT '库存',
  `sort` smallint(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `give_integral` decimal(8,2) unsigned NOT NULL COMMENT '获得积分',
  `ficti` mediumint(11) DEFAULT '100' COMMENT '虚拟销量',
  `browse` int(11) DEFAULT '0' COMMENT '浏览量',
  `code_path` varchar(64) DEFAULT '' COMMENT '产品二维码地址(用户小程序海报)',
  `soure_link` varchar(255) DEFAULT '' COMMENT '淘宝京东1688类型',
  `is_show` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态（0：未上架，1：上架）',
  `is_hot` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否热卖',
  `is_benefit` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否优惠',
  `is_best` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否精品',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否新品', 
  `is_postage` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否包邮',
  `is_seckill` tinyint(1) unsigned DEFAULT '0' COMMENT '秒杀状态 0 未开启 1已开启',
  `is_bargain` tinyint(1) unsigned DEFAULT NULL COMMENT '砍价状态 0未开启 1开启',
  `is_good` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否优品推荐',
  `is_del` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否删除',
  `mer_use` tinyint(1) unsigned DEFAULT '0' COMMENT '商户是否代理 0不可代理1可代理',
  `description` text NOT NULL COMMENT '产品描述', 
  `dtime` timestamp NULL DEFAULT now() COMMENT '添加时间',
  PRIMARY KEY (`id`)  
   
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='{$tableName}商品表';
        ";



        if ($this->db->exec_update_delete($sql)) {
            // 成功，并判断受影响的记录数
            return true;
        } else {
            // 失败返回false
            return false;
        }
    }


    public function addProductFiled($tableName)
    {
        $filed = new Model("filed");
        $table = new Model($tableName);
        $model_id = $this->where(["u1"=>$tableName])->one()['id'];
        $array = $table->getFieldsAndTypes();
        foreach ($array as $v) {
            if ($v['column_name'] != 'id' && $v['column_name'] != 'sort_id' ) {

                $data['model_id'] = $model_id;
                $data['u1'] = $v['column_name'];
                $data['u2'] = $v['column_comment'];
                $data['u3'] = "";
                $data['u4'] = ($v['is_nullable'] == 'YES') ? '否' : '是';
                $data['u5'] = '否';
                $data['u6'] = '否';
                $data['u8'] = $v['column_default'];
                $data['u9'] = "80";
                $data['u10'] = $v['id'];

                // 得到字段的类型
                $filed_type = "文本框";
                switch ($v['data_type']) {
                    case "int":
                        $filed_type = "数字";
                        break;
                    case "mediumint":
                        $filed_type = "数字";
                        break;
                    case "tinyint":
                        $filed_type = "数字";
                        if($data['u1']=="is_show")
                        {
                            $filed_type="单选";
                            $data['u2']="状态";
                            $data['u8']="
                            [
                                {\"value\":\"未上架\",\"key\":0},
                                {\"value\":\"上架\",\"key\":1} 
                            ]
                            ";
                        }else if($data['u1']=="is_hot"){
                            $filed_type="单选";
                            $data['u2']="是否热卖";
                            $data['u8']="
                            [
                                {\"value\":\"是\",\"key\":1},
                                {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }else if($data['u1']=="is_benefit"){
                            $filed_type="单选";
                            $data['u2']="是否优惠";
                            $data['u8']="
                            [
                                {\"value\":\"是\",\"key\":1},
                                {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }else if($data['u1']=="is_best"){
                            $filed_type="单选";
                            $data['u2']="是否精品";
                            $data['u8']="
                            [
                                {\"value\":\"是\",\"key\":1},
                                {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }else if($data['u1']=="is_new"){
                            $filed_type="单选";
                            $data['u2']="是否新品";
                            $data['u8']="
                            [
                                {\"value\":\"是\",\"key\":1},
                                {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }else if($data['u1']=="is_postage"){
                            $filed_type="单选";
                            $data['u2']="是否包邮";
                            $data['u8']="
                            [
                                {\"value\":\"是\",\"key\":1},
                                {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }else if($data['u1']=="is_del"){
                            $filed_type="单选";
                            $data['u2']="是否删除";
                            $data['u8']="
                            [
                                {\"value\":\"是\",\"key\":1},
                                {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }else if($data['u1']=="mer_use"){
                            $filed_type="单选";
                            $data['u2']="商户是否代理";
                            $data['u8']="
                            [
                                {\"value\":\"是\",\"key\":1},
                                {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }else if($data['u1']=="is_seckill"){
                            $filed_type="单选";
                            $data['u2']="秒杀状态";
                            $data['u8']="
                            [
                                {\"value\":\"未开启\",\"key\":0},
                                {\"value\":\"已开启\",\"key\":1} 
                            ]
                            ";
                        }else if($data['u1']=="is_bargain"){
                            $filed_type="单选";
                            $data['u2']="砍价状态";
                            $data['u8']="
                            [
                                {\"value\":\"未开启\",\"key\":0},
                                {\"value\":\"已开启\",\"key\":1} 
                            ]
                            ";
                        }else if($data['u1']=="is_good"){
                            $filed_type="单选";
                            $data['u2']="是否优品推荐";
                            $data['u8']="
                            [
                               {\"value\":\"是\",\"key\":1},
                               {\"value\":\"否\",\"key\":0} 
                            ]
                            ";
                        }

                        break;
                    case "smallint":
                        $filed_type = "数字";
                        break;
                    case "decimal":
                        $filed_type = "金额";
                        break;
                    case "char":
                        if($data['u2']=="密码")
                        {
                            $filed_type = "密码";
                        }else if($data['u2']=="编号"){
                            $filed_type = "编号";
                        }else if($data['u2']=="商品规格"){
                            $filed_type = "商品规格";
                        }else if($data['u2']=="商品价格"){
                            $filed_type = "商品价格";
                        }else
                        {
                            $filed_type = "文本框";
                        }

                        break;
                    case "mediumtext":
                        $filed_type = "文本编辑器";
                        break;
                    case "text":
                        $filed_type = "文本编辑器";
                        break;
                    case "varchar":
                        if($data['u2']=="商品图片")
                        {
                            $filed_type = "图片";
                        }else if($data['u2']=="轮播图"){
                            $filed_type = "组图";
                        }else if($data['u2']=="商品名称"){
                            $filed_type = "单行输入框";
                        }
                        else if($data['u2']=="关键字" ){
                            $data['u3']="多个关键词以空格隔开";
                            $filed_type = "单行输入框";
                        }else if($data['u2']=="分类id"){
                            $data['u2']="商品分类";
                            $filed_type = "多级联动";
                            $data['u8']="sql{sl_store_category  | where   1=1    | order by paixu asc , id desc | id,biaoti }";
                            //
                        }else if($data['u2']=="单位名"){
                            $filed_type = "文本框";
                        }else
                        {
                            $filed_type = "文本域";
                        }

                        break;
                    case "timestamp":
                        $filed_type = "时间框";
                        break;
                }
                $data['u7'] = $filed_type;
                //是否显示
                $data['u5'] = '是';

                $filed->insert($data);
            }
        }
    }

    /**

     * 根据传递的参数，自动获得SQL的条件语句

     * @date: 2018年10月5日 下午8:32:41

     * @author: 龚华尧

     * @param: variable

     * @return:

     */
    public function getSqlWhereStr_new($table_id ,$andOror="and",$nosort_id=true)
    {
        $filedModel=new filedModel();
        $filedAraay=$filedModel->getallFiledByTableid($table_id);
        $search_value=$this->common->Requert("search_value");
        $sql="";

        foreach ($filedAraay as $v)
        {
            if (!empty($this->common->Requert($v['u1'])) && $this->common->Requert($v['u1']) != '') {
                if($v['u7']=='时间框')
                {
                    $sql .= $this->getDtimeSql($v['u1'])." {$andOror} ";
                }else if($v['u7']=='多级联动')
                {
                    $liandong_id= $this->common->Requert($v['u1']);
                    $t= $this->getTablenameByTableid($table_id);
                    $filedM = new filedModel();
                    $tList = $filedM->getFiledDefaultValue($v['id']);
                    //挂载 TREE 类
                    $this->helper('tree');
                    $tree =new Tree($tList) ;
                    $t_id_list = $tree->getSubIdList($liandong_id);
                    $t_id_list[]=$liandong_id;
                    // 	            var_dump($site_id_list);die();
                    $t_ids = implode(",", $t_id_list);
                    $sql= $sql."   {$v['u1']} in ({$t_ids})"." {$andOror} ";

                }else{
                    $sql = $sql . $v['u1']. " like '%{$this->common->Requert($v['u1'])}%' {$andOror} ";
                }

            }


            //组合统一查询
            if($search_value!="" && $v['u6']=="是")
            {
                $sql = $sql . $v['u1']. " like '%{$search_value}%' {$andOror} ";
            }

        }



        if(!empty($this->common->Requert("sort_id")) && $nosort_id)
        {
            $sql = $sql ." sort_id ={$this->common->Requert("sort_id")}  {$andOror}  ";
        }

        if( $this->common->Requert("class_id")=='0' )
        {
            $sql = $sql ." class_id ={$this->common->Requert("class_id")}  {$andOror}  ";
        }



        if($sql!="")
        {
            if($andOror=="and")
            {
                $sql.="  1=1";
            }else{
                $sql.="  1=2";
            }
        }

//         echo $sql."asdf";die();

        return $sql;
    }

    /**

     * 判断表是否拥有查询权限

     * @date: 2019年1月30日 下午5:49:11

     * @author: 龚华尧

     * @param: variable

     * @return:

     */
    public  function isableapi($tablename){
        $tablename= str_replace($GLOBALS['config_db']['prefix'], "", $tablename);
        $tablename= $GLOBALS['config_db']['prefix'] . $tablename;
        $tabledetail = $this->where("u1='{$tablename}' ")->one();

        if(empty($tabledetail)){

            return false;
        }else{
            if($tabledetail['u11']=="on"){
                return true;

            }
        }

        return false;
    }



    public  function gettableidBytablename($tablename){
        $tablename= str_replace($GLOBALS['config_db']['prefix'], "", $tablename);
        $tablename= $GLOBALS['config_db']['prefix'] . $tablename;

        $tabledetail = $this->where("u1='{$tablename}'")->one();
        if(empty($tabledetail)){

            return "";
        }else{
            return $tabledetail['id'];
        }

        return "";
    }


}
