<?php

/**
 * 短视频
 * 2020-4-16 15:58:12
 * junshi
*/

class shortVideoModule extends commonModule
{
    public function __construct()
    {
        parent::__construct("sl_short_video");
    }

    //短视频上传
    public function uploadVideo($request){

        //视频地址
        if (empty($request["videoId"])){
            returnFail([],getcodestr(9002),9002);
        }

        //视频标签
        $span = $request["span"];
        if (!empty($span)){
            //验证标签是否正确
            $video_span = (new videoSpanModule())->getAllBySort();
            $video_span_id = [];
            foreach ($video_span as $k => $v){
                $video_span_id[] = $v["id"];
            }
            $span_arr = explode(",",$span);
           if (!empty(array_diff($span_arr, $video_span_id))){
               returnFail([],getcodestr(9007),9007);
           }
        }

        //组装数据
        $data = [
            "filePath" => $request["filePath"],
            "address" => $request["address"],
            "span" => $span,
        ];

        return $data;

    }

    //获取动态列表
    public function getUserRelease($request){

        //参数验证
        if (empty($request["user_number"])){
            $user_info = $this->getUserInfoByToken();
        }else{
            //查询用户是否存在
            $user_info = (new userModule())->getUserInfoByNumber($request["user_number"]);
        }
        $user_number = $user_info["number"];
        if (empty($user_number)){
            returnFail([],getcodestr(205),205);
        }

        //页码与每页数量
        $page = !empty($request["page"])?$request["page"]:1;
        $limit = !empty($request["limit"])?$request["limit"]:9;

        //查询
        $short_video = $this
            ->where(["user_number" => $user_number,"status" => 1])
            ->limit(($page - 1) * $limit,$limit)
            ->orderBy("create_time desc")
            ->all();

        //获取用户信息
        $userModule = new userModule();
        $user_now = $userModule->getUserInfoByToken();

        //查询视频的类型与标签
        foreach ($short_video as &$v){
            $v['collection'] = (new userVideoModule())->where(['type' => 1,'video_id' => $v['id']])->count();   //收藏
            $v['say'] = (new videoTalkModule())->where(['video_id' => $v['id']])->count();                      //评论
            $v["type"] = (new videoTypeModule())->findOne($v["type"]);                                          //类型
            //标签
            if (!empty($v["span"])){
                $v["span"] = (new videoSpanModule())->where("id in ({$v['span']})")->all();
            }else{
                $v["span"] = "";
            }
            $v["play"] = (new userSeeVideoLogModule())->where(["video" => $v["id"]])->count();                  //播放量
            //查询用户头像
            $up_info = $userModule->where(['number'=>$v['user_number']])->one();
            $v['avatar'] = !empty($up_info) ? "https://zhibo.cdsile.cn".$up_info['avatar'] : "";
            //查询用户是否关注up
            $if_focus = 2;
            if (!empty($user_now)){
                $if_focus = (new userShieldingModule())->where(["user_number"=>$user_now["number"],"usered_number"=>$v['user_number'],"type"=>2])->one();
                $if_focus = !empty($if_focus) ? 1 : 2;
            }
            $v['if_focus'] = $if_focus; //判断是否关注
        }

        return $short_video;

    }

    //增加短视频播放记录
    public function addVideoPlay($request,$user_info){

        //验证视频是否存在
        $video = $this->findOne($request["video"]);
        if (!empty($video)){
            //增加视频浏览记录
            $play_now = $video["play"] + 1;
            $this->where(["id" => $video["id"]])->update(["play" => $play_now]);
            //判断用户是否存在，存在则增加一条用户浏览记录
            if (!empty($user_info)){
                $log = [
                    "user" => $user_info["number"],
                    "video" => $video["id"],
                    "create_time" => date("Y-m-d H:i:s"),
                ];
                (new userSeeVideoLogModule())->insert($log);
            }
            returnSuccess($play_now,getcodestr(200),200);
        }else{
            returnFail([],getcodestr(9006),9006);
        }

    }

    //推送短视频视频
    public function pushVideo($request,$number){

        //页码与每页数量
        $page = !empty($request["page"])?$request["page"]:1;
        $limit = !empty($request["limit"])?$request["limit"]:9;

        //查询
        $short_video = $this
            ->where(["status" => 1])
            ->limit(($page - 1) * $limit,$limit)
            ->orderBy("create_time desc")
            ->all();

        //数据重置
        if (empty($short_video) && $page > 1){
            $page = 1;
            $short_video = $this
                ->where(["status" => 1])
                ->limit(($page - 1) * $limit,$limit)
                ->orderBy("create_time desc")
                ->all();
        }
        //查询视频的类型与标签
        foreach ($short_video as &$v){
            $v['collection'] = (new userVideoModule())->where(['type' => 1,'video_id' => $v['id']])->count();   //收藏
            //查询用户是否收藏该短视频
            if (!empty($number)){
                $is_collection = (new userVideoModule())->where(['user_number'=>$number,'type'=>1,'video_id'=>$v['id']])->one();
                if (empty($is_collection)){
                    $v['is_collection'] = 0;
                }else{
                    $v['is_collection'] = 1;
                }
            }else{
                $v['is_collection'] = 1;
            }
            $v['share'] = (new userVideoModule())->where(['type' => 2,'video_id' => $v['id']])->count();   //分享量
            $v['say'] = (new videoTalkModule())->where(['video_id' => $v['id']])->count();                      //评论
            $one = (new videoTypeModule())->findOne($v["type"]);                                          //类型
            $v["type"]['id'] = $one['id'];
            $two = (new userModule())->where(['number'=>$v['user_number']])->one();
            $v['avatar'] = "https://zhibo.cdsile.cn".$two['avatar'];
            //标签
            if (!empty($v["span"])){
                $all = (new videoSpanModule())->where("id in ({$v['span']})")->all();
                $arr = [];
                foreach ($all as $kk=>$vv){
                    $arr[$kk]=$vv['id'];
                    $v["span"] = $arr;
                }
            }else{
                $v["span"] = "";
            }
            $v["play"] = (new userSeeVideoLogModule())->where(["video" => $v["id"]])->count();                  //播放量
            //查询用户头像
            $up_info = (new userModule())->where(['number'=>$v['user_number']])->one();
            $v['avatar'] = !empty($up_info['avatar']) ? "https://zhibo.cdsile.cn".$up_info['avatar'] : "";
            //查询用户是否关注up
            $if_focus = 2;
            if (!empty($number)){
                $if_focus = (new userShieldingModule())->where(["user_number"=>$number,"usered_number"=>$v['user_number'],"type"=>2])->one();
                $if_focus = !empty($if_focus) ? 1 : 2;
            }

            $v['if_focus'] = $if_focus; //判断是否关注
        }

        $data = [
            "short_video" => $short_video,
            "page_now" => $page,
        ];

        return $data;

    }

    //根据用户编号查询短视频数量
    public function getVideoCount($user_number){
        $data = $this->where(["user_number" => $user_number])->count();
        return $data;
    }


}