<?php

/**
 * 收礼记录
*/

class userGiftLogModule extends Model
{
    public function __construct()
    {
        parent::__construct("sl_user_gift_log");
    }

    //查询主播当天的
    public function getOneDayGift($user_number){
        //获取当日日期
        $date = date("Y-m-d");
        $begin_time = $date." 00:00:00";
        $over_time = $date." 23:59:59";

        $where = "usered_number = {$user_number} and (create_time between '{$begin_time}' and '{$over_time}')";
        $data = $this->where($where)->all();
        $price = 0;
        foreach ($data as &$v){
            $price += (double)$v["price"];
        }

        return $price;

    }

    //获取贡献榜
    public function getContributionList($user_number){

        //验证主播
        $user_info = (new userModule())->getUserInfoByNumber($user_number);
        if (empty($user_info)){
            returnFail([],getcodestr(205),205);
        }

        //日榜
        $day_start = date("Y-m-d")." 00:00:00";
        $day_finish = date("Y-m-d")." 23:59:59";
        $day_list = $this->where("usered_number = '{$user_number}' and create_time between '{$day_start}' and '{$day_finish}'")->all();
        $date_list_arr = $this->searchContributionList($day_list);

        //周榜
        $week_start = date('Y-m-d', strtotime('this week'))." 00:00:00";
        $week_finish = date('Y-m-d', strtotime('last day next week'))." 23:59:59";
        $week_list = $this->where("usered_number = '{$user_number}' and create_time between '{$week_start}' and '{$week_finish}'")->all();
        $week_list_arr = $this->searchContributionList($week_list);

        //总榜
        $total_list = $this->where("usered_number = '{$user_number}'")->all();
        $total_list_arr = $this->searchContributionList($total_list);

        //整理数据
        $data = [
            "date_list" => $date_list_arr,
            "week_list" => $week_list_arr,
            "total_list" => $total_list_arr,
        ];

        returnSuccess($data,getcodestr(200),200);

    }

    //根据礼物查询出贡献榜
    public function searchContributionList($list){

        //根据用户分组
        $list = group_same_key($list,"user_number");
        $userModule = new userModule();
        $list_total = [];
        foreach ($list as $k => $v){
            //查询该用户的基本信息
            $user_info = $userModule->getUserInfoByNumber($k);
            $contribution = 0;
            foreach ($v as $k1 => $v1){
                $contribution += $v1["price"];
            }
            $list_now = [
                "number" => $user_info["number"],
                "nickname" => $user_info["nickname"],
                "avatar" => $user_info["avatar"],
                "contribution" => $contribution,
            ];
            $list_total[] = $list_now;
        }

        //排序
        array_multisort(array_column($list_total,'contribution'),SORT_DESC,$list_total);

        return $list_total;
    }

}