<?php

/**
 * 用户等级
 */

class userLevelModule extends commonModule
{

    public function __construct()
    {
        parent::__construct("sl_user_level");
    }

    //获取用户等级
    public function getUserLevel($experience,$user_score){

        //查询符合的等级
        $level_list = $this->where("score > $experience")->orderBy("sort asc,leavel asc")->all();
        //查询最大等级
        $level_last = $this->orderBy("score desc")->one();
        if (!empty($level_list)){
            $level = $this->where("score < {$level_list[0]['score']}")->orderBy("sort desc,leavel desc")->one();
        }else{
            $level = $level_last;
        }
        //获取用户下一等级
        $next_level = $this->where(['leavel'=>($level['leavel']*1+1)])->one();
        $level_last['leavel']==$level?$next_level = $level_last:$next_level;
        $arr['user_score'] = $user_score;
        if (empty($next_level)){
            $arr['need_score']=0;
        }else{
            $arr['need_score']=$next_level['score']*1 - $user_score*1;
        }
        $arr['user_leavel'] = $level['leavel'];
        returnSuccess($arr,getcodestr(200),200);
    }

    //根据用户经验值查询用户等级
    public function getUserLevelByExp($experience){

        //查询符合的等级
        $level_list = $this->where("score > $experience")->orderBy("sort asc,leavel asc")->all();
        //查询最大等级
        $level_last = $this->orderBy("score desc")->one();
        if (!empty($level_list)){
            $level = $this->where("score < {$level_list[0]['score']}")->orderBy("sort desc,leavel desc")->one();
        }else{
            $level = $level_last;
        }
        return $level;
    }

}