<?php

/**
 * 直播记录
 * 2020-4-9 10:59:09
 * junshi
*/

class userLiveLogModule extends commonModule
{
    public function __construct()
    {
        parent::__construct("sl_user_live_log");
    }

    //获取直播列表参数验证
    public function verGetOnLiveList($request){

        //验证直播状态类型
        if (!empty($request["live_type"])){
            $live_type = in_array($request["live_type"],[1,2])?$request["live_type"]:"";
        }else{
            $live_type = 1;
        }
        if (empty($live_type)){
            returnFail([],getcodestr(4008),4008);
        }

        //验证是否查询热门
        if (!empty($request["hot"])){
            $hot = in_array($request["hot"],[1,2,3,4])?$request["hot"]:"";
        }else{
            $hot = 2;
        }

        //验证直播类型
        if (!empty($request["type"])){
            //查询全部直播类型
            $type_all = (new liveTypeModule())->getAllBySort();
            $type_ids = [];
            foreach ($type_all as &$v){
                $type_ids[] = $v["id"];
            }
            $type = in_array($request["type"],array_unique($type_ids))?$request["type"]:"";
        }else{
            $type = "";
        }

        //返回参数
        $data = [
            "live_type" => $live_type,
            "hot" => $hot,
            "type" => $type,
            "page" => !empty($request["page"])?$request["page"]:1,
            "limit" => !empty($request["limit"])?$request["limit"]:10,
        ];

        return $data;

    }

    //修改直播间数据验证
    public function verEditOnLive($request){
        if (empty($request["title"]) && empty($request["cover"])){
            returnSuccess([],getcodestr(4011),4011);
        }

        //组装修改内容
        $data = [];
        if (!empty($request["title"])){
            $data = ["title"=>$request["title"]];
        }elseif(!empty($request["cover"])){
            $data = ["cover"=>$request["cover"]];
        }

        if (!empty($data)){
            return $data;
        }else{
            returnSuccess([],getcodestr(4011),4011);
        }

    }

    //监控视频
    public function getOnLiveAll(){
        $where = ["live_type" => 1, "is_offline" => 2,];
        $data = $this->where($where)->orderBy("top desc,hot desc,create_time desc")->all();
        return $data;
    }

    //后台关闭直播
    public function close($id){
        $data = [
            "live_type" => 2,
            "is_offline" => 1,
            "finish_time" => date("Y-m-d H:i:s"),
        ];
        $res = $this->where(["id"=>$id])->update($data);
        return $res;
    }

}