<?php

class userReportModule extends commonModule
{
    public function __construct()
    {
        parent::__construct("sl_user_report");
    }

    //用户举报提交
    public function userReport($request,$user){
        $userReportTypeModule = new userReportTypeModule();
        $userReport = $userReportTypeModule->where(["id"=>$request["type"]])->one();
        if (!$request["type"] || !$userReport){
            returnFail([],getcodestr(3024),3024);
        }
        if (!$request["content"]){
            returnFail([],getcodestr(3025),3025);
        }
        if (!$request["pics"]){
            returnFail([],getcodestr(3026),3026);
        }
        if (!$request["phone"]){
            returnFail([],getcodestr(3027),3027);
        }

        //处理图片
        $pic_arr = explode(",",$request["pics"]);
        $pic_str = "";
        for ($i = 0; $i < count($pic_arr); $i++){
            if ($i == (count($pic_arr) - 1)){
                $pic_str .= $pic_arr[$i];
            }else{
                $pic_str .= $pic_arr[$i]."{next}";
            }
        }

        //组装数据
        $data = [
            "user_number" => $user["number"],
            "usered_number" => $request["usered_number"],
            "type" => $request["type"],
            "content" => $request["content"],
            "pics" => $pic_str,
            "phone" => $request["phone"],
            "create_time" => date("Y-m-d H:i:s")
        ];
        $res = $this->insert($data);
        if ($res){
            returnSuccess([]);
        }
        returnFail([]);

    }

}