<?php

/**
 * 房间人员管理
*/

class userRoomModule extends Model
{
    public function __construct()
    {
        parent::__construct("sl_user_room");
    }

    //验证赋予房管参数
    public function verRoomManage($request){

        //主播
        $userModule = new userModule();
        if (empty($request["anchor_id"])){
//            returnFail([],getcodestr(6001),6001);
            return 6001;
        }
        $anchor = $userModule->getUserInfoByNumber($request["anchor_id"]);
        if (empty($anchor)){
//            returnFail([],getcodestr(6001),6001);
            return 6001;
        }

        //操作人
        if (empty($request["user_number"])){
//            returnFail([],getcodestr(6002),6002);
            return 6002;
        }
        $user = $userModule->getUserInfoByNumber($request["user_number"]);
        if (empty($user)){
//            returnFail([],getcodestr(6002),6002);
            return 6002;
        }

        //被操作人
        if (empty($request["usered_number"])){
            returnFail([],getcodestr(6003),6003);
        }
        $usered = $userModule->getUserInfoByNumber($request["usered_number"]);
        if (empty($usered)){
//            returnFail([],getcodestr(6003),6003);
            return 6003;
        }

        //操作类型
        if (empty($request["type"])){
//            returnFail([],getcodestr(6004),6004);
            return 6004;
        }
        if (!in_array($request["type"],[1,2,3])){
//            returnFail([],getcodestr(6004),6004);
            return 6004;
        }

        //检测操作权限
        if ($request["user_number"] == $request["usered_number"]){
//            returnFail([],getcodestr(6005),6005);
            return 6005;
        }

        return 200;

    }
    public function etRoomManage($request){
        $userRoomModule = new userRoomModule();
        $res = $userRoomModule->verRoomManage($request);
        //参数验证成功
        if ($res){
            switch ($request["type"]){
                case 1:         //设置为房管
                    //判断是否是主播
                    if ($request["anchor_id"] == $request["user_number"]){  //是主播，直接执行操作
                        //判断该用户是否为该房间的房管，是则取消房管 否则添加房管
                        $is_room_manage = $userRoomModule->where(["usered_number"=>$request["usered_number"],"type"=>1])->one();
                        if (!empty($is_room_manage)){
                            $result = $userRoomModule->delete($is_room_manage["id"]);
                            $request['type']=2;
                            $log = (new userRoomLogModule())->insert($request);
                            return $request;
                        }else{
                            $request["create_time"] = date("Y-m-d H:i:s");
                            $result = $userRoomModule->insert($request);
                            $request['type']=1;
                            $log = (new userRoomLogModule())->insert($request);
                            return $request;
                        }
                    }else{  //判断
                        return;
//                        returnFail([],getcodestr(6005),6005);
                    }
                    break;
                case 2:         //禁言
                    if ($request["anchor_id"] == $request["user_number"]){  //是主播，直接执行操作
                        $is_ban = $userRoomModule->where(["usered_number"=>$request["usered_number"],"type"=>2])->one();
                        if (!empty($is_ban)){
                            $result = $userRoomModule->delete($is_ban["id"]);
                            $request['type']=4;
                            $log = (new userRoomLogModule())->insert($request);
                            return $request;
                        }else{
                            $request["create_time"] = date("Y-m-d H:i:s");
                            //判断禁言时间
                            $request["time"] = !empty($request["time"])?date("Y-m-d H:i:s",time() + $request["time"]):date("Y-m-d H:i:s",time() + 10 * 365 * 24 * 3600);
                            $result = $userRoomModule->insert($request);
                            $request['type']=3;
                            $log = (new userRoomLogModule())->insert($request);
                            return $request;
                        }
                    }else{  //判断该用户是否为房管
                        //判断操作人是否是房管
                        $is_room_manage = $userRoomModule->where(["usered_number"=>$request["user_number"],"type"=>1])->one();
                        if (!empty($is_room_manage)){
                            $is_ban = $userRoomModule->where(["usered_number"=>$request["usered_number"],"type"=>2])->one();
                            if (!empty($is_ban)){
                                if (strtotime($is_ban["time"]) > time()){   //解除禁言
                                    $result = $userRoomModule->delete($is_ban["id"]);
                                    $request['type']=4;
                                    $log = (new userRoomLogModule())->insert($request);
                                    return $request;
                                }else{
//                                    returnSuccess([],getcodestr(200),200);
                                    return;
                                }
                            }else{
                                $request["create_time"] = date("Y-m-d H:i:s");
                                //判断禁言时间
                                $request["time"] = !empty($request["time"])?date("Y-m-d H:i:s",time() + $request["time"]):date("Y-m-d H:i:s",time() + 10 * 365 * 24 * 3600);
                                $result = $userRoomModule->insert($request);
                                $request['type']=3;
                                $log = (new userRoomLogModule())->insert($request);
                                return $request;
                            }
                        }else{
//                            returnFail([],getcodestr(6005),6005);
                            return;
                        }
                    }
                    break;
                case 3:         //踢人
                    $request["time"] = !empty($request["time"])?date("Y-m-d H:i:s",time() + $request["time"]):date("Y-m-d H:i:s",time() + 10 * 365 * 24 * 3600);
                    if ($request["anchor_id"] == $request["user_number"]){  //是主播，直接执行操作

                        $is_ban = $userRoomModule->where(["usered_number"=>$request["usered_number"],"type"=>3])->one();
                        if (!empty($is_ban)){
                            $result = $userRoomModule->delete($is_ban["id"]);
                            $request['type']=6;
                            $log = (new userRoomLogModule())->insert($request);
                            return $request;
                        }else{
                            $request["create_time"] = date("Y-m-d H:i:s");
                            $result = $userRoomModule->insert($request);
                            $request['type']=5;
                            $log = (new userRoomLogModule())->insert($request);
                            return $request;
                        }
                    }else{  //判断该用户是否为房管
                        //判断操作人是否是房管
                        $is_room_manage = $userRoomModule->where(["usered_number"=>$request["user_number"],"type"=>1])->one();
                        if (!empty($is_room_manage)){
                            $is_ban = $userRoomModule->where(["usered_number"=>$request["usered_number"],"type"=>2])->one();
                            if (!empty($is_ban)){
                                $result = $userRoomModule->delete($is_ban["id"]);
                                $request['type']=6;
                                $log = (new userRoomLogModule())->insert($request);
                                return $request;
                            }else{
                                $request["create_time"] = date("Y-m-d H:i:s");
                                $result = $userRoomModule->insert($request);
                                $request['type']=5;
                                $log = (new userRoomLogModule())->insert($request);
                                return $request;
                            }
                        }else{
//                            returnFail([],getcodestr(6005),6005);
                            return;
                        }
                    }
                    break;
                default:
//                    returnFail([],getcodestr(10001),10001);
                    return;
                    break;
            }

        }
    }

}