<?php

/**
 * 直播浏览记录
 * 2020-4-17 14:12:41
 * junshi
*/

class userSeeLiveLogModule extends commonModule
{
    public function __construct()
    {
        parent::__construct("sl_user_see_live_log");
    }
    //用户观看直播记录
    public function userSee($user,$anchor){
        $one = $this->where(['user'=>$user,'anchor'=>$anchor])->one();
        $time = date('Y-m-d H:i:s');
        if ($one){
            $insert = $this->where(['id'=>$one['id']])->update(['creat_time'=>$time]);
        }else {
            $insert = $this->insert(['user'=>$user,'anchor'=>$anchor,'creat_time'=>$time]);
        }
        return $insert;
    }

    //查询用户观看的直播且在线的直播列表
    public function getUserSee($user){
        $data = $this->where(['user'=>$user])->orderBy("create_time desc")->all();
        $userModule = new userModule();
        $userShieldingModule = new userShieldingModule();
        $ids = [];
        foreach ($data as $k => $v){
            //查询该主播是否关注
            if (!in_array($v["anchor"],$ids)){
                $anchor = $userModule->getUserInfoByUserId($v['anchor']);
                //查询是否已经关注主播
                $follow_info = $userShieldingModule->where(["user_number"=>$user,"usered_number"=>$anchor["number"],"type"=>2])->one();
                $data[$k]["is_follow"] = !empty($follow_info) ? 1 : 2;
                $data[$k]['anchor'] = $anchor;
            }else{
                unset($data[$k]);
            }
            $ids[] = $v["anchor"];
        }
        return $data;
    }

    //获取用户观看列表
    public function getList($user_number,$limit=10){
        //查询主播
        $anchor = $this->where(["user"=>$user_number])->orderBy(0,$limit)->all();
        //查询主播最近直播
        $type = [];
        $userLiveLogModel = new userLiveLogModule();
        foreach ($anchor as &$v){
            $log = $userLiveLogModel->where(["user_number"=>$v["user"]])->orderBy("create_time desc")->one();
            if (!empty($log)){
                $type[] = $log["type_id"];
            }
        }

        $type_ = array_unique($type);
        return $type_;
    }

}