<?php

/**
 * 用户关注拉黑
*/

class userShieldingModule extends Model
{
    public function __construct()
    {
        parent::__construct("sl_user_shielding");
    }

    //用户关注拉黑
    public function userFocus($arr){
        if ($arr['type']==2){
            $one = $this->where(['user_number'=>$arr['user_number'],'usered_number'=>$arr['usered_number'],'type'=>2])->one();
            if ($one){
                $del = $this->where(['id'=>$one['id']])->delete();
                if ($del){
                    returnSuccess('取消关注成功',config('code')['200'],200);
                }else{
                    returnFail(config('code')['10001'],[],10001);
                }
            }else{
                $data = $this->insert($arr);
                if ($data){
                    returnSuccess('关注成功',config('code')['200'],200);
                }else{
                    returnFail(config('code')['10001'],[],10001);
                }
            }
        }else if ($arr['type']==1){
            //拉黑用户
            $one = $this->where(['user_number'=>$arr['user_number'],'usered_number'=>$arr['usered_number'],'type'=>1])->one();
            if ($one){
                $del = $this->where(['id'=>$one['id']])->delete();
                if ($del){
                    returnSuccess('取消拉黑成功',config('code')['200'],200);
                }else{
                    returnFail(config('code')['10001'],[],10001);
                }
            }else{
                $data = $this->insert($arr);
                if ($data){
                    returnSuccess('拉黑成功',config('code')['200'],200);
                }else{
                    returnFail(config('code')['10001'],[],10001);
                }
            }
        }

    }

    //获取我的关注列表
    public function getUserFocus($user_number){
        $data = $this->where(['user_number'=>$user_number,'type'=>2])->all();
        $arr = [];
        //获取关注的人的信息
        foreach ($data as $k=>$v){
            $one = $this->findBySql("select * from sl_user where number = {$v['usered_number']}");
            if (empty($one[0]['experience'])){
                $one[0]['experience']=0;
            }else{
                $one[0]['experience'] = $one[0]['experience']*1;
            }
            $one[0]['sex']==1?$one[0]['sex']='男':$one[0]['sex']='女';
            $arr[$k]['avatar'] = $one[0]['avatar'];
            $arr[$k]['nickname'] = $one[0]['nickname'];
            $arr[$k]['sex'] = $one[0]['sex'];
            $arr[$k]['number'] = $one[0]['number'];
            //获取用户的等级
            $leavel = $this->findBySql("select * from sl_user_level where score>{$one[0]['experience']} order by sort asc,leavel asc");
            $arr[$k]['user_leavel'] = $leavel[0]['leavel']*1-1;
            if (empty($leavel)){
                $leavel = $this->findBySql("select * from sl_user_level order by sort desc,leavel desc");
                $arr[$k]['user_leavel'] = $leavel[0]['leavel']*1;
            }

        }
        returnSuccess($arr,config('code')['200'],200);
    }

    //获取我的粉丝列表
    public function getUserFans($user_number){
        $data = $this->where(['usered_number'=>$user_number,'type'=>2])->all();

        $arr = [];
        //获取关注的人的信息
        foreach ($data as $k=>$v){
            $one = $this->findBySql("select * from sl_user where number = {$v['user_number']}");
            //查看我是否关注过粉丝

            if (!empty($one)){
                $is_focus = $this->where(['user_number'=>$user_number,'usered_number'=>$one[0]['number'],'type'=>2])->one();
                if (empty($one[0]['experience'])){
                    $one[0]['experience']=0;
                }else{
                    $one[0]['experience'] = $one[0]['experience']*1;
                }
                $one[0]['sex']==1?$one[0]['sex']='男':$one[0]['sex']='女';

                $arr[$k]['avatar'] = $one[0]['avatar'];
                $arr[$k]['number'] = $user_number;
                $arr[$k]['nickname'] = $one[0]['nickname'];
                $arr[$k]['sex'] = $one[0]['sex'];
                if (!empty($is_focus)){
                    $arr[$k]['is_focus'] = true;
                }else{
                    $arr[$k]['is_focus'] = false;
                }
                //获取用户的等级
                $leavel = $this->findBySql("select * from sl_user_level where score>{$one[0]['experience']} order by sort asc,leavel asc");
                $arr[$k]['user_leavel'] = $leavel[0]['leavel']*1-1;
                if (empty($leavel)){
                    $leavel = $this->findBySql("select * from sl_user_level order by sort desc,leavel desc");
                    $arr[$k]['user_leavel'] = $leavel[0]['leavel']*1;
                }
            }



        }
        returnSuccess($arr,config('code')['200'],200);
    }

    //获取我的黑名单列表
    public function  getUserBlacklist($user_number){
        $data = $this->where(['user_number'=>$user_number,'type'=>1])->all();
        $arr = [];
        //获取黑名单的人的信息
        foreach ($data as $k=>$v){
            $one = $this->findBySql("select * from sl_user where number = {$v['usered_number']}");
            if (empty($one[0]['experience'])){
                $one[0]['experience']=0;
            }else{
                $one[0]['experience'] = $one[0]['experience']*1;
            }
            $one[0]['sex']==1?$one[0]['sex']='男':$one[0]['sex']='女';
            $arr[$k]['avatar'] = $one[0]['avatar'];
            $arr[$k]['nickname'] = $one[0]['nickname'];
            $arr[$k]['sex'] = $one[0]['sex'];
            $arr[$k]['number'] = $one[0]['number'];
            //获取用户的等级
            $leavel = $this->findBySql("select * from sl_user_level where score>{$one[0]['experience']} order by sort asc,leavel asc");
            $arr[$k]['user_leavel'] = $leavel[0]['leavel']*1-1;
            if (empty($leavel)){
                $leavel = $this->findBySql("select * from sl_user_level order by sort desc,leavel desc");
                $arr[$k]['user_leavel'] = $leavel[0]['leavel']*1;
            }

        }
        returnSuccess($arr,config('code')['200'],200);
    }

    //查询用户的关注数量
    public function getUserFollowNum($user_number){
        $data = $this->where(['user_number'=>$user_number,'type'=>2])->all();
        return count($data);
    }

    public function getUserFansNum($user_number){
        $data = $this->where(['usered_number'=>$user_number,'type'=>2])->all();
        return count($data);
    }

}