<?php

/**
 * 贵族订单
 * 2020-4-13 19:17:15
 * junshi
*/

class vipOrderModule extends commonModule
{
    public function __construct()
    {
        parent::__construct("sl_vip_order");
    }

    //开通贵族参数验证
    public function verOpeningVip($request,$user_info){

        //验证贵族
        $vip = (new vipPackageModule())->findOne($request["vip"]);
        if (empty($vip)){
            returnFail([],getcodestr(7001),7001);
        }

        //验证价格套餐
        $price_info = (new vipPriceModule())->findOne($request["price"]);
        if (empty($price_info)){
            returnFail([],getcodestr(7003),7003);
        }

        //验证开通等级
        $userLevelModule = new userLevelModule();
        $user_level = $userLevelModule->getUserLevelByExp($user_info["experience"]);
        $user_level = !empty($user_level)?$user_level["leavel"]:1;
        if ($user_level < $vip["rule"]){
            returnFail([],getcodestr(7005),7005);
        }

        //判断用户是否为vip
        if (strtotime($user_info["vip_over_time"]) > time()){   //用户处于贵族状态
            returnFail([],getcodestr(7012),7012);
        }

        //验证支付方式
        $pay_method_all = (new parameterModel())->getparameterArrayByclassid(553);
        $pay_method_all_val = [];
        foreach ($pay_method_all as &$v){
            $pay_method_all_val[] = $v["value"];
        }
        if (!in_array($request["pay_method"],$pay_method_all_val)){
            returnFail([],getcodestr(7004),7004);
        }

        //支付方式验证成功,判断是否是连续包月
        if ($price_info["is_rec"] == 1){    //连续包月，不能使用贵族币支付
            //总价
            $total = $price_info["price"];
            //实际支付
            $pay = $price_info["price"];
            //消耗积分
            $score = 0;
            $order = $this->monthlyPay($request,$user_info,$total,$pay,$score);
        }else{  //非连续包月
            $order = $this->notMonthlyPay($request,$user_info,$price_info);
        }

        return $order;

    }

    //连续包月支付
    public function monthlyPay($request,$user_info,$total,$pay,$score){

        //验证是否使用积分支付
        if ($request["is_score"] == 1){
            returnFail([],getcodestr(7007),7007);
        }

        //判断支付方式
        switch ($request["pay_method"]){
            case 1:     //微信支付
                $res = $this->createOrder($request,$user_info,$total,$pay,$score);
                return $res;
                break;
            case 2:     //支付宝支付
                $res = $this->createOrder($request,$user_info,$total,$pay,$score);
                return $res;
                break;
            case 3:     //贵族币支付
                returnFail([],getcodestr(7006),7006);
                break;
            default:
                returnFail([],getcodestr(7004),7004);
                break;
        }
    }

    //非连续包月支付
    public function notMonthlyPay($request,$user_info,$price_info){

        //验证是否使用积分支付
        if ($request["is_score"] == 1){
            //判断用户积分
            if ($user_info["noble_integral"] > $price_info["price"] / 2){
                $score = $price_info["price"] / 2;
                $pay = $price_info["price"] - $price_info["price"] / 2;
            }else{  //消耗全部积分
                $score = $user_info["noble_integral"];
                $pay = $price_info["price"] - $score;
            }
        }else{
            $score = 0;
            $pay = $price_info["price"];
        }

        //判断是否是贵族币支付
        if ($request["pay_method"] == 3){
            //判断用户贵族币是否足够
            if ($user_info["noble_currency"] >= $pay){
                //生成订单
                $total = $price_info["price"];
                $res = $this->createOrder($request,$user_info,$total,$pay,$score);
                return $res;
            }else{
                returnFail([],getcodestr(7011),7011);
            }
        }else{
            //生成订单
            $total = $price_info["price"];
            $res = $this->createOrder($request,$user_info,$total,$pay,$score);
            return $res;
        }
    }

    //生成订单
    public function createOrder($request,$user_info,$total,$pay,$score){

        //生成订单编号
        $order_number = $this->createOrderNumber();
        $order_data = [
            "order_number" => $order_number,                //订单编号
            "user" => $user_info["number"],                 //用户编号
            "vip" => $request["vip"],                       //贵族id
            "vip_price" => $request["price"],               //套餐id
            "pay_method" => $request["pay_method"],         //支付方式
            "total" => $total,                              //总价
            "pay" => $pay,                                  //实际支付
            "score" => $score,                              //消耗积分
            "status" => 1,                                  //状态，默认为1待支付
            "create_time" => date("Y-m-d H:i:s"),   //订单创建时间
            "pay_time" => "",                               //订单支付时间
        ];

        $res = $this->insert($order_data);
        if (!$res){
            returnFail([],getcodestr(7008),7008);
        }
        return $order_number;

    }

    //生成订单编号
    public function createOrderNumber(){
        $order_number = time().rand(1000,9999);
        $order_number_all = $this->find("order_number")->all();
        $order_number_all_num = [];
        foreach ($order_number_all as &$v){
            $order_number_all_num[] = $v["order_number"];
        }
        if (in_array($order_number,$order_number_all_num)){
            return $this->createOrderNumber();
        }else{
            return $order_number;
        }
    }

    //通过订单编号查询订单信息
    public function getInfoByOrderNumber($order_number){
        $data = $this->where(["order_number" => $order_number])->one();
        return $data;
    }

    //支付订单
    public function payOrder($order){

        //验证订单信息
        $order_info = $this->getInfoByOrderNumber($order);
        if (empty($order_info)){
            returnFail([],getcodestr(7009),7009);
        }
        if ($order_info["status"] == 2){
            returnFail([],getcodestr(7010),7010);
        }

        //通过支付方式调用不同的支付
        if ($order["pay_method"] == 3){
            //唤起贵族币支付页面
            return true;
        }else{
            switch ($order["pay_method"]){
                case 1: //微信支付
                    return true;
                    break;
                case 2: //支付宝支付
                    return true;
                    break;
                default:
                    returnFail([],getcodestr(8001),8001);
                    break;
            }
        }
    }

}