<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class GoodsCateController extends Controller
{
    protected $userid;
    protected $Url = 'https://janrosy.1vgy.com';

    public function __construct()
    {
        // laravel 在构造方法获取session
        $this->middleware(function ($request, $next) {
            $this -> userid = $request->session()->get('userid');
            return $next($request);
        });
    }
    //商品分类列表
    public function index(Request $req)
    {
        if(!isset($_SERVER['HTTP_REFERER'])){
            return view('Admin.error');
        }
        //新增   获取所有的门店
        $md = DB::table('md') -> where('status',1) -> get();
        if($req -> id){
            $goods_cate = DB::table('goods_cate') -> where('md_id',$req -> id) -> orderBy('orders','asc') -> get();
            return view('Admin.goodscate',['goods_cate'=>$goods_cate,'md' => $md,'md_id' => $req -> id]);
        }
        $goods_cate = DB::table('goods_cate') -> orderBy('orders','asc') -> get();
        return view('Admin.goodscate',['goods_cate'=>$goods_cate,'md' => $md,'md_id' => $req -> id]);
    }
    //商品分类增加
    public function create(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $goodsCate = [];
        $goodsCate['cate_name'] = $req -> goodsName;
        $goodsCate['orders'] = $req -> goodsOrders;
        $goodsCate['md_id'] = $req -> md;
        $goodsCate['status'] = 1;
        $is = DB::table('goods_cate') -> insert($goodsCate);
        return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
    }
    //商品分类删除
    public function delete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $is = DB::table('goods_cate') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }
    //查询需要修改的分类详情
    public function edit(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $cateInfo = DB::table('goods_cate') -> where('id',$req -> id) -> first();
        return json_encode($cateInfo);
    }
    //商品分类修改
    public function update(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $id = $req -> id;
        $update['cate_name'] = $req -> name;
        $update['orders'] = $req -> orders;
        $update['md_id'] = $req -> md;
        $is = DB::table('goods_cate') -> where('id',$id) -> update($update);
        return $is ? ['code'=> '1000','msg'=>'修改成功'] : ['code'=> '1002','msg'=>'修改失败'];
    }
    //商品分类状态更改
    public function status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('goods_cate') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('goods_cate') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('goods_cate') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //商品排序
    public function orders(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $orders = trim($req -> text);
        $is = DB::table('goods_cate') -> where('id',$req -> id) -> update(['orders'=>$orders]);
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //购买须知
    public function notes(Request $req)
    {
        if(!isset($_SERVER['HTTP_REFERER'])){
            return view('Admin.error');
        }
        //新增   获取所有的门店
        $md = DB::table('md') -> where('status',1) -> get();
        if($req -> id){
            $goods_notes = DB::table('goods_notes') -> where('md_id',$req -> id) -> first();
            return view('Admin.goodsnotes',['goods_notes'=>$goods_notes,'md'=>$md,'md_id' => $req -> id]);
        }
        $goods_notes = DB::table('goods_notes') -> where('md_id',$md[0] -> id) -> first();   //默认取值第一家门店，不允许全部显示
        return view('Admin.goodsnotes',['goods_notes'=>$goods_notes,'md'=>$md,'md_id' => $md[0] -> id]);
    }
    //购买须知保存
    public function notesSave(Request $req)
    {
        if($req -> id) {
            $is = DB::table('goods_notes') -> where('id',$req -> id) -> update(['content'=>$req -> content,'status'=>$req -> status,'md_id' => $req -> md]);
            return $is ? ['code'=> '1000','msg'=>'保存成功'] : ['code'=> '1002','msg'=>'内容无改变'];
        }
            $is = DB::table('goods_notes') -> insert(['content'=>$req -> content,'status'=>$req -> status,'md_id' => $req -> md]);
            return $is ? ['code'=> '1000','msg'=>'保存成功'] : ['code'=> '1002','msg'=>'内容无改变'];

    }

    //商品列表
    public function goods(Request $req)
    {
        if(!isset($_SERVER['HTTP_REFERER'])){
            return view('Admin.error');
        }
        $md = DB::table('md') -> where('status',1) -> get();
        $cate_id = '';
        if($req -> md){
            //选择了门店
            $goods = DB::table('goods')
            -> where('md_id',$req -> md)
            -> whereIn('status',[0,1])
            -> orderBy('orders','asc')
            -> get();   //按门店查询全部
            if($req -> cate) {   //选择了门店和分类
                $goods = DB::table('goods')
                -> where('md_id',$req -> md)
                -> where('pid',$req -> cate)
                -> whereIn('status',[0,1])
                -> orderBy('orders','asc')
                -> get();   //按门店查询全部
                $cate_id = $req -> cate;
            }
            //获取这个门店下面的所有商品分类
            $goods_cate = DB::table('goods_cate') -> where('md_id',$req -> md) -> get();
            $md_id = $req -> md;
        }else{
            //没有选择门店  默认一个门店
            $goods = DB::table('goods')
            -> where('md_id',$md[0] -> id)
            -> whereIn('status',[0,1])
            -> orderBy('orders','asc')
            -> get();   //按门店查询全部
            if($req -> cate) {   //选择了门店和分类
                $goods = DB::table('goods')
                -> where('md_id',$md[0] -> id)
                -> where('pid',$req -> cate)
                -> whereIn('status',[0,1])
                -> orderBy('orders','asc')
                -> get();   //按门店查询全部
                $cate_id = $req -> cate;
            }
            $goods_cate = DB::table('goods_cate') -> where('md_id',$md[0] -> id) -> get();
            $md_id = $md[0] -> id;
        }
        return view('Admin.goods',['goods'=>$goods,'goods_cate'=>$goods_cate,'md' => $md,'md_id' => $md_id,'cate_id'=>$cate_id]);
    }
    //商品上下架状态
    public function goodsStatus(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('goods') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('goods') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('goods') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //商品上下架状态
    public function goodsisrecomd(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('goods') -> where('id',$req -> id) -> value('is_recomd');
        if($status){
            $is = DB::table('goods') -> where('id',$req -> id) -> update(['is_recomd'=>0]);
        }else{
            $is = DB::table('goods') -> where('id',$req -> id) -> update(['is_recomd'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    public function goodsOrders(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $orders = trim($req -> text);
        $is = DB::table('goods') -> where('id',$req -> id) -> update(['orders'=>$orders]);
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    public function goodsDelete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $is = DB::table('goods') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }
    //添加商品页面
    public function goodsAdd()
    {
        $cate = DB::table('goods_cate') -> where('status','1') -> get();
        $md = DB::table('md') -> where('status',1) -> get();
        return view('Admin.goodsadd',['cate'=>$cate,'md'=>$md]);
    }
    //ajax请求门店下面的商品分类
    public function goodsGetCate(Request $req)
    {
        if($req -> id){
            $cate = DB::table('goods_cate') -> where('md_id',$req -> id) -> get();
            return $cate;
        }
    }
    //处理商品添加
    public function goodsDoadd(Request $req)
    {
        if(!$req -> goodsName || !$req -> goodsCate) {
            return ['code'=>'10001','msg'=>'参数错误'];
          }
        $imageSrc = '';
        if($req -> imgURL) {
            $image = $req -> imgURL;
            $path = "uploads";
            $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $imageSrc= $path."/". $imageName; //图片名字    入库
                $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
        }
        $goods['pid'] = $req -> goodsCate;  //商品所属分类
        if($imageSrc) {
            $goods['goods_images'] = $imageSrc;
        }else{
            $goods['goods_images'] = 'uploads/wz_default.jpg';   //使用默认图片
        }
        $goods['goods_name'] = $req -> goodsName;
        $goods['goods_keywords'] = $req -> keywords;
        $goods['goods_description'] = $req -> goodsDescription;
        $guige = $req -> guige;
        foreach($guige as $k => $v) {
            $goods['price'] = $v[1];
            continue;
        }
//        $goods['price'] = $req -> goodsPrice;
        $goods['md_id'] = $req -> md_id;
        $goods['xuhao'] = $req -> xuhao;
        $goods['beizhu'] = $req -> beizhu;
        $goods['addtime'] = time();
        $id = DB::table('goods') -> insertGetId($goods);
        $is = 0;
        if($id) {
            $is = 1;
            if($req -> guige){
                $guige = $req -> guige;
                foreach($guige as $k => $v) {
                    $goods_guige['guige_name'] = $v[0];
                    $goods_guige['guige_price'] = $v[1];
                    $goods_guige['goods_id'] = $id;
                    $is = DB::table('goods_guige') -> insert($goods_guige);
                }
            }
        }
        return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
    }
    //热销商品管理
    // public function goodshot(Request $req)
    // {
    //     $md = DB::table('md') -> where('status',1) -> get();
    //     if($req -> id){
    //         $hot = DB::table('goods') -> where('status',2) -> where('md_id',$req -> id) -> orderBy('orders','asc') -> get();
    //         $goods = DB::table('goods') -> whereIn('status',[0,1]) -> where('md_id',$req -> id) -> orderBy('goods_xiaoliang','desc') -> get();
    //         $md_id = $req -> id;
    //     }else{
    //         $md_id = $md[0] -> id;
    //         $hot = DB::table('goods') -> where('status',2) -> where('md_id',$md[0] -> id) -> orderBy('orders','asc') -> get();
    //         $goods = DB::table('goods') -> whereIn('status',[0,1]) -> where('md_id',$md[0] -> id) -> orderBy('goods_xiaoliang','desc') -> get();
    //     }
    //     $goods_all = [];
    //     foreach($goods as $key => $val) {
    //         $goods_all[$key]['id'] = $val -> id;
    //         $goods_all[$key]['goods_name'] = $val -> goods_name;
    //         $goods_all[$key]['xiaoliang'] = $val -> goods_xiaoliang;
    //     }
    //     return view('Admin.goodshot',['hot'=>$hot,'goods_all'=>$goods_all,'md'=>$md,'md_id' => $md_id]);
    // }
    //删除热销（改变状态2改为0）
    // public function goodshotDelete(Request $req)
    // {
    //     if(!$req -> id){
    //         return ['code'=>'10001','msg'=>'参数错误'];
    //     }
    //     $is = DB::table('goods') -> where('id',$req -> id) -> update(['status'=>0]);
    //     return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    // }
    //添加热销
    // public function goodshotAdd(Request $req)
    // {
    //     if(!$req -> check_val) {
    //         return ['code'=>'10001','msg'=>'参数错误'];
    //     }
    //     $is = DB::table('goods') -> whereIn('id',$req -> check_val) -> update(['status'=>2]);
    //     return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    // }
    //查看订单详情页面
    public function order_goods($id)
    {
        if(!$id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $orderdetail = DB::table('order')
            ->join('order_goods', 'order_goods.order_id', '=', 'order_goods.order_id')
            ->join('user', 'order.user_id', '=', 'user.id')
            ->where('order.order_id','=',$id)
            ->where('order_goods.order_id','=',$id)
            ->select('order.id','order_goods.goods_id','order.price','order_goods.goods_num','order_goods.guige_id','order.order_time','order.notes','order.pay_time','order.status','user.nickname','user.address','user.menpai','user.phone')
            ->get();
        $orderdetail1 = DB::table('order')
            ->join('order_goods', 'order_goods.order_id', '=', 'order_goods.order_id')
            ->join('user', 'order.user_id', '=', 'user.id')
            ->where('order.order_id','=',$id)
            ->where('order_goods.order_id','=',$id)
            ->select('order.id','order_goods.goods_id','order_goods.goods_num','order.price','order_goods.goods_num','order_goods.guige_id','order.order_time','order.notes','order.pay_time','order.status','user.nickname','user.name','user.address','user.menpai','user.phone')
            ->first();
        $i = 0;
        $goods = [];
        foreach ($orderdetail as $key => $val)
        {
            $goodsguige = DB::table('goods_guige')
                ->join('goods', 'goods.id', '=', 'goods_guige.goods_id')
                ->join('order_goods', 'order_goods.guige_id', '=', 'goods_guige.id')
                -> where('goods.id',$val->goods_id)
                -> where('goods_guige.id',$val->guige_id)
                ->select('goods.goods_name','goods.beizhu','goods_guige.guige_price','goods_guige.guige_name','order_goods.goods_num')
                -> first();
            $goods[$i] = $goodsguige;
            $i++;
        }
//        $goodsguige = DB::table('order_goods')
//                -> where('order_goods.order_id',$id)
//                -> get();
//        dd($goods);
//        dd($goods);
        return view('Admin.order_goods',['orderdetail' => (array)$orderdetail1,'orderdetail0' => (array)$orderdetail,'goods'=>(array)$goods]);
    }
    //编辑商品页面
    public function goodsEdit($id)
    {
        if(!$id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $md = DB::table('md') -> where('status',1) -> get(); //所有门店
        $res = DB::table('goods') -> where('id',$id) -> first();   //当前商品
        //商品规格
        $guige = DB::table('goods_guige') -> where('goods_id',$res -> id) -> get();
        $cate = DB::table('goods_cate') -> where('status','1') -> where('md_id',$res -> md_id) -> get();   //当前门店分类
        return view('Admin.goodsedit',['res' => $res,'cate'=>$cate,'md' => $md,'guige' => $guige]);
    }
    //处理编辑商品
    public function goodsUpdate(Request $req)
    {
        if(!$req -> goodsName || !$req -> goodsCate || !$req -> id) {
            return ['code'=>'10001','msg'=>'参数错误'];
          }
          $imageSrc = '';
          if($req -> imgURL) {
              $image = $req -> imgURL;
              $path = "uploads";
              $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
              if (strstr($image,",")){
                  $image = explode(',',$image);
                  $image = $image[1];
              }
              $imageSrc= $path."/". $imageName; //图片名字    入库
                  $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
          }
          $goods['pid'] = $req -> goodsCate;  //商品所属分类
          if($imageSrc) {
              $goods['goods_images'] = $imageSrc;
          }
          $goods['goods_name'] = $req -> goodsName;
          $goods['goods_description'] = $req -> goodsDescription;
            $guige = $req -> guige;
            foreach($guige as $k => $v) {
                $goods['price'] = $v[1];
                break;
            }
//          $goods['price'] = $req -> goodsPrice;
          $goods['md_id'] = $req -> md_id;
          $goods['xuhao'] = $req -> xuhao;
          $goods['beizhu'] = $req -> beizhu;
          $goods['goods_keywords'] = $req -> keywords;
          //规格直接全部删除在添加
          DB::table('goods_guige') -> where('goods_id',$req -> id) -> delete();
          $is = DB::table('goods') -> where('id',$req -> id) -> update($goods);

            foreach($guige as $k => $v) {
                $goods_guige['guige_name'] = $v[0];
                $goods_guige['guige_price'] = $v[1];
                $goods_guige['goods_id'] = $req -> id;
                $is = DB::table('goods_guige') -> insert($goods_guige);
            }
          return $is ? ['code'=> '1000','msg'=>'修改完成'] : ['code'=> '1002','msg'=>'没有发生改变'];
    }
    //首页营销图
    public function ad(Request $req)
    {
        if(!$req -> has('save')) {
            //获取图片和选择的链接页面
            $index_ad = DB::table('index_ad') -> where('map',1) -> first();
            //获取所有的文章和商品
            $goods = DB::table('goods') -> where('status',1) -> get();
            $wz = DB::table('wz') -> whereIn('status',[1,2]) -> get();
            return view('Admin.index-ad',['ad' => $index_ad,'goods'=>$goods,'wz' => $wz]);
        }else{
            //保存
            $imageSrc = '';
                if($req -> imgURL) {
                    $image = $req -> imgURL;
                    $path = "uploads";
                    $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
                    if (strstr($image,",")){
                        $image = explode(',',$image);
                        $image = $image[1];
                    }
                    $imageSrc= $path."/". $imageName; //图片名字    入库
                        $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
                }
                if($imageSrc) {
                    $ad['imgURL'] = $imageSrc;
                }
                $link = explode('/',$req -> link);
                if($link[0] == 'sp') {
                    $ad['link'] = '/pages/goodsDetail/goodsDetail?id='.$link[1];
                }else{
                    $ad['link'] = '/pages/wzDetail/wzDetail?id='.$link[1];
                }
                $is = DB::table('index_ad') -> where('map',1) -> update($ad);
                return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
        }
    }
    //文章页面营销图
    //首页营销图
    public function jan_ad(Request $req)
    {
        if(!$req -> has('save')) {
            //获取图片和选择的链接页面
            $index_ad = DB::table('index_ad') -> where('map',2) -> first();
            //获取所有的文章和商品
            $goods = DB::table('goods') -> where('status',1) -> get();
            $wz = DB::table('wz') -> whereIn('status',[1,2]) -> get();
            return view('Admin.jan-ad',['ad' => $index_ad,'goods'=>$goods,'wz' => $wz]);
        }else{
            //保存
            $imageSrc = '';
                if($req -> imgURL) {
                    $image = $req -> imgURL;
                    $path = "uploads";
                    $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
                    if (strstr($image,",")){
                        $image = explode(',',$image);
                        $image = $image[1];
                    }
                    $imageSrc= $path."/". $imageName; //图片名字    入库
                        $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
                }
                if($imageSrc) {
                    $ad['imgURL'] = $imageSrc;
                }
                $link = explode('/',$req -> link);
                if($link[0] == 'sp') {
                    $ad['link'] = '/pages/goodsDetail/goodsDetail?id='.$link[1];
                }else{
                    $ad['link'] = '/pages/wzDetail/wzDetail?id='.$link[1];
                }
                $is = DB::table('index_ad') -> where('map',2) -> update($ad);
                return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
        }

    }
    //选择商品和文章以获取下面的分类
    public function getxuanze(Request $req)
    {
        if($req -> status == 1) {
            //商品
            $cate = DB::table('goods_cate') -> where('status',1) -> orderBy('orders','asc') -> get();
        }else if($req -> status == 2) {
            $cate = DB::table('wz_cate') -> where('status',1) -> get();
        }
        if($cate) {
            return ['code' => '1000','msg' => 'OK','result' => $cate];
        }else{
            return ['code' => '1001','msg' => 'err','result' => '数据为空'];
        }

    }
    //选择商品或者文章下面的三级分类
    public function getxuanze3(Request $req)
    {
        if($req -> status == 'wz') {
            //查找文章
            $res = DB::table('wz') -> where('status',1) -> where('pid',$req -> id) -> get();
        }else{
            //商品
            $res = DB::table('goods') -> where('status',1) -> where('pid',$req -> id) -> get();
        }
        if($res) {
            return ['code' => '1000','msg' => 'OK','result' => $res];
        }else{
            return ['code' => '1001','msg' => 'err','result' => '数据为空'];
        }
    }
}
