<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;

class JifenController extends Controller
{
    //积分商城分类列表
    public function list()
    {
        $cate = DB::table('jifen_cate') -> get();
        return view('Admin.jifen_cate',['cate'=>$cate]);
    }
    //分类状态管理
    public function cate_status(Request $req) 
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('jifen_cate') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('jifen_cate') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('jifen_cate') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //分类排序
    public function cate_orders(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $orders = trim($req -> text);
        $is = DB::table('jifen_cate') -> where('id',$req -> id) -> update(['orders'=>$orders]);
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //分类删除
    public function cate_delete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $is = DB::table('jifen_cate') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }
    //分类添加
    public function cate_create(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $goodsCate = [];
        $goodsCate['cate_name'] = $req -> goodsName;
        $goodsCate['orders'] = $req -> goodsOrders;
        $is = DB::table('jifen_cate') -> insert($goodsCate);
        return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
    }
    //分类编辑
    public function cate_update(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $id = $req -> id;
        $update['cate_name'] = $req -> name;
        $is = DB::table('jifen_cate') -> where('id',$id) -> update($update);
        return $is ? ['code'=> '1000','msg'=>'修改成功'] : ['code'=> '1002','msg'=>'修改失败'];
    }

    //积分商品列表
    public function goods_list($id = null)
    {
        $cate = DB::table('jifen_cate') -> get();
        if($id) {
            $goods = DB::table('jifen_goods') -> where('pid',$id) -> get();
            return view('Admin.jifen_goods',['cate' => $cate,'goods' => $goods,'pid' => $id]);
        }else{
            $id = '';
            $goods = DB::table('jifen_goods') -> get();
            return view('Admin.jifen_goods',['cate' => $cate,'goods' => $goods,'pid' => $id]);
        }
    }
    //商品添加
    public function goods_add()
    {
        $cate = DB::table('jifen_cate') -> get();
        return view('Admin.jifen_goods_add',['cate' => $cate]);
    }
    //处理商品添加
    public function goods_doadd(Request $req)
    {
        if(!$req -> goodsName || !$req -> goodsCate || !$req -> goodsPrice) {
            return ['code'=>'10001','msg'=>'参数错误'];
          }
        $imageSrc = '';
        if($req -> imgURL) {
            $image = $req -> imgURL;
            $path = "uploads";
            $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
            if (strstr($image,",")){
                $image = explode(',',$image);
                $image = $image[1];
            }
            $imageSrc= $path."/". $imageName; //图片名字    入库
                $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
        }
        $goods['pid'] = $req -> goodsCate;  //商品所属分类
        if($imageSrc) {
            $goods['goods_images'] = $imageSrc;
        }else{
            $goods['goods_images'] = 'uploads/wz_default.jpg';   //使用默认图片
        }
        $goods['goods_name'] = $req -> goodsName;
        $goods['goods_description'] = $req -> goodsDescription;
        $goods['price'] = $req -> goodsPrice;
        $goods['addtime'] = time();
        $is = DB::table('jifen_goods') -> insert($goods);
        return $is ? ['code'=> '1000','msg'=>'添加完成'] : ['code'=> '1002','msg'=>'添加失败'];
    }
    //商品编辑页面
    public function goods_edit($id)
    {
        if(!$id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $cate = DB::table('jifen_cate') -> get();
        $res = DB::table('jifen_goods') -> where('id',$id) -> first();
        return view('Admin.jifen_goods_edit',['res' => $res,'cate'=>$cate]);
    }
    //商品保存编辑
    public function goods_update(Request $req)
    {
        if(!$req -> goodsName || !$req -> goodsCate || !$req -> goodsPrice || !$req -> id) {
            return ['code'=>'10001','msg'=>'参数错误'];
          }
          $imageSrc = '';
          if($req -> imgURL) {
              $image = $req -> imgURL;
              $path = "uploads";
              $imageName = "25220_".date("His",time())."_".rand(1111,9999).'.png';
              if (strstr($image,",")){
                  $image = explode(',',$image);
                  $image = $image[1];
              }
              $imageSrc= $path."/". $imageName; //图片名字    入库
                  $r = file_put_contents($imageSrc, base64_decode($image));//返回的是字节数
          }
          $goods['pid'] = $req -> goodsCate;  //商品所属分类
          if($imageSrc) {
              $goods['goods_images'] = $imageSrc;
          }
          $goods['goods_name'] = $req -> goodsName;
          $goods['goods_description'] = $req -> goodsDescription;
          $goods['price'] = $req -> goodsPrice;
          $is = DB::table('jifen_goods') -> where('id',$req -> id) -> update($goods);
          return $is ? ['code'=> '1000','msg'=>'修改完成'] : ['code'=> '1002','msg'=>'没有发生改变'];
    }
    //商品列表状态修改
    public function goods_status(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $status = DB::table('jifen_goods') -> where('id',$req -> id) -> value('status');
        if($status){
            $is = DB::table('jifen_goods') -> where('id',$req -> id) -> update(['status'=>0]);
        }else{
            $is = DB::table('jifen_goods') -> where('id',$req -> id) -> update(['status'=>1]);
        }
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //积分商品排序
    public function goods_orders(Request $req)
    {
        if(in_array('',$req -> all())) {
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $orders = trim($req -> text);
        $is = DB::table('jifen_goods') -> where('id',$req -> id) -> update(['orders'=>$orders]);
        return $is ? ['code'=> '1000','msg'=>'操作完成'] : ['code'=> '1002','msg'=>'操作失败'];
    }
    //商品删除
    public function goods_delete(Request $req)
    {
        if(!$req -> id){
            return ['code'=>'10001','msg'=>'参数错误'];
        }
        $is = DB::table('jifen_goods') -> where('id',$req -> id) -> delete();
        return $is ? ['code'=> '1000','msg'=>'删除成功'] : ['code'=> '1002','msg'=>'删除失败'];
    }

    //积分规则
    public function guize(Request $req)
    {
        $rule = DB::table('jifen_rule') -> first();
        return view('Admin.jifen_rule',['rule' => $rule]);
    }
    //保存积分规则
    public function guize_save(Request $req)
    {
        if(!$req -> jifen || !$req -> id) {
            return ['code'=>'10001','msg'=>'参数不全'];
        }
        $rule['jifen'] = $req -> jifen;
        $is = DB::table('jifen_rule') -> where('id',$req -> id) -> update($rule);
        return $is ? ['code'=> '1000','msg'=>'保存成功'] : ['code'=> '1002','msg'=>'内容无改变'];
    }
}
