<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    // 登录页面
    public function index()
    {
        return view('Admin.login');
    }
    //处理登录
    public function dologin(Request $request)
    {
        if($request -> isone == 'one'){   //第一次ajax验证账号密码是否为空
            if(in_array('',$request -> all())){
                return 0;
            }
            return 1;
        }
        //极验服务端验证参数
        if(session('login_n')){

            $result = $this->validate($request, [
                'geetest_challenge' => 'geetest',
            ], [
                'geetest' => config('geetest.server_fail_alert')
            ]);
            if (!$request) {
                return redirect('/') -> with('err4','请通过验证码操作!');
            }
        }
        if(!in_array('',$request -> all())){
            $passwd = DB::table('adminuser') -> where('username',$request->username) -> first();
            if(!$passwd){
                session(['login_n' => '1']);
                return redirect('/') -> with('err','账号或密码错误!');
            }
            if(Hash::check($request -> password,$passwd -> password)){
                //验证账号是否被禁用
                if($passwd -> status == '0'){
                    session(['login_n' => '1']);
                    return redirect('/') -> with('err2','账号已被关闭，请联系超级管理员!');
                }
                //信息加入session
                session(['username' => $request->username,'userid' => $passwd -> id]);
                $request->session()->forget('login_n');
                $list = DB::table('adminuser')
                -> join('rule_node','adminuser.rule','=','rule_node.rule_id')
                -> join('node','rule_node.node_id','=','node.id')
                -> where('adminuser.id','=',$passwd -> id) -> get();
                //权限初始化 可以让所有管理员具有访问后台首页的权限
                $nodelist['IndexController'][]='list';
                foreach($list as $val) {
                    $nodelist[$val->controller_name][]=$val->function_name;
					if($val->function_name == "create"){   //添加商品分类 (操作)
						$nodelist[$val->controller_name][]='delete';
						$nodelist[$val->controller_name][]='status';
						$nodelist[$val->controller_name][]='orders';
						$nodelist[$val->controller_name][]='edit';
						$nodelist[$val->controller_name][]='update';
                    }
                    if($val->function_name == "notes"){   //购买须知 (操作)
						$nodelist[$val->controller_name][]='notesSave';  //保存购买须知
                    }
                    if($val->function_name == "goodsAdd"){   //商品列表 (操作)
						$nodelist[$val->controller_name][]='goodsStatus';
						$nodelist[$val->controller_name][]='goodsOrders';
						$nodelist[$val->controller_name][]='goodsDelete';
						$nodelist[$val->controller_name][]='goodsDoadd';
						$nodelist[$val->controller_name][]='goodsEdit';
                        $nodelist[$val->controller_name][]='goodsUpdate';
                        $nodelist[$val->controller_name][]='goodsGetCate';    //添加商品时ajax请求门店下面的商品分类
                    }
                    if($val->function_name == "goodshotAdd"){   //热销商品列表 (操作)
						$nodelist[$val->controller_name][]='goodshotDelete';
                    }
                    if($val->function_name == "cate_create"){   //文章类别 (操作)
						$nodelist[$val->controller_name][]='cate_status';
						$nodelist[$val->controller_name][]='cate_update';
						$nodelist[$val->controller_name][]='cate_delete';
                    }
                    if($val->function_name == "add"){   //文章列表 (操作)
						$nodelist[$val->controller_name][]='doadd';
						$nodelist[$val->controller_name][]='delete';
						$nodelist[$val->controller_name][]='status';
						$nodelist[$val->controller_name][]='top';
						$nodelist[$val->controller_name][]='edit';
						$nodelist[$val->controller_name][]='updata';
                    }
                    if($val->function_name == "about"){   //关于简诺 (查看、操作)
						$nodelist[$val->controller_name][]='about_edit';
                    }
                    if($val->function_name == "add"){   //沙龙列表(操作)
						$nodelist[$val->controller_name][]='doadd';
						$nodelist[$val->controller_name][]='status';
						$nodelist[$val->controller_name][]='top';
						$nodelist[$val->controller_name][]='delete';
						$nodelist[$val->controller_name][]='edit';
						$nodelist[$val->controller_name][]='update';
                    }
                    if($val->function_name == "list"){   //优惠券 (查看详情)
						$nodelist[$val->controller_name][]='look';
                    }
                    if($val->function_name == "add"){   //优惠券 ( 操作)      未完成。。。。。。。。
						$nodelist[$val->controller_name][]='back';
						$nodelist[$val->controller_name][]='delete';
						$nodelist[$val->controller_name][]='status';
                        $nodelist[$val->controller_name][]='getGoods';    //添加优惠券根据门店获取商品信息
                        $nodelist[$val->controller_name][]='search';    //搜索单个用户信息
                        $nodelist[$val->controller_name][]='doadd';    //处理优惠券添加
                    }
                    if($val->function_name == "level_create"){   //会员等级 ( 操作)
						$nodelist[$val->controller_name][]='level_status';
						$nodelist[$val->controller_name][]='update';
						$nodelist[$val->controller_name][]='level_update';
                    }
                    if($val->function_name == "cate_create"){   //积分商城分类 ( 操作)
						$nodelist[$val->controller_name][]='cate_update';
						$nodelist[$val->controller_name][]='cate_delete';
						$nodelist[$val->controller_name][]='cate_orders';
						$nodelist[$val->controller_name][]='cate_status';
                    }
                    if($val->function_name == "goods_add"){   //积分商城商品 ( 操作)
						$nodelist[$val->controller_name][]='goods_doadd';
						$nodelist[$val->controller_name][]='goods_edit';
						$nodelist[$val->controller_name][]='goods_update';
						$nodelist[$val->controller_name][]='goods_status';
						$nodelist[$val->controller_name][]='goods_orders';
						$nodelist[$val->controller_name][]='goods_delete';
                    }
                    if($val->function_name == "guize"){   //积分规则 (查看、 操作)
						$nodelist[$val->controller_name][]='guize_save';
                    }
                    if($val->function_name == "create"){   //门店 (查看、 操作)
						$nodelist[$val->controller_name][]='update';
						$nodelist[$val->controller_name][]='status';
                    }
                    if($val->function_name == "create"){   //管理员 (查看、 操作)
						$nodelist[$val->controller_name][]='update';
						$nodelist[$val->controller_name][]='status';
						$nodelist[$val->controller_name][]='delete';
                    }
                }
                //去重
                $new_nodelist = [];
                foreach($nodelist as $key => $val) {
                    $new_nodelist[$key] = array_unique($val);
                }
                session(['nodelist'=>$new_nodelist]);
                return redirect('/admin/index');
            }else{
                session(['login_n' => '1']);
                return redirect('/') -> with('err','账号或密码错误');
            }
        }

    }

    //退出登录
    public function outlogin(Request $request)
    {
        $request->session()->forget('username');
        $request->session()->forget('userid');
        return redirect('/') -> with('outlogin','已安全退出');
    }
}
